package microblog;

import java.util.List;

import sina.weibo.process.LoginProcess;

import android.util.Log;

import weibo4j.MBlog;
import weibo4j.Paging;
import weibo4j.Status;
import weibo4j.User;
import weibo4j.UserInfo;

public class MyMicroBlogAsync extends MyMicroBlog
{

	public MyMicroBlogAsync(String account, String password, KeySecret keySecret)
	{
		super(account, password, keySecret);
		// TODO Auto-generated constructor stub
	}

	public MyMicroBlogAsync(String account, String password)
	{
		super(account, password);
		// TODO Auto-generated constructor stub
	}

	public Thread loginAsync(MicroBlogListener microBlogListener)
	{

		ExecuteThread executeThread = new ExecuteThread(new AsyncTask(
				microBlogListener, OPERATION_TYPE_LOGIN, MESSAGE_LOGIN,
				mLanguage)
		{
			@Override
			public Object invoke() throws Exception
			{

				return login();
			}
		});
		executeThread.execute();

		return executeThread.getThread();

	}

	public void getHomeTimelineAsync(MicroBlogListener microBlogListener)
	{

		ExecuteThread executeThread = new ExecuteThread(new AsyncTask(
				microBlogListener, OPERATION_TYPE_HOME_TIMELINE,
				MESSAGE_HOME_TIMELINE, mLanguage)
		{
			@Override
			public Object invoke() throws Exception
			{
				return getHomeTimeline();
			}
		});

		executeThread.execute();

	}

	public void getUserTimelineAsync(MicroBlogListener microBlogListener)
	{

		ExecuteThread executeThread = new ExecuteThread(new AsyncTask(
				microBlogListener, OPERATION_TYPE_USER_TIMELINE,
				MESSAGE_USER_TIMELINE, mLanguage)
		{
			@Override
			public Object invoke() throws Exception
			{
				return getUserTimeline();
			}
		});

		executeThread.execute();

	}

	public void getUserTimelineAsync(MicroBlogListener microBlogListener,
			final Paging paging)
	{

		ExecuteThread executeThread = new ExecuteThread(new AsyncTask(
				microBlogListener, OPERATION_TYPE_USER_TIMELINE,
				MESSAGE_USER_TIMELINE, mLanguage)
		{
			@Override
			public Object invoke() throws Exception
			{
				return getUserTimeline(paging);
			}
		});

		executeThread.execute();

	}

	public void getMentionsAsync(MicroBlogListener microBlogListener)
	{

		ExecuteThread executeThread = new ExecuteThread(new AsyncTask(
				microBlogListener, OPERATION_TYPE_MENTIONS, MESSAGE_MENTIONS,
				mLanguage)
		{
			@Override
			public Object invoke() throws Exception
			{

				return getMentions();
			}
		});

		executeThread.execute();

	}

	public void getMentionsAsync(MicroBlogListener microBlogListener,
			final Paging paging)
	{

		ExecuteThread executeThread = new ExecuteThread(new AsyncTask(
				microBlogListener, OPERATION_TYPE_MENTIONS, MESSAGE_MENTIONS,
				mLanguage)
		{
			@Override
			public Object invoke() throws Exception
			{

				return getMentions(paging);
			}
		});

		executeThread.execute();

	}

	public void getHomeTimelineAsync(MicroBlogListener microBlogListener,
			final Paging paging)
	{

		ExecuteThread executeThread = new ExecuteThread(new AsyncTask(
				microBlogListener, OPERATION_TYPE_HOME_TIMELINE,
				MESSAGE_HOME_TIMELINE, mLanguage)
		{
			@Override
			public Object invoke() throws Exception
			{
				return getHomeTimeline(paging);
			}
		});

		executeThread.execute();

	}

	public void getFavoritesAsync(MicroBlogListener microBlogListener)
	{

		ExecuteThread executeThread = new ExecuteThread(new AsyncTask(
				microBlogListener, OPERATION_TYPE_FAVORITES, MESSAGE_FAVORITES,
				mLanguage)
		{
			@Override
			public Object invoke() throws Exception
			{

				return getFavorites();
			}
		});

		executeThread.execute();

	}

	public void getFavoritesAsync(MicroBlogListener microBlogListener,
			final Paging paging)
	{

		ExecuteThread executeThread = new ExecuteThread(new AsyncTask(
				microBlogListener, OPERATION_TYPE_FAVORITES, MESSAGE_FAVORITES,
				mLanguage)
		{
			@Override
			public Object invoke() throws Exception
			{

				return getFavorites(paging);
			}
		});

		executeThread.execute();

	}

	public void getPublicTimelineAsync(MicroBlogListener microBlogListener)
	{

		ExecuteThread executeThread = new ExecuteThread(new AsyncTask(
				microBlogListener, OPERATION_TYPE_PUBLIC_TIMELINE,
				MESSAGE_PUBLIC_TIMELINE, mLanguage)
		{
			@Override
			public Object invoke() throws Exception
			{
				return getPublicTimeline();
			}
		});

		executeThread.execute();

	}

	public void getCommentAsync(MicroBlogListener microBlogListener,
			final String statusId)
	{

		ExecuteThread executeThread = new ExecuteThread(new AsyncTask(
				microBlogListener, OPERATION_TYPE_COMMENT, MESSAGE_COMMENT,
				mLanguage)
		{
			@Override
			public Object invoke() throws Exception
			{
				return getComments(statusId);
			}
		});

		executeThread.execute();

	}

	public void getCommentAsync(MicroBlogListener microBlogListener,
			final String statusId, final Paging paging)
	{

		ExecuteThread executeThread = new ExecuteThread(new AsyncTask(
				microBlogListener, OPERATION_TYPE_COMMENT, MESSAGE_COMMENT,
				mLanguage)
		{
			@Override
			public Object invoke() throws Exception
			{
				return getComments(statusId, paging);
			}
		});

		executeThread.execute();

	}

	public void getCommentsTimelineAsync(MicroBlogListener microBlogListener)
	{

		ExecuteThread executeThread = new ExecuteThread(new AsyncTask(
				microBlogListener, OPERATION_TYPE_COMMENTS_TIMELINE,
				MESSAGE_COMMENTS_TIMELINE, mLanguage)
		{
			@Override
			public Object invoke() throws Exception
			{
				return getCommentsTimeline();
			}
		});

		executeThread.execute();

	}

	public void getCommentsTimelineAsync(MicroBlogListener microBlogListener,
			final Paging paging)
	{

		ExecuteThread executeThread = new ExecuteThread(new AsyncTask(
				microBlogListener, OPERATION_TYPE_COMMENTS_TIMELINE,
				MESSAGE_COMMENTS_TIMELINE, mLanguage)
		{
			@Override
			public Object invoke() throws Exception
			{
				return getCommentsTimeline(paging);
			}
		});

		executeThread.execute();
	}

	public void getCommentsByMeAsync(MicroBlogListener microBlogListener)
	{

		ExecuteThread executeThread = new ExecuteThread(new AsyncTask(
				microBlogListener, OPERATION_TYPE_COMMENTS_TIMELINE,
				MESSAGE_COMMENTS_BY_ME, mLanguage)
		{
			@Override
			public Object invoke() throws Exception
			{
				return getCommentsByMe();
			}
		});

		executeThread.execute();

	}

	public void getCommentsByMeAsync(MicroBlogListener microBlogListener,
			final Paging paging)
	{

		ExecuteThread executeThread = new ExecuteThread(new AsyncTask(
				microBlogListener, OPERATION_TYPE_COMMENTS_TIMELINE,
				MESSAGE_COMMENTS_BY_ME, mLanguage)
		{
			@Override
			public Object invoke() throws Exception
			{
				return getCommentsByMe(paging);
			}
		});

		executeThread.execute();

	}

	public void getDirectMessagesExtAsync(MicroBlogListener microBlogListener,
			final Paging paging)
	{

		ExecuteThread executeThread = new ExecuteThread(new AsyncTask(
				microBlogListener, OPERATION_TYPE_DIRECT_MESSAGE,
				MESSAGE_DIRECT_MESSAGE, mLanguage)
		{
			@Override
			public Object invoke() throws Exception
			{
				return getDirectMessagesExt(paging);
			}
		});

		executeThread.execute();

	}

	public void getDirectMessagesExtAsync(MicroBlogListener microBlogListener,
			final Paging paging, final String userId)
	{

		ExecuteThread executeThread = new ExecuteThread(new AsyncTask(
				microBlogListener, OPERATION_TYPE_DIRECT_MESSAGE,
				MESSAGE_DIRECT_MESSAGE, mLanguage)
		{
			@Override
			public Object invoke() throws Exception
			{
				return getDirectMessagesExt(paging, userId);
			}
		});

		executeThread.execute();

	}

	public void getDirectMessagesAsync(MicroBlogListener microBlogListener,
			final Paging paging)
	{

		ExecuteThread executeThread = new ExecuteThread(new AsyncTask(
				microBlogListener, OPERATION_TYPE_DIRECT_MESSAGE_ME,
				MESSAGE_DIRECT_MESSAGE, mLanguage)
		{
			@Override
			public Object invoke() throws Exception
			{
				return getDirectMessages(paging);
			}
		});

		executeThread.execute();

	}

	public void updateStatusAsync(final String status,
			MicroBlogListener microBlogListener)
	{
		ExecuteThread executeThread = new ExecuteThread(new AsyncTask(
				microBlogListener, OPERATION_TYPE_UPDATE_STATUS,
				MESSAGE_UPDATE_STATUS, mLanguage)
		{
			@Override
			public Object invoke() throws Exception
			{
				return updateStatus(status);
			}
		});

		executeThread.execute();
	}

	public void getCount(final String id, MicroBlogListener microBlogListener)
	{
		ExecuteThread executeThread = new ExecuteThread(new AsyncTask(
				microBlogListener, OPERATION_TYPE_COUNT, MESSAGE_COUNT,
				mLanguage, false)
		{
			@Override
			public Object invoke() throws Exception
			{
				return getCount(id);
			}
		});

		executeThread.execute();
	}

	public Thread createFriendshipAsync(final List<String> userIds)
	{
		Thread thread = new Thread(new Runnable()
		{

			@Override
			public void run()
			{
				for (String userId : userIds)
				{
					int count = 0;
					while (count < 3)
					{
						try
						{
							User user = createFriendship(userId);
							if (userId.equals(user.getId()))
								break;

						}
						catch (Exception e)
						{
							// TODO: handle exception
						}
						count++;
					}
				}

			}
		});
		thread.start();
		return thread;
	}

	public Thread createFriendshipAsync(final String userId)
	{
		Thread thread = new Thread(new Runnable()
		{

			@Override
			public void run()
			{
				try
				{

					User user = createFriendship(userId);
				}
				catch (Exception e)
				{
					// TODO: handle exception
				}

			}
		});
		thread.start();
		return thread;
	}

	public Thread destroyFavoriteAsync(final String statusId)
	{
		Thread thread = new Thread(new Runnable()
		{

			@Override
			public void run()
			{
				try
				{
					Status status = destroyFavorite(statusId);
				}
				catch (Exception e)
				{
					// TODO: handle exception
				}

			}
		});
		thread.start();
		return thread;
	}

	public Thread destroyFriendshipAsync(final String userId)
	{
		Thread thread = new Thread(new Runnable()
		{

			@Override
			public void run()
			{
				try
				{
					User user = destroyFriendship(userId);
				}
				catch (Exception e)
				{
					// TODO: handle exception
				}

			}
		});
		thread.start();
		return thread;
	}

	public void searchMBlogAsync(MicroBlogListener microBlogListener,
			final Paging paging, final String keyword) throws Exception
	{
		ExecuteThread executeThread = new ExecuteThread(new AsyncTask(
				microBlogListener, OPERATION_TYPE_SEARCH_MBLOG,
				MESSAGE_SEARCH_MBLOG, mLanguage)
		{
			@Override
			public Object invoke() throws Exception
			{
				Object obj = searchMBlog(paging, keyword);
				List<MBlog> mBlogs = (List<MBlog>) obj;
				if (mBlogs.size() == 0)
				{
					int count = 1;

					while (count < 3)
					{
						obj = searchMBlog(paging, keyword);
						mBlogs = (List<MBlog>) obj;
						if (mBlogs.size() > 0)
							break;

						count++;
					}
				}
				return obj;
			}
		});

		executeThread.execute();

	}

	public void searchMicroBlogAsync(MicroBlogListener microBlogListener,
			final Paging paging) throws Exception
	{
		ExecuteThread executeThread = new ExecuteThread(new AsyncTask(
				microBlogListener, OPERATION_TYPE_SEARCH_MBLOG,
				MESSAGE_SEARCH_MBLOG, mLanguage)
		{
			@Override
			public Object invoke() throws Exception
			{
				Object obj = searchMicroBlog(paging);
				return obj;
			}
		});

		executeThread.execute();

	}

	public void searchUserAsync(MicroBlogListener microBlogListener,
			final Paging paging, final String keyword) throws Exception
	{
		ExecuteThread executeThread = new ExecuteThread(new AsyncTask(
				microBlogListener, OPERATION_TYPE_SEARCH_USER,
				MESSAGE_SEARCH_USER, mLanguage)
		{
			@Override
			public Object invoke() throws Exception
			{
				Object obj = searchUser(paging, keyword);
				List<UserInfo> userInfos = (List<UserInfo>) obj;
				if (userInfos.size() == 0)
				{
					int count = 1;

					while (count < 3)
					{
						obj = searchUser(paging, keyword);
						userInfos = (List<UserInfo>) obj;
						if (userInfos.size() > 0)
							break;

						count++;
					}
				}
				return obj;
			}
		});

		executeThread.execute();

	}

	public void searchUsersAsync(MicroBlogListener microBlogListener,
			final Paging paging) throws Exception
	{
		ExecuteThread executeThread = new ExecuteThread(new AsyncTask(
				microBlogListener, OPERATION_TYPE_SEARCH_USER,
				MESSAGE_SEARCH_USER, mLanguage)
		{
			@Override
			public Object invoke() throws Exception
			{
				Object obj = searchUsers(paging);
				List<User> users = (List<User>) obj;
				if (users.size() == 0)
				{
					int count = 1;

					while (count < 3)
					{
						obj = searchUsers(paging);
						users = (List<User>) obj;
						if (users.size() > 0)
							break;

						count++;
					}
				}
				return obj;
			}
		});

		executeThread.execute();

	}

}
