package microblog;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import microblog.commons.Const;
import microblog.commons.ConstExt;
import weibo4j.http.BASE64Decoder;

public class MyUtil
{
	public static String decode(String s, String microBlogId)

	{
		String result = s;
		try
		{

			if ("9911".equals(microBlogId))
			{

				result = new String(new BASE64Decoder().decode(s.getBytes()),
						"utf-8");
			}
			else if ("leihou".equals(microBlogId))
			{

			}

		}
		catch (Exception e)
		{

		}
		return result;
	}

	public static String Unicode2Str(String s)
	{

		StringBuffer sb = new StringBuffer();
		int state = 0;
		int i = 0;
		String numStr = "";
		while (i < s.length())
		{
			char c = s.charAt(i);
			switch (state)
			{
				case 0:
					if (c == '&')
					{
						state = 1;
					}
					else
					{
						sb.append(c);
					}
					break;

				case 1:
					if (c == '#')
					{
						state = 2;
						numStr = "";
					}
					else
					{
						state = 0;
						sb.append('&');
						sb.append(c);
					}

					break;
				case 2:
					if (c == ';')
					{
						state = 0;
						if (numStr.length() > 0)
						{
							char cc = (char) Integer.parseInt(numStr);
							sb.append(cc);
						}
					}
					else
					{
						numStr += c;
					}
					break;
			}

			i++;
		}
		return sb.toString();

	}

	public static String[] getString(int id, int language)
	{

		switch (language)
		{
			case Const.LANGUAGE_ZH_CN:
				return ConstExt.chineseMap.get(id);
			case Const.LANGUAGE_EN_US:
				return ConstExt.chineseMap.get(id);
		}
		return new String[]
		{ "", "", "" };
	}

	public String[] getString1(int id, int language)
	{

		switch (language)
		{
			case Const.LANGUAGE_ZH_CN:
				return ConstExt.chineseMap.get(id);
			case Const.LANGUAGE_EN_US:
				return ConstExt.chineseMap.get(id);
		}
		return new String[]
		{ "", "", "" };
	}

	public static String getTimeStr(Date oldTime, Date currentDate)
	{

		long time1 = currentDate.getTime();

		long time2 = oldTime.getTime();

		long time = (time1 - time2) / 1000;
		String FormattedCreatedAt = "";
		if (time >= 0 && time < 60)
		{
			return "ղ";
		}
		else if (time >= 60 && time < 3600)
		{
			return time / 60 + "ǰ";
		}
		else if (time >= 3600 && time < 3600 * 24)
		{
			return time / 3600 + "Сʱǰ";
		}
		else
		{
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
			return sdf.format(oldTime);
		}
	}
    //  ʱ2010-12-14 12:52:26
	public static Date stringToDate(String s)
	{
		int year, month, day, hour, minute, second;
		year = Integer.parseInt(s.substring(0, 4));
		month = Integer.parseInt(s.substring(5, 7));
		day = Integer.parseInt(s.substring(8, 10));
		hour = Integer.parseInt(s.substring(11, 13));
		minute = Integer.parseInt(s.substring(14, 16));
		second = Integer.parseInt(s.substring(17));
		Calendar calendar = Calendar.getInstance();
		calendar.set(year, month - 1, day, hour, minute, second);
		return calendar.getTime();
	}
}
