package microblog.net;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

import microblog.commons.EncryptDecrypt;
import microblog.net.interfaces.DataTransferListener;

//  ַܷ͵ˣӷ˻Ӧ
public class DataTransfer implements Runnable
{

	public static String sendData(String s, String urlStr)
	{
		try
		{
			URL url = new URL(urlStr);
			HttpURLConnection http = (HttpURLConnection) url.openConnection();
			http.setDoInput(true);
			http.setDoOutput(true);
			http.setDefaultUseCaches(false);
			http.setRequestMethod("POST");
			String data = EncryptDecrypt.simpleEncrypt(s);
			data = "data=" + data;
			OutputStream os = http.getOutputStream();
			os.write(data.getBytes());
			os.flush(); 

			InputStream is = http.getInputStream();
			InputStreamReader isr = new InputStreamReader(is, "utf-8");
			BufferedReader br = new BufferedReader(isr);

			String result = br.readLine();
			return result.trim();
		}
		catch (Exception e)
		{
			return e.getMessage();
		}
	}

	private String mData;
	private String mUrlStr;
	private DataTransferListener mListener;

	public DataTransfer(String data, String urlStr,
			DataTransferListener listener)
	{
		mData = data;
		mUrlStr = urlStr;
		mListener = listener;
	}

	public void run()
	{
		String result = DataTransfer.sendData(mData, mUrlStr);
		if (mListener != null)
			mListener.onResult(result);
	}

	public static void sendDataAsync(String s, String urlStr,
			DataTransferListener listener)
	{
		Thread thread = new Thread(new DataTransfer(s, urlStr, listener));
		thread.start();
	}
}
