package sina.weibo;

import java.util.HashMap;
import java.util.Map;

import microblog.commons.EncryptDecrypt;
import microblog.storage.SqliteCursor;
import sina.weibo.commons.AndroidUtil;
import sina.weibo.commons.Message;
import sina.weibo.commons.Values;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.ContextMenu;
import android.view.ContextMenu.ContextMenuInfo;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MenuItem.OnMenuItemClickListener;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.AdapterView.OnItemLongClickListener;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;

public class AccountManager extends Activity implements
		OnMenuItemClickListener, OnItemLongClickListener, OnItemClickListener,
		OnClickListener
{
	private SqliteCursor mSqliteCursor;
	private int mCurrentPosition;
	private AccountManagerAdapter mAccountManagerAdapter;
	private ListView mlvAccountList;
	private LinearLayout mlayoutButtons;
	private int mRequestCode;
	private String mCurrentAlias;

	private static boolean mSyncAccount = false;

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{

		super.onCreate(savedInstanceState);
		AndroidUtil.setContentView(this, R.layout.account_manager);

		mRequestCode = getIntent().getIntExtra("select_account", 0);

		if (mRequestCode == Values.REQUEST_CODE_SELECT_ACCOUNT)
		{
			setTitle("ѡʺ");
		}
		mCurrentAlias = WeiboMain.mainAlias;
		WeiboMain.init(this);

		mlvAccountList = (ListView) findViewById(R.id.lvAccountList);
		mlayoutButtons = (LinearLayout) findViewById(R.id.layout_buttons);
		Button btnOK = (Button) findViewById(R.id.btnOK);
		Button btnCancel = (Button) findViewById(R.id.btnCancel);
		btnOK.setOnClickListener(this);
		btnCancel.setOnClickListener(this);

		mAccountManagerAdapter = new AccountManagerAdapter(this);
		mlvAccountList.setAdapter(mAccountManagerAdapter);
		mlvAccountList.setOnItemLongClickListener(this);
		mlvAccountList.setOnItemClickListener(this);
		registerForContextMenu(mlvAccountList);

		if (mSyncAccount)
		{
			mlayoutButtons.setVisibility(View.VISIBLE);
		}

	}

	@Override
	public void onItemClick(AdapterView<?> parent, View view, int position,
			long id)
	{
		if (mRequestCode == Values.REQUEST_CODE_SELECT_ACCOUNT)
		{
			Intent intent = new Intent();
			intent.putExtra("account", ((SqliteCursor) mAccountManagerAdapter
					.getItem(position)).getString("microblog_account"));

			setResult(Values.RESULT_CODE_SELECT_ACCOUNT, intent);
			finish();
		}

	}

	@Override
	public boolean onItemLongClick(AdapterView<?> parent, View view,
			int position, long id)
	{
		mCurrentPosition = position;
		return false;
	}

	@Override
	public void onClick(View view)
	{
		switch (view.getId())
		{
			case R.id.btnOK:
				mAccountManagerAdapter.save();
			case R.id.btnCancel:
				mSyncAccount = false;
				mAccountManagerAdapter.notifyDataSetChanged();
				mlayoutButtons.setVisibility(View.GONE);
				break;

		}

	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu)
	{
		getMenuInflater().inflate(R.menu.account_manager_options_menu, menu);
		MenuItem miAddAccount = menu.findItem(R.id.mnuAddAccount);
		MenuItem miEditAccount = menu.findItem(R.id.mnuEditAccount);
		MenuItem miDeleteAccount = menu.findItem(R.id.mnuDeleteAccount);
		MenuItem miSyncAccount = menu.findItem(R.id.mnuSyncAccount);

		miDeleteAccount.setVisible(false);
		miEditAccount.setVisible(false);

		miAddAccount.setOnMenuItemClickListener(this);
		miEditAccount.setOnMenuItemClickListener(this);
		miEditAccount.setOnMenuItemClickListener(this);
		miSyncAccount.setOnMenuItemClickListener(this);
		return super.onCreateOptionsMenu(menu);
	}

	@Override
	public void onCreateContextMenu(ContextMenu menu, View view,
			ContextMenuInfo menuInfo)
	{
		if (mRequestCode == 0)
		{
			getMenuInflater()
					.inflate(R.menu.account_manager_context_menu, menu);
			MenuItem miAddAccount = menu.findItem(R.id.mnuAddAccount);
			MenuItem miEditAccount = menu.findItem(R.id.mnuEditAccount);
			MenuItem miDeleteAccount = menu.findItem(R.id.mnuDeleteAccount);
			MenuItem miSyncAccount = menu.findItem(R.id.mnuSyncAccount);
			MenuItem miMainAccount = menu.findItem(R.id.mnuMainAccount);
			miEditAccount.setVisible(false);
			miAddAccount.setOnMenuItemClickListener(this);
			miEditAccount.setOnMenuItemClickListener(this);
			miDeleteAccount.setOnMenuItemClickListener(this);
			miSyncAccount.setOnMenuItemClickListener(this);
			miMainAccount.setOnMenuItemClickListener(this);
		}
		super.onCreateContextMenu(menu, view, menuInfo);

	}

	@Override
	public boolean onMenuItemClick(MenuItem item)
	{
		Intent intent = null;

		switch (item.getItemId())
		{
			case R.id.mnuAddAccount:
				intent = new Intent(this, AddAccount.class);
				startActivityForResult(intent, Values.REQUEST_CODE_ADD_ACCOUNT);
				break;

			case R.id.mnuEditAccount:

				break;
			case R.id.mnuDeleteAccount:
				try
				{
					mAccountManagerAdapter.delete(mCurrentPosition);
					mSqliteCursor.requery();
					mAccountManagerAdapter.notifyDataSetChanged();
					Message.showMsg(this, "ɹɾʺ.");
				}
				catch (Exception e)
				{
					Message.showMsg(this, "ɾʺʧ.");
				}
				break;
			case R.id.mnuSyncAccount:

				if (mSyncAccount == false)
				{
					mSyncAccount = true;
					mlayoutButtons.setVisibility(View.VISIBLE);
					mAccountManagerAdapter.notifyDataSetChanged();
				}
				break;
			case R.id.mnuMainAccount:
				mSqliteCursor.moveToPosition(mCurrentPosition);
				mCurrentAlias = mSqliteCursor.getString("alias");

				mAccountManagerAdapter.notifyDataSetChanged();

				intent = new Intent();
				intent.putExtra("alias", mCurrentAlias);

				intent.putExtra("password", EncryptDecrypt
						.decrypt(mSqliteCursor.getString("password")));
				setResult(Values.RESULT_CODE_ACCOUNT_MANAGER, intent);
				break;
		}

		return false;
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data)
	{
		switch (requestCode)
		{
			case Values.REQUEST_CODE_ADD_ACCOUNT:
				switch (resultCode)
				{
					case Values.RESULT_CODE_ADD_ACCOUNT:
						mSqliteCursor.requery();

						mAccountManagerAdapter.notifyDataSetChanged();

						break;

					default:
						break;
				}
				break;

			default:
				break;
		}
		super.onActivityResult(requestCode, resultCode, data);
	}

	class AccountManagerAdapter extends BaseAdapter
	{
		private LayoutInflater mLayoutInflater;
		private Map<String, String> mMicroBlogMap;
		private Map<String, CheckBox> mSyncMap;

		public AccountManagerAdapter(Context context)
		{
			mLayoutInflater = (LayoutInflater) context
					.getSystemService(Context.LAYOUT_INFLATER_SERVICE);

			try
			{
				mSqliteCursor = AndroidUtil.getSystemDBService(
						AccountManager.this).getMicroBlogAccounts(
						WeiboMain.happyBlogAccount);
				mMicroBlogMap = Values.getMicroBlogNameMap(context);
				mSyncMap = new HashMap<String, CheckBox>();

			}
			catch (Exception e)
			{

			}
		}

		@Override
		public int getCount()
		{

			return mSqliteCursor.getCount();
		}

		@Override
		public Object getItem(int position)
		{
			mSqliteCursor.moveToPosition(position);
			return mSqliteCursor;
		}

		public String getAlias(int position)
		{
			mSqliteCursor.moveToPosition(position);
			return mSqliteCursor.getString("alias");
		}

		public void delete(int position) throws Exception
		{
			String alias = getAlias(position);
			AndroidUtil.getSystemDBService(AccountManager.this)
					.deleteAccountSync(alias);
		}

		public void save()
		{
			mSqliteCursor.moveToFirst();

			do
			{
				String alias = mSqliteCursor.getString("alias");

				CheckBox cbSync = mSyncMap.get(alias);

				if (cbSync != null)
				{
					AndroidUtil.getSystemDBService(AccountManager.this)
							.updateAccountSync(alias, cbSync.isChecked());
				}

			}
			while (mSqliteCursor.moveToNext());
			mSqliteCursor.requery();
		}

		@Override
		public long getItemId(int position)
		{
			// TODO Auto-generated method stub
			return position;
		}

		@Override
		public View getView(int position, View convertView, ViewGroup parent)
		{
			if (convertView == null)
				convertView = mLayoutInflater.inflate(R.layout.account_item,
						null);
			try
			{
				mSqliteCursor.moveToPosition(position);

				ImageView ivMicroBlogLogo = (ImageView) convertView
						.findViewById(R.id.ivMicroBlogLogo);
				ImageView ivHome = (ImageView) convertView
						.findViewById(R.id.ivHome);
				ImageView ivSync = (ImageView) convertView
						.findViewById(R.id.ivSync);
				CheckBox cbSync = (CheckBox) convertView
						.findViewById(R.id.cbSync);
				TextView tvMicroBlog = (TextView) convertView
						.findViewById(R.id.tvMicroBlog);
				TextView tvAlias = (TextView) convertView
						.findViewById(R.id.tvAlias);

				ivMicroBlogLogo.setImageResource(Values.BLOG_NAME_ID_MAP
						.get(mSqliteCursor.getString("microblog")));

				boolean sync = mSqliteCursor.getBoolean("sync");

				if (mSqliteCursor.getString("alias").equals(mCurrentAlias))
				{
					ivHome.setVisibility(View.VISIBLE);
					ivSync.setVisibility(View.GONE);
					cbSync.setVisibility(View.GONE);
				}
				else
				{
					ivHome.setVisibility(View.GONE);
					if (mSyncAccount)
					{
						cbSync.setVisibility(View.VISIBLE);
						ivSync.setVisibility(View.GONE);
						cbSync.setChecked(sync);

					}
					else
					{
						cbSync.setVisibility(View.GONE);
						if (sync)
							ivSync.setVisibility(View.VISIBLE);
						else
							ivSync.setVisibility(View.GONE);
					}
				}
				tvMicroBlog.setText(mMicroBlogMap.get(mSqliteCursor
						.getString("microblog")));
				tvAlias.setText(mSqliteCursor.getString("alias"));
				mSyncMap.put(mSqliteCursor.getString("alias"), cbSync);
			}
			catch (Exception e)
			{

			}
			return convertView;
		}
	}

	@Override
	public boolean onKeyUp(int keyCode, KeyEvent event)
	{
		switch (keyCode)
		{
			case KeyEvent.KEYCODE_BACK:
				mSyncAccount = false;
				break;

		}

		return super.onKeyUp(keyCode, event);
	}

	@Override
	protected void onDestroy()
	{
		if (mSqliteCursor != null)
			mSqliteCursor.close();

		super.onDestroy();
	}
}
