package sina.weibo;

import java.util.ArrayList;
import java.util.List;
import sina.weibo.commons.AndroidUtil;
import sina.weibo.commons.Message;
import sina.weibo.commons.Values;
import sina.weibo.process.AddAccountOperationProcess;
import microblog.MyMicroBlogAsync;
import microblog.commons.EncryptDecrypt;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.AdapterView.OnItemSelectedListener;

public class AddAccount extends Activity implements OnClickListener,
		OnItemSelectedListener
{
	private Spinner mspBlogList;
	private BlogListAdapter mBlogListAdapter;
	private int mMicroBlogIndex = 0;
	private EditText metAccount;
	private EditText metPassword;
	private EditText metAlias;

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		AndroidUtil.setContentView(this, R.layout.add_account);

		mspBlogList = (Spinner) findViewById(R.id.spBlogList);
		mBlogListAdapter = new BlogListAdapter(this);
		mspBlogList.setAdapter(mBlogListAdapter);
		mspBlogList.setOnItemSelectedListener(this);

		Button btnSave = (Button) findViewById(R.id.btnSave);
		Button btnClose = (Button) findViewById(R.id.btnClose);

		btnSave.setOnClickListener(this);
		btnClose.setOnClickListener(this);

		metAccount = (EditText) findViewById(R.id.etAccount);
		metPassword = (EditText) findViewById(R.id.etPassword);
		metAlias = (EditText) findViewById(R.id.etAccountAlias);

	}

	// //////////////¼/////////////////

	@Override
	public void onClick(View view)
	{

		switch (view.getId())
		{
			case R.id.btnSave:
				if ("".equals(metAccount.getText().toString()))
				{
					Message.showMsg(this,
							"" + mBlogListAdapter.getMBName(mMicroBlogIndex)
									+ "ʺ.");
					return;
				}
				if ("".equals(metPassword.getText().toString()))
				{
					Message.showMsg(this, ".");
					return;
				}

				metAlias.setText(metAccount.getText());
				String microblog = mBlogListAdapter.getItem(mMicroBlogIndex)
						.toString();

				MyMicroBlogAsync myMicroBlog = new MyMicroBlogAsync(metAccount
						.getText().toString(),
						metPassword.getText().toString(), new MyKeySecret());

				myMicroBlog.loginAsync(new AddAccountOperationProcess(this,
						WeiboMain.happyBlogAccount, microblog,
						metAccount.getText().toString(), EncryptDecrypt
								.encrypt(metPassword.getText().toString()),
						metAlias.getText().toString(), myMicroBlog));

				break;
			case R.id.btnClose:
				finish();
				break;
		}

	}

	@Override
	public void onItemSelected(AdapterView<?> parent, View view, int position,
			long id)
	{
		mMicroBlogIndex = position;

	}

	@Override
	public void onNothingSelected(AdapterView<?> parent)
	{
		// TODO Auto-generated method stub

	}

	// /////////////////////////////////
	class BlogListAdapter extends BaseAdapter
	{
		private List<String> mBlogList = new ArrayList<String>();
		private String[] mBlogs; // Blogıʶsinatwitter

		private LayoutInflater mLayoutInflater;

		public BlogListAdapter(Context context)
		{
			mBlogs = context.getResources().getStringArray(R.array.blog_list);

			for (int i = 0; i < mBlogs.length; i++)
			{
				int pos = mBlogs[i].indexOf("#");
				if (pos < 0)
					continue;
				mBlogList.add(mBlogs[i].substring(pos + 1));
				mBlogs[i] = mBlogs[i].substring(0, pos);
			}
			mLayoutInflater = (LayoutInflater) context
					.getSystemService(Context.LAYOUT_INFLATER_SERVICE);

		}

		@Override
		public int getCount()
		{
			return mBlogs.length;
		}

		@Override
		public Object getItem(int position)
		{

			return mBlogs[position];
		}

		public String getMBName(int position)
		{
			return mBlogList.get(position);
		}

		@Override
		public long getItemId(int position)
		{
			// TODO Auto-generated method stub
			return 0;
		}

		@Override
		public View getView(int position, View convertView, ViewGroup parent)
		{
			View view = mLayoutInflater.inflate(R.layout.microblog_list_item,
					null);
			ImageView ivBlogLogo = (ImageView) view
					.findViewById(R.id.ivBlogLogo);
			TextView tvBlogName = (TextView) view.findViewById(R.id.tvBlogName);
			ivBlogLogo.setImageResource(Values.BLOG_NAME_ID_MAP
					.get(mBlogs[position]));
			tvBlogName.setText(mBlogList.get(position));
			return view;
		}

	}
}
