package sina.weibo;

import java.io.ByteArrayOutputStream;

import microblog.StaticResources;
import microblog.thread.Task;
import sina.weibo.WriteMicroBlog.SyncStatus;
import sina.weibo.commons.AndroidUtil;
import sina.weibo.commons.Message;
import sina.weibo.commons.Values;
import sina.weibo.process.TaskListenerImpl;
import sina.weibo.storage.Cache;
import android.app.Activity;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Bitmap.CompressFormat;
import android.os.Bundle;
import android.view.ContextMenu;
import android.view.ContextMenu.ContextMenuInfo;
import android.view.MenuItem;
import android.view.MenuItem.OnMenuItemClickListener;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ImageView;

public class BigImageViewer extends Activity implements OnMenuItemClickListener
{
	private ImageView mivBigImage;

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);

		getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN,
				WindowManager.LayoutParams.FLAG_FULLSCREEN);

		requestWindowFeature(Window.FEATURE_NO_TITLE);

		AndroidUtil.setContentView(this, R.layout.big_image_viewer);

		mivBigImage = (ImageView) findViewById(R.id.ivBigImage);
		AndroidUtil.getMainTimelineOperationProcess(this).loadBitmap(
				WeiboMain.mCurrentStatus.getThumbnailPic(), mivBigImage);

		AndroidUtil.getMainTimelineOperationProcess(this).loadBitmap(
				WeiboMain.mCurrentStatus.getOriginalPic(), mivBigImage);

		registerForContextMenu(mivBigImage);
 
	}

	@Override
	protected void onDestroy()
	{
		mivBigImage.setImageBitmap(null);
		super.onDestroy();
	}

	@Override
	public void onCreateContextMenu(ContextMenu menu, View view,
			ContextMenuInfo menuInfo)
	{
		getMenuInflater().inflate(R.menu.status_viewer_context_menu, menu);

		MenuItem miImageSaveAs = menu.findItem(R.id.mnuImageSaveAs);
		miImageSaveAs.setOnMenuItemClickListener(this);
		MenuItem miShareImage = menu.findItem(R.id.mnuShareImage);
		miShareImage.setOnMenuItemClickListener(this);
		MenuItem miViewBigImage = menu.findItem(R.id.mnuViewBigImage);
		miViewBigImage.setVisible(false);

		super.onCreateContextMenu(menu, view, menuInfo);
	}

	@Override
	public boolean onMenuItemClick(MenuItem item)
	{
		switch (item.getItemId())
		{
			case R.id.mnuImageSaveAs:
				Intent intent = new Intent(this, SaveAsImage.class);
				startActivityForResult(intent,
						Values.REQUEST_CODE_SAVE_AS_IMAGE);

				break;

			case R.id.mnuShareImage:
				try
				{

					Task task = new Task();

					task.alias = WeiboMain.mainAlias;
					TaskListenerImpl taskProcess = new TaskListenerImpl(this);
					task.msg = "ͼƬ.";
					task.taskListener = taskProcess;
					ByteArrayOutputStream baos = new ByteArrayOutputStream();

					Bitmap bitmap = null;

					bitmap = Cache
							.restoreBitmap(WeiboMain.mCurrentStatus
									.getOriginalPic());

					bitmap.compress(CompressFormat.JPEG, 100, baos);
					task.image = baos.toByteArray();
					StaticResources.AddTask(task);

					// ͬ΢
					new Thread(new SyncStatus(this, task.msg, task.image))
							.start();

					if (bitmap != null && !bitmap.isRecycled())
						bitmap.recycle();
					bitmap = null;

					finish();
					Message.showTaskQueueMsg("ͼƬ", this);
				}
				catch (Exception e)
				{
					Message.showMsg(this, "ͼƬʧ.");
				}
				break;
		}
		return false;
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data)
	{
		switch (requestCode)
		{
			case Values.REQUEST_CODE_SAVE_AS_IMAGE:
				switch (resultCode)
				{
					case Values.RESULT_CODE_SAVE_AS_IMAGE:
						String path = data.getStringExtra("path");
						try
						{
							Bitmap bitmap = null;

							bitmap = Cache
									.restoreBitmap(WeiboMain.mCurrentStatus
											.getOriginalPic());

							if (bitmap == null)
							{
								Message.showMsg(this, "ͼ񱣴ʧ.");
							}
							else
							{
								AndroidUtil.BitmapSaveAsJPG(bitmap, path);
								Message.showMsg(this, "ͼ񱣴ɹ.");
								AndroidUtil.freeBitmap(bitmap);
							}
						}
						catch (Exception e)
						{
							Message.showMsg(this, "ͼ񱣴ʧ.");
						}
						break;

					default:
						break;
				}

				break;

			default:
				break;
		}
		super.onActivityResult(requestCode, resultCode, data);
	}

}
