package sina.weibo;

import java.util.ArrayList;

import microblog.StaticResources;
import microblog.commons.Const;
import microblog.thread.Task;
import sina.weibo.commons.AndroidUtil;
import sina.weibo.commons.Message;
import sina.weibo.commons.Values;
import sina.weibo.process.TaskListenerImpl;
import android.app.Activity;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.speech.RecognizerIntent;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.TextView;

public class Comment extends Activity implements TextWatcher
{
	private EditText etComment;
	private CheckBox cbPostStatus;
	private TextView tvRemainWordCount;
	private Message message;
	private String mStatusId;
	private String mCommentId;
	private String mCommentUserName;
	private String mCommentText;
	private String mTaskType = Const.TASK_TYPE_COMMENT;

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		 
		// TODO Auto-generated method stub
		super.onCreate(savedInstanceState);
		setContentView(R.layout.comment);
		message = new Message(this);
		mStatusId = getIntent().getStringExtra("statusId");
		etComment = (EditText) findViewById(R.id.etComment);
		cbPostStatus = (CheckBox) findViewById(R.id.cbPostStatus);
		tvRemainWordCount = (TextView) findViewById(R.id.tvRemainWordCount);

		etComment.addTextChangedListener(this);
		updateMessage();
		mCommentUserName = getIntent().getStringExtra("username");
		mCommentText = getIntent().getStringExtra("commentText");
		mTaskType = getIntent().getStringExtra("taskType");
		if (mTaskType == null)
			mTaskType = Const.TASK_TYPE_COMMENT;
		mCommentId = getIntent().getStringExtra("commentId");

		if (Const.TASK_TYPE_REPLY_COMMENT.equals(mTaskType))
		{
			setTitle("ظ");
		}

	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data)
	{
		if (resultCode == Activity.RESULT_OK)
		{
			switch (requestCode)
			{
				case Values.REQUEST_CODE_FACE:
					// ѡ
					String face = data.getStringExtra("face");
					StringBuilder sb = new StringBuilder(etComment.getText()
							.toString());
					int start = etComment.getSelectionStart();
					sb.insert(start, face);

					etComment.setText(sb.toString());
					etComment.setSelection(start + face.length());
					break;
				case Values.REQUEST_CODE_VOICE_RECOGNITION:

					ArrayList<String> matches = data
							.getStringArrayListExtra(RecognizerIntent.EXTRA_RESULTS);
					if (matches.size() > 0)
					{
						sb = new StringBuilder(etComment.getText().toString());
						start = etComment.getSelectionStart();

						sb.insert(start, matches.get(0));
						etComment.setText(sb.toString());
						etComment.setSelection(start + matches.get(0).length());
					}
					break;
			}
		}
		super.onActivityResult(requestCode, resultCode, data);
	}
	public void onClick_Voice(View view)
	{
		AndroidUtil.voiceRecognizer(this);
	}
	public void onClick_Post(View view)
	{
		String comment = etComment.getText().toString().trim();
		if (!"".equals(comment))
		{
			Task task = new Task();
			task.taskType = mTaskType;
			TaskListenerImpl taskListenerImpl = new TaskListenerImpl(this);
			task.taskListener = taskListenerImpl;
			task.msg = comment;
			task.alias = WeiboMain.mainAlias;
			if (Const.TASK_TYPE_REPLY_COMMENT.equals(mTaskType))
			{
				task.replyStatus = "ظ@" + mCommentUserName + ":" + comment;
						//+ "//@" + mCommentUserName + ":" + mCommentText;
				
				
				if (WeiboMain.mCurrentStatus != null && WeiboMain.mCurrentStatus.getRetweetDetails() != null)
				{
					task.replyStatus += "//@"
							+ WeiboMain.mCurrentUserName + ":"
							+ WeiboMain.mCurrentStatusText;
				}
				
			}
			if (false/*
					 * AndroidUtil.getMainTimelineOperationProcess(this).getDataType
					 * () == Const.DATA_TYPE_SEARCH_MBLOG
					 */)
			{
				WeiboMain.mProcessTasks.mDataType = Const.DATA_TYPE_SINA_COMMENT;
				task.srcid = WeiboMain.mCurrentMBlog.mblogId;
				task.srcuid = WeiboMain.mCurrentMBlog.userId;
				task.postStatus = cbPostStatus.isChecked();
			}
			else
			{
				WeiboMain.mProcessTasks.mDataType = Const.DATA_TYPE_SINA_COMMENT;

				task.statusId = mStatusId;
				task.commentId = mCommentId;
				task.postStatus = cbPostStatus.isChecked();

			}
			StaticResources.AddTask(task);
			finish();
			if (Const.TASK_TYPE_REPLY_COMMENT.equals(mTaskType))
				Message.showTaskQueueMsg("ظ", this);
			else
				Message.showTaskQueueMsg("д", this);

		}
		else
		{
			if (Const.TASK_TYPE_REPLY_COMMENT.equals(mTaskType))
				message.showMsg("ظ.");
			else
				message.showMsg(".");
		}

	}

	@Override
	public void afterTextChanged(Editable s)
	{
		// TODO Auto-generated method stub

	}

	@Override
	public void beforeTextChanged(CharSequence s, int start, int count,
			int after)
	{
		// TODO Auto-generated method stub

	}

	public void onClick_Face(View view)
	{
		Intent intent = new Intent(this, FaceList.class);
		startActivityForResult(intent, 3);
	}

	@Override
	public void onTextChanged(CharSequence s, int start, int before, int count)
	{
		updateMessage();

	}

	private void updateMessage()
	{

		int remainWordCount = 140 - etComment.getText().length();
				
		if (remainWordCount >= 0)
		{
			tvRemainWordCount.setText("㻹" + remainWordCount + "");
			tvRemainWordCount.setTextColor(Color.WHITE);
		}

		else
		{
			remainWordCount = -remainWordCount;
			tvRemainWordCount.setText("ѳ" + remainWordCount + "");
			tvRemainWordCount.setTextColor(Color.RED);
		}

	}

}
