package sina.weibo;

import java.io.ByteArrayOutputStream;
import java.util.Date;

import microblog.MyMicroBlogAsync;
import microblog.MyUtil;
import microblog.StaticResources;
import microblog.commons.Const;
import microblog.thread.Task;
import sina.weibo.WriteMicroBlog.SyncStatus;
import sina.weibo.commons.AndroidUtil;
import sina.weibo.commons.Message;
import sina.weibo.commons.Values;
import sina.weibo.interfaces.HandlerRun;
import sina.weibo.process.MainContextMenuProcess;
import sina.weibo.process.OperationProcess;
import sina.weibo.process.TaskListenerImpl;
import sina.weibo.storage.Cache;
import weibo4j.Count;
import weibo4j.MBlog;
import weibo4j.RetweetDetails;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Bitmap.CompressFormat;
import android.os.Bundle;
import android.os.Handler;
import android.text.Html;
import android.view.ContextMenu;
import android.view.ContextMenu.ContextMenuInfo;
import android.view.MenuItem;
import android.view.MenuItem.OnMenuItemClickListener;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;

public class MicroBlogViewer extends Activity implements OnClickListener,
		OnMenuItemClickListener
{
	private MainContextMenuProcess mMainContextMenuProcess;
	private TextView mtvRepostCount;
	private TextView mtvCommentCount;
	private TextView mtvShowComments;
	private ImageView mivProfileImage;
	private ScrollView msvStatusView;

	private Handler mHandler = new Handler();

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{

		super.onCreate(savedInstanceState);

		View view = getLayoutInflater().inflate(R.layout.microblog_viewer, null);
		setContentView(view);
		AndroidUtil.changeBackground(getWindow());
		AndroidUtil.changeColorTransparency(view);
		mMainContextMenuProcess = new MainContextMenuProcess(this);

		LinearLayout llComment = (LinearLayout) findViewById(R.id.llComment);
		LinearLayout llRepost = (LinearLayout) findViewById(R.id.llRepost);
		LinearLayout llFavorite = (LinearLayout) findViewById(R.id.llFavorite);

		mtvRepostCount = (TextView) findViewById(R.id.tvRepostCount);
		mtvCommentCount = (TextView) findViewById(R.id.tvCommentCount);
		TextView tvName = (TextView) findViewById(R.id.tvName);
		ImageView ivVerified = (ImageView) findViewById(R.id.ivVerified);
		TextView tvCreatedAt = (TextView) findViewById(R.id.tvCreatedAt);
		ImageView ivPicture = (ImageView) findViewById(R.id.ivPicture);
		TextView tvText = (TextView) findViewById(R.id.tvText);
		TextView tvRetweetDetailText = (TextView) findViewById(R.id.tvRetweetDetailText);

		mtvShowComments = (TextView) findViewById(R.id.tvShowComments);
		mtvShowComments.setOnClickListener(this);
		ImageView ivRetweetDetailProfileImage = (ImageView) findViewById(R.id.ivRetweetDetailProfileImage);
		
		if (Const.TIMELINE_TYPE_STATUS.equals(AndroidUtil
				.getMainTimelineOperationProcess(this).getType())
				|| Const.TIMELINE_TYPE_SEARCH_MBLOG.equals(AndroidUtil
						.getMainTimelineOperationProcess(this).getType()))
		{

			tvName.setText(WeiboMain.mCurrentUserName);

			if (true/* HappyBlogAndroid.mCurrentStatus != null */)
			{

				if (!"".equals(WeiboMain.mCurrentStatus.getBmiddlePic()))
					ivPicture.setVisibility(View.VISIBLE);
				else
					ivPicture.setVisibility(View.GONE);

				if (WeiboMain.mCurrentStatus.getUser().isVerified())
				{
					ivVerified.setVisibility(View.VISIBLE);
				}
				tvCreatedAt.setText(MyUtil.getTimeStr(
						WeiboMain.mCurrentStatus.getCreatedAt(),
						new Date()));
				Count count = null; // HappyBlogAndroid.mCurrentStatus.getCount();

				if (count == null)
				{
					MyMicroBlogAsync myMicroBlogAsync = AndroidUtil
							.getMyMicroBlogs(this).get(
									WeiboMain.mainAlias);

					if (myMicroBlogAsync != null)
					{
						MyOperationProcess myOperationProcess = new MyOperationProcess(
								this);
						myMicroBlogAsync.getCount(
								WeiboMain.mCurrentStatusId,
								myOperationProcess);
					}
				}
				else
				{
					setRepostCommentCount();
					if (count.getCommentCount() == 0)
					{
						mtvShowComments.setVisibility(View.GONE);
					}
					else
					{
						mtvShowComments.setVisibility(View.VISIBLE);
					}

				}

				mivProfileImage = (ImageView) findViewById(R.id.ivProfileImage);
				AndroidUtil.getMainTimelineOperationProcess(this).loadBitmap(
						WeiboMain.mCurrentProfileImagePath,
						mivProfileImage);
				tvText.setText(Html.fromHtml(AndroidUtil
						.atBlue(WeiboMain.mCurrentStatus.getText())));
				RetweetDetails retweetDetails = WeiboMain.mCurrentStatus
						.getRetweetDetails();
				LinearLayout linearLayout3 = (LinearLayout) findViewById(R.id.linearlayout3);
				if (retweetDetails != null)
				{

					linearLayout3.setVisibility(View.VISIBLE);
					tvRetweetDetailText.setText(Html.fromHtml(AndroidUtil
							.atBlue("@"
									+ retweetDetails.getRetweetingUser()
											.getName() + ":"
									+ retweetDetails.getText())));

					AndroidUtil
							.getMainTimelineOperationProcess(this)
							.loadBitmap(
									WeiboMain.mCurrentRetweetDetailProfileImagePath,
									ivRetweetDetailProfileImage);

				}
				else
				{
					linearLayout3.setVisibility(View.GONE);
				}
				ImageView ivStatusImage = (ImageView) findViewById(R.id.ivStatusImage);
				ImageView ivStatusImage1 = (ImageView) findViewById(R.id.ivStatusImage1);
				ivStatusImage.setVisibility(View.VISIBLE);
				ivStatusImage1.setVisibility(View.VISIBLE);

				if (!"".equals(WeiboMain.mCurrentStatus
						.getThumbnailPic()))
				{
					if (retweetDetails != null)
					{
						AndroidUtil.getMainTimelineOperationProcess(this)
								.loadBitmap(
										WeiboMain.mCurrentStatus
												.getThumbnailPic(),
										ivStatusImage);
						ivStatusImage1.setVisibility(View.GONE);

					}
					else
					{
						AndroidUtil.getMainTimelineOperationProcess(this)
								.loadBitmap(
										WeiboMain.mCurrentStatus
												.getThumbnailPic(),
										ivStatusImage1);
						ivStatusImage.setVisibility(View.GONE);
					}
					View contextView1 = findViewById(R.id.linearlayout4);
					registerForContextMenu(contextView1);
				}
				else
				{
					ivStatusImage.setVisibility(View.GONE);
					ivStatusImage1.setVisibility(View.GONE);
				}

			}
			TextView tvSource = (TextView) findViewById(R.id.tvSource);

			tvSource.setText(Html.fromHtml(""
					+ AndroidUtil.setTextColor(WeiboMain.mCurrentStatus
							.getSource(), "blue")));
		}
		else if (Const.TIMELINE_TYPE_SEARCH_MBLOG.equals(AndroidUtil
				.getMainTimelineOperationProcess(this).getType()))
		{

			MBlog mBlog = WeiboMain.mCurrentMBlog;
			View buttonView = findViewById(R.id.llButtonView);
			buttonView.setVisibility(View.GONE);
			if (mBlog != null)
			{

				tvName.setText(mBlog.nick);

				if (!"".equals(mBlog.pic))
					ivPicture.setVisibility(View.VISIBLE);
				else
					ivPicture.setVisibility(View.GONE);

				if (mBlog.vip == 1)
				{
					ivVerified.setVisibility(View.VISIBLE);
				}

				tvCreatedAt.setText(MyUtil.getTimeStr(mBlog.time, new Date()));

				mtvRepostCount.setText("ת:" + mBlog.rtNum);
				mtvCommentCount.setText(":" + mBlog.commentNum);

				if (mBlog.commentNum == 0)
				{
					mtvShowComments.setVisibility(View.GONE);
				}
				else
				{
					mtvShowComments.setVisibility(View.VISIBLE);
				}

				mivProfileImage = (ImageView) findViewById(R.id.ivProfileImage);
				AndroidUtil.getMainTimelineOperationProcess(this).loadBitmap(
						mBlog.portrait, mivProfileImage);
				String text = null;

				if ("".equals(mBlog.rtReason))
				{
					text = mBlog.content;
				}
				else
				{
					text = mBlog.rtReason;
				}
				tvText.setText(Html.fromHtml(AndroidUtil.atBlue(text)));

				LinearLayout linearLayout3 = (LinearLayout) findViewById(R.id.linearlayout3);
				if (!"".equals(mBlog.rtReason))
				{

					linearLayout3.setVisibility(View.VISIBLE);
					tvRetweetDetailText.setText(Html.fromHtml(AndroidUtil
							.atBlue("@" + mBlog.rtRootNick + ":"
									+ mBlog.content)));

					ivRetweetDetailProfileImage.setVisibility(View.GONE);

				}
				else
				{
					linearLayout3.setVisibility(View.GONE);
				}
				ImageView ivStatusImage = (ImageView) findViewById(R.id.ivStatusImage);
				ImageView ivStatusImage1 = (ImageView) findViewById(R.id.ivStatusImage1);
				ivStatusImage.setVisibility(View.VISIBLE);
				ivStatusImage1.setVisibility(View.VISIBLE);

				if (!"".equals(mBlog.pic))
				{
					if (!"".equals(mBlog.rtReason))
					{
						AndroidUtil.getMainTimelineOperationProcess(this)
								.loadBitmap(mBlog.pic, ivStatusImage);
						ivStatusImage1.setVisibility(View.GONE);
					}
					else
					{
						AndroidUtil.getMainTimelineOperationProcess(this)
								.loadBitmap(mBlog.pic, ivStatusImage1);
						ivStatusImage1.setVisibility(View.GONE);
					}
					View contextView1 = findViewById(R.id.linearlayout4);
					registerForContextMenu(contextView1);
				}
				else
				{
					ivStatusImage.setVisibility(View.GONE);
					ivStatusImage1.setVisibility(View.GONE);
				}

			}

			TextView tvSource = (TextView) findViewById(R.id.tvSource);

			tvSource.setText(Html.fromHtml(""
					+ AndroidUtil.setTextColor(mBlog.source, "blue")));

		}
		llComment.setOnClickListener(this);
		llRepost.setOnClickListener(this);
		llFavorite.setOnClickListener(this);

	}

	private void setRepostCommentCount()
	{
		mtvRepostCount.setText("ת:"
				+ WeiboMain.mCurrentStatus.getCount().getRepostCount());
		mtvCommentCount.setText(":"
				+ WeiboMain.mCurrentStatus.getCount().getCommentCount());

	}

	// ///////////////event///////////////////////
	@Override
	public void onClick(View view)
	{
		Intent intent = null;
		switch (view.getId())
		{
			case R.id.llRepost:
				mMainContextMenuProcess.repost();
				break;

			case R.id.llComment:
				mMainContextMenuProcess.comment();
				break;
			case R.id.llFavorite:
				mMainContextMenuProcess.favorite();
				break;
			case R.id.tvShowComments:
				intent = new Intent(this, CommentViewer.class);
				startActivity(intent);
				break;
		}

	}

	class MyOperationProcess extends OperationProcess
	{

		public MyOperationProcess(Context context)
		{
			super(context);
			// TODO Auto-generated constructor stub
		}

		@Override
		public void onGetCountException()
		{
			// TODO Auto-generated method stub
			super.onGetCountException();
		}

		@Override
		public void onGetCountSuccess(final Count count)
		{
			super.onGetCountSuccess(count);
			WeiboMain.mCurrentStatus.setCount(count);
			try
			{
				myHandler.run(new HandlerRun()
				{

					@Override
					public void invoke()
					{
						setRepostCommentCount();
						if (count.getCommentCount() == 0)
						{
							mtvShowComments.setVisibility(View.GONE);
						}
						else
						{
							mtvShowComments.setVisibility(View.VISIBLE);
						}

					}
				});

			}
			catch (Exception e)
			{

			}

		}

	}

	@Override
	public boolean onMenuItemClick(MenuItem item)
	{
		Intent intent = null;
		switch (item.getItemId())
		{
			case R.id.mnuViewBigImage:
				mMainContextMenuProcess.viewBigImage();
				break;

			case R.id.mnuImageSaveAs:
				intent = new Intent(this, SaveAsImage.class);
				startActivityForResult(intent,
						Values.REQUEST_CODE_SAVE_AS_IMAGE);
				break;

			case R.id.mnuShareImage:
				try
				{

					Task task = new Task();

					task.alias = WeiboMain.mainAlias;
					TaskListenerImpl taskProcess = new TaskListenerImpl(this);
					task.msg = "ͼƬ.";
					task.taskListener = taskProcess;
					ByteArrayOutputStream baos = new ByteArrayOutputStream();

					Bitmap bitmap = null;

					bitmap = Cache
							.restoreBitmap(WeiboMain.mCurrentStatus
									.getThumbnailPic());

					bitmap.compress(CompressFormat.JPEG, 100, baos);
					task.image = baos.toByteArray();
					StaticResources.AddTask(task);

					// ͬ΢
					new Thread(new SyncStatus(this, task.msg, task.image))
							.start();

					if (bitmap != null && !bitmap.isRecycled())
						bitmap.recycle();
					bitmap = null;

					finish();
					Message.showTaskQueueMsg("ͼƬ", this);
				}
				catch (Exception e)
				{
					Message.showMsg(this, "ͼƬʧ.");
				}
				break;

		}
		return false;
	}

	@Override
	public void onCreateContextMenu(ContextMenu menu, View v,
			ContextMenuInfo menuInfo)
	{

		getMenuInflater().inflate(R.menu.status_viewer_context_menu, menu);

		MenuItem mnuViewBigImage = (MenuItem) menu
				.findItem(R.id.mnuViewBigImage);

		MenuItem mnuImageSaveAs = (MenuItem) menu.findItem(R.id.mnuImageSaveAs);
		MenuItem mnuShareImage = (MenuItem) menu.findItem(R.id.mnuShareImage);

		mnuViewBigImage.setOnMenuItemClickListener(this);
		mnuImageSaveAs.setOnMenuItemClickListener(this);
		mnuShareImage.setOnMenuItemClickListener(this);
		super.onCreateContextMenu(menu, v, menuInfo);
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data)
	{

		switch (requestCode)
		{
			case Values.REQUEST_CODE_SAVE_AS_IMAGE:
				switch (resultCode)
				{
					case Values.RESULT_CODE_SAVE_AS_IMAGE:
						String path = data.getStringExtra("path");

						try
						{
							Bitmap bitmap = null;

							bitmap = Cache
									.restoreBitmap(WeiboMain.mCurrentStatus
											.getThumbnailPic());

							if (bitmap == null)
							{
								Message.showMsg(this, "ͼ񱣴ʧ.");
							}
							else
							{
								AndroidUtil.BitmapSaveAsJPG(bitmap, path);
								Message.showMsg(this, "ͼ񱣴ɹ.");
								AndroidUtil.freeBitmap(bitmap);
							}
						}
						catch (Exception e)
						{
							Message.showMsg(this, "ͼ񱣴ʧ.");
						}
						break;
				}

				break;

			default:
				break;
		}
		super.onActivityResult(requestCode, resultCode, data);
	}

}
