package sina.weibo;

import java.util.ArrayList;

import microblog.StaticResources;
import microblog.commons.Const;
import microblog.thread.Task;
import sina.weibo.commons.AndroidUtil;
import sina.weibo.commons.Message;
import sina.weibo.commons.Values;
import sina.weibo.process.TaskListenerImpl;
import android.app.Activity;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.speech.RecognizerIntent;
import android.text.Editable;
import android.text.Html;
import android.text.TextWatcher;
import android.view.View;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.TextView;

public class Repost extends Activity implements TextWatcher
{
	private EditText etRepost;
	private CheckBox cbComment1;
	private CheckBox cbComment2;
	private TextView tvRemainWordCount;
	private Message message;
	private String mStatusId;
	private String mRetweetId;

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{

		super.onCreate(savedInstanceState);
		View view = getLayoutInflater().inflate(R.layout.repost, null);
		setContentView(view);
		AndroidUtil.changeBackground(getWindow());
		AndroidUtil.changeColorTransparency(view);
		message = new Message(this);

		etRepost = (EditText) findViewById(R.id.etRepost);
		cbComment1 = (CheckBox) findViewById(R.id.cbComment1);
		cbComment2 = (CheckBox) findViewById(R.id.cbComment2);
		tvRemainWordCount = (TextView) findViewById(R.id.tvRemainWordCount);
		etRepost.addTextChangedListener(this);
		mStatusId = getIntent().getStringExtra("statusId");
		mRetweetId = getIntent().getStringExtra("retweetId");

		boolean hasRetweeting = getIntent().getBooleanExtra("hasRetweeting",
				false);
		String statusText = getIntent().getStringExtra("statusText");
		String username = getIntent().getStringExtra("username");
		String retweetUsername = getIntent().getStringExtra("retweetUsername");
		if (username == null)
			username = WeiboMain.mCurrentMBlog.nick;
		cbComment1.setText(Html.fromHtml("ͬʱΪ"
				+ AndroidUtil.setTextColor(username, "red") + "۷"));

		if (hasRetweeting)
		{
			etRepost.setText(" //@" + username + ":" + statusText);
			etRepost.setSelection(0, 1);
			etRepost.getText().delete(0, 1);
			cbComment2.setText(Html.fromHtml("ͬʱΪ"
					+ AndroidUtil.setTextColor(retweetUsername, "red")
					+ "۷"));
		}
		else
		{
			cbComment2.setVisibility(View.GONE);
		}

		updateMessage();
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data)
	{
		if (resultCode == Activity.RESULT_OK)
		{
			switch (requestCode)
			{
				case Values.REQUEST_CODE_FACE:
					// ѡ
					String face = data.getStringExtra("face");
					StringBuilder sb = new StringBuilder(etRepost.getText()
							.toString());
					int start = etRepost.getSelectionStart();
					sb.insert(start, face);

					etRepost.setText(sb.toString());
					etRepost.setSelection(start + face.length());
					break;
				case Values.REQUEST_CODE_VOICE_RECOGNITION:

					ArrayList<String> matches = data
							.getStringArrayListExtra(RecognizerIntent.EXTRA_RESULTS);
					if (matches.size() > 0)
					{
						sb = new StringBuilder(etRepost.getText().toString());
						start = etRepost.getSelectionStart();

						sb.insert(start, matches.get(0));
						etRepost.setText(sb.toString());
						etRepost.setSelection(start + matches.get(0).length());
					}
					break;
			}
		}
		super.onActivityResult(requestCode, resultCode, data);
	}

	public void onClick_Voice(View view)
	{
		AndroidUtil.voiceRecognizer(this);
	}

	public void onClick_Face(View view)
	{
		Intent intent = new Intent(this, FaceList.class);
		startActivityForResult(intent, 3);
	}

	public void onClick_Post(View view)
	{
		String repost = etRepost.getText().toString().trim();
		if ("".equals(repost))
		{
			repost = "ת΢";
		}
		Task task = new Task();
		task.taskType = Const.TASK_TYPE_REPOST;
		TaskListenerImpl taskListenerImpl = new TaskListenerImpl(this);
		task.taskListener = taskListenerImpl;
		task.msg = repost;
		task.alias = WeiboMain.mainAlias;
		if (false/*
				 * AndroidUtil
				 * .getMainTimelineOperationProcess(this).getDataType() ==
				 * Const.DATA_TYPE_SEARCH_MBLOG
				 */)
		{
			task.srcid = WeiboMain.mCurrentMBlog.mblogId;
			task.srcuid = WeiboMain.mCurrentMBlog.userId;
			task.comment1 = cbComment1.isChecked();
			WeiboMain.mProcessTasks.mDataType = Const.DATA_TYPE_SINA_REPOST;
		}
		else
		{

			task.statusId = mStatusId;
			task.comment1 = cbComment1.isChecked();
			task.comment2 = cbComment2.isChecked();
			task.retweetId = mRetweetId;
		}
		StaticResources.AddTask(task);
		finish();
		Message.showTaskQueueMsg("ת΢", this);

	}

	@Override
	public void afterTextChanged(Editable s)
	{
		// TODO Auto-generated method stub

	}

	@Override
	public void beforeTextChanged(CharSequence s, int start, int count,
			int after)
	{
		// TODO Auto-generated method stub

	}

	@Override
	public void onTextChanged(CharSequence s, int start, int before, int count)
	{
		updateMessage();

	}

	private void updateMessage()
	{

		int remainWordCount = Values.getRemainWordCount(etRepost.getText()
				.toString());
		if (remainWordCount >= 0)
		{
			tvRemainWordCount.setText("㻹" + remainWordCount + "");
			tvRemainWordCount.setTextColor(Color.BLACK);
		}

		else
		{
			remainWordCount = -remainWordCount;
			tvRemainWordCount.setText("ѳ" + remainWordCount + "");
			tvRemainWordCount.setTextColor(Color.RED);
		}

	}

}
