package sina.weibo;

import java.io.File;

import sina.weibo.commons.Message;
import sina.weibo.commons.Values;
import sina.weibo.widget.FileBrowser;
import sina.weibo.widget.OnFileBrowserListener;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;

public class SaveAsImage extends Activity implements OnFileBrowserListener,
		OnClickListener
{
	private String mPath = android.os.Environment.getExternalStorageDirectory()
			.getAbsolutePath();

	private EditText metFilename;

	@Override
	public void onFileItemClick(String filename)
	{
		setTitle(filename);
		metFilename.setText(filename.substring(filename.lastIndexOf("/") + 1, filename.length() - 4));

	}

	@Override
	public void onDirItemClick(String path)
	{
		setTitle(path);
		mPath = path;

	}

	@Override
	public void onClick(View view)
	{
		switch (view.getId())
		{
			case R.id.btnSave:
				final String filename = metFilename.getText().toString() +  ".jpg";
				if (".jpg".equals(filename))
				{
					Message.showMsg(this, "Ҫļչ.");
					return;
				}
				else
				{
					
					if (new File(mPath + "/" + filename).exists())
					{
						try
						{
							new AlertDialog.Builder(this)
									.setIcon(R.drawable.question)
									.setTitle("ļظǷ񸲸ǣ")
									.setPositiveButton(
											"ȷ",
											new DialogInterface.OnClickListener()
											{
												public void onClick(
														DialogInterface dialog,
														int whichButton)
												{
													Intent intent = new Intent();
													intent.putExtra("path",
															mPath + "/"
																	+ filename);
													setResult(
															Values.RESULT_CODE_SAVE_AS_IMAGE,
															intent);
													finish();
												}
											})
									.setNegativeButton(
											"ȡ",
											new DialogInterface.OnClickListener()
											{
												public void onClick(
														DialogInterface dialog,
														int whichButton)
												{

												}
											}).show();
						}
						catch (Exception e)
						{
							// TODO: handle exception
						}
					}
					else
					{
						Intent intent = new Intent();
						intent.putExtra("path", mPath + "/" + filename);
						setResult(Values.RESULT_CODE_SAVE_AS_IMAGE, intent);
						finish();
					}
				}

				break;

			case R.id.btnCancel:
				finish();
				break;
		}

	}

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		// TODO Auto-generated method stub
		super.onCreate(savedInstanceState);
		setContentView(R.layout.save_as_image);
		FileBrowser fileBrowser = (FileBrowser) findViewById(R.id.filebrowser);
		fileBrowser.setOnFileBrowserListener(this);

		Button btnSave = (Button) findViewById(R.id.btnSave);
		Button btnCancel = (Button) findViewById(R.id.btnCancel);

		btnSave.setOnClickListener(this);
		btnCancel.setOnClickListener(this);

		metFilename = (EditText) findViewById(R.id.etFilename);
	}

}
