package sina.weibo;

import java.util.ArrayList;

import microblog.MyMicroBlogAsync;
import microblog.commons.Const;
import sina.weibo.commons.AndroidUtil;
import sina.weibo.commons.Message;
import sina.weibo.commons.Values;
import sina.weibo.process.MainContextMenuProcess;
import sina.weibo.process.TimelineOperationProcess;
import weibo4j.Comment;
import weibo4j.Paging;
import weibo4j.User;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.speech.RecognizerIntent;
import android.view.ContextMenu;
import android.view.ContextMenu.ContextMenuInfo;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.CompoundButton;
import android.widget.CompoundButton.OnCheckedChangeListener;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.RadioButton;
import android.widget.Toast;

public class Search extends Activity implements OnClickListener,
		OnItemClickListener, OnCheckedChangeListener
{

	private EditText metKeyword;
	private ImageButton mibSearch;
	private RadioButton mrbSearchMBlog;
	private RadioButton mrbSearchUser;

	private int mPage = 1;

	public static TimelineOperationProcess mSearchMBlogOperationProcess;
	public static TimelineOperationProcess mSearchUserOperationProcess;
	private TimelineOperationProcess mOldOPerationProcess;
	private MainContextMenuProcess mMainContextMenuProcess;

	public static String mKeyword = "";
	public static String mOldKeyword = "";

	@Override
	public void onCheckedChanged(CompoundButton buttonView, boolean isChecked)
	{
		if (isChecked)
		{
			mKeyword = "";
		}

	}

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		WeiboMain.init(this);
		String mainAlias = WeiboMain.happyBlogConfig.getString(
				Values.MAIN_ALIAS, "");
		if ("".equals(mainAlias))
		{
			Message.showMsg(this, "ûе¼޷б.");
			finish();
		}
		// requestWindowFeature(Window.FEATURE_INDETERMINATE_PROGRESS);
		super.onCreate(savedInstanceState);

		View view = getLayoutInflater().inflate(R.layout.search, null);
		setContentView(view);
		AndroidUtil.changeBackground(getWindow());
		AndroidUtil.changeColorTransparency(view);
		metKeyword = (EditText) findViewById(R.id.etKeyword);
		mibSearch = (ImageButton) findViewById(R.id.ibSearch);
		mrbSearchMBlog = (RadioButton) findViewById(R.id.rbSearchMBlog);
		mrbSearchUser = (RadioButton) findViewById(R.id.rbSearchUser);

		mibSearch.setOnClickListener(this);
		mrbSearchMBlog.setOnCheckedChangeListener(this);
		mrbSearchUser.setOnCheckedChangeListener(this);

		mSearchMBlogOperationProcess = new TimelineOperationProcess(this,
				Const.TIMELINE_TYPE_SEARCH_MBLOG, Const.DATA_TYPE_SEARCH_MBLOG,
				R.id.lvSearchResult);
		mSearchMBlogOperationProcess.mInitData = false;
		mSearchUserOperationProcess = new TimelineOperationProcess(this,
				Const.TIMELINE_TYPE_SEARCH_USER, Const.DATA_TYPE_SEARCH_USER,
				R.id.lvSearchResult);
		mSearchUserOperationProcess.mInitData = false;

		mOldOPerationProcess = AndroidUtil
				.getMainTimelineOperationProcess(this);
		AndroidUtil.setMainTimelineOperationProcess(this,
				mSearchMBlogOperationProcess);
		mSearchMBlogOperationProcess.getListView().setOnItemClickListener(
				mSearchMBlogOperationProcess);
		mSearchMBlogOperationProcess.getListView().setOnScrollListener(
				mSearchMBlogOperationProcess);
		mSearchUserOperationProcess.getListView().setOnItemClickListener(this);
		mSearchUserOperationProcess.getListView().setOnScrollListener(
				mSearchUserOperationProcess);
		String keyword = getIntent().getStringExtra("keyword");
		if (keyword != null)
		{
			WeiboMain.init(this);
			metKeyword.setText(keyword);
			onClick(null);
		}
		registerForContextMenu(mSearchMBlogOperationProcess.getListView());
		AndroidUtil.changeBackground(getWindow());
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data)
	{
		if (resultCode == Activity.RESULT_OK)
		{
			int start = 0;
			StringBuilder sb = null;
			switch (requestCode)
			{

				case Values.REQUEST_CODE_VOICE_RECOGNITION:

					ArrayList<String> matches = data
							.getStringArrayListExtra(RecognizerIntent.EXTRA_RESULTS);
					if (matches.size() > 0)
					{
						sb = new StringBuilder(metKeyword.getText().toString());
						start = metKeyword.getSelectionStart();

						sb.insert(start, matches.get(0));
						metKeyword.setText(sb.toString());
						metKeyword
								.setSelection(start + matches.get(0).length());
					}
					break;

			}
		}

	}

	public void onClick_Voice(View view)
	{
		AndroidUtil.voiceRecognizer(this);
	}

	@Override
	public void onClick(View view)
	{

		switch (view.getId())
		{
			case R.id.ibSearch:
				if ("".equals(metKeyword.getText().toString()))
				{
					Message.showMsg(this, "ҪѯĹؼ");
					return;
				}

				Paging paging = new Paging();
				mOldKeyword = mKeyword;
				mKeyword = metKeyword.getText().toString();

				paging.setKeyword(mKeyword);
				try
				{
					MyMicroBlogAsync myMicroBlogAsync = AndroidUtil
							.getMyMicroBlogs(this).get(WeiboMain.mainAlias);
					if (mrbSearchMBlog.isChecked())
					{
						AndroidUtil.setMainTimelineOperationProcess(this,
								mSearchMBlogOperationProcess);
						mSearchMBlogOperationProcess.getListView()
								.setOnItemClickListener(
										mSearchMBlogOperationProcess);
						myMicroBlogAsync.searchMicroBlogAsync(
								mSearchMBlogOperationProcess, paging);

					}
					else
					{
						AndroidUtil.setMainTimelineOperationProcess(this,
								mSearchUserOperationProcess);
						mSearchUserOperationProcess.getListView()
								.setOnItemClickListener(this);
						myMicroBlogAsync.searchUsersAsync(
								mSearchUserOperationProcess, paging);

					}
				}
				catch (Exception e)
				{
					// TODO: handle exception
				}

				break;

		}

	}

	@Override
	public void onItemClick(AdapterView<?> parent, View view, int position,
			long id)
	{
		if (mrbSearchUser.isChecked())
		{
			if (mSearchUserOperationProcess != null)
			{
				if (position == mSearchUserOperationProcess.mWeiboResponses
						.size())
				{
					mSearchUserOperationProcess.onItemClick(parent, view,
							position, id);
					return;

				}
			}
		}
		if (mrbSearchMBlog.isChecked())
		{
			if (mSearchMBlogOperationProcess != null)
			{
				if (position == mSearchMBlogOperationProcess.mWeiboResponses
						.size())
				{
					mSearchMBlogOperationProcess.onItemClick(parent, view,
							position, id);
					return;
				}
			}
		}

		User user = AndroidUtil.getMainTimelineOperationProcess(this).getUser(
				position);

		Intent intent = new Intent(this, UserViewer.class);
		intent.putExtra("profileimagepath", "http://"
				+ user.getProfileImageURL().getHost()
				+ user.getProfileImageURL().getPath());
		intent.putExtra("name", user.getName());
		intent.putExtra("userId", String.valueOf(user.getId()));
		intent.putExtra("verified", user.isVerified());
		intent.putExtra("friendship", 0);
		intent.putExtra("location", user.getLocation());
		intent.putExtra("friendCount", user.getFriendsCount());
		intent.putExtra("followerCount", user.getFollowersCount());
		intent.putExtra("statusCount", user.getStatusesCount());
		intent.putExtra("description", user.getDescription());
		intent.putExtra("text", user.getStatusText());

		startActivity(intent);

	}

	@Override
	public void onCreateContextMenu(ContextMenu menu, View v,
			ContextMenuInfo menuInfo)
	{
		if (mrbSearchMBlog.isChecked())
		{
			getMenuInflater().inflate(R.menu.main_context_menu, menu);
			MenuItem mnuDelete = menu.findItem(R.id.mnuDeleteStatus);
			MenuItem mnuCreateFriendShip = menu
					.findItem(R.id.mnuCreateFriendShip);

			mnuDelete.setVisible(false);
			mnuCreateFriendShip.setVisible(true);

			User user = AndroidUtil.getMainTimelineOperationProcess(this)
					.getUser(WeiboMain.mCurrentPosition);
			mnuCreateFriendShip.setTitle("ע@" + user.getName());

			mMainContextMenuProcess = new MainContextMenuProcess(this, menu);
		}
		super.onCreateContextMenu(menu, v, menuInfo);
	}

	@Override
	protected void onDestroy()
	{
		mSearchMBlogOperationProcess.clear();
		AndroidUtil.setMainTimelineOperationProcess(this, mOldOPerationProcess);
		mMainContextMenuProcess = null;
		mKeyword = "";
		mOldKeyword = "";

		super.onDestroy();
	}

}
