package sina.weibo;

import sina.weibo.commons.Values;
import android.app.ListActivity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;

public class Setting extends ListActivity 
{

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setListAdapter(new SettingAdapter(this));
		
	}


	@Override
	protected void onListItemClick(ListView l, View v, int position, long id)
	{		
		super.onListItemClick(l, v, position, id);
		Intent intent = null;
		switch (position)
		{
			case 0:  //  
				intent = new Intent(this, ThemeCatalogs.class);
				startActivityForResult(intent, Values.REQUEST_CODE_THEME_CATALOGS);
				break;
			case 1:  //  ñ͸
				intent = new Intent(this, SettingColorTransparency.class);
				startActivity(intent);
				break;
			case 2:  //  ıɫ
				intent = new Intent(this, TextColorSetting.class);
				startActivity(intent);
				break;
			default:
				break;
		}
	}


	class SettingAdapter extends BaseAdapter
	{
		private String[] mItemTextArray = new String[]
		{ "", "ñɫ͸", "ɫ" };
		private int[] mItemIconArray = new int[]
		{ R.drawable.setting_background,
				R.drawable.setting_background_transparency,
				R.drawable.setting_text_color };
		private LayoutInflater mLayoutInflater;

		public SettingAdapter(Context context)
		{
			mLayoutInflater = (LayoutInflater) context
					.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		}

		@Override
		public int getCount()
		{
			return mItemTextArray.length;
		}

		@Override
		public Object getItem(int position)
		{
			// TODO Auto-generated method stub
			return null;
		}

		@Override
		public long getItemId(int position)
		{
			// TODO Auto-generated method stub
			return 0;
		}

		@Override
		public View getView(int position, View convertView, ViewGroup parent)
		{
			if (convertView == null)
			{
				convertView = mLayoutInflater.inflate(
						R.layout.setting_list_item, null);
			}
			ImageView ivSettingItemIcon = (ImageView) convertView
					.findViewById(R.id.ivSettingItemIcon);
			TextView tvSettingItemText = (TextView) convertView
					.findViewById(R.id.tvSettingItemText);

			ivSettingItemIcon.setImageResource(mItemIconArray[position]);
			tvSettingItemText.setText(mItemTextArray[position]);

			return convertView;
		}
	}
}
