package sina.weibo;

import sina.weibo.commons.AndroidUtil;
import sina.weibo.commons.Values;
import android.app.Activity;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.SeekBar;
import android.widget.SeekBar.OnSeekBarChangeListener;

public class SettingColorTransparency extends Activity implements
		OnSeekBarChangeListener, OnClickListener
{
	private int mTransparency;
	private int mRed;
	private int mGreen;
	private int mBlue;

	private SeekBar msbTransparency;
	private SeekBar msbRed;
	private SeekBar msbGreen;
	private SeekBar msbBlue;

	private ImageView mivBackground;
	private ImageView mivTransparency;

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.setting_color_transparency);

		mTransparency = WeiboMain.happyBlogConfig.getInt(
				"background_transparency", 170);
		mRed = WeiboMain.happyBlogConfig.getInt("background_red", 255);
		mGreen = WeiboMain.happyBlogConfig.getInt("background_green",
				255);
		mBlue = WeiboMain.happyBlogConfig
				.getInt("background_blue", 255);

		msbTransparency = (SeekBar) findViewById(R.id.sbTransparency);
		msbRed = (SeekBar) findViewById(R.id.sbRed);
		msbGreen = (SeekBar) findViewById(R.id.sbGreen);
		msbBlue = (SeekBar) findViewById(R.id.sbBlue);
		msbTransparency.setOnSeekBarChangeListener(this);
		msbRed.setOnSeekBarChangeListener(this);
		msbGreen.setOnSeekBarChangeListener(this);
		msbBlue.setOnSeekBarChangeListener(this);
		mivBackground = (ImageView) findViewById(R.id.ivBackground);
		mivTransparency = (ImageView) findViewById(R.id.ivTransparency);

		Button btnOK = (Button) findViewById(R.id.btnOK);
		Button btnCancel = (Button) findViewById(R.id.btnCancel);

		btnOK.setOnClickListener(this);
		btnCancel.setOnClickListener(this);

		msbTransparency.setProgress(mTransparency);
		msbRed.setProgress(mRed);
		msbGreen.setProgress(mGreen);
		msbBlue.setProgress(mBlue);

		int hashcode = WeiboMain.happyBlogConfig.getInt(
				"theme_filename", -1);
		if (hashcode != -1)
		{
			String filename = Values.getThemeImagePath() + hashcode;
			mivBackground.setImageBitmap(BitmapFactory.decodeFile(filename));

		}

		mivTransparency.setBackgroundColor(Color.parseColor("#"
				+ AndroidUtil.toHexString(mTransparency)
				+ AndroidUtil.toHexString(mRed)
				+ AndroidUtil.toHexString(mGreen)
				+ AndroidUtil.toHexString(mBlue)));

	}

	@Override
	public void onProgressChanged(SeekBar seekBar, int progress,
			boolean fromUser)
	{

		switch (seekBar.getId())
		{
			case R.id.sbTransparency:
				mTransparency = seekBar.getProgress();
				break;
			case R.id.sbRed:
				mRed = seekBar.getProgress();
				break;
			case R.id.sbGreen:
				mGreen = seekBar.getProgress();
				break;
			case R.id.sbBlue:
				mBlue = seekBar.getProgress();
				break;

		}

		mivTransparency.setBackgroundColor(Color.parseColor("#"
				+ AndroidUtil.toHexString(mTransparency)
				+ AndroidUtil.toHexString(mRed)
				+ AndroidUtil.toHexString(mGreen)
				+ AndroidUtil.toHexString(mBlue)));
	}

	@Override
	public void onStartTrackingTouch(SeekBar seekBar)
	{
		// TODO Auto-generated method stub

	}

	@Override
	public void onStopTrackingTouch(SeekBar seekBar)
	{
		// TODO Auto-generated method stub

	}

	@Override
	public void onClick(View view)
	{
		switch (view.getId())
		{
			case R.id.btnOK:
				WeiboMain.happyBlogConfig.setValue(
						"background_transparency", mTransparency);
				WeiboMain.happyBlogConfig.setValue("background_red",
						mRed);
				WeiboMain.happyBlogConfig.setValue("background_green",
						mGreen);
				WeiboMain.happyBlogConfig.setValue("background_blue",
						mBlue);
				AndroidUtil.changeColorTransparency(WeiboMain.mView);
				finish();
				break;
			case R.id.btnCancel:
				finish();
				
				break;
		}

	}

}
