package sina.weibo;

import sina.weibo.ColorPickerDialog.OnColorChangedListener;
import sina.weibo.commons.AndroidUtil;
import android.app.Activity;
import android.graphics.Color;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.ImageView;

public class TextColorSetting extends Activity implements OnClickListener,
		OnColorChangedListener
{
	private ImageView mivCommonTextColor;
	private ImageView mivNameColor;
	private ImageView mivTimeColor;
	private ImageView mivSourceColor;
	private ImageView mivSignColor;
	private ImageView mivLinkColor;

	private int mCurrentCommonTextColor;
	private int mCurrentNameColor;
	private int mCurrentTimeColor;
	private int mCurrentSourceColor;
	private int mCurrentSignColor;
	private int mCurrentLinkColor;

	private int mCurrentResultId;

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.text_color_setting);
		Button btnCommonTextColor = (Button) findViewById(R.id.btnCommonTextColor);
		Button btnNameColor = (Button) findViewById(R.id.btnNameColor);
		Button btnTimeColor = (Button) findViewById(R.id.btnTimeColor);
		Button btnSourceColor = (Button) findViewById(R.id.btnSourceColor);
		Button btnSignColor = (Button) findViewById(R.id.btnSignColor);
		Button btnLinkColor = (Button)findViewById(R.id.btnLinkColor);
		Button btnOK = (Button)findViewById(R.id.btnOK);
		Button btnCancel = (Button)findViewById(R.id.btnCancel);
		Button btnDefault = (Button)findViewById(R.id.btnDefault);
		
		mivCommonTextColor = (ImageView) findViewById(R.id.ivCommonTextColor);
		mivNameColor = (ImageView) findViewById(R.id.ivNameColor);
		mivTimeColor = (ImageView) findViewById(R.id.ivTimeColor);
		mivSourceColor = (ImageView) findViewById(R.id.ivSourceColor);
		mivSignColor = (ImageView) findViewById(R.id.ivSignColor);
		mivLinkColor = (ImageView)findViewById(R.id.ivLinkColor);

		btnCommonTextColor.setOnClickListener(this);
		btnNameColor.setOnClickListener(this);
		btnTimeColor.setOnClickListener(this);
		btnSourceColor.setOnClickListener(this);
		btnSignColor.setOnClickListener(this);
		btnLinkColor.setOnClickListener(this);
		btnOK.setOnClickListener(this);
		btnCancel.setOnClickListener(this);
		btnDefault.setOnClickListener(this);

		mCurrentCommonTextColor = WeiboMain.happyBlogConfig.getInt(
				"common_text_color", 0);
		mCurrentNameColor = WeiboMain.happyBlogConfig.getInt(
				"name_color", Color.RED);
		mCurrentTimeColor = WeiboMain.happyBlogConfig.getInt(
				"time_color", 0);

		mCurrentSourceColor = WeiboMain.happyBlogConfig.getInt(
				"source_color", Color.BLUE);
		mCurrentSignColor = WeiboMain.happyBlogConfig.getInt(
				"sign_color", Color.BLUE);
		
		mCurrentLinkColor = WeiboMain.happyBlogConfig.getInt(
				"link_color", Color.BLUE);
		mivCommonTextColor.setBackgroundColor(mCurrentCommonTextColor);
		mivNameColor.setBackgroundColor(mCurrentNameColor);
		mivTimeColor.setBackgroundColor(mCurrentTimeColor);
		mivSourceColor.setBackgroundColor(mCurrentSourceColor);
		mivSignColor.setBackgroundColor(mCurrentSignColor);
		mivLinkColor.setBackgroundColor(mCurrentLinkColor);

	}

	@Override
	public void colorChanged(int color)
	{
		switch (mCurrentResultId)
		{
			case R.id.ivCommonTextColor:
				mivCommonTextColor.setBackgroundColor(color);
				mCurrentCommonTextColor = color;
				break;

			case R.id.ivNameColor:
				mivNameColor.setBackgroundColor(color);
				mCurrentNameColor = color;
				break;
			case R.id.ivTimeColor:
				mivTimeColor.setBackgroundColor(color);
				mCurrentTimeColor = color;
				break;
			case R.id.ivSourceColor:
				mivSourceColor.setBackgroundColor(color);
				mCurrentSourceColor = color;
				break;
			case R.id.ivSignColor:
				mivSignColor.setBackgroundColor(color);
				mCurrentSignColor = color;
				break;
			case R.id.ivLinkColor:
				mivLinkColor.setBackgroundColor(color);
				mCurrentLinkColor = color;
				break;
			default:
				break;
		}

	}

	@Override
	public void onClick(View view)
	{
		int color = 0;
		switch (view.getId())
		{
			case R.id.btnCommonTextColor:
				mCurrentResultId = R.id.ivCommonTextColor;
				new ColorPickerDialog(this, this, mCurrentCommonTextColor)
						.show();
				break;
			case R.id.btnNameColor:
				mCurrentResultId = R.id.ivNameColor;
				new ColorPickerDialog(this, this, mCurrentNameColor).show();
				break;
			case R.id.btnTimeColor:

				mCurrentResultId = R.id.ivTimeColor;
				new ColorPickerDialog(this, this, mCurrentTimeColor).show();
				break;
			case R.id.btnSourceColor:
				mCurrentResultId = R.id.ivSourceColor;
				new ColorPickerDialog(this, this, mCurrentSourceColor).show();
				break;
			case R.id.btnSignColor:
				mCurrentResultId = R.id.ivSignColor;
				new ColorPickerDialog(this, this, mCurrentSignColor).show();
				break;
			case R.id.btnLinkColor:
				mCurrentResultId = R.id.ivLinkColor;
				new ColorPickerDialog(this, this, mCurrentLinkColor).show();
				break;				
			case R.id.btnOK:
				WeiboMain.happyBlogConfig.setValue("common_text_color", mCurrentCommonTextColor);
				WeiboMain.happyBlogConfig.setValue("name_color", mCurrentNameColor);				
				WeiboMain.happyBlogConfig.setValue("time_color", mCurrentTimeColor);				
				WeiboMain.happyBlogConfig.setValue("source_color", mCurrentSourceColor);				
				WeiboMain.happyBlogConfig.setValue("sign_color", mCurrentSignColor);
				WeiboMain.happyBlogConfig.setValue("link_color", mCurrentLinkColor);
				AndroidUtil.getMainTimelineOperationProcess(this).mWeakReferenceAdapter.get().notifyDataSetChanged();
				finish();
				break;
			case R.id.btnDefault:
				WeiboMain.happyBlogConfig.setValue("common_text_color", Color.BLACK);
				WeiboMain.happyBlogConfig.setValue("name_color", Color.RED);				
				WeiboMain.happyBlogConfig.setValue("time_color", Color.BLACK);				
				WeiboMain.happyBlogConfig.setValue("source_color",Color.BLUE);				
				WeiboMain.happyBlogConfig.setValue("sign_color", Color.BLUE);
				WeiboMain.happyBlogConfig.setValue("link_color", Color.BLUE);
				AndroidUtil.getMainTimelineOperationProcess(this).mWeakReferenceAdapter.get().notifyDataSetChanged();
				finish();
				
				break;
			case R.id.btnCancel:
				finish();
				break;
			default:
				break;
		}
	}

}
