package sina.weibo;

import java.util.ArrayList;

import microblog.StaticResources;
import microblog.thread.Task;
import sina.weibo.commons.AndroidUtil;
import sina.weibo.commons.Message;
import sina.weibo.commons.Values;
import sina.weibo.process.TaskListenerImpl;
import android.app.Activity;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.speech.RecognizerIntent;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;

public class WeiboText extends Activity implements TextWatcher
{
	private EditText metMicroBlog;
	private TextView mtvRemainWordCount;

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		WeiboMain.init(this);
		String mainAlias = WeiboMain.happyBlogConfig.getString(
				Values.MAIN_ALIAS, "");
		if ("".equals(mainAlias))
		{
			Message.showMsg(this, "ûе¼޷б.");
			finish();
		}

		AndroidUtil.setContentView(this, R.layout.happyblog_text);
	//	AndroidUtil.changeBackground(getWindow());
		AndroidUtil.startService(this);
		metMicroBlog = (EditText) findViewById(R.id.etMicroBlog);
		mtvRemainWordCount = (TextView) findViewById(R.id.tvRemainWordCount);
		metMicroBlog.addTextChangedListener(this);
		updateMessage();
	}

	public void onClick_Post(View view)
	{
		if ("".equals(metMicroBlog.getText().toString()))
		{
			Message.showMsg(this, "û.");
			return;
		}

		Task task = new Task();

		task.alias = WeiboMain.mainAlias;

		task.msg = metMicroBlog.getText().toString();
		task.taskListener = new TaskListenerImpl(this);

		StaticResources.AddTask(task);
		finish();
	}

	public void onClick_Voice(View view)
	{
		AndroidUtil.voiceRecognizer(this);
	}

	public void onClick_Face(View view)
	{
		Intent intent = new Intent(this, FaceList.class);
		startActivityForResult(intent, 3);
		
	}

	public void onClick_Close(View view)
	{
		finish();
	}

	public void onClick_Topic(View view)
	{

		StringBuilder sb = new StringBuilder(metMicroBlog.getText().toString());
		int start = metMicroBlog.getSelectionStart();
		sb.insert(start, "##");

		metMicroBlog.setText(sb.toString());
		metMicroBlog.setSelection(start + 1);
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data)
	{
		if (resultCode == Activity.RESULT_OK)
		{
			int start = 0;
			StringBuilder sb = null;
			switch (requestCode)
			{

				case Values.REQUEST_CODE_FACE:
					// ѡ
					String face = data.getStringExtra("face");
					sb = new StringBuilder(metMicroBlog.getText().toString());
					start = metMicroBlog.getSelectionStart();
					sb.insert(start, face);

					metMicroBlog.setText(sb.toString());
					metMicroBlog.setSelection(start + face.length());
					break;
				case Values.REQUEST_CODE_VOICE_RECOGNITION:

					ArrayList<String> matches = data
							.getStringArrayListExtra(RecognizerIntent.EXTRA_RESULTS);
					if (matches.size() > 0)
					{
						sb = new StringBuilder(metMicroBlog.getText()
								.toString());
						start = metMicroBlog.getSelectionStart();

						sb.insert(start, matches.get(0));
						metMicroBlog.setText(sb.toString());
						metMicroBlog.setSelection(start
								+ matches.get(0).length());
					}
					break;

			}
		}

	}

	@Override
	public void afterTextChanged(Editable s)
	{
		// TODO Auto-generated method stub

	}

	@Override
	public void beforeTextChanged(CharSequence s, int start, int count,
			int after)
	{
		// TODO Auto-generated method stub

	}

	@Override
	public void onTextChanged(CharSequence s, int start, int before, int count)
	{
		updateMessage();

	}

	private void updateMessage()
	{

		int remainWordCount = Values.getRemainWordCount(metMicroBlog.getText()
				.toString());
		if (remainWordCount >= 0)
		{
			mtvRemainWordCount.setText("㻹" + remainWordCount + "");
			mtvRemainWordCount.setTextColor(Color.WHITE);
		}

		else
		{
			remainWordCount = -remainWordCount;
			mtvRemainWordCount.setText("ѳ" + remainWordCount + "");
			mtvRemainWordCount.setTextColor(Color.RED);
		}

	}
}
