package sina.weibo.commons;

import java.io.FileOutputStream;
import java.util.Map;

import microblog.MyMicroBlogAsync;
import microblog.storage.SystemDBService;
import sina.weibo.WeiboMain;
import sina.weibo.R;
import sina.weibo.process.TimelineOperationProcess;
import sina.weibo.service.HappyBlogService;
import sina.weibo.storage.HappyBlogConfig;
import sina.weibo.storage.MyApp;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.DialogInterface.OnClickListener;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.graphics.Bitmap;
import android.graphics.Bitmap.CompressFormat;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.speech.RecognizerIntent;
import android.view.View;
import android.view.Window;
import android.widget.ImageView;

public class AndroidUtil
{
	public static String setTextColor(String s, String color)
	{
		String result = "<font color='" + color + "'>" + s + "</font>";

		return result;
	}

	public static String color = "#00FF00";

	// @[Ӣġ֡_]֮ݣ[Ӣġ֡_]ɫ
	public static String atBlue(String s)
	{

		StringBuilder sb = new StringBuilder();
		int commonTextColor = WeiboMain.happyBlogConfig.getInt(
				"common_text_color", 0);
		int signColor = WeiboMain.happyBlogConfig.getInt("sign_color",
				Color.BLUE);

		int state = 1;
		String str = "";
		for (int i = 0; i < s.length(); i++)
		{
			switch (state)
			{
				case 1: // ַͨ״̬
					// @
					if (s.charAt(i) == '@')
					{
						state = 2;
						str += s.charAt(i);
					}
					// #
					else if (s.charAt(i) == '#')
					{
						str += s.charAt(i);
						state = 3;
					}
					// ַͨ
					else
					{
						if (commonTextColor == Color.BLACK)
							sb.append(s.charAt(i));
						else
							sb.append("<font color='" + commonTextColor + "'>"
									+ s.charAt(i) + "</font>");
					}
					break;
				case 2: // @
					// @ַͨ
					if (Character.isJavaIdentifierPart(s.charAt(i)))
					{
						str += s.charAt(i);
					}

					else
					{
						// ֻһ@Ϊַͨ
						if ("@".equals(str))
						{
							sb.append(str);
						}
						// @ַͨɫ
						else
						{
							sb.append(setTextColor(str,
									String.valueOf(signColor)));
						}
						// @#Ӧ#ӵstrֵܻɫҲΪַͨҪ滹û#
						if (s.charAt(i) == '#')
						{

							str = String.valueOf(s.charAt(i));
							state = 3;
						}
						// @滹и@#
						else if (s.charAt(i) == '@')
						{
							str = String.valueOf(s.charAt(i));
							state = 2;
						}
						// @г@#ַҪַΪַͨ
						else
						{
							if (commonTextColor == Color.BLACK)
								sb.append(s.charAt(i));
							else
								sb.append("<font color='" + commonTextColor
										+ "'>" + s.charAt(i) + "</font>");
							state = 1;
							str = "";
						}
					}
					break;
				case 3: // #
					// ǰѾһ#ˣﴦ#
					if (s.charAt(i) == '#')
					{
						str += s.charAt(i);
						sb.append(setTextColor(str, String.valueOf(signColor)));
						str = "";
						state = 1;

					}
					// #@ôһºǷ#û#ǰ#ϣ@
					else if (s.charAt(i) == '@')
					{
						if (s.substring(i).indexOf("#") < 0)
						{
							sb.append(str);
							str = String.valueOf(s.charAt(i));
							state = 2;

						}
						else
						{
							str += s.charAt(i);
						}
					}
					// #...#ַ֮ͨ
					else
					{
						str += s.charAt(i);
					}
					break;
			}

		}
		if (state == 1 || state == 3)
		{
			sb.append(str);
		}
		else if (state == 2)
		{
			if ("@".equals(str))
			{
				sb.append(str);
			}
			else
			{
				sb.append(setTextColor(str, String.valueOf(signColor)));
			}

		}

		return sb.toString();

	}

	public static String colorForKeyword(String s, String keyword)
	{
		return s.replaceAll(keyword, setTextColor(keyword, "red"));
	}

	public static void freeBitmap(Bitmap bitmap)
	{
		if (bitmap != null && !bitmap.isRecycled())
		{
			bitmap.recycle();
		}
	}

	public static String fillZero(int n, int length)
	{
		String s = String.valueOf(n);
		int fillNumber = length - s.length();
		for (int i = 0; i < fillNumber; i++)
		{
			s = "0" + s;
		}
		return s;
	}

	public static void startService(Context context)
	{
		Intent serviceIntent = new Intent(context, HappyBlogService.class);
		context.startService(serviceIntent);
	}

	private static PackageInfo getPackageInfo(Context context)
	{
		PackageInfo packageInfo = null;
		try
		{
			packageInfo = context.getPackageManager().getPackageInfo(
					context.getPackageName(), 0);
		}
		catch (Exception e)
		{
			// TODO: handle exception
		}
		return packageInfo;
	}

	public static int getVersionCode(Context context)
	{
		PackageInfo packageInfo = getPackageInfo(context);
		return packageInfo.versionCode;
	}

	public static String getVersionName(Context context)
	{
		PackageInfo packageInfo = getPackageInfo(context);
		return packageInfo.versionName;
	}

	public static TimelineOperationProcess getMainTimelineOperationProcess(
			Context context)
	{
		MyApp myApp = (MyApp) context.getApplicationContext();
		return myApp.getMainTimelineOperationProcess();
	}

	public static void setMainTimelineOperationProcess(Context context,
			TimelineOperationProcess timelineOperationProcess)
	{
		MyApp myApp = (MyApp) context.getApplicationContext();
		myApp.setMainTimelineOperationProcess(timelineOperationProcess);
	}

	public static TimelineOperationProcess getHomeTimelineOperationProcess(
			Context context)
	{
		MyApp myApp = (MyApp) context.getApplicationContext();
		return myApp.getHomeTimelineOperationProcess();
	}

	public static void setHomeTimelineOperationProcess(Context context,
			TimelineOperationProcess timelineOperationProcess)
	{
		MyApp myApp = (MyApp) context.getApplicationContext();
		myApp.setHomeTimelineOperationProcess(timelineOperationProcess);
	}

	public static TimelineOperationProcess getPublicTimelineOperationProcess(
			Context context)
	{
		MyApp myApp = (MyApp) context.getApplicationContext();
		return myApp.getPublicTimelineOperationProcess();
	}

	public static void setPublicTimelineOperationProcess(Context context,
			TimelineOperationProcess timelineOperationProcess)
	{
		MyApp myApp = (MyApp) context.getApplicationContext();
		myApp.setPublicTimelineOperationProcess(timelineOperationProcess);
	}

	public static TimelineOperationProcess getUserTimelineOperationProcess(
			Context context)
	{
		MyApp myApp = (MyApp) context.getApplicationContext();
		return myApp.getUserTimelineOperationProcess();
	}

	public static void setUserTimelineOperationProcess(Context context,
			TimelineOperationProcess timelineOperationProcess)
	{
		MyApp myApp = (MyApp) context.getApplicationContext();
		myApp.setUserTimelineOperationProcess(timelineOperationProcess);
	}

	public static TimelineOperationProcess getMentionsOperationProcess(
			Context context)
	{
		MyApp myApp = (MyApp) context.getApplicationContext();
		return myApp.getMentionsOperationProcess();
	}

	public static void setMentionsOperationProcess(Context context,
			TimelineOperationProcess timelineOperationProcess)
	{
		MyApp myApp = (MyApp) context.getApplicationContext();
		myApp.setMentionsOperationProcess(timelineOperationProcess);
	}

	public static TimelineOperationProcess getCommentsTimelineOperationProcess(
			Context context)
	{
		MyApp myApp = (MyApp) context.getApplicationContext();
		return myApp.getCommentsTimelineOperationProcess();
	}

	public static void setCommentsTimelineOperationProcess(Context context,
			TimelineOperationProcess timelineOperationProcess)
	{
		MyApp myApp = (MyApp) context.getApplicationContext();
		myApp.setCommentsTimelineOperationProcess(timelineOperationProcess);
	}

	public static void setContentView(Activity activity, int layoutId)
	{
		while (true)
		{
			try
			{
				activity.setContentView(layoutId);
				break;
			}
			catch (Exception e)
			{
				// TODO: handle exception
			}

		}
	}

	public static void BitmapSaveAsJPG(Bitmap bitmap, String filename)
	{
		try
		{
			FileOutputStream fos = new FileOutputStream(filename);
			bitmap.compress(CompressFormat.JPEG, 100, fos);
			fos.close();
		}
		catch (Exception e)
		{
			// TODO: handle exception
		}
	}

	/*
	 * 
	 * 
	 * private TimelineOperationProcess directMessageProcess;
	 */

	public static void hideAllListView(Context context)
	{
		MyApp myApp = (MyApp) context.getApplicationContext();
		if (myApp.getHomeTimelineOperationProcess() != null)
			myApp.getHomeTimelineOperationProcess().getListView()
					.setVisibility(View.GONE);
		if (myApp.getMentionsOperationProcess() != null)
			myApp.getMentionsOperationProcess().getListView()
					.setVisibility(View.GONE);

		if (myApp.getPublicTimelineOperationProcess() != null)
			myApp.getPublicTimelineOperationProcess().getListView()
					.setVisibility(View.GONE);
		if (myApp.getFavoritesOperationProcess() != null)
			myApp.getFavoritesOperationProcess().getListView()
					.setVisibility(View.GONE);
		if (myApp.getDirectMessageProcess() != null)
			myApp.getDirectMessageProcess().getListView()
					.setVisibility(View.GONE);
		if (myApp.getCommentsTimelineOperationProcess() != null)
			myApp.getCommentsTimelineOperationProcess().getListView()
					.setVisibility(View.GONE);
		if (myApp.getCommentByMeOperationProcess() != null)
			myApp.getCommentByMeOperationProcess().getListView()
					.setVisibility(View.GONE);

	}

	public static TimelineOperationProcess getCommentByMeOperationProcess(
			Context context)
	{
		MyApp myApp = (MyApp) context.getApplicationContext();
		return myApp.getCommentByMeOperationProcess();
	}

	public static void setCommentByMeOperationProcess(Context context,
			TimelineOperationProcess timelineOperationProcess)
	{
		MyApp myApp = (MyApp) context.getApplicationContext();
		myApp.setCommentByMeOperationProcess(timelineOperationProcess);
	}

	public static TimelineOperationProcess getFavoritesOperationProcess(
			Context context)
	{
		MyApp myApp = (MyApp) context.getApplicationContext();
		return myApp.getFavoritesOperationProcess();
	}

	public static void setFavoritesOperationProcess(Context context,
			TimelineOperationProcess timelineOperationProcess)
	{
		MyApp myApp = (MyApp) context.getApplicationContext();
		myApp.setFavoritesOperationProcess(timelineOperationProcess);
	}

	public static TimelineOperationProcess getDirectMessageProcess(
			Context context)
	{
		MyApp myApp = (MyApp) context.getApplicationContext();
		return myApp.getDirectMessageProcess();
	}

	public static void setDirectMessageProcess(Context context,
			TimelineOperationProcess timelineOperationProcess)
	{
		MyApp myApp = (MyApp) context.getApplicationContext();
		myApp.setDirectMessageProcess(timelineOperationProcess);
	}

	public static Map<String, MyMicroBlogAsync> getMyMicroBlogs(Context context)
	{
		MyApp myApp = (MyApp) context.getApplicationContext();
		return myApp.getMyMicroBlogs();
	}

	public static MyMicroBlogAsync getCurrentMyMicroBlog(Context context)
	{
		return getMyMicroBlogs(context).get(WeiboMain.mainAlias);
	}

	public static void setMyMicroBlogs(Context context,
			Map<String, MyMicroBlogAsync> myMicroBlogs)
	{
		MyApp myApp = (MyApp) context.getApplicationContext();
		myApp.setMyMicroBlogs(myMicroBlogs);
	}

	public static SystemDBService getSystemDBService(Context context)
	{
		MyApp myApp = (MyApp) context.getApplicationContext();
		return myApp.getSystemDBService();
	}

	public static void setSystemDBService(Context context,
			SystemDBService systemDBService)
	{
		MyApp myApp = (MyApp) context.getApplicationContext();
		myApp.setSystemDBService(systemDBService);
	}

	public static View getLandscapeView(Context context)
	{
		MyApp myApp = (MyApp) context.getApplicationContext();
		return myApp.getLandscapeView();
	}

	public static void setLandscapeView(Context context, View view)
	{
		MyApp myApp = (MyApp) context.getApplicationContext();
		myApp.setLandscapeView(view);
	}

	public static View getPortraitView(Context context)
	{
		MyApp myApp = (MyApp) context.getApplicationContext();
		return myApp.getPortraitView();
	}

	public static void setPortraitView(Context context, View view)
	{
		MyApp myApp = (MyApp) context.getApplicationContext();
		myApp.setPortraitView(view);
	}

	public static void voiceRecognizer(Activity activity)
	{
		Intent intent = new Intent(RecognizerIntent.ACTION_RECOGNIZE_SPEECH);
		intent.putExtra(RecognizerIntent.EXTRA_LANGUAGE_MODEL,
				RecognizerIntent.LANGUAGE_MODEL_WEB_SEARCH);
		
		intent.putExtra(RecognizerIntent.EXTRA_PROMPT, "¼");
		activity.startActivityForResult(intent,
				Values.REQUEST_CODE_VOICE_RECOGNITION);
	}

	// װصǰ¼ûprofileimage
	public static void loadProfileImage(Context context)
	{
		if (context == null)
			return;
		if (context instanceof Activity)
		{
			Activity activity = (Activity) context;
			ImageView ivProfileImage = (ImageView) activity
					.findViewById(R.id.ivProfileImage);

			if (ivProfileImage != null)
			{
				String path = "http://"
						+ WeiboMain.mCurrentUser.getProfileImageURL()
								.getHost()
						+ WeiboMain.mCurrentUser.getProfileImageURL()
								.getPath();
				AndroidUtil.getMainTimelineOperationProcess(context)
						.loadBitmap(path, ivProfileImage);
			}
		}

	}

	public static String toHexString(int value)
	{
		String hex = Integer.toHexString(value);
		if (hex.length() == 1)
			return "0" + hex;
		else
			return hex;
	}

	public static void changeBackground(Window window)
	{

		int hashcode = WeiboMain.happyBlogConfig.getInt(
				"theme_filename", -1);
		if (hashcode != -1)
		{
			String filename = Values.getThemeImagePath() + hashcode;

			window.setBackgroundDrawable(Drawable.createFromPath(filename));
		}
		else
		{
			window.setBackgroundDrawableResource(R.drawable.background);
		}

	}

	public static void changeColorTransparency(View view)
	{
		if (view != null)
		{
			int transparency = WeiboMain.happyBlogConfig.getInt(
					"background_transparency", 170);
			int red = WeiboMain.happyBlogConfig.getInt(
					"background_red", 255);
			int green = WeiboMain.happyBlogConfig.getInt(
					"background_green", 255);
			int blue = WeiboMain.happyBlogConfig.getInt(
					"background_blue", 255);

			view.setBackgroundColor(Color.parseColor("#"
					+ AndroidUtil.toHexString(transparency)
					+ AndroidUtil.toHexString(red)
					+ AndroidUtil.toHexString(green)
					+ AndroidUtil.toHexString(blue)));
		}

	}

	public static void showStartupMsg(Context context)
	{
		int visible = 1;
		final HappyBlogConfig happyBlogConfig = new HappyBlogConfig(context);
		visible = happyBlogConfig.getInt("startup_msg_visible", 1);
		if (visible == 1)
		{
			String msg = "\n\n";
			msg += "*\n*ɫ\n*ɫ͸\n\n";
			msg += "˵ѡ<>⡢ɫɫ͸.";
			new AlertDialog.Builder(context).setMessage(msg)
					.setIcon(R.drawable.icon)
					.setPositiveButton("ر", new OnClickListener()
					{

						@Override
						public void onClick(DialogInterface dialog, int which)
						{

						}
					}).setNegativeButton("ʾ", new OnClickListener()
					{

						@Override
						public void onClick(DialogInterface dialog, int which)
						{
							happyBlogConfig.setValue("startup_msg_visible", 0);

						}
					}).show();
		}

	}
}
