package sina.weibo.commons;

import sina.weibo.NotificationView;
import sina.weibo.R;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.widget.Toast;

public class Message
{
	private Context mContext;

	public Message(Context context)
	{
		mContext = context;
	}

	public void showMsg(String msg)
	{
		Toast.makeText(mContext, msg, Toast.LENGTH_LONG).show();
	}

	public static void showMsg(Context context, String msg)
	{
		Toast.makeText(context, msg, Toast.LENGTH_LONG).show();
	}

	public void showTaskQueueMsg(String msg)
	{
		showMsg("[" + msg + "]ѱ.");
	}

	public static void showTaskQueueMsg(String msg, Context context)
	{
		Toast.makeText(context, "[" + msg + "}ѱ.", Toast.LENGTH_LONG)
				.show();

	}

	public void showNotification(int id, int icon, String tickerText,
			String contentTitle, String contentText)
	{
		showNotification(id, icon, tickerText, contentTitle, contentText, null,
				null);
	}

	public void showNotification(int id, int icon, String tickerText,
			String contentTitle, String contentText, Intent contentIntent,
			Intent deleteIntent)
	{
		NotificationManager notificationManager = (NotificationManager) mContext
				.getSystemService(Context.NOTIFICATION_SERVICE);
		Notification notification = new Notification(icon, tickerText, System
				.currentTimeMillis());
		PendingIntent pendingIntent = null;
		Intent intent = null;
		if (contentIntent == null)
		{
			intent = new Intent(mContext, NotificationView.class);

			intent.putExtra("content", contentText);

			pendingIntent = PendingIntent.getActivity(mContext, 0, intent,
					PendingIntent.FLAG_UPDATE_CURRENT);
		}
		else
		{ 
			
			contentIntent.putExtra("tickerText", tickerText);
			contentIntent.putExtra("title", contentTitle);
			contentIntent.putExtra("message", contentText);

			pendingIntent = PendingIntent.getActivity(mContext, 0,
					contentIntent, PendingIntent.FLAG_UPDATE_CURRENT);
		}
		notification.setLatestEventInfo(mContext, contentTitle, contentText,
				pendingIntent);
		if (deleteIntent == null && icon == R.drawable.update)
		{
			intent = new Intent(Values.DELETE_NOTIFICATION_BROADCAST_ACTION);
			notification.deleteIntent = PendingIntent.getBroadcast(mContext, 0,
					intent, PendingIntent.FLAG_UPDATE_CURRENT);
		}
		else if(deleteIntent != null)
		{
			notification.deleteIntent = PendingIntent.getBroadcast(mContext, 0,
					deleteIntent, PendingIntent.FLAG_UPDATE_CURRENT);
		}
		notificationManager.notify(id, notification);
	}
}
