package sina.weibo.commons;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

import microblog.commons.Const;
import microblog.commons.ConstExt;
import microblog.commons.EncryptDecrypt;
import sina.weibo.R;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.util.Log;

public abstract class Values
{
	// 
	public final static String MAIN_TITLE = "΢ͻ";

	// shared_preferencesеıkey
	public final static String MAIN_ALIAS = "main_alias";
	public final static String DATA_TYPE = "data_type";
	public final static String CREATE_FRIEND_SHIP = "create_friend_ship";

	// ֪ͨID
	public final static int UPDATE_TASK_ID = 1000;
	public final static int MESSAGE_TASK_ID = 2000;

	// Ŀ¼ͼ
	public final static int CACHE_MAX_BITMAP_COUNT = 500;

	// Broadcast Action
	public final static String DELETE_NOTIFICATION_BROADCAST_ACTION = "happy.blog.android.DELETE_NOTIFICATION_ACTION";

	public final static Map<String, Integer> BLOG_NAME_ID_MAP = new HashMap<String, Integer>();

	public final static float TARGET_HEAP_UTILIZATION = 0.75f;
	// Request Code
	public final static int REQUEST_CODE_CAPTURE = 1;
	public final static int REQUEST_CODE_ALBUM = 2;
	public final static int REQUEST_CODE_FACE = 3;
	public final static int REQUEST_CODE_SELECT_ACCOUNT = 4;
	public final static int REQUEST_CODE_ACCOUNT_MANAGER = 5;
	public final static int REQUEST_CODE_SAVE_AS_IMAGE = 6;
	public final static int REQUEST_CODE_ADD_ACCOUNT = 7;
	public final static int REQUEST_CODE_VOICE_RECOGNITION = 8;
	public final static int REQUEST_CODE_THEME_CATALOGS = 9;

	// ش
	public final static int RESULT_CODE_SAVE = 1;
	public final static int RESULT_CODE_CANCEL = 2;
	public final static int RESULT_CODE_SELECT_ACCOUNT = 3;
	public final static int RESULT_CODE_ACCOUNT_MANAGER = 4;
	public final static int RESULT_CODE_SAVE_AS_IMAGE = 5;
	public final static int RESULT_CODE_ADD_ACCOUNT = 6;
	public final static int RESULT_CODE_THEME_CATALOGS = 7;

	// path
	public final static String HAPPY_BLOG_ROOT_PATH = android.os.Environment
			.getExternalStorageDirectory().getAbsolutePath() + "/~~happyblog/";

	// size
	public final static long BITMAP_MAX_SIZE = 307200; // 300K
	
	public final static String EFFECT_TEMP_IMAGE_PATH = HAPPY_BLOG_ROOT_PATH + "images/effect.jpg";

	// Ƿ
	public static boolean cleanCache = true;
	static
	{
		BLOG_NAME_ID_MAP.put("sina", R.drawable.logo_sina);
		BLOG_NAME_ID_MAP.put("twitter", R.drawable.logo_twitter);
		BLOG_NAME_ID_MAP.put("twitter_china", R.drawable.logo_twitter);
		BLOG_NAME_ID_MAP.put("sohu", R.drawable.logo_sohu);
		BLOG_NAME_ID_MAP.put("follow5", R.drawable.logo_follow5);

	}

	public static Map<String, String> getMicroBlogNameMap(Context context)
	{
		String[] blogs = context.getResources().getStringArray(
				R.array.blog_list);
		Map<String, String> map = new HashMap<String, String>();
		for (int i = 0; i < blogs.length; i++)
		{
			int pos = blogs[i].indexOf("#");
			if (pos < 0)
				continue;

			map.put(blogs[i].substring(0, pos), blogs[i].substring(pos + 1));

		}
		return map;
	}

	public static int getLogoIcon(String microblog)
	{
		return getDrawableResource("logo_" + microblog);
	}

	public static int getDrawableResource(String id)
	{
		try
		{
			Field field = R.drawable.class.getField(id);
			return Integer.parseInt(field.get(null).toString());
		}
		catch (Exception e)
		{
			// TODO: handle exception
		}
		return 0;
	}

	public static int getRemainWordCount(String s)
	{
		return getRemainWordCount(s, 140);
	}

	public static int getRemainWordCount(String s, int wordCount)
	{
		try
		{
			byte[] bytes = s.getBytes("GBK");
			int length = bytes.length / 2;
			return wordCount - length;
		}
		catch (Exception e)
		{
			// TODO: handle exception
		}
		return 0;
	}

	public static String getNotificationValue(Context context, String microblog)
	{
		int resourceId = 0;
		try
		{
			Field field = R.string.class.getField("notification_" + microblog);
			resourceId = field.getInt(null);
		}
		catch (Exception e)
		{
			// TODO: handle exception
		}
		return context.getResources().getString(resourceId);
	}

	public static String getImagePath()
	{

		String path = HAPPY_BLOG_ROOT_PATH + "images/";
		File file = new File(path);
		if (!file.exists())
		{
			file.mkdirs();
		}
		return path;
	}

	public static String getThemeImagePath()
	{

		String path = HAPPY_BLOG_ROOT_PATH + "theme_images/";
		File file = new File(path);
		if (!file.exists())
		{
			file.mkdirs();
		}
		return path;
	}

	public static String getSystemDBPath()
	{

		String path = HAPPY_BLOG_ROOT_PATH + "databases/";
		File file = new File(path);
		if (!file.exists())
		{
			file.mkdirs();
		}
		return path;
	}

	// ÷nullϵͳȻprivateĿ¼ݿ
	public static String getSystemDBFileName()
	{

		String path = getSystemDBPath() + ConstExt.SYSTEM_DB_NAME;

		return path;
	}

	public static String getCachePath()
	{
		String path = HAPPY_BLOG_ROOT_PATH + "cache/";
		File file = new File(path);
		if (!file.exists())
		{
			file.mkdirs();
		}
		return path;
	}

	public static String getCaptureTempImageFilename()
	{
		String filename = getImagePath() + "temp.png";
		File file = new File(filename);
		if (!file.exists())
		{
			try
			{
				file.createNewFile();
			}
			catch (Exception e)
			{
				// TODO: handle exception
			}
		}

		return filename;
	}
	public static String getEffectTempImageFilename()
	{
		String filename = getImagePath() + "temp.jpg";
		File file = new File(filename);
		if (!file.exists())
		{
			try
			{
				file.createNewFile();
			}
			catch (Exception e)
			{
				// TODO: handle exception
			}
		}

		return filename;
	}
	public static String getProfileImageFilename()
	{
		String filename = getImagePath() + "profile.png";
		File file = new File(filename);
		if (!file.exists())
		{
			try
			{
				file.createNewFile();
			}
			catch (Exception e)
			{
				// TODO: handle exception
			}
		}
		return filename;
	}

	public static Bitmap getFitBitmap(String path, long maxSize)
	{

		File file = new File(path);
		if (!file.exists())
			return null;
		Bitmap bitmap = null;
		try
		{
			if (file.length() <= maxSize)
			{

				try
				{

					BitmapFactory.Options options = new BitmapFactory.Options();
					options.inTempStorage = new byte[16 * 1024];

					try
					{
						FileInputStream fis = new FileInputStream(path);
						// bitmap = BitmapFactory.decodeFile(path, options);
						
						bitmap = BitmapFactory.decodeStream(fis, new Rect(-1,
								-1, -1, -1), options);
						fis.close();
					}
					catch (Exception e)
					{
						// TODO: handle exception
					}

				}
				catch (Exception e)
				{
					// TODO: handle exception
				}
			}
			else
			{
				int inSampleSize = (int) (file.length() / maxSize + 1);
				BitmapFactory.Options options = new BitmapFactory.Options();
				options.inTempStorage = new byte[16 * 1024];
				options.inSampleSize = inSampleSize;
				try
				{
					FileInputStream fis = new FileInputStream(path);
					// bitmap = BitmapFactory.decodeFile(path, options);
					bitmap = BitmapFactory.decodeStream(fis, new Rect(-1, -1,
							-1, -1), options);
					fis.close();
				}
				catch (Exception e)
				{
					// TODO: handle exception
				}
			}
		}
		catch (Exception e)
		{
			// TODO: handle exception
		}

		return bitmap;
	}

	public static Bitmap getFitBitmap(String path)
	{

		return getFitBitmap(path, BITMAP_MAX_SIZE);
	}

	// Ѿɹ¼ֱӴCacheȡݡ÷жǷҪCacheл
	public static boolean ignoreLogin(String account, int dataType)
	{

		
		String name = EncryptDecrypt
				.encrypt(account + String.valueOf(dataType));

		if (new File(getCachePath() + name).exists())
			return true;
		else
			return false;
	}

	public static String getCacheFilename(String account)
	{
		String name = String.valueOf(EncryptDecrypt.encrypt(account));

		return getCachePath() + name;
	}

	public static String getCacheFilename(String account, int dataType)
	{
		String name = EncryptDecrypt
				.encrypt(account + String.valueOf(dataType));
		return getCachePath() + name;
	}

	public static String getBitmapCachePath()
	{
		String path = getCachePath() + "/images/";
		File file = new File(path);
		if (!file.exists())
		{
			file.mkdirs();
		}
		return path;
	}
}
