package sina.weibo.process;

import microblog.MyMicroBlogAsync;
import sina.weibo.CommentViewer;
import sina.weibo.WeiboMain;
import sina.weibo.R;
import sina.weibo.commons.AndroidUtil;
import android.content.Intent;
import android.view.View;
import android.view.View.OnClickListener;

public class CommentViewerButtonProcess extends MainContextMenuProcess  implements
		OnClickListener
{
	private View mRefresh;
	private View mComment;
	private CommentViewer mCommentViewer;

	public CommentViewerButtonProcess(CommentViewer commentViewer)
	{
		mCommentViewer = commentViewer;
		mContext = commentViewer;
		mRefresh = commentViewer.findViewById(R.id.llRefresh);
		mComment = commentViewer.findViewById(R.id.llComment);
		mRefresh.setOnClickListener(this);
		mComment.setOnClickListener(this);		
	}



	@Override
	public void onClick(View view)
	{
		Intent intent = null;
		switch (view.getId())
		{
			case R.id.llRefresh:

				if (TimelineOperationProcess.mLoading)
					return;
				//TimelineOperationProcess commentTimelineOperationProcess = new TimelineOperationProcess(mCommentViewer,
				//		Const.TIMELINE_TYPE_COMMENT, Const.DATA_TYPE_COMMENT);
				
				MyMicroBlogAsync myMicroBlogAsync = AndroidUtil.getMyMicroBlogs(mCommentViewer)
						.get(WeiboMain.mainAlias);
				myMicroBlogAsync.getCommentAsync(mCommentViewer.mCommentOperationProcess,
						WeiboMain.mCurrentStatusId);

				
				break;
			case R.id.llComment:
				comment();
				break;
			
		}

	}

}
