package sina.weibo.process;

import java.util.HashMap;

import microblog.MicroBlogListenerImpl;
import microblog.MyMicroBlogAsync;
import microblog.commons.ConstExt;
import microblog.commons.EncryptDecrypt;
import microblog.storage.SystemDBService;
import sina.weibo.WeiboMain;
import sina.weibo.MyKeySecret;
import sina.weibo.R;
import sina.weibo.commons.AndroidUtil;
import sina.weibo.commons.Message;
import sina.weibo.commons.Values;
import sina.weibo.interfaces.HandlerRun;
import sina.weibo.storage.Cache;
import sina.weibo.storage.DatabaseOperatorImpl;
import sina.weibo.storage.HappyBlogConfig;
import sina.weibo.storage.MySQLiteOpenHelper;
import weibo4j.User;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.ProgressBar;
public class LoginProcess implements OnClickListener
{
	private WeiboMain mHappyBlogAndroid;
	private View mView;
	private Button mbtnLogin;
	private Button mbtnRegister;
	private EditText metAccount;
	private EditText metPassword;
	private CheckBox mcbCreateFriendShip;
	private ProgressBar mpbLogin;
	private MyMicroBlogAsync mMyMicroBlogAsync;
	private MyHandler mHandler = new MyHandler();
	private Thread mThread;

	private String mAccount;
	private String mPassword;

	class MyMicroBlogListenerImpl extends MicroBlogListenerImpl
	{

		@Override
		public void onLoginException(final String msg)
		{

			mHandler.run(new HandlerRun()
			{

				@Override
				public void invoke()
				{
					if (mbtnLogin != null)
					{
						mbtnLogin.setEnabled(true);
						mpbLogin.setVisibility(View.GONE);
					}
					mHappyBlogAndroid
							.setProgressBarIndeterminateVisibility(false);
					sina.weibo.commons.Message.showMsg(
							mHappyBlogAndroid, msg);

				}
			});
		}

		// ڸ¼Ҫ¼
		// 1. User
		// 2. עֲAndroidͻ
		@Override
		public void onLoginSuccess(final String msg, final User user)
		{

			mHandler.run(new HandlerRun()
			{

				@Override
				public void invoke()
				{
					WeiboMain.mCurrentUser = user;
					if (mcbCreateFriendShip != null
							&& mcbCreateFriendShip.isChecked())
					{
						try
						{
							mMyMicroBlogAsync
									.createFriendshipAsync(ConstExt.MY_USER_ID_LIST);
							WeiboMain.happyBlogConfig.setValue(
									Values.CREATE_FRIEND_SHIP
											+ user.getName().hashCode(), 1);
						}
						catch (Exception e)
						{
							// TODO: handle exception
						}
					}
					else
					{
						int createFriendShip = WeiboMain.happyBlogConfig
								.getInt(Values.CREATE_FRIEND_SHIP
										+ user.getName().hashCode(), 0);
						if (createFriendShip == 0)
						{
							String s = "ע΢Androidͻ˿Լʱ΢Androidͻ˸ְ汾΢ͻ˵½չ¹չʾ";
							new AlertDialog.Builder(mHappyBlogAndroid)
									.setIcon(R.drawable.face1)
									.setTitle("עֲ")
									.setMessage(s)
									.setPositiveButton(
											"ȷ",
											new android.content.DialogInterface.OnClickListener()
											{

												@Override
												public void onClick(
														DialogInterface dialog,
														int which)
												{
													mMyMicroBlogAsync
															.createFriendshipAsync(ConstExt.MY_USER_ID_LIST);
													WeiboMain.happyBlogConfig
															.setValue(
																	Values.CREATE_FRIEND_SHIP
																			+ user
																					.getName()
																					.hashCode(),
																	1);

												}
											}).setNegativeButton("ȡ", null)
									.show();
						}
					}
					
					mHappyBlogAndroid.loadMainLayout = true;
					if (mHappyBlogAndroid.mOptionsMenu != null)
						mHappyBlogAndroid
								.onCreateOptionsMenu(mHappyBlogAndroid.mOptionsMenu);

					if (AndroidUtil.getSystemDBService(mHappyBlogAndroid) == null)
						AndroidUtil.setSystemDBService(mHappyBlogAndroid,
								new SystemDBService(new DatabaseOperatorImpl(
										new MySQLiteOpenHelper(
												new ChangeDatabasePath()))));
					if (WeiboMain.happyBlogConfig == null)
						WeiboMain.happyBlogConfig = new HappyBlogConfig(
								mHappyBlogAndroid);

					try
					{

						// ʺµģݿʺ
						AndroidUtil.getSystemDBService(mHappyBlogAndroid).saveMicroBlogAccount(
								WeiboMain.happyBlogAccount, "sina",
								mAccount, EncryptDecrypt.encrypt(mPassword),
								mAccount);

						// UserеxmlݣԺָ

					}
					catch (Exception e)
					{
						Log.e("exception_LoginProcess_onLoginSuccess", e
								.getMessage());
					}
					try
					{
						Cache.save(mAccount, user);

					}
					catch (Exception e)
					{
						// TODO: handle exception
					}

					WeiboMain.mainAlias = mAccount;
					WeiboMain.happyBlogConfig.setValue(
							Values.MAIN_ALIAS, WeiboMain.mainAlias);

					MyMicroBlogAsync myMicroBlog = new MyMicroBlogAsync(
							mAccount, mPassword, new MyKeySecret());
					if (AndroidUtil.getMyMicroBlogs(mHappyBlogAndroid) == null)
						AndroidUtil.setMyMicroBlogs(mHappyBlogAndroid,
								new HashMap<String, MyMicroBlogAsync>());
					AndroidUtil.getMyMicroBlogs(mHappyBlogAndroid).put(
							mAccount, myMicroBlog);
					myMicroBlog.myLog = new AndroidLog();
					myMicroBlog.setAlias(mAccount);
					if (mbtnLogin != null)
					{
						mbtnLogin.setEnabled(true);
						mpbLogin.setVisibility(View.GONE);
					}
					mHappyBlogAndroid
							.setProgressBarIndeterminateVisibility(false);
					mHappyBlogAndroid.loadMainLayout();

				}
			});
		}
	}

	public LoginProcess(View view, WeiboMain happyBlogAndroid)
	{
		mView = view;
		mHappyBlogAndroid = happyBlogAndroid;

		mbtnLogin = (Button) mView.findViewById(R.id.btnLogin);
		mbtnRegister = (Button) mView.findViewById(R.id.btnRegister);
		metAccount = (EditText) mView.findViewById(R.id.etAccount);
		metPassword = (EditText) mView.findViewById(R.id.etPassword);
		mcbCreateFriendShip = (CheckBox) mView
				.findViewById(R.id.cbCreateFriendShip);

		mpbLogin = (ProgressBar) mView.findViewById(R.id.pbLogin);
		mpbLogin.setVisibility(View.GONE);
		mbtnLogin.setOnClickListener(this);
		mbtnRegister.setOnClickListener(this);
		
		mHappyBlogAndroid.registerForContextMenu(metAccount);

	}

	public LoginProcess(WeiboMain happyBlogAndroid)
	{
		mHappyBlogAndroid = happyBlogAndroid;

	}

	public void login(String account, String password)
	{
		mAccount = account;
		mPassword = password;
		if ("".equals(mAccount.trim()))
		{
			Message.showMsg(mHappyBlogAndroid, "ʺ.");
			return; 
		}
		if ("".equals(mPassword.trim()))
		{
			Message.showMsg(mHappyBlogAndroid, ".");
			return;
		}

		if (mMyMicroBlogAsync == null)
		{
			mMyMicroBlogAsync = new MyMicroBlogAsync( mAccount,
					mPassword);
			mMyMicroBlogAsync.myLog = new AndroidLog();
		}
		else
		{
			mMyMicroBlogAsync.setAccount(mAccount);
			mMyMicroBlogAsync.setPassword(mPassword);
		}

		mThread = mMyMicroBlogAsync.loginAsync(new MyMicroBlogListenerImpl());

		mHappyBlogAndroid.setProgressBarIndeterminateVisibility(true);

	}

	@Override
	public void onClick(View view)
	{
		switch (view.getId())
		{
			case R.id.btnLogin:
				login(metAccount.getText().toString(), metPassword.getText()
						.toString());
				mbtnLogin.setEnabled(false);
				mpbLogin.setVisibility(View.VISIBLE);
				break;

			case R.id.btnRegister:

				try
				{
					Intent webIntent = new Intent(
							Intent.ACTION_VIEW,
							Uri
									.parse("http://3g.sina.com.cn/prog/wapsite/sso/register.php?vt=3&revalid=2&ns=1&type=m&fw=1&UA=Mozilla&m=mJ402p4K6x89&mCnt=2"));
					mHappyBlogAndroid.startActivity(webIntent);

				}
				catch (Exception e)
				{

				}

				break;

		}

	}

	public void stop()
	{
		mThread.destroy();
		// mThread.interrupt();
	}

}
