package sina.weibo.process;

import microblog.MyMicroBlogAsync;
import microblog.commons.Const;
import microblog.commons.ConstExt;
import sina.weibo.WeiboMain;
import sina.weibo.R;
import sina.weibo.commons.AndroidUtil;
import weibo4j.Paging;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MenuItem.OnMenuItemClickListener;
import android.view.View;

public class MainMoreMenuProcess extends ProcessParent implements
		OnMenuItemClickListener
{

	private Menu mMenu;
	public WeiboMain mHappyBlogAndroid;

	public MainMoreMenuProcess(WeiboMain happyBlogAndroid, Menu menu)
	{
		super(happyBlogAndroid);
		mHappyBlogAndroid = happyBlogAndroid;
		mMenu = menu;
		MenuItem mnuPublicTimeline = (MenuItem) menu
				.findItem(R.id.mnuPublicTimeline);
		MenuItem mnuUserTimeline = (MenuItem) menu
				.findItem(R.id.mnuUserTimeline);
		MenuItem mnuMentions = (MenuItem) menu.findItem(R.id.mnuMentions);
		MenuItem mnuCommentsTimeline = (MenuItem) menu
				.findItem(R.id.mnuCommentsTimeline);
		MenuItem mnuCommentByMe = (MenuItem) menu.findItem(R.id.mnuCommentByMe);
		MenuItem mnuMyFavorites = (MenuItem) menu.findItem(R.id.mnuMyFavorites);
		MenuItem mnuDirectMessage = (MenuItem) menu
				.findItem(R.id.mnuDirectMessages);
		mnuPublicTimeline.setOnMenuItemClickListener(this);
		mnuUserTimeline.setOnMenuItemClickListener(this);
		mnuMentions.setOnMenuItemClickListener(this);
		mnuCommentsTimeline.setOnMenuItemClickListener(this);
		mnuCommentByMe.setOnMenuItemClickListener(this);
		mnuMyFavorites.setOnMenuItemClickListener(this);
		mnuDirectMessage.setOnMenuItemClickListener(this);

	}

	public MainMoreMenuProcess(WeiboMain happyBlogAndroid)
	{
		super(happyBlogAndroid);
		mHappyBlogAndroid = happyBlogAndroid;
	}

	public void publicTimeline()
	{
		hideAllWidget();
		if (mlvPublicTimeline.getAdapter() != null)
		{
			mlvPublicTimeline.setVisibility(View.VISIBLE);
			AndroidUtil
					.setMainTimelineOperationProcess(
							mHappyBlogAndroid,
							AndroidUtil
									.getPublicTimelineOperationProcess(mHappyBlogAndroid));
			WeiboMain.mtvName.setText(WeiboMain.mCurrentUser.getName());
			WeiboMain.mtvStatus.setText(AndroidUtil
					.getMainTimelineOperationProcess(mHappyBlogAndroid)
					.getDataTypeTitle());

		}
		else
		{

			mLoading.setVisibility(View.VISIBLE);
			AndroidUtil.setMainTimelineOperationProcess(mHappyBlogAndroid,
					new TimelineOperationProcess(mHappyBlogAndroid,
							Const.TIMELINE_TYPE_STATUS,
							Const.DATA_TYPE_PUBLIC_TIMELINE,
							R.id.lvPublicTimeline));
			AndroidUtil
					.setPublicTimelineOperationProcess(
							mHappyBlogAndroid,
							AndroidUtil
									.getMainTimelineOperationProcess(mHappyBlogAndroid));

			AndroidUtil.getPublicTimelineOperationProcess(mHappyBlogAndroid).mInitData = true;

			MyMicroBlogAsync myMicroBlogAsync = AndroidUtil.getMyMicroBlogs(
					mHappyBlogAndroid).get(WeiboMain.mainAlias);
			myMicroBlogAsync.getPublicTimelineAsync(AndroidUtil
					.getPublicTimelineOperationProcess(mHappyBlogAndroid));
		}
	}

	private void userTimeline()
	{
		hideAllWidget();
		if (mlvUserTimeline.getAdapter() != null)
		{
			mlvUserTimeline.setVisibility(View.VISIBLE);
			
			AndroidUtil
					.setMainTimelineOperationProcess(
							mHappyBlogAndroid,
							AndroidUtil
									.getUserTimelineOperationProcess(mHappyBlogAndroid));

			WeiboMain.mtvName.setText(WeiboMain.mCurrentUser.getName());
			WeiboMain.mtvStatus.setText(AndroidUtil
					.getMainTimelineOperationProcess(mHappyBlogAndroid)
					.getDataTypeTitle());

		}
		else
		{
			mLoading.setVisibility(View.VISIBLE);
			AndroidUtil
					.setMainTimelineOperationProcess(mHappyBlogAndroid,
							new TimelineOperationProcess(mHappyBlogAndroid,
									Const.TIMELINE_TYPE_STATUS,
									Const.DATA_TYPE_USER_TIMELINE,
									R.id.lvUserTimeline));
			AndroidUtil
					.setUserTimelineOperationProcess(
							mHappyBlogAndroid,
							AndroidUtil
									.getMainTimelineOperationProcess(mHappyBlogAndroid));
			AndroidUtil.getUserTimelineOperationProcess(mHappyBlogAndroid).mInitData = true;

			MyMicroBlogAsync myMicroBlogAsync = AndroidUtil.getMyMicroBlogs(
					mHappyBlogAndroid).get(WeiboMain.mainAlias);
			myMicroBlogAsync.getUserTimelineAsync(AndroidUtil
					.getUserTimelineOperationProcess(mHappyBlogAndroid));
		}
	}

	private void mentions()
	{
		hideAllWidget();
		if (mlvMentions.getAdapter() != null)
		{
			mlvMentions.setVisibility(View.VISIBLE);
			AndroidUtil.setMainTimelineOperationProcess(mHappyBlogAndroid,
					AndroidUtil.getMentionsOperationProcess(mHappyBlogAndroid));
			WeiboMain.mtvName.setText(WeiboMain.mCurrentUser.getName());
			WeiboMain.mtvStatus.setText(AndroidUtil
					.getMainTimelineOperationProcess(mHappyBlogAndroid)
					.getDataTypeTitle());
		}
		else
		{
			mLoading.setVisibility(View.VISIBLE);
			AndroidUtil.setMainTimelineOperationProcess(mHappyBlogAndroid,
					new TimelineOperationProcess(mHappyBlogAndroid,
							Const.TIMELINE_TYPE_STATUS,
							Const.DATA_TYPE_MENTIONS, R.id.lvMentions));
			AndroidUtil
					.setMentionsOperationProcess(mHappyBlogAndroid, AndroidUtil
							.getMainTimelineOperationProcess(mHappyBlogAndroid));
			AndroidUtil.getMentionsOperationProcess(mHappyBlogAndroid).mInitData = true;

			MyMicroBlogAsync myMicroBlogAsync = AndroidUtil.getMyMicroBlogs(
					mHappyBlogAndroid).get(WeiboMain.mainAlias);
			myMicroBlogAsync.getMentionsAsync(AndroidUtil
					.getMentionsOperationProcess(mHappyBlogAndroid));
		}
	}

	private void commentsTimeline()
	{
		hideAllWidget();
		if (mlvCommentsTimeline.getAdapter() != null)
		{
			mlvCommentsTimeline.setVisibility(View.VISIBLE);
			AndroidUtil
					.setMainTimelineOperationProcess(
							mHappyBlogAndroid,
							AndroidUtil
									.getCommentsTimelineOperationProcess(mHappyBlogAndroid));
			WeiboMain.mtvName.setText(WeiboMain.mCurrentUser.getName());
			WeiboMain.mtvStatus.setText(AndroidUtil
					.getMainTimelineOperationProcess(mHappyBlogAndroid)
					.getDataTypeTitle());

		}
		else
		{
			mLoading.setVisibility(View.VISIBLE);
			AndroidUtil.setMainTimelineOperationProcess(mHappyBlogAndroid,
					new TimelineOperationProcess(mHappyBlogAndroid,
							Const.TIMELINE_TYPE_COMMENT,
							Const.DATA_TYPE_COMMENTS_TIMELINE,
							R.id.lvCommentsTimeline));

			AndroidUtil
					.setCommentsTimelineOperationProcess(
							mHappyBlogAndroid,
							AndroidUtil
									.getMainTimelineOperationProcess(mHappyBlogAndroid));
			AndroidUtil.getCommentsTimelineOperationProcess(mHappyBlogAndroid).mInitData = true;

			MyMicroBlogAsync myMicroBlogAsync = AndroidUtil.getMyMicroBlogs(
					mHappyBlogAndroid).get(WeiboMain.mainAlias);
			myMicroBlogAsync.getCommentsTimelineAsync(AndroidUtil
					.getCommentsTimelineOperationProcess(mHappyBlogAndroid));
		}
	}

	private void commentByMe()
	{
		hideAllWidget();
		if (mlvCommentByMe.getAdapter() != null)
		{
			mlvCommentByMe.setVisibility(View.VISIBLE);
			AndroidUtil.setMainTimelineOperationProcess(mHappyBlogAndroid,
					AndroidUtil
							.getCommentByMeOperationProcess(mHappyBlogAndroid));

			WeiboMain.mtvName.setText(WeiboMain.mCurrentUser.getName());
			WeiboMain.mtvStatus.setText(AndroidUtil
					.getMainTimelineOperationProcess(mHappyBlogAndroid)
					.getDataTypeTitle());

		}
		else
		{
			mLoading.setVisibility(View.VISIBLE);
			AndroidUtil.setMainTimelineOperationProcess(mHappyBlogAndroid,
					new TimelineOperationProcess(mHappyBlogAndroid,
							Const.TIMELINE_TYPE_COMMENT,
							Const.DATA_TYPE_COMMENT_BY_ME, R.id.lvCommentByMe));

			AndroidUtil
					.setCommentByMeOperationProcess(
							mHappyBlogAndroid,
							AndroidUtil
									.getMainTimelineOperationProcess(mHappyBlogAndroid));
			AndroidUtil.getCommentByMeOperationProcess(mHappyBlogAndroid).mInitData = true;

			MyMicroBlogAsync myMicroBlogAsync = AndroidUtil.getMyMicroBlogs(
					mHappyBlogAndroid).get(WeiboMain.mainAlias);
			myMicroBlogAsync.getCommentsByMeAsync(AndroidUtil
					.getCommentByMeOperationProcess(mHappyBlogAndroid));
		}
	}

	private void favorites()
	{
		hideAllWidget();
		if (mlvFavorites.getAdapter() != null)
		{
			mlvFavorites.setVisibility(View.VISIBLE);

			AndroidUtil
					.setMainTimelineOperationProcess(
							mHappyBlogAndroid,
							AndroidUtil
									.getFavoritesOperationProcess(mHappyBlogAndroid));

			WeiboMain.mtvName.setText(WeiboMain.mCurrentUser.getName());
			WeiboMain.mtvStatus.setText(AndroidUtil
					.getMainTimelineOperationProcess(mHappyBlogAndroid)
					.getDataTypeTitle());
		}
		else
		{
			mLoading.setVisibility(View.VISIBLE);
			AndroidUtil.setMainTimelineOperationProcess(mHappyBlogAndroid,
					new TimelineOperationProcess(mHappyBlogAndroid,
							Const.TIMELINE_TYPE_STATUS,
							Const.DATA_TYPE_FAVORITES, R.id.lvFavorites));

			AndroidUtil
					.setFavoritesOperationProcess(
							mHappyBlogAndroid,
							AndroidUtil
									.getMainTimelineOperationProcess(mHappyBlogAndroid));
			AndroidUtil.getFavoritesOperationProcess(mHappyBlogAndroid).mInitData = true;

			MyMicroBlogAsync myMicroBlogAsync = AndroidUtil.getMyMicroBlogs(
					mHappyBlogAndroid).get(WeiboMain.mainAlias);
			myMicroBlogAsync.getFavoritesAsync(AndroidUtil
					.getFavoritesOperationProcess(mHappyBlogAndroid));
		}
	}

	private void directMessage1()
	{
		hideAllWidget();
		if (mlvDirectMessage.getAdapter() != null)
		{
			mlvDirectMessage.setVisibility(View.VISIBLE);

			AndroidUtil.setMainTimelineOperationProcess(mHappyBlogAndroid,
					AndroidUtil.getDirectMessageProcess(mHappyBlogAndroid));

			WeiboMain.mtvName.setText(WeiboMain.mCurrentUser.getName());
			WeiboMain.mtvStatus.setText(AndroidUtil
					.getMainTimelineOperationProcess(mHappyBlogAndroid)
					.getDataTypeTitle());
		}
		else
		{
			mLoading.setVisibility(View.VISIBLE);
			AndroidUtil.setMainTimelineOperationProcess(mHappyBlogAndroid,
					new TimelineOperationProcess(mHappyBlogAndroid,
							Const.TIMELINE_TYPE_DIRECT_MESSAGE,
							Const.DATA_TYPE_DIRECT_MESSAGE,
							R.id.lvDirectMessage));
			AndroidUtil.setDirectMessageProcess(mHappyBlogAndroid, AndroidUtil
					.getMainTimelineOperationProcess(mHappyBlogAndroid));
			AndroidUtil.getDirectMessageProcess(mHappyBlogAndroid).mInitData = true;

			AndroidUtil
					.getMainTimelineOperationProcess(mHappyBlogAndroid)
					.getListView()
					.setOnItemClickListener(
							AndroidUtil
									.getMainTimelineOperationProcess(mHappyBlogAndroid));
			MyMicroBlogAsync myMicroBlogAsync = AndroidUtil.getMyMicroBlogs(
					mHappyBlogAndroid).get(WeiboMain.mainAlias);
			myMicroBlogAsync.getDirectMessagesExtAsync(
					AndroidUtil.getDirectMessageProcess(mHappyBlogAndroid),
					new Paging());
		}
	}

	private void directMessage()
	{
		hideAllWidget();
		if (mlvDirectMessage.getAdapter() != null)
		{
			mlvDirectMessage.setVisibility(View.VISIBLE);

			AndroidUtil.setMainTimelineOperationProcess(mHappyBlogAndroid,
					AndroidUtil.getDirectMessageProcess(mHappyBlogAndroid));

			WeiboMain.mtvName.setText(WeiboMain.mCurrentUser.getName());
			WeiboMain.mtvStatus.setText(AndroidUtil
					.getMainTimelineOperationProcess(mHappyBlogAndroid)
					.getDataTypeTitle());

		}
		else
		{
			mLoading.setVisibility(View.VISIBLE);
			AndroidUtil.setMainTimelineOperationProcess(mHappyBlogAndroid,
					new TimelineOperationProcess(mHappyBlogAndroid,
							Const.TIMELINE_TYPE_DIRECT_MESSAGE_ME,
							Const.DATA_TYPE_DIRECT_MESSAGE_ME,
							R.id.lvDirectMessage));
			AndroidUtil.setDirectMessageProcess(mHappyBlogAndroid, AndroidUtil
					.getMainTimelineOperationProcess(mHappyBlogAndroid));
			AndroidUtil.getDirectMessageProcess(mHappyBlogAndroid).mInitData = true;

			AndroidUtil
					.getMainTimelineOperationProcess(mHappyBlogAndroid)
					.getListView()
					.setOnItemClickListener(
							AndroidUtil
									.getMainTimelineOperationProcess(mHappyBlogAndroid));
			MyMicroBlogAsync myMicroBlogAsync = AndroidUtil.getMyMicroBlogs(
					mHappyBlogAndroid).get(WeiboMain.mainAlias);
			myMicroBlogAsync.getDirectMessagesAsync(
					AndroidUtil.getDirectMessageProcess(mHappyBlogAndroid),
					new Paging());
		}
	}

	@Override
	public boolean onMenuItemClick(MenuItem item)
	{

		switch (item.getItemId())
		{
			case R.id.mnuPublicTimeline:
				publicTimeline();
				break;
			case R.id.mnuUserTimeline:
				userTimeline();
				break;
			case R.id.mnuMentions:
				mentions();
				break;
			case R.id.mnuCommentsTimeline:
				commentsTimeline();
				break;
			case R.id.mnuCommentByMe:
				commentByMe();
				break;
			case R.id.mnuMyFavorites:
				favorites();
				break;
			case R.id.mnuDirectMessages:
				directMessage();
				break;
			case R.id.mnuCreateFriendShip:
				AndroidUtil.getMyMicroBlogs(mHappyBlogAndroid)
						.get(WeiboMain.mainAlias)
						.createFriendshipAsync(ConstExt.MY_USER_ID_LIST);
				break;
		}
		return false;
	}

}
