package sina.weibo.process;


import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import sina.weibo.commons.Message;

import android.content.Context;
import android.os.Handler;
import android.util.Log;

public class NotificationProcess implements Runnable
{
	public static List<NotificationParams> taskList = new ArrayList<NotificationParams>();
	public static boolean finishFlag;

	private Message message;

	private Handler handler = new Handler()
	{

		@Override
		public void handleMessage(android.os.Message msg)
		{
			NotificationParams params = (NotificationParams) msg.obj;
			showNotification(params);
			super.handleMessage(msg);
		}
	};

	public synchronized static void addNotification(NotificationParams params)
	{
		taskList.add(params);
	}

	public synchronized static NotificationParams getNotification()
	{
		if (taskList.size() == 0)
			return null;
		NotificationParams params = taskList.get(0);

		taskList.remove(0);
		return params;
	}

	public NotificationProcess(Context context)
	{
		finishFlag = false;
		message = new Message(context);

	}

	public void showNotification(NotificationParams params)
	{
		try
		{
			message.showNotification(params.id, params.icon, params.tickerText,
					params.contentTitle, params.contentText,
					params.contentIntent, params.deleteIntent);
		}
		catch (Exception e)
		{
			Log.d("exception_NotificationProcess_showNotification", String.valueOf(params.toString()));
		}

	}

	@Override
	public void run()
	{
		while (true)
		{

			try
			{

				NotificationParams params = getNotification();
				
				if (params != null)
				{

					android.os.Message message = new android.os.Message();
					message.obj = params;
					handler.sendMessage(message);

				}
				else
				{
					if (finishFlag)
					{
						break;
					}
				}
				Thread.sleep(3000);
			}
			catch (Exception e)
			{
				// TODO: handle exception
			}

		}
	}

}
