package sina.weibo.process;

import sina.weibo.WeiboMain;
import sina.weibo.commons.Message;
import sina.weibo.interfaces.HandlerRun;
import microblog.MicroBlogListenerImpl;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.util.Log;
import android.widget.Toast;

public class OperationProcess extends MicroBlogListenerImpl
{
	protected Context mContext;
	public Activity mActivity;
	protected MyHandler myHandler = new MyHandler();
	protected ProgressDialog progressDialog;
	protected Message mMessage;
	protected ProcessParent mProcessParent;
    public OperationProcess(Context context)
    {
        mContext = context;	
        mActivity = (Activity)context;
		progressDialog = new ProgressDialog(context);		
		progressDialog.setProgressStyle(ProgressDialog.STYLE_SPINNER);
		mMessage = new Message(mContext);
		if(mActivity instanceof WeiboMain)
		{
			mProcessParent = new ProcessParent((WeiboMain)mActivity);
		}
    }
	@Override
	public void onEnd(String msg, Object obj, int type)
	{
		myHandler.run(new HandlerRun()
		{			
			@Override
			public void invoke()
			{
				//progressDialog.cancel();
			}
		});
		super.onEnd(msg, obj, type);
	}
	@Override
	public void onException(final String msg, int type)
	{
		myHandler.run(new HandlerRun()
		{
			
			@Override
			public void invoke()
			{
				progressDialog.cancel();
				Toast.makeText(mContext, msg, Toast.LENGTH_SHORT).show();

			}
		});
		
		super.onException(msg, type);
	}
	@Override
	public boolean onWait(final String msg, final int type)
	{
		return super.onWait(msg, type);
	}
	
	
}
