package sina.weibo.process;


import java.io.InputStream;

import sina.weibo.interfaces.HandlerRun;
import sina.weibo.process.TimelineOperationProcess.TimelineAdapter;
import sina.weibo.storage.Cache;

import microblog.net.interfaces.PullListener;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.widget.ImageView;

public class PullProfileImageProcess implements PullListener
{
	
	
	private TimelineAdapter mTimelineAdapter;
	
	private Handler mHandler = new Handler()
	{  
 
		@Override
		public void handleMessage(Message msg)
		{
			Data data = (Data)msg.obj;
			
			data.imageView.setImageBitmap(data.bitmap);

			super.handleMessage(msg);
		}
		
	};
    class Data
    {
    	public ImageView imageView;
    	public Bitmap bitmap;
    }
	public PullProfileImageProcess(TimelineAdapter timelineAdapter)
	{
		mTimelineAdapter = timelineAdapter;
	}

	@Override
	public void onPullFile(final String path, final InputStream is,
			final Object obj)
	{
		
        Message message = new Message();
        Data data = new Data();
        data.imageView = (ImageView) obj;
        
		final Bitmap bitmap = mTimelineAdapter.getProfileImageBitmap(
				path, is);


		data.bitmap = bitmap;
		
		message.obj = data;
		
		mHandler.sendMessage(message); 
		
		
	}

}
