package sina.weibo.storage;


import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

import microblog.MyMicroBlog;
import microblog.commons.EncryptDecrypt;
import sina.weibo.commons.Values;
import weibo4j.Status;
import weibo4j.Weibo;
import weibo4j.WeiboResponse;
import weibo4j.User;
import weibo4j.http.Response;
import android.graphics.Bitmap;
import android.graphics.Bitmap.CompressFormat;


public class Cache
{

	public static void save(String name, List<WeiboResponse> responses)
			throws Exception
	{

		if (responses.size() == 0)
			return;
		String xml = EncryptDecrypt.encrypt(responses.get(0).asString());

		FileOutputStream fos = new FileOutputStream(Values.getCachePath()
				+ EncryptDecrypt.encrypt(name));
		fos.write(xml.getBytes("utf-8"));

		fos.close();
	}

	public static void save(String name, User user) throws Exception
	{
		
		String xml = EncryptDecrypt.encrypt(user.asString());
		FileOutputStream fos = new FileOutputStream(Values.getCachePath()
				+ EncryptDecrypt.encrypt(name));
		fos.write(xml.getBytes("utf-8"));
		fos.close();
	}

	// ͼ񱣴浽ͼ񻺳
	public static void save(String name, Bitmap bitmap) throws Exception
	{
		FileOutputStream fos = new FileOutputStream(Values.getBitmapCachePath()
				+ EncryptDecrypt.encrypt(name));
		bitmap.compress(CompressFormat.PNG, 100, fos);
		fos.close();
	}

	public static Bitmap restoreBitmap(String name) throws Exception
	{

		Bitmap bitmap = Values.getFitBitmap(Values.getBitmapCachePath()
				+ EncryptDecrypt.encrypt(name));
		return bitmap;
	}

	public static User restoreUser(String name) throws Exception
	{
		String xml = "";
		FileInputStream fis = new FileInputStream(Values.getCachePath()
				+ EncryptDecrypt.encrypt(name));
		InputStreamReader isr = new InputStreamReader(fis, "utf-8");
		BufferedReader br = new BufferedReader(isr);
		String s = "";
		while ((s = br.readLine()) != null)
		{
			xml += s;
		}
		Response response = new Response();
		response.responseAsString = EncryptDecrypt.decrypt(xml);
		User user = User.constructUser(response, new Weibo());
		fis.close();
		return user;
	}

	public static List<WeiboResponse> restore(String name,
			Weibo Weibo) throws Exception
	{
		String xml = "";
		FileInputStream fis = new FileInputStream(Values.getCachePath()
				+ EncryptDecrypt.encrypt(name));

		InputStreamReader isr = new InputStreamReader(fis, "utf-8");
		BufferedReader br = new BufferedReader(isr);
		String s = ""; 
		while ((s = br.readLine()) != null)
		{
			xml += s;
		}
		Response response = new Response();
		response.responseAsString = EncryptDecrypt.decrypt(xml);
	
		List<Status> statuses = Status.constructStatuses(response, Weibo);
		List<WeiboResponse> responses = new ArrayList<WeiboResponse>();
		for (Status status : statuses)
		{
			responses.add(status);
		}
		fis.close();
		return responses;   
	}

}
