package sina.weibo.storage;

import android.database.sqlite.SQLiteDatabase;
import microblog.storage.DatabaseOperator;
import microblog.storage.SqliteCursor;

public class DatabaseOperatorImpl implements DatabaseOperator
{
	private MySQLiteOpenHelper mHelper;
	private SQLiteDatabase mDatabase;

	public DatabaseOperatorImpl(MySQLiteOpenHelper helper)
	{
		mHelper = helper;
	}

	@Override
	public void createDatabase()
	{
		mDatabase = mHelper.getWritableDatabase();
	}

	@Override
	public void execSQL(String sql)
	{
		mDatabase.execSQL(sql);
		
	}

	@Override
	public SqliteCursor query(String sql, String[] selectionArgs)
	{

		return new SqliteCursorImpl(mDatabase.rawQuery(sql, selectionArgs));
	}

	@Override
	public SqliteCursor query(String sql)
	{

		return new SqliteCursorImpl(mDatabase.rawQuery(sql, new String[]
		{}));
	}

	@Override
	public void execSQL(String sql, Object[] bindArgs)
	{
		mDatabase.execSQL(sql, bindArgs);
		
	}

}
