package sina.weibo.storage;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.MemoryFile;

public class HappyBlogConfig
{
	private final String CONFIG_NAME = "happyblog.cfg";

	private SharedPreferences mSharedPreferences;

	public HappyBlogConfig(Context context)
	{
		mSharedPreferences = context.getSharedPreferences(CONFIG_NAME,
				Context.MODE_PRIVATE);
	}

	public void setValue(String key, String value)
	{
		mSharedPreferences.edit().putString(key, value).commit();
	}

	public void setValue(String key, int value)
	{
		mSharedPreferences.edit().putInt(key, value).commit();
	}

	public String getString(String key)
	{
		return mSharedPreferences.getString(key, null);
	}
	public String getString(String key, String defaultValue)
	{ 
		return mSharedPreferences.getString(key,defaultValue);
	}

	public int getInt(String key)
	{
		return mSharedPreferences.getInt(key, -1);
	}
	public int getInt(String key, int defaultValue)
	{
		return mSharedPreferences.getInt(key, defaultValue);
	}
}