package sina.weibo.thread;


import java.io.File;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;

import sina.weibo.commons.Values;

import android.R.integer;
import android.app.Activity;
import android.content.Context;
import android.util.Log;

public class CleanCache implements Runnable
{
	private static Thread mThread;

	private void clearBitmapCache()
	{
		try
		{
			String path = Values.getBitmapCachePath();
			File file = new java.io.File(path);

			File[] files = file.listFiles();

			if (files.length <= Values.CACHE_MAX_BITMAP_COUNT)
				return;

			Arrays.sort(files, new Comparator<File>()
			{
				private final Collator collator = Collator.getInstance();

				@Override
				public int compare(File file1, File file2)
				{

					if (file1.lastModified() > file2.lastModified())
						return 1;
					else if (file1.lastModified() == file2.lastModified())
						return 0;
					else
						return -1;

				}
			});

			int count = files.length - Values.CACHE_MAX_BITMAP_COUNT;
			for (int i = 0; i < count * 5 && i < files.length; i++)
			{
				try
				{
					files[i].delete();
				}
				catch (Exception e)
				{
					// TODO: handle exception
				}

			}
			mThread = null;
		}
		catch (Exception e)
		{
			// TODO: handle exception
		}
	}

	@Override
	public void run()
	{
		while (Values.cleanCache)
		{
			clearBitmapCache();
			try
			{
				Thread.sleep(1000 * 60 * 5); // 5һ
			}
			catch (Exception e)
			{
			}


		}

	}

	public static void clearCache()
	{
		if (mThread == null)
		{
			mThread = new Thread(new CleanCache());
			mThread.start();
		}
	}
}
