package sina.weibo.widget;

import sina.weibo.R;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.widget.ImageView;

public class AnimImageView extends ImageView
{ 
	private Bitmap mBitmap;
	private Matrix mMatrix;
	private int mRotateDegree = 0;;
	private boolean mPause = true;

	public AnimImageView(Context context, AttributeSet attrs)
	{
		super(context, attrs);

		mBitmap = BitmapFactory.decodeResource(context.getResources(),
				R.drawable.refresh2);

		mMatrix = new Matrix();
		mMatrix.setRotate(mRotateDegree);

	}

	public void stop()
	{
	
		mPause = true;
	}

	public void start()
	{
		mPause = false;
		
		invalidate();
	}  

	@Override
	protected void onDraw(Canvas canvas)
	{
		mRotateDegree += 3;

		mMatrix.setRotate(mRotateDegree, getWidth() / 2, getHeight() / 2);

		// Bitmap bitmap = Bitmap.createBitmap(mBitmap, 0, 0,
		// mBitmap.getWidth(),
		// mBitmap.getHeight(), mMatrix, true);

		// setImageBitmap(bitmap);
		canvas.drawBitmap(mBitmap, mMatrix, new Paint());
		if (!mPause)
		{
			//Log.d("mpause", String.valueOf(mPause));
			
			invalidate();
		}

		super.onDraw(canvas);
	}

}
