/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.animation.LayoutTransition;
import android.app.Activity;
import android.app.BackStackRecord;
import android.app.FragmentManager;
import android.app.FragmentManagerImpl;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

public class FragmentBreadCrumbs
extends ViewGroup
implements FragmentManager.OnBackStackChangedListener {
    Activity mActivity;
    LayoutInflater mInflater;
    LinearLayout mContainer;
    int mMaxVisible = -1;
    BackStackRecord mTopEntry;
    BackStackRecord mParentEntry;
    private View.OnClickListener mParentClickListener;
    private OnBreadCrumbClickListener mOnBreadCrumbClickListener;
    private View.OnClickListener mOnClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (v.getTag() instanceof FragmentManager.BackStackEntry) {
                FragmentManager.BackStackEntry bse = (FragmentManager.BackStackEntry)v.getTag();
                if (bse == FragmentBreadCrumbs.this.mParentEntry) {
                    if (FragmentBreadCrumbs.this.mParentClickListener != null) {
                        FragmentBreadCrumbs.this.mParentClickListener.onClick(v);
                    }
                } else {
                    if (FragmentBreadCrumbs.this.mOnBreadCrumbClickListener != null && FragmentBreadCrumbs.this.mOnBreadCrumbClickListener.onBreadCrumbClick(bse == FragmentBreadCrumbs.this.mTopEntry ? null : bse, 0)) {
                        return;
                    }
                    if (bse == FragmentBreadCrumbs.this.mTopEntry) {
                        FragmentBreadCrumbs.this.mActivity.getFragmentManager().popBackStack();
                    } else {
                        FragmentBreadCrumbs.this.mActivity.getFragmentManager().popBackStack(bse.getId(), 0);
                    }
                }
            }
        }
    };

    public FragmentBreadCrumbs(Context context) {
        this(context, null);
    }

    public FragmentBreadCrumbs(Context context, AttributeSet attrs) {
        this(context, attrs, 16973961);
    }

    public FragmentBreadCrumbs(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setActivity(Activity a) {
        this.mActivity = a;
        this.mInflater = (LayoutInflater)a.getSystemService("layout_inflater");
        this.mContainer = (LinearLayout)this.mInflater.inflate(17367103, (ViewGroup)this, false);
        this.addView(this.mContainer);
        a.getFragmentManager().addOnBackStackChangedListener(this);
        this.updateCrumbs();
        this.setLayoutTransition(new LayoutTransition());
    }

    public void setMaxVisible(int visibleCrumbs) {
        if (visibleCrumbs < 1) {
            throw new IllegalArgumentException("visibleCrumbs must be greater than zero");
        }
        this.mMaxVisible = visibleCrumbs;
    }

    public void setParentTitle(CharSequence title, CharSequence shortTitle, View.OnClickListener listener) {
        this.mParentEntry = this.createBackStackEntry(title, shortTitle);
        this.mParentClickListener = listener;
        this.updateCrumbs();
    }

    public void setOnBreadCrumbClickListener(OnBreadCrumbClickListener listener) {
        this.mOnBreadCrumbClickListener = listener;
    }

    private BackStackRecord createBackStackEntry(CharSequence title, CharSequence shortTitle) {
        if (title == null) {
            return null;
        }
        BackStackRecord entry = new BackStackRecord((FragmentManagerImpl)this.mActivity.getFragmentManager());
        entry.setBreadCrumbTitle(title);
        entry.setBreadCrumbShortTitle(shortTitle);
        return entry;
    }

    public void setTitle(CharSequence title, CharSequence shortTitle) {
        this.mTopEntry = this.createBackStackEntry(title, shortTitle);
        this.updateCrumbs();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            int childRight = this.mPaddingLeft + child.getMeasuredWidth() - this.mPaddingRight;
            int childBottom = this.mPaddingTop + child.getMeasuredHeight() - this.mPaddingBottom;
            child.layout(this.mPaddingLeft, this.mPaddingTop, childRight, childBottom);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int count = this.getChildCount();
        int maxHeight = 0;
        int maxWidth = 0;
        int measuredChildState = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
            maxWidth = Math.max(maxWidth, child.getMeasuredWidth());
            maxHeight = Math.max(maxHeight, child.getMeasuredHeight());
            measuredChildState = FragmentBreadCrumbs.combineMeasuredStates(measuredChildState, child.getMeasuredState());
        }
        maxWidth += this.mPaddingLeft + this.mPaddingRight;
        maxHeight += this.mPaddingTop + this.mPaddingBottom;
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        this.setMeasuredDimension(FragmentBreadCrumbs.resolveSizeAndState(maxWidth, widthMeasureSpec, measuredChildState), FragmentBreadCrumbs.resolveSizeAndState(maxHeight, heightMeasureSpec, measuredChildState << 16));
    }

    public void onBackStackChanged() {
        this.updateCrumbs();
    }

    private int getPreEntryCount() {
        return (this.mTopEntry != null ? 1 : 0) + (this.mParentEntry != null ? 1 : 0);
    }

    private FragmentManager.BackStackEntry getPreEntry(int index) {
        if (this.mParentEntry != null) {
            return index == 0 ? this.mParentEntry : this.mTopEntry;
        }
        return this.mTopEntry;
    }

    void updateCrumbs() {
        FragmentManager fm = this.mActivity.getFragmentManager();
        int numEntries = fm.getBackStackEntryCount();
        int numPreEntries = this.getPreEntryCount();
        int numViews = this.mContainer.getChildCount();
        for (int i = 0; i < numEntries + numPreEntries; ++i) {
            View v;
            Object tag;
            FragmentManager.BackStackEntry bse;
            FragmentManager.BackStackEntry backStackEntry = bse = i < numPreEntries ? this.getPreEntry(i) : fm.getBackStackEntryAt(i - numPreEntries);
            if (i < numViews && (tag = (v = this.mContainer.getChildAt(i)).getTag()) != bse) {
                for (int j = i; j < numViews; ++j) {
                    this.mContainer.removeViewAt(i);
                }
                numViews = i;
            }
            if (i < numViews) continue;
            View item = this.mInflater.inflate(17367102, (ViewGroup)this, false);
            TextView text = (TextView)item.findViewById(16908310);
            text.setText(bse.getBreadCrumbTitle());
            text.setTag(bse);
            if (i == 0) {
                item.findViewById(16908829).setVisibility(8);
            }
            this.mContainer.addView(item);
            text.setOnClickListener(this.mOnClickListener);
        }
        int viewI = numEntries + numPreEntries;
        for (numViews = this.mContainer.getChildCount(); numViews > viewI; --numViews) {
            this.mContainer.removeViewAt(numViews - 1);
        }
        for (int i = 0; i < numViews; ++i) {
            View child = this.mContainer.getChildAt(i);
            child.findViewById(16908310).setEnabled(i < numViews - 1);
            if (this.mMaxVisible <= 0) continue;
            child.setVisibility(i < numViews - this.mMaxVisible ? 8 : 0);
            View leftIcon = child.findViewById(16908829);
            leftIcon.setVisibility(i > numViews - this.mMaxVisible && i != 0 ? 0 : 8);
        }
    }

    public static interface OnBreadCrumbClickListener {
        public boolean onBreadCrumbClick(FragmentManager.BackStackEntry var1, int var2);
    }
}

