/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ClipDescription;
import android.content.ComponentCallbacks2;
import android.content.ContentProviderNative;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.IContentProvider;
import android.content.OperationApplicationException;
import android.content.pm.PathPermission;
import android.content.pm.ProviderInfo;
import android.content.res.AssetFileDescriptor;
import android.content.res.Configuration;
import android.database.Cursor;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.Bundle;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContentProvider
implements ComponentCallbacks2 {
    private static final String TAG = "ContentProvider";
    private Context mContext = null;
    private int mMyUid;
    private String mReadPermission;
    private String mWritePermission;
    private PathPermission[] mPathPermissions;
    private boolean mExported;
    private Transport mTransport = new Transport();

    public ContentProvider() {
    }

    public ContentProvider(Context context, String readPermission, String writePermission, PathPermission[] pathPermissions) {
        this.mContext = context;
        this.mReadPermission = readPermission;
        this.mWritePermission = writePermission;
        this.mPathPermissions = pathPermissions;
    }

    public static ContentProvider coerceToLocalContentProvider(IContentProvider abstractInterface) {
        if (abstractInterface instanceof Transport) {
            return ((Transport)abstractInterface).getContentProvider();
        }
        return null;
    }

    public Context getContext() {
        return this.mContext;
    }

    protected void setReadPermission(String permission2) {
        this.mReadPermission = permission2;
    }

    public String getReadPermission() {
        return this.mReadPermission;
    }

    protected void setWritePermission(String permission2) {
        this.mWritePermission = permission2;
    }

    public String getWritePermission() {
        return this.mWritePermission;
    }

    protected void setPathPermissions(PathPermission[] permissions) {
        this.mPathPermissions = permissions;
    }

    public PathPermission[] getPathPermissions() {
        return this.mPathPermissions;
    }

    public abstract boolean onCreate();

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
    }

    @Override
    public void onLowMemory() {
    }

    @Override
    public void onTrimMemory(int level) {
    }

    public abstract Cursor query(Uri var1, String[] var2, String var3, String[] var4, String var5);

    public abstract String getType(Uri var1);

    public abstract Uri insert(Uri var1, ContentValues var2);

    public int bulkInsert(Uri uri, ContentValues[] values) {
        int numValues = values.length;
        for (int i = 0; i < numValues; ++i) {
            this.insert(uri, values[i]);
        }
        return numValues;
    }

    public abstract int delete(Uri var1, String var2, String[] var3);

    public abstract int update(Uri var1, ContentValues var2, String var3, String[] var4);

    public ParcelFileDescriptor openFile(Uri uri, String mode) throws FileNotFoundException {
        throw new FileNotFoundException("No files supported by provider at " + uri);
    }

    public AssetFileDescriptor openAssetFile(Uri uri, String mode) throws FileNotFoundException {
        ParcelFileDescriptor fd = this.openFile(uri, mode);
        return fd != null ? new AssetFileDescriptor(fd, 0L, -1L) : null;
    }

    protected ParcelFileDescriptor openFileHelper(Uri uri, String mode) throws FileNotFoundException {
        int count;
        Cursor c = this.query(uri, new String[]{"_data"}, null, null, null);
        int n = count = c != null ? c.getCount() : 0;
        if (count != 1) {
            if (c != null) {
                c.close();
            }
            if (count == 0) {
                throw new FileNotFoundException("No entry for " + uri);
            }
            throw new FileNotFoundException("Multiple items at " + uri);
        }
        c.moveToFirst();
        int i = c.getColumnIndex("_data");
        String path = i >= 0 ? c.getString(i) : null;
        c.close();
        if (path == null) {
            throw new FileNotFoundException("Column _data not found.");
        }
        int modeBits = ContentResolver.modeToMode(uri, mode);
        return ParcelFileDescriptor.open(new File(path), modeBits);
    }

    public String[] getStreamTypes(Uri uri, String mimeTypeFilter) {
        return null;
    }

    public AssetFileDescriptor openTypedAssetFile(Uri uri, String mimeTypeFilter, Bundle opts) throws FileNotFoundException {
        if ("*/*".equals(mimeTypeFilter)) {
            return this.openAssetFile(uri, "r");
        }
        String baseType = this.getType(uri);
        if (baseType != null && ClipDescription.compareMimeTypes(baseType, mimeTypeFilter)) {
            return this.openAssetFile(uri, "r");
        }
        throw new FileNotFoundException("Can't open " + uri + " as type " + mimeTypeFilter);
    }

    public <T> ParcelFileDescriptor openPipeHelper(final Uri uri, final String mimeType, final Bundle opts, final T args, final PipeDataWriter<T> func) throws FileNotFoundException {
        try {
            final ParcelFileDescriptor[] fds = ParcelFileDescriptor.createPipe();
            AsyncTask<Object, Object, Object> task = new AsyncTask<Object, Object, Object>(){

                @Override
                protected Object doInBackground(Object ... params) {
                    func.writeDataToPipe(fds[1], uri, mimeType, opts, args);
                    try {
                        fds[1].close();
                    }
                    catch (IOException e) {
                        Log.w(ContentProvider.TAG, "Failure closing pipe", e);
                    }
                    return null;
                }
            };
            task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, null);
            return fds[0];
        }
        catch (IOException e) {
            throw new FileNotFoundException("failure making pipe");
        }
    }

    protected boolean isTemporary() {
        return false;
    }

    public IContentProvider getIContentProvider() {
        return this.mTransport;
    }

    public void attachInfo(Context context, ProviderInfo info) {
        AsyncTask.init();
        if (this.mContext == null) {
            this.mContext = context;
            this.mMyUid = Process.myUid();
            if (info != null) {
                this.setReadPermission(info.readPermission);
                this.setWritePermission(info.writePermission);
                this.setPathPermissions(info.pathPermissions);
                this.mExported = info.exported;
            }
            this.onCreate();
        }
    }

    public ContentProviderResult[] applyBatch(ArrayList<ContentProviderOperation> operations) throws OperationApplicationException {
        int numOperations = operations.size();
        ContentProviderResult[] results = new ContentProviderResult[numOperations];
        for (int i = 0; i < numOperations; ++i) {
            results[i] = operations.get(i).apply(this, results, i);
        }
        return results;
    }

    public Bundle call(String method, String arg, Bundle extras) {
        return null;
    }

    public void shutdown() {
        Log.w(TAG, "implement ContentProvider shutdown() to make sure all database connections are gracefully shutdown");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PipeDataWriter<T> {
        public void writeDataToPipe(ParcelFileDescriptor var1, Uri var2, String var3, Bundle var4, T var5);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Transport
    extends ContentProviderNative {
        Transport() {
        }

        ContentProvider getContentProvider() {
            return ContentProvider.this;
        }

        @Override
        public String getProviderName() {
            return this.getContentProvider().getClass().getName();
        }

        @Override
        public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
            this.enforceReadPermission(uri);
            return ContentProvider.this.query(uri, projection, selection, selectionArgs, sortOrder);
        }

        @Override
        public String getType(Uri uri) {
            return ContentProvider.this.getType(uri);
        }

        @Override
        public Uri insert(Uri uri, ContentValues initialValues) {
            this.enforceWritePermission(uri);
            return ContentProvider.this.insert(uri, initialValues);
        }

        @Override
        public int bulkInsert(Uri uri, ContentValues[] initialValues) {
            this.enforceWritePermission(uri);
            return ContentProvider.this.bulkInsert(uri, initialValues);
        }

        @Override
        public ContentProviderResult[] applyBatch(ArrayList<ContentProviderOperation> operations) throws OperationApplicationException {
            for (ContentProviderOperation operation : operations) {
                if (operation.isReadOperation()) {
                    this.enforceReadPermission(operation.getUri());
                }
                if (!operation.isWriteOperation()) continue;
                this.enforceWritePermission(operation.getUri());
            }
            return ContentProvider.this.applyBatch(operations);
        }

        @Override
        public int delete(Uri uri, String selection, String[] selectionArgs) {
            this.enforceWritePermission(uri);
            return ContentProvider.this.delete(uri, selection, selectionArgs);
        }

        @Override
        public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
            this.enforceWritePermission(uri);
            return ContentProvider.this.update(uri, values, selection, selectionArgs);
        }

        @Override
        public ParcelFileDescriptor openFile(Uri uri, String mode) throws FileNotFoundException {
            if (mode != null && mode.startsWith("rw")) {
                this.enforceWritePermission(uri);
            } else {
                this.enforceReadPermission(uri);
            }
            return ContentProvider.this.openFile(uri, mode);
        }

        @Override
        public AssetFileDescriptor openAssetFile(Uri uri, String mode) throws FileNotFoundException {
            if (mode != null && mode.startsWith("rw")) {
                this.enforceWritePermission(uri);
            } else {
                this.enforceReadPermission(uri);
            }
            return ContentProvider.this.openAssetFile(uri, mode);
        }

        @Override
        public Bundle call(String method, String arg, Bundle extras) {
            return ContentProvider.this.call(method, arg, extras);
        }

        @Override
        public String[] getStreamTypes(Uri uri, String mimeTypeFilter) {
            return ContentProvider.this.getStreamTypes(uri, mimeTypeFilter);
        }

        @Override
        public AssetFileDescriptor openTypedAssetFile(Uri uri, String mimeType, Bundle opts) throws FileNotFoundException {
            this.enforceReadPermission(uri);
            return ContentProvider.this.openTypedAssetFile(uri, mimeType, opts);
        }

        private void enforceReadPermission(Uri uri) {
            int uid = Binder.getCallingUid();
            if (uid == ContentProvider.this.mMyUid) {
                return;
            }
            Context context = ContentProvider.this.getContext();
            String rperm = ContentProvider.this.getReadPermission();
            int pid = Binder.getCallingPid();
            if (ContentProvider.this.mExported && (rperm == null || context.checkPermission(rperm, pid, uid) == 0)) {
                return;
            }
            PathPermission[] pps = ContentProvider.this.getPathPermissions();
            if (pps != null) {
                String path = uri.getPath();
                int i = pps.length;
                while (i > 0) {
                    PathPermission pp;
                    String pprperm;
                    if ((pprperm = (pp = pps[--i]).getReadPermission()) == null || !pp.match(path) || context.checkPermission(pprperm, pid, uid) != 0) continue;
                    return;
                }
            }
            if (context.checkUriPermission(uri, pid, uid, 1) == 0) {
                return;
            }
            String msg = "Permission Denial: reading " + ContentProvider.this.getClass().getName() + " uri " + uri + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + rperm;
            throw new SecurityException(msg);
        }

        private boolean hasWritePermission(Uri uri) {
            int uid = Binder.getCallingUid();
            if (uid == ContentProvider.this.mMyUid) {
                return true;
            }
            Context context = ContentProvider.this.getContext();
            String wperm = ContentProvider.this.getWritePermission();
            int pid = Binder.getCallingPid();
            if (ContentProvider.this.mExported && (wperm == null || context.checkPermission(wperm, pid, uid) == 0)) {
                return true;
            }
            PathPermission[] pps = ContentProvider.this.getPathPermissions();
            if (pps != null) {
                String path = uri.getPath();
                int i = pps.length;
                while (i > 0) {
                    PathPermission pp;
                    String ppwperm;
                    if ((ppwperm = (pp = pps[--i]).getWritePermission()) == null || !pp.match(path) || context.checkPermission(ppwperm, pid, uid) != 0) continue;
                    return true;
                }
            }
            return context.checkUriPermission(uri, pid, uid, 2) == 0;
        }

        private void enforceWritePermission(Uri uri) {
            if (this.hasWritePermission(uri)) {
                return;
            }
            String msg = "Permission Denial: writing " + ContentProvider.this.getClass().getName() + " uri " + uri + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + ContentProvider.this.getWritePermission();
            throw new SecurityException(msg);
        }
    }
}

