/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.NinePatch_Delegate;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;

public class NinePatch {
    private final Bitmap mBitmap;
    private final byte[] mChunk;
    private Paint mPaint;
    private String mSrcName;
    private final RectF mRect = new RectF();

    public NinePatch(Bitmap bitmap, byte[] chunk, String srcName) {
        this.mBitmap = bitmap;
        this.mChunk = chunk;
        this.mSrcName = srcName;
        NinePatch.validateNinePatchChunk(this.mBitmap.ni(), chunk);
    }

    public NinePatch(NinePatch patch) {
        this.mBitmap = patch.mBitmap;
        this.mChunk = patch.mChunk;
        this.mSrcName = patch.mSrcName;
        if (patch.mPaint != null) {
            this.mPaint = new Paint(patch.mPaint);
        }
        NinePatch.validateNinePatchChunk(this.mBitmap.ni(), this.mChunk);
    }

    public void setPaint(Paint p) {
        this.mPaint = p;
    }

    public void draw(Canvas canvas, RectF location) {
        if (!canvas.isHardwareAccelerated()) {
            NinePatch.nativeDraw(canvas.mNativeCanvas, location, this.mBitmap.ni(), this.mChunk, this.mPaint != null ? this.mPaint.mNativePaint : 0, canvas.mDensity, this.mBitmap.mDensity);
        } else {
            canvas.drawPatch(this.mBitmap, this.mChunk, location, this.mPaint);
        }
    }

    public void draw(Canvas canvas, Rect location) {
        if (!canvas.isHardwareAccelerated()) {
            NinePatch.nativeDraw(canvas.mNativeCanvas, location, this.mBitmap.ni(), this.mChunk, this.mPaint != null ? this.mPaint.mNativePaint : 0, canvas.mDensity, this.mBitmap.mDensity);
        } else {
            this.mRect.set(location);
            canvas.drawPatch(this.mBitmap, this.mChunk, this.mRect, this.mPaint);
        }
    }

    public void draw(Canvas canvas, Rect location, Paint paint) {
        if (!canvas.isHardwareAccelerated()) {
            NinePatch.nativeDraw(canvas.mNativeCanvas, location, this.mBitmap.ni(), this.mChunk, paint != null ? paint.mNativePaint : 0, canvas.mDensity, this.mBitmap.mDensity);
        } else {
            this.mRect.set(location);
            canvas.drawPatch(this.mBitmap, this.mChunk, this.mRect, paint);
        }
    }

    public int getDensity() {
        return this.mBitmap.mDensity;
    }

    public int getWidth() {
        return this.mBitmap.getWidth();
    }

    public int getHeight() {
        return this.mBitmap.getHeight();
    }

    public boolean hasAlpha() {
        return this.mBitmap.hasAlpha();
    }

    public Region getTransparentRegion(Rect location) {
        int r = NinePatch.nativeGetTransparentRegion(this.mBitmap.ni(), this.mChunk, location);
        return r != 0 ? new Region(r) : null;
    }

    @LayoutlibDelegate
    public static boolean isNinePatchChunk(byte[] byArray) {
        return NinePatch_Delegate.isNinePatchChunk(byArray);
    }

    @LayoutlibDelegate
    private static void validateNinePatchChunk(int n, byte[] byArray) {
        NinePatch_Delegate.validateNinePatchChunk(n, byArray);
    }

    @LayoutlibDelegate
    private static void nativeDraw(int n, RectF rectF, int n2, byte[] byArray, int n3, int n4, int n5) {
        NinePatch_Delegate.nativeDraw(n, rectF, n2, byArray, n3, n4, n5);
    }

    @LayoutlibDelegate
    private static void nativeDraw(int n, Rect rect, int n2, byte[] byArray, int n3, int n4, int n5) {
        NinePatch_Delegate.nativeDraw(n, rect, n2, byArray, n3, n4, n5);
    }

    @LayoutlibDelegate
    private static int nativeGetTransparentRegion(int n, byte[] byArray, Rect rect) {
        return NinePatch_Delegate.nativeGetTransparentRegion(n, byArray, rect);
    }
}

