/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class LayerDrawable
extends Drawable
implements Drawable.Callback {
    LayerState mLayerState;
    private int mOpacityOverride = 0;
    private int[] mPaddingL;
    private int[] mPaddingT;
    private int[] mPaddingR;
    private int[] mPaddingB;
    private final Rect mTmpRect = new Rect();
    private boolean mMutated;

    public LayerDrawable(Drawable[] layers) {
        this(layers, null);
    }

    LayerDrawable(Drawable[] layers, LayerState state) {
        this(state, null);
        int length = layers.length;
        ChildDrawable[] r = new ChildDrawable[length];
        for (int i = 0; i < length; ++i) {
            r[i] = new ChildDrawable();
            r[i].mDrawable = layers[i];
            layers[i].setCallback(this);
            this.mLayerState.mChildrenChangingConfigurations |= layers[i].getChangingConfigurations();
        }
        this.mLayerState.mNum = length;
        this.mLayerState.mChildren = r;
        this.ensurePadding();
    }

    LayerDrawable() {
        this((LayerState)null, null);
    }

    LayerDrawable(LayerState state, Resources res) {
        LayerState as;
        this.mLayerState = as = this.createConstantState(state, res);
        if (as.mNum > 0) {
            this.ensurePadding();
        }
    }

    LayerState createConstantState(LayerState state, Resources res) {
        return new LayerState(state, this, res);
    }

    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        int depth;
        int type;
        super.inflate(r, parser, attrs);
        TypedArray a = r.obtainAttributes(attrs, R.styleable.LayerDrawable);
        this.mOpacityOverride = a.getInt(0, 0);
        a.recycle();
        int innerDepth = parser.getDepth() + 1;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            Drawable dr;
            if (type != 2 || depth > innerDepth || !parser.getName().equals("item")) continue;
            a = r.obtainAttributes(attrs, R.styleable.LayerDrawableItem);
            int left = a.getDimensionPixelOffset(2, 0);
            int top = a.getDimensionPixelOffset(3, 0);
            int right = a.getDimensionPixelOffset(4, 0);
            int bottom = a.getDimensionPixelOffset(5, 0);
            int drawableRes = a.getResourceId(1, 0);
            int id2 = a.getResourceId(0, -1);
            a.recycle();
            if (drawableRes != 0) {
                dr = r.getDrawable(drawableRes);
            } else {
                while ((type = parser.next()) == 4) {
                }
                if (type != 2) {
                    throw new XmlPullParserException(parser.getPositionDescription() + ": <item> tag requires a 'drawable' attribute or " + "child tag defining a drawable");
                }
                dr = Drawable.createFromXmlInner(r, parser, attrs);
            }
            this.addLayer(dr, id2, left, top, right, bottom);
        }
        this.ensurePadding();
        this.onStateChange(this.getState());
    }

    private void addLayer(Drawable layer, int id2, int left, int top, int right, int bottom) {
        ChildDrawable childDrawable;
        LayerState st = this.mLayerState;
        int i = st.mNum;
        int N = st.mChildren != null ? st.mChildren.length : 0;
        if (i >= N) {
            ChildDrawable[] nu = new ChildDrawable[N + 10];
            if (i > 0) {
                System.arraycopy(st.mChildren, 0, nu, 0, i);
            }
            st.mChildren = nu;
        }
        this.mLayerState.mChildrenChangingConfigurations |= layer.getChangingConfigurations();
        st.mChildren[i] = childDrawable = new ChildDrawable();
        childDrawable.mId = id2;
        childDrawable.mDrawable = layer;
        childDrawable.mInsetL = left;
        childDrawable.mInsetT = top;
        childDrawable.mInsetR = right;
        childDrawable.mInsetB = bottom;
        ++st.mNum;
        layer.setCallback(this);
    }

    public Drawable findDrawableByLayerId(int id2) {
        ChildDrawable[] layers = this.mLayerState.mChildren;
        for (int i = this.mLayerState.mNum - 1; i >= 0; --i) {
            if (layers[i].mId != id2) continue;
            return layers[i].mDrawable;
        }
        return null;
    }

    public void setId(int index, int id2) {
        this.mLayerState.mChildren[index].mId = id2;
    }

    public int getNumberOfLayers() {
        return this.mLayerState.mNum;
    }

    public Drawable getDrawable(int index) {
        return this.mLayerState.mChildren[index].mDrawable;
    }

    public int getId(int index) {
        return this.mLayerState.mChildren[index].mId;
    }

    public boolean setDrawableByLayerId(int id2, Drawable drawable2) {
        ChildDrawable[] layers = this.mLayerState.mChildren;
        for (int i = this.mLayerState.mNum - 1; i >= 0; --i) {
            if (layers[i].mId != id2) continue;
            if (layers[i].mDrawable != null) {
                if (drawable2 != null) {
                    Rect bounds = layers[i].mDrawable.getBounds();
                    drawable2.setBounds(bounds);
                }
                layers[i].mDrawable.setCallback(null);
            }
            if (drawable2 != null) {
                drawable2.setCallback(this);
            }
            layers[i].mDrawable = drawable2;
            return true;
        }
        return false;
    }

    public void setLayerInset(int index, int l, int t, int r, int b) {
        ChildDrawable childDrawable = this.mLayerState.mChildren[index];
        childDrawable.mInsetL = l;
        childDrawable.mInsetT = t;
        childDrawable.mInsetR = r;
        childDrawable.mInsetB = b;
    }

    public void invalidateDrawable(Drawable who) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable(this);
        }
    }

    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.scheduleDrawable(this, what, when);
        }
    }

    public void unscheduleDrawable(Drawable who, Runnable what) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.unscheduleDrawable(this, what);
        }
    }

    public void draw(Canvas canvas) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            array2[i].mDrawable.draw(canvas);
        }
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mLayerState.mChangingConfigurations | this.mLayerState.mChildrenChangingConfigurations;
    }

    public boolean getPadding(Rect padding) {
        padding.left = 0;
        padding.top = 0;
        padding.right = 0;
        padding.bottom = 0;
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            this.reapplyPadding(i, array2[i]);
            padding.left += this.mPaddingL[i];
            padding.top += this.mPaddingT[i];
            padding.right += this.mPaddingR[i];
            padding.bottom += this.mPaddingB[i];
        }
        return true;
    }

    public boolean setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            array2[i].mDrawable.setVisible(visible, restart);
        }
        return changed;
    }

    public void setDither(boolean dither) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            array2[i].mDrawable.setDither(dither);
        }
    }

    public void setAlpha(int alpha) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            array2[i].mDrawable.setAlpha(alpha);
        }
    }

    public void setColorFilter(ColorFilter cf) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        for (int i = 0; i < N; ++i) {
            array2[i].mDrawable.setColorFilter(cf);
        }
    }

    public void setOpacity(int opacity) {
        this.mOpacityOverride = opacity;
    }

    public int getOpacity() {
        if (this.mOpacityOverride != 0) {
            return this.mOpacityOverride;
        }
        return this.mLayerState.getOpacity();
    }

    public boolean isStateful() {
        return this.mLayerState.isStateful();
    }

    protected boolean onStateChange(int[] state) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        boolean paddingChanged = false;
        boolean changed = false;
        for (int i = 0; i < N; ++i) {
            ChildDrawable r = array2[i];
            if (r.mDrawable.setState(state)) {
                changed = true;
            }
            if (!this.reapplyPadding(i, r)) continue;
            paddingChanged = true;
        }
        if (paddingChanged) {
            this.onBoundsChange(this.getBounds());
        }
        return changed;
    }

    protected boolean onLevelChange(int level) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        boolean paddingChanged = false;
        boolean changed = false;
        for (int i = 0; i < N; ++i) {
            ChildDrawable r = array2[i];
            if (r.mDrawable.setLevel(level)) {
                changed = true;
            }
            if (!this.reapplyPadding(i, r)) continue;
            paddingChanged = true;
        }
        if (paddingChanged) {
            this.onBoundsChange(this.getBounds());
        }
        return changed;
    }

    protected void onBoundsChange(Rect bounds) {
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        int padL = 0;
        int padT = 0;
        int padR = 0;
        int padB = 0;
        for (int i = 0; i < N; ++i) {
            ChildDrawable r = array2[i];
            r.mDrawable.setBounds(bounds.left + r.mInsetL + padL, bounds.top + r.mInsetT + padT, bounds.right - r.mInsetR - padR, bounds.bottom - r.mInsetB - padB);
            padL += this.mPaddingL[i];
            padR += this.mPaddingR[i];
            padT += this.mPaddingT[i];
            padB += this.mPaddingB[i];
        }
    }

    public int getIntrinsicWidth() {
        int width = -1;
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        int padL = 0;
        int padR = 0;
        for (int i = 0; i < N; ++i) {
            ChildDrawable r = array2[i];
            int w = r.mDrawable.getIntrinsicWidth() + r.mInsetL + r.mInsetR + padL + padR;
            if (w > width) {
                width = w;
            }
            padL += this.mPaddingL[i];
            padR += this.mPaddingR[i];
        }
        return width;
    }

    public int getIntrinsicHeight() {
        int height = -1;
        ChildDrawable[] array2 = this.mLayerState.mChildren;
        int N = this.mLayerState.mNum;
        int padT = 0;
        int padB = 0;
        for (int i = 0; i < N; ++i) {
            ChildDrawable r = array2[i];
            int h = r.mDrawable.getIntrinsicHeight() + r.mInsetT + r.mInsetB + padT + padB;
            if (h > height) {
                height = h;
            }
            padT += this.mPaddingT[i];
            padB += this.mPaddingB[i];
        }
        return height;
    }

    private boolean reapplyPadding(int i, ChildDrawable r) {
        Rect rect = this.mTmpRect;
        r.mDrawable.getPadding(rect);
        if (rect.left != this.mPaddingL[i] || rect.top != this.mPaddingT[i] || rect.right != this.mPaddingR[i] || rect.bottom != this.mPaddingB[i]) {
            this.mPaddingL[i] = rect.left;
            this.mPaddingT[i] = rect.top;
            this.mPaddingR[i] = rect.right;
            this.mPaddingB[i] = rect.bottom;
            return true;
        }
        return false;
    }

    private void ensurePadding() {
        int N = this.mLayerState.mNum;
        if (this.mPaddingL != null && this.mPaddingL.length >= N) {
            return;
        }
        this.mPaddingL = new int[N];
        this.mPaddingT = new int[N];
        this.mPaddingR = new int[N];
        this.mPaddingB = new int[N];
    }

    public Drawable.ConstantState getConstantState() {
        if (this.mLayerState.canConstantState()) {
            this.mLayerState.mChangingConfigurations = this.getChangingConfigurations();
            return this.mLayerState;
        }
        return null;
    }

    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            ChildDrawable[] array2 = this.mLayerState.mChildren;
            int N = this.mLayerState.mNum;
            for (int i = 0; i < N; ++i) {
                array2[i].mDrawable.mutate();
            }
            this.mMutated = true;
        }
        return this;
    }

    static class LayerState
    extends Drawable.ConstantState {
        int mNum;
        ChildDrawable[] mChildren;
        int mChangingConfigurations;
        int mChildrenChangingConfigurations;
        private boolean mHaveOpacity = false;
        private int mOpacity;
        private boolean mHaveStateful = false;
        private boolean mStateful;
        private boolean mCheckedConstantState;
        private boolean mCanConstantState;

        LayerState(LayerState orig, LayerDrawable owner, Resources res) {
            if (orig != null) {
                int N;
                ChildDrawable[] origChildDrawable = orig.mChildren;
                this.mNum = N = orig.mNum;
                this.mChildren = new ChildDrawable[N];
                this.mChangingConfigurations = orig.mChangingConfigurations;
                this.mChildrenChangingConfigurations = orig.mChildrenChangingConfigurations;
                for (int i = 0; i < N; ++i) {
                    ChildDrawable r = this.mChildren[i] = new ChildDrawable();
                    ChildDrawable or = origChildDrawable[i];
                    r.mDrawable = res != null ? or.mDrawable.getConstantState().newDrawable(res) : or.mDrawable.getConstantState().newDrawable();
                    r.mDrawable.setCallback(owner);
                    r.mInsetL = or.mInsetL;
                    r.mInsetT = or.mInsetT;
                    r.mInsetR = or.mInsetR;
                    r.mInsetB = or.mInsetB;
                    r.mId = or.mId;
                }
                this.mHaveOpacity = orig.mHaveOpacity;
                this.mOpacity = orig.mOpacity;
                this.mHaveStateful = orig.mHaveStateful;
                this.mStateful = orig.mStateful;
                this.mCanConstantState = true;
                this.mCheckedConstantState = true;
            } else {
                this.mNum = 0;
                this.mChildren = null;
            }
        }

        public Drawable newDrawable() {
            return new LayerDrawable(this, null);
        }

        public Drawable newDrawable(Resources res) {
            return new LayerDrawable(this, res);
        }

        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        public int getOpacity() {
            if (this.mHaveOpacity) {
                return this.mOpacity;
            }
            int N = this.mNum;
            int op = N > 0 ? this.mChildren[0].mDrawable.getOpacity() : -2;
            for (int i = 1; i < N; ++i) {
                op = Drawable.resolveOpacity(op, this.mChildren[i].mDrawable.getOpacity());
            }
            this.mOpacity = op;
            this.mHaveOpacity = true;
            return op;
        }

        public boolean isStateful() {
            if (this.mHaveStateful) {
                return this.mStateful;
            }
            boolean stateful = false;
            int N = this.mNum;
            for (int i = 0; i < N; ++i) {
                if (!this.mChildren[i].mDrawable.isStateful()) continue;
                stateful = true;
                break;
            }
            this.mStateful = stateful;
            this.mHaveStateful = true;
            return stateful;
        }

        public synchronized boolean canConstantState() {
            if (!this.mCheckedConstantState && this.mChildren != null) {
                this.mCanConstantState = true;
                int N = this.mNum;
                for (int i = 0; i < N; ++i) {
                    if (this.mChildren[i].mDrawable.getConstantState() != null) continue;
                    this.mCanConstantState = false;
                    break;
                }
                this.mCheckedConstantState = true;
            }
            return this.mCanConstantState;
        }
    }

    static class ChildDrawable {
        public Drawable mDrawable;
        public int mInsetL;
        public int mInsetT;
        public int mInsetR;
        public int mInsetB;
        public int mId;

        ChildDrawable() {
        }
    }
}

