/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.ActivityManagerNative;
import android.app.KeyguardManager;
import android.app.PendingIntent;
import android.bluetooth.BluetoothA2dp;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.media.AudioManager;
import android.media.AudioSystem;
import android.media.IAudioFocusDispatcher;
import android.media.IAudioService;
import android.media.IRemoteControlClient;
import android.media.IRemoteControlDisplay;
import android.media.MediaPlayer;
import android.media.SoundPool;
import android.os.Binder;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.provider.Settings;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.view.KeyEvent;
import android.view.VolumePanel;
import com.android.internal.telephony.ITelephony;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;

public class AudioService
extends IAudioService.Stub {
    private static final String TAG = "AudioService";
    protected static final boolean DEBUG_RC = false;
    private static final int PERSIST_DELAY = 3000;
    private Context mContext;
    private ContentResolver mContentResolver;
    private boolean mVoiceCapable;
    private VolumePanel mVolumePanel;
    private static final int SHARED_MSG = -1;
    private static final int SENDMSG_REPLACE = 0;
    private static final int SENDMSG_NOOP = 1;
    private static final int SENDMSG_QUEUE = 2;
    private static final int MSG_SET_SYSTEM_VOLUME = 0;
    private static final int MSG_PERSIST_VOLUME = 1;
    private static final int MSG_PERSIST_RINGER_MODE = 3;
    private static final int MSG_PERSIST_VIBRATE_SETTING = 4;
    private static final int MSG_MEDIA_SERVER_DIED = 5;
    private static final int MSG_MEDIA_SERVER_STARTED = 6;
    private static final int MSG_PLAY_SOUND_EFFECT = 7;
    private static final int MSG_BTA2DP_DOCK_TIMEOUT = 8;
    private static final int MSG_LOAD_SOUND_EFFECTS = 9;
    private static final int MSG_SET_FORCE_USE = 10;
    private static final int MSG_PERSIST_MEDIABUTTONRECEIVER = 11;
    private static final int MSG_BT_HEADSET_CNCT_FAILED = 12;
    private static final int MSG_RCDISPLAY_CLEAR = 13;
    private static final int MSG_RCDISPLAY_UPDATE = 14;
    private static final int BTA2DP_DOCK_TIMEOUT_MILLIS = 8000;
    private static final int BT_HEADSET_CNCT_TIMEOUT_MS = 3000;
    private AudioSystemThread mAudioSystemThread;
    private AudioHandler mAudioHandler;
    private VolumeStreamState[] mStreamStates;
    private SettingsObserver mSettingsObserver;
    private int mMode;
    private Object mSettingsLock = new Object();
    private boolean mMediaServerOk;
    private SoundPool mSoundPool;
    private Object mSoundEffectsLock = new Object();
    private static final int NUM_SOUNDPOOL_CHANNELS = 4;
    private static final int SOUND_EFFECT_VOLUME = 1000;
    private static final String SOUND_EFFECTS_PATH = "/media/audio/ui/";
    private static final String[] SOUND_EFFECT_FILES = new String[]{"Effect_Tick.ogg", "KeypressStandard.ogg", "KeypressSpacebar.ogg", "KeypressDelete.ogg", "KeypressReturn.ogg"};
    private int[][] SOUND_EFFECT_FILES_MAP = new int[][]{{0, -1}, {0, -1}, {0, -1}, {0, -1}, {0, -1}, {1, -1}, {2, -1}, {3, -1}, {4, -1}};
    private int[] MAX_STREAM_VOLUME = new int[]{5, 7, 7, 15, 7, 7, 15, 7, 15, 15};
    private int[] STREAM_VOLUME_ALIAS = new int[]{0, 1, 2, 3, 4, 2, 6, 1, 0, 3};
    private AudioSystem.ErrorCallback mAudioSystemCallback = new AudioSystem.ErrorCallback(){

        public void onError(int error) {
            switch (error) {
                case 100: {
                    if (!AudioService.this.mMediaServerOk) break;
                    AudioService.sendMsg(AudioService.this.mAudioHandler, 5, -1, 1, 0, 0, null, 1500);
                    AudioService.this.mMediaServerOk = false;
                    break;
                }
                case 0: {
                    if (AudioService.this.mMediaServerOk) break;
                    AudioService.sendMsg(AudioService.this.mAudioHandler, 6, -1, 1, 0, 0, null, 0);
                    AudioService.this.mMediaServerOk = true;
                    break;
                }
            }
        }
    };
    private int mRingerMode;
    private int mRingerModeAffectedStreams;
    private int mRingerModeMutedStreams;
    private int mMuteAffectedStreams;
    private int mVibrateSetting;
    private final BroadcastReceiver mReceiver = new AudioServiceBroadcastReceiver();
    private final BroadcastReceiver mMediaButtonReceiver = new MediaButtonBroadcastReceiver();
    private boolean mIsRinging = false;
    private HashMap<Integer, String> mConnectedDevices = new HashMap();
    private int mForcedUseForComm;
    private ArrayList<SetModeDeathHandler> mSetModeDeathHandlers = new ArrayList();
    private ArrayList<ScoClient> mScoClients = new ArrayList();
    private BluetoothHeadset mBluetoothHeadset;
    private BluetoothDevice mBluetoothHeadsetDevice;
    private int mScoAudioState;
    private static final int SCO_STATE_INACTIVE = 0;
    private static final int SCO_STATE_ACTIVATE_REQ = 1;
    private static final int SCO_STATE_ACTIVE_INTERNAL = 3;
    private static final int SCO_STATE_DEACTIVATE_REQ = 5;
    private static final int SCO_STATE_ACTIVE_EXTERNAL = 2;
    private static final int SCO_STATE_DEACTIVATE_EXT_REQ = 4;
    private int mScoConnectionState;
    private boolean mBootCompleted;
    private SoundPoolCallback mSoundPoolCallBack;
    private SoundPoolListenerThread mSoundPoolListenerThread;
    private Looper mSoundPoolLooper = null;
    private static final int SOUND_EFFECT_DEFAULT_VOLUME_DB = -20;
    private int SOUND_EFFECT_VOLUME_DB;
    private static final int NOTIFICATION_VOLUME_DELAY_MS = 5000;
    private int mPrevVolDirection = 0;
    private KeyguardManager mKeyguardManager;
    private BluetoothProfile.ServiceListener mBluetoothProfileServiceListener = new BluetoothProfile.ServiceListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(int profile, BluetoothProfile proxy) {
            switch (profile) {
                case 2: {
                    BluetoothA2dp a2dp = (BluetoothA2dp)proxy;
                    List<BluetoothDevice> deviceList = a2dp.getConnectedDevices();
                    if (deviceList.size() <= 0) break;
                    BluetoothDevice btDevice = deviceList.get(0);
                    AudioService.this.handleA2dpConnectionStateChange(btDevice, a2dp.getConnectionState(btDevice));
                    break;
                }
                case 1: {
                    ArrayList arrayList = AudioService.this.mScoClients;
                    synchronized (arrayList) {
                        AudioService.this.mAudioHandler.removeMessages(12);
                        AudioService.this.mBluetoothHeadset = (BluetoothHeadset)proxy;
                        List<BluetoothDevice> deviceList = AudioService.this.mBluetoothHeadset.getConnectedDevices();
                        if (deviceList.size() > 0) {
                            AudioService.this.mBluetoothHeadsetDevice = deviceList.get(0);
                        } else {
                            AudioService.this.mBluetoothHeadsetDevice = null;
                        }
                        AudioService.this.checkScoAudioState();
                        if (AudioService.this.mScoAudioState == 1 || AudioService.this.mScoAudioState == 5 || AudioService.this.mScoAudioState == 4) {
                            boolean status = false;
                            if (AudioService.this.mBluetoothHeadsetDevice != null) {
                                switch (AudioService.this.mScoAudioState) {
                                    case 1: {
                                        AudioService.this.mScoAudioState = 3;
                                        status = AudioService.this.mBluetoothHeadset.startScoUsingVirtualVoiceCall(AudioService.this.mBluetoothHeadsetDevice);
                                        break;
                                    }
                                    case 5: {
                                        status = AudioService.this.mBluetoothHeadset.stopScoUsingVirtualVoiceCall(AudioService.this.mBluetoothHeadsetDevice);
                                        break;
                                    }
                                    case 4: {
                                        status = AudioService.this.mBluetoothHeadset.stopVoiceRecognition(AudioService.this.mBluetoothHeadsetDevice);
                                    }
                                }
                            }
                            if (!status) {
                                AudioService.sendMsg(AudioService.this.mAudioHandler, 12, 0, 0, 0, 0, null, 0);
                            }
                        }
                        break;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceDisconnected(int profile) {
            switch (profile) {
                case 2: {
                    HashMap hashMap = AudioService.this.mConnectedDevices;
                    synchronized (hashMap) {
                        if (AudioService.this.mConnectedDevices.containsKey(128)) {
                            AudioService.this.makeA2dpDeviceUnavailableNow((String)AudioService.this.mConnectedDevices.get(128));
                        }
                        break;
                    }
                }
                case 1: {
                    ArrayList arrayList = AudioService.this.mScoClients;
                    synchronized (arrayList) {
                        AudioService.this.mBluetoothHeadset = null;
                        break;
                    }
                }
            }
        }
    };
    private String mDockAddress;
    private static final String IN_VOICE_COMM_FOCUS_ID = "AudioFocus_For_Phone_Ring_And_Calls";
    private static final Object mAudioFocusLock = new Object();
    private static final Object mRingingLock = new Object();
    private PhoneStateListener mPhoneStateListener = new PhoneStateListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCallStateChanged(int state, String incomingNumber) {
            if (state == 1) {
                Object object = mRingingLock;
                synchronized (object) {
                    AudioService.this.mIsRinging = true;
                }
            }
            if (state == 2 || state == 0) {
                Object object = mRingingLock;
                synchronized (object) {
                    AudioService.this.mIsRinging = false;
                }
            }
        }
    };
    private Stack<FocusStackEntry> mFocusStack = new Stack();
    private final Object mCurrentRcLock = new Object();
    private IRemoteControlClient mCurrentRcClient = null;
    private static final int RC_INFO_NONE = 0;
    private static final int RC_INFO_ALL = 15;
    private int mCurrentRcClientGen = 0;
    private Stack<RemoteControlStackEntry> mRCStack = new Stack();
    private IRemoteControlDisplay mRcDisplay;
    private RcDisplayDeathHandler mRcDisplayDeathHandler;
    private int mArtworkExpectedWidth = -1;
    private int mArtworkExpectedHeight = -1;

    public AudioService(Context context) {
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
        this.mVoiceCapable = this.mContext.getResources().getBoolean(17891363);
        this.MAX_STREAM_VOLUME[0] = SystemProperties.getInt("ro.config.vc_call_vol_steps", this.MAX_STREAM_VOLUME[0]);
        this.SOUND_EFFECT_VOLUME_DB = SystemProperties.getInt("ro.config.sound_fx_volume", -20);
        this.mVolumePanel = new VolumePanel(context, this);
        this.mForcedUseForComm = 0;
        this.createAudioSystemThread();
        this.readPersistedSettings();
        this.mSettingsObserver = new SettingsObserver();
        this.createStreamStates();
        this.mMode = 0;
        this.mMediaServerOk = true;
        this.mRingerModeMutedStreams = 0;
        this.setRingerModeInt(this.getRingerMode(), false);
        AudioSystem.setErrorCallback(this.mAudioSystemCallback);
        IntentFilter intentFilter = new IntentFilter("android.intent.action.HEADSET_PLUG");
        intentFilter.addAction("android.bluetooth.a2dp.profile.action.CONNECTION_STATE_CHANGED");
        intentFilter.addAction("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED");
        intentFilter.addAction("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
        intentFilter.addAction("android.intent.action.DOCK_EVENT");
        intentFilter.addAction("android.intent.action.USB_ANLG_HEADSET_PLUG");
        intentFilter.addAction("android.intent.action.USB_DGTL_HEADSET_PLUG");
        intentFilter.addAction("android.intent.action.HDMI_AUDIO_PLUG");
        intentFilter.addAction("android.intent.action.BOOT_COMPLETED");
        intentFilter.addAction("android.intent.action.SCREEN_ON");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        context.registerReceiver(this.mReceiver, intentFilter);
        IntentFilter pkgFilter = new IntentFilter();
        pkgFilter.addAction("android.intent.action.PACKAGE_REMOVED");
        pkgFilter.addDataScheme("package");
        context.registerReceiver(this.mReceiver, pkgFilter);
        intentFilter = new IntentFilter("android.intent.action.MEDIA_BUTTON");
        intentFilter.setPriority(Integer.MAX_VALUE);
        context.registerReceiver(this.mMediaButtonReceiver, intentFilter);
        TelephonyManager tmgr = (TelephonyManager)context.getSystemService("phone");
        tmgr.listen(this.mPhoneStateListener, 32);
    }

    private void createAudioSystemThread() {
        this.mAudioSystemThread = new AudioSystemThread();
        this.mAudioSystemThread.start();
        this.waitForAudioHandlerCreation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForAudioHandlerCreation() {
        AudioService audioService = this;
        synchronized (audioService) {
            while (this.mAudioHandler == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Log.e(TAG, "Interrupted while waiting on volume handler.");
                }
            }
        }
    }

    private void createStreamStates() {
        int i;
        int numStreamTypes = AudioSystem.getNumStreamTypes();
        this.mStreamStates = new VolumeStreamState[numStreamTypes];
        VolumeStreamState[] streams = this.mStreamStates;
        for (i = 0; i < numStreamTypes; ++i) {
            streams[i] = new VolumeStreamState(Settings.System.VOLUME_SETTINGS[this.STREAM_VOLUME_ALIAS[i]], i);
        }
        for (i = 0; i < numStreamTypes; ++i) {
            if (this.STREAM_VOLUME_ALIAS[i] == i) continue;
            int index = this.rescaleIndex(streams[i].mIndex, this.STREAM_VOLUME_ALIAS[i], i);
            streams[i].mIndex = streams[i].getValidIndex(index);
            this.setStreamVolumeIndex(i, index);
            index = this.rescaleIndex(streams[i].mLastAudibleIndex, this.STREAM_VOLUME_ALIAS[i], i);
            streams[i].mLastAudibleIndex = streams[i].getValidIndex(index);
        }
    }

    private void readPersistedSettings() {
        ContentResolver cr = this.mContentResolver;
        this.mRingerMode = Settings.System.getInt(cr, "mode_ringer", 2);
        if (!AudioManager.isValidRingerMode(this.mRingerMode)) {
            this.mRingerMode = 2;
            Settings.System.putInt(cr, "mode_ringer", this.mRingerMode);
        }
        this.mVibrateSetting = Settings.System.getInt(cr, "vibrate_on", 0);
        this.mRingerModeAffectedStreams = Settings.System.getInt(cr, "mode_ringer_streams_affected", 166);
        this.mRingerModeAffectedStreams = this.mVoiceCapable ? (this.mRingerModeAffectedStreams &= 0xFFFFFFF7) : (this.mRingerModeAffectedStreams |= 8);
        Settings.System.putInt(cr, "mode_ringer_streams_affected", this.mRingerModeAffectedStreams);
        this.mMuteAffectedStreams = Settings.System.getInt(cr, "mute_streams_affected", 14);
        this.broadcastRingerMode();
        this.broadcastVibrateSetting(0);
        this.broadcastVibrateSetting(1);
        this.restoreMediaButtonReceiver();
    }

    private void setStreamVolumeIndex(int stream, int index) {
        AudioSystem.setStreamVolumeIndex(stream, (index + 5) / 10);
    }

    private int rescaleIndex(int index, int srcStream, int dstStream) {
        return (index * this.mStreamStates[dstStream].getMaxIndex() + this.mStreamStates[srcStream].getMaxIndex() / 2) / this.mStreamStates[srcStream].getMaxIndex();
    }

    public void adjustVolume(int direction, int flags) {
        this.adjustSuggestedStreamVolume(direction, Integer.MIN_VALUE, flags);
    }

    public void adjustSuggestedStreamVolume(int direction, int suggestedStreamType, int flags) {
        int streamType = (flags & 0x20) != 0 ? suggestedStreamType : this.getActiveStreamType(suggestedStreamType);
        if ((flags & 4) != 0 && (this.STREAM_VOLUME_ALIAS[streamType] != 2 || this.mKeyguardManager != null && this.mKeyguardManager.isKeyguardLocked())) {
            flags &= 0xFFFFFFFB;
        }
        this.adjustStreamVolume(streamType, direction, flags);
    }

    public void adjustStreamVolume(int streamType, int direction, int flags) {
        int index;
        this.ensureValidDirection(direction);
        this.ensureValidStreamType(streamType);
        int streamTypeAlias = this.STREAM_VOLUME_ALIAS[streamType];
        VolumeStreamState streamState = this.mStreamStates[streamTypeAlias];
        int oldIndex = streamState.muteCount() != 0 ? streamState.mLastAudibleIndex : streamState.mIndex;
        boolean adjustVolume = true;
        if ((flags & 2) != 0 || streamTypeAlias == 2 || !this.mVoiceCapable && streamTypeAlias == 3) {
            if (this.mRingerMode == 1) {
                flags &= 0xFFFFFFEF;
            }
            adjustVolume = this.checkForRingerModeChange(oldIndex, direction, streamTypeAlias);
        }
        if (streamState.muteCount() != 0) {
            if (adjustVolume) {
                int numStreamTypes = AudioSystem.getNumStreamTypes();
                for (int i = numStreamTypes - 1; i >= 0; --i) {
                    if (this.STREAM_VOLUME_ALIAS[i] != streamTypeAlias) continue;
                    VolumeStreamState s = this.mStreamStates[i];
                    s.adjustLastAudibleIndex(direction);
                    AudioService.sendMsg(this.mAudioHandler, 1, i, 0, 0, 1, s, 3000);
                }
            }
            index = streamState.mLastAudibleIndex;
        } else {
            if (adjustVolume && streamState.adjustIndex(direction)) {
                AudioService.sendMsg(this.mAudioHandler, 0, streamTypeAlias, 1, 0, 0, streamState, 0);
            }
            index = streamState.mIndex;
        }
        this.sendVolumeUpdate(streamType, oldIndex, index, flags);
    }

    public void setStreamVolume(int streamType, int index, int flags) {
        int oldIndex;
        this.ensureValidStreamType(streamType);
        VolumeStreamState streamState = this.mStreamStates[this.STREAM_VOLUME_ALIAS[streamType]];
        int n = oldIndex = streamState.muteCount() != 0 ? streamState.mLastAudibleIndex : streamState.mIndex;
        if (this.mVoiceCapable && ((flags & 2) != 0 || this.STREAM_VOLUME_ALIAS[streamType] == 2)) {
            int newRingerMode = this.mRingerMode;
            if (index == 0) {
                newRingerMode = Settings.System.getInt(this.mContentResolver, "vibrate_in_silent", 1) == 1 ? 1 : 0;
                this.setStreamVolumeInt(this.STREAM_VOLUME_ALIAS[streamType], index, false, true);
            } else {
                newRingerMode = 2;
            }
            if (newRingerMode != this.mRingerMode) {
                this.setRingerMode(newRingerMode);
            }
        }
        index = this.rescaleIndex(index * 10, streamType, this.STREAM_VOLUME_ALIAS[streamType]);
        this.setStreamVolumeInt(this.STREAM_VOLUME_ALIAS[streamType], index, false, true);
        index = streamState.muteCount() != 0 ? streamState.mLastAudibleIndex : streamState.mIndex;
        this.sendVolumeUpdate(streamType, oldIndex, index, flags);
    }

    private void sendVolumeUpdate(int streamType, int oldIndex, int index, int flags) {
        if (!this.mVoiceCapable && streamType == 2) {
            streamType = 5;
        }
        this.mVolumePanel.postVolumeChanged(streamType, flags);
        oldIndex = (oldIndex + 5) / 10;
        index = (index + 5) / 10;
        Intent intent = new Intent("android.media.VOLUME_CHANGED_ACTION");
        intent.putExtra("android.media.EXTRA_VOLUME_STREAM_TYPE", streamType);
        intent.putExtra("android.media.EXTRA_VOLUME_STREAM_VALUE", index);
        intent.putExtra("android.media.EXTRA_PREV_VOLUME_STREAM_VALUE", oldIndex);
        this.mContext.sendBroadcast(intent);
    }

    private void setStreamVolumeInt(int streamType, int index, boolean force, boolean lastAudible) {
        VolumeStreamState streamState = this.mStreamStates[streamType];
        if (streamState.muteCount() != 0) {
            if (index != 0) {
                streamState.setLastAudibleIndex(index);
                AudioService.sendMsg(this.mAudioHandler, 1, streamType, 0, 0, 1, streamState, 3000);
            }
        } else if (streamState.setIndex(index, lastAudible) || force) {
            AudioService.sendMsg(this.mAudioHandler, 0, streamType, 1, 0, 0, streamState, 0);
        }
    }

    public void setStreamSolo(int streamType, boolean state, IBinder cb) {
        for (int stream = 0; stream < this.mStreamStates.length; ++stream) {
            if (!this.isStreamAffectedByMute(stream) || stream == streamType) continue;
            this.mStreamStates[stream].mute(cb, state);
        }
    }

    public void setStreamMute(int streamType, boolean state, IBinder cb) {
        if (this.isStreamAffectedByMute(streamType)) {
            this.mStreamStates[streamType].mute(cb, state);
        }
    }

    public boolean isStreamMute(int streamType) {
        return this.mStreamStates[streamType].muteCount() != 0;
    }

    public int getStreamVolume(int streamType) {
        this.ensureValidStreamType(streamType);
        return (this.mStreamStates[streamType].mIndex + 5) / 10;
    }

    public int getStreamMaxVolume(int streamType) {
        this.ensureValidStreamType(streamType);
        return (this.mStreamStates[streamType].getMaxIndex() + 5) / 10;
    }

    public int getLastAudibleStreamVolume(int streamType) {
        this.ensureValidStreamType(streamType);
        return (this.mStreamStates[streamType].mLastAudibleIndex + 5) / 10;
    }

    public int getRingerMode() {
        return this.mRingerMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRingerMode(int ringerMode) {
        Object object = this.mSettingsLock;
        synchronized (object) {
            if (ringerMode != this.mRingerMode) {
                this.setRingerModeInt(ringerMode, true);
                this.broadcastRingerMode();
            }
        }
    }

    private void setRingerModeInt(int ringerMode, boolean persist) {
        this.mRingerMode = ringerMode;
        int numStreamTypes = AudioSystem.getNumStreamTypes();
        for (int streamType = numStreamTypes - 1; streamType >= 0; --streamType) {
            if (this.isStreamMutedByRingerMode(streamType)) {
                if (this.isStreamAffectedByRingerMode(streamType) && this.mRingerMode != 2) continue;
                if (this.mVoiceCapable && this.STREAM_VOLUME_ALIAS[streamType] == 2 && this.mStreamStates[streamType].mLastAudibleIndex == 0) {
                    this.mStreamStates[streamType].mLastAudibleIndex = 10;
                }
                this.mStreamStates[streamType].mute(null, false);
                this.mRingerModeMutedStreams &= ~(1 << streamType);
                continue;
            }
            if (!this.isStreamAffectedByRingerMode(streamType) || this.mRingerMode == 2) continue;
            this.mStreamStates[streamType].mute(null, true);
            this.mRingerModeMutedStreams |= 1 << streamType;
        }
        if (persist) {
            AudioService.sendMsg(this.mAudioHandler, 3, -1, 0, 0, 0, null, 3000);
        }
    }

    public boolean shouldVibrate(int vibrateType) {
        switch (this.getVibrateSetting(vibrateType)) {
            case 1: {
                return this.mRingerMode != 0;
            }
            case 2: {
                return this.mRingerMode == 1;
            }
            case 0: {
                return false;
            }
        }
        return false;
    }

    public int getVibrateSetting(int vibrateType) {
        return this.mVibrateSetting >> vibrateType * 2 & 3;
    }

    public void setVibrateSetting(int vibrateType, int vibrateSetting) {
        this.mVibrateSetting = AudioService.getValueForVibrateSetting(this.mVibrateSetting, vibrateType, vibrateSetting);
        this.broadcastVibrateSetting(vibrateType);
        AudioService.sendMsg(this.mAudioHandler, 4, -1, 1, 0, 0, null, 0);
    }

    public static int getValueForVibrateSetting(int existingValue, int vibrateType, int vibrateSetting) {
        existingValue &= ~(3 << vibrateType * 2);
        return existingValue |= (vibrateSetting & 3) << vibrateType * 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMode(int mode, IBinder cb) {
        if (!this.checkAudioSettingsPermission("setMode()")) {
            return;
        }
        if (mode < -1 || mode >= 4) {
            return;
        }
        int newModeOwnerPid = 0;
        ArrayList<SetModeDeathHandler> arrayList = this.mSetModeDeathHandlers;
        synchronized (arrayList) {
            if (mode == -1) {
                mode = this.mMode;
            }
            newModeOwnerPid = this.setModeInt(mode, cb, Binder.getCallingPid());
        }
        if (newModeOwnerPid != 0) {
            this.disconnectBluetoothSco(newModeOwnerPid);
        }
    }

    int setModeInt(int mode, IBinder cb, int pid) {
        int newModeOwnerPid = 0;
        if (cb == null) {
            Log.e(TAG, "setModeInt() called with null binder");
            return newModeOwnerPid;
        }
        SetModeDeathHandler hdlr = null;
        Iterator<SetModeDeathHandler> iter = this.mSetModeDeathHandlers.iterator();
        while (iter.hasNext()) {
            SetModeDeathHandler h = iter.next();
            if (h.getPid() != pid) continue;
            hdlr = h;
            iter.remove();
            hdlr.getBinder().unlinkToDeath(hdlr, 0);
            break;
        }
        int status = 0;
        do {
            if (mode == 0) {
                if (!this.mSetModeDeathHandlers.isEmpty()) {
                    hdlr = this.mSetModeDeathHandlers.get(0);
                    cb = hdlr.getBinder();
                    mode = hdlr.getMode();
                }
            } else {
                if (hdlr == null) {
                    hdlr = new SetModeDeathHandler(cb, pid);
                }
                try {
                    cb.linkToDeath(hdlr, 0);
                }
                catch (RemoteException e) {
                    Log.w(TAG, "setMode() could not link to " + cb + " binder death");
                }
                this.mSetModeDeathHandlers.add(0, hdlr);
                hdlr.setMode(mode);
            }
            if (mode != this.mMode) {
                status = AudioSystem.setPhoneState(mode);
                if (status == 0) {
                    this.handleFocusForCalls(this.mMode, mode, cb);
                    this.mMode = mode;
                    continue;
                }
                if (hdlr != null) {
                    this.mSetModeDeathHandlers.remove(hdlr);
                    cb.unlinkToDeath(hdlr, 0);
                }
                mode = 0;
                continue;
            }
            status = 0;
        } while (status != 0 && !this.mSetModeDeathHandlers.isEmpty());
        if (status == 0) {
            if (mode != 0) {
                if (this.mSetModeDeathHandlers.isEmpty()) {
                    Log.e(TAG, "setMode() different from MODE_NORMAL with empty mode client stack");
                } else {
                    newModeOwnerPid = this.mSetModeDeathHandlers.get(0).getPid();
                }
            }
            int streamType = this.getActiveStreamType(Integer.MIN_VALUE);
            int index = this.mStreamStates[this.STREAM_VOLUME_ALIAS[streamType]].mIndex;
            this.setStreamVolumeInt(this.STREAM_VOLUME_ALIAS[streamType], index, true, false);
        }
        return newModeOwnerPid;
    }

    private void handleFocusForCalls(int oldMode, int newMode, IBinder cb) {
        if (newMode == 1) {
            int ringVolume = this.getStreamVolume(2);
            if (ringVolume > 0) {
                this.requestAudioFocus(2, 2, cb, null, IN_VOICE_COMM_FOCUS_ID, "system");
            }
        } else if (newMode == 2 || newMode == 3) {
            this.requestAudioFocus(2, 2, cb, null, IN_VOICE_COMM_FOCUS_ID, "system");
        } else if (newMode == 0) {
            this.abandonAudioFocus(null, IN_VOICE_COMM_FOCUS_ID);
        }
    }

    public int getMode() {
        return this.mMode;
    }

    public void playSoundEffect(int effectType) {
        AudioService.sendMsg(this.mAudioHandler, 7, -1, 1, effectType, -1, null, 0);
    }

    public void playSoundEffectVolume(int effectType, float volume) {
        this.loadSoundEffects();
        AudioService.sendMsg(this.mAudioHandler, 7, -1, 1, effectType, (int)(volume * 1000.0f), null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadSoundEffects() {
        int status;
        Object object = this.mSoundEffectsLock;
        synchronized (object) {
            if (!this.mBootCompleted) {
                Log.w(TAG, "loadSoundEffects() called before boot complete");
                return false;
            }
            if (this.mSoundPool != null) {
                return true;
            }
            this.mSoundPool = new SoundPool(4, 1, 0);
            if (this.mSoundPool == null) {
                Log.w(TAG, "loadSoundEffects() could not allocate sound pool");
                return false;
            }
            try {
                this.mSoundPoolCallBack = null;
                this.mSoundPoolListenerThread = new SoundPoolListenerThread();
                this.mSoundPoolListenerThread.start();
                this.mSoundEffectsLock.wait();
            }
            catch (InterruptedException e) {
                Log.w(TAG, "Interrupted while waiting sound pool listener thread.");
            }
            if (this.mSoundPoolCallBack == null) {
                Log.w(TAG, "loadSoundEffects() could not create SoundPool listener or thread");
                if (this.mSoundPoolLooper != null) {
                    this.mSoundPoolLooper.quit();
                    this.mSoundPoolLooper = null;
                }
                this.mSoundPoolListenerThread = null;
                this.mSoundPool.release();
                this.mSoundPool = null;
                return false;
            }
            int[] poolId = new int[SOUND_EFFECT_FILES.length];
            for (int fileIdx = 0; fileIdx < SOUND_EFFECT_FILES.length; ++fileIdx) {
                poolId[fileIdx] = -1;
            }
            int lastSample = 0;
            for (int effect = 0; effect < 9; ++effect) {
                if (this.SOUND_EFFECT_FILES_MAP[effect][1] == 0) continue;
                if (poolId[this.SOUND_EFFECT_FILES_MAP[effect][0]] == -1) {
                    String filePath = Environment.getRootDirectory() + SOUND_EFFECTS_PATH + SOUND_EFFECT_FILES[this.SOUND_EFFECT_FILES_MAP[effect][0]];
                    int sampleId = this.mSoundPool.load(filePath, 0);
                    if (sampleId <= 0) {
                        Log.w(TAG, "Soundpool could not load file: " + filePath);
                        continue;
                    }
                    this.SOUND_EFFECT_FILES_MAP[effect][1] = sampleId;
                    poolId[this.SOUND_EFFECT_FILES_MAP[effect][0]] = sampleId;
                    lastSample = sampleId;
                    continue;
                }
                this.SOUND_EFFECT_FILES_MAP[effect][1] = poolId[this.SOUND_EFFECT_FILES_MAP[effect][0]];
            }
            if (lastSample != 0) {
                this.mSoundPoolCallBack.setLastSample(lastSample);
                try {
                    this.mSoundEffectsLock.wait();
                    status = this.mSoundPoolCallBack.status();
                }
                catch (InterruptedException e) {
                    Log.w(TAG, "Interrupted while waiting sound pool callback.");
                    status = -1;
                }
            } else {
                status = -1;
            }
            if (this.mSoundPoolLooper != null) {
                this.mSoundPoolLooper.quit();
                this.mSoundPoolLooper = null;
            }
            this.mSoundPoolListenerThread = null;
            if (status != 0) {
                Log.w(TAG, "loadSoundEffects(), Error " + (lastSample != 0 ? this.mSoundPoolCallBack.status() : -1) + " while loading samples");
                for (int effect = 0; effect < 9; ++effect) {
                    if (this.SOUND_EFFECT_FILES_MAP[effect][1] <= 0) continue;
                    this.SOUND_EFFECT_FILES_MAP[effect][1] = -1;
                }
                this.mSoundPool.release();
                this.mSoundPool = null;
            }
        }
        return status == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadSoundEffects() {
        Object object = this.mSoundEffectsLock;
        synchronized (object) {
            if (this.mSoundPool == null) {
                return;
            }
            this.mAudioHandler.removeMessages(9);
            this.mAudioHandler.removeMessages(7);
            int[] poolId = new int[SOUND_EFFECT_FILES.length];
            for (int fileIdx = 0; fileIdx < SOUND_EFFECT_FILES.length; ++fileIdx) {
                poolId[fileIdx] = 0;
            }
            for (int effect = 0; effect < 9; ++effect) {
                if (this.SOUND_EFFECT_FILES_MAP[effect][1] <= 0 || poolId[this.SOUND_EFFECT_FILES_MAP[effect][0]] != 0) continue;
                this.mSoundPool.unload(this.SOUND_EFFECT_FILES_MAP[effect][1]);
                this.SOUND_EFFECT_FILES_MAP[effect][1] = -1;
                poolId[this.SOUND_EFFECT_FILES_MAP[effect][0]] = -1;
            }
            this.mSoundPool.release();
            this.mSoundPool = null;
        }
    }

    public void reloadAudioSettings() {
        this.readPersistedSettings();
        int numStreamTypes = AudioSystem.getNumStreamTypes();
        for (int streamType = 0; streamType < numStreamTypes; ++streamType) {
            VolumeStreamState streamState = this.mStreamStates[streamType];
            String settingName = Settings.System.VOLUME_SETTINGS[this.STREAM_VOLUME_ALIAS[streamType]];
            String lastAudibleSettingName = settingName + "_last_audible";
            int index = Settings.System.getInt(this.mContentResolver, settingName, AudioManager.DEFAULT_STREAM_VOLUME[streamType]);
            index = this.STREAM_VOLUME_ALIAS[streamType] != streamType ? this.rescaleIndex(index * 10, this.STREAM_VOLUME_ALIAS[streamType], streamType) : (index *= 10);
            streamState.mIndex = streamState.getValidIndex(index);
            index = (index + 5) / 10;
            index = Settings.System.getInt(this.mContentResolver, lastAudibleSettingName, index > 0 ? index : AudioManager.DEFAULT_STREAM_VOLUME[streamType]);
            index = this.STREAM_VOLUME_ALIAS[streamType] != streamType ? this.rescaleIndex(index * 10, this.STREAM_VOLUME_ALIAS[streamType], streamType) : (index *= 10);
            streamState.mLastAudibleIndex = streamState.getValidIndex(index);
            if (streamState.muteCount() != 0 && !this.isStreamAffectedByMute(streamType)) {
                int size = streamState.mDeathHandlers.size();
                for (int i = 0; i < size; ++i) {
                    ((VolumeStreamState.VolumeDeathHandler)streamState.mDeathHandlers.get(i)).mMuteCount = 1;
                    ((VolumeStreamState.VolumeDeathHandler)streamState.mDeathHandlers.get(i)).mute(false);
                }
            }
            if (streamState.muteCount() != 0) continue;
            this.setStreamVolumeIndex(streamType, streamState.mIndex);
        }
        this.setRingerModeInt(this.getRingerMode(), false);
    }

    public void setSpeakerphoneOn(boolean on) {
        if (!this.checkAudioSettingsPermission("setSpeakerphoneOn()")) {
            return;
        }
        this.mForcedUseForComm = on ? 1 : 0;
        AudioService.sendMsg(this.mAudioHandler, 10, -1, 2, 0, this.mForcedUseForComm, null, 0);
    }

    public boolean isSpeakerphoneOn() {
        return this.mForcedUseForComm == 1;
    }

    public void setBluetoothScoOn(boolean on) {
        if (!this.checkAudioSettingsPermission("setBluetoothScoOn()")) {
            return;
        }
        this.mForcedUseForComm = on ? 3 : 0;
        AudioService.sendMsg(this.mAudioHandler, 10, -1, 2, 0, this.mForcedUseForComm, null, 0);
        AudioService.sendMsg(this.mAudioHandler, 10, -1, 2, 2, this.mForcedUseForComm, null, 0);
    }

    public boolean isBluetoothScoOn() {
        return this.mForcedUseForComm == 3;
    }

    public void startBluetoothSco(IBinder cb) {
        if (!this.checkAudioSettingsPermission("startBluetoothSco()") || !this.mBootCompleted) {
            return;
        }
        ScoClient client = this.getScoClient(cb, true);
        client.incCount();
    }

    public void stopBluetoothSco(IBinder cb) {
        if (!this.checkAudioSettingsPermission("stopBluetoothSco()") || !this.mBootCompleted) {
            return;
        }
        ScoClient client = this.getScoClient(cb, false);
        if (client != null) {
            client.decCount();
        }
    }

    private void checkScoAudioState() {
        if (this.mBluetoothHeadset != null && this.mBluetoothHeadsetDevice != null && this.mScoAudioState == 0 && this.mBluetoothHeadset.getAudioState(this.mBluetoothHeadsetDevice) != 10) {
            this.mScoAudioState = 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScoClient getScoClient(IBinder cb, boolean create) {
        ArrayList<ScoClient> arrayList = this.mScoClients;
        synchronized (arrayList) {
            ScoClient client = null;
            int size = this.mScoClients.size();
            for (int i = 0; i < size; ++i) {
                client = this.mScoClients.get(i);
                if (client.getBinder() != cb) continue;
                return client;
            }
            if (create) {
                client = new ScoClient(cb);
                this.mScoClients.add(client);
            }
            return client;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllScoClients(int exceptPid, boolean stopSco) {
        ArrayList<ScoClient> arrayList = this.mScoClients;
        synchronized (arrayList) {
            ScoClient savedClient = null;
            int size = this.mScoClients.size();
            for (int i = 0; i < size; ++i) {
                ScoClient cl = this.mScoClients.get(i);
                if (cl.getPid() != exceptPid) {
                    cl.clearCount(stopSco);
                    continue;
                }
                savedClient = cl;
            }
            this.mScoClients.clear();
            if (savedClient != null) {
                this.mScoClients.add(savedClient);
            }
        }
    }

    private boolean getBluetoothHeadset() {
        boolean result = false;
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null) {
            result = adapter.getProfileProxy(this.mContext, this.mBluetoothProfileServiceListener, 1);
        }
        AudioService.sendMsg(this.mAudioHandler, 12, 0, 0, 0, 0, null, result ? 3000 : 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectBluetoothSco(int exceptPid) {
        ArrayList<ScoClient> arrayList = this.mScoClients;
        synchronized (arrayList) {
            this.checkScoAudioState();
            if (this.mScoAudioState == 2 || this.mScoAudioState == 4) {
                if (this.mBluetoothHeadsetDevice != null) {
                    if (this.mBluetoothHeadset != null) {
                        if (!this.mBluetoothHeadset.stopVoiceRecognition(this.mBluetoothHeadsetDevice)) {
                            AudioService.sendMsg(this.mAudioHandler, 12, 0, 0, 0, 0, null, 0);
                        }
                    } else if (this.mScoAudioState == 2 && this.getBluetoothHeadset()) {
                        this.mScoAudioState = 4;
                    }
                }
            } else {
                this.clearAllScoClients(exceptPid, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetBluetoothSco() {
        ArrayList<ScoClient> arrayList = this.mScoClients;
        synchronized (arrayList) {
            this.clearAllScoClients(0, false);
            this.mScoAudioState = 0;
            this.broadcastScoConnectionState(0);
        }
    }

    private void broadcastScoConnectionState(int state) {
        if (state != this.mScoConnectionState) {
            Intent newIntent = new Intent("android.media.ACTION_SCO_AUDIO_STATE_UPDATED");
            newIntent.putExtra("android.media.extra.SCO_AUDIO_STATE", state);
            newIntent.putExtra("android.media.extra.SCO_AUDIO_PREVIOUS_STATE", this.mScoConnectionState);
            this.mContext.sendStickyBroadcast(newIntent);
            this.mScoConnectionState = state;
        }
    }

    private boolean checkForRingerModeChange(int oldIndex, int direction, int streamType) {
        boolean vibeInSilent;
        boolean adjustVolumeIndex = true;
        int newRingerMode = this.mRingerMode;
        int uiIndex = (oldIndex + 5) / 10;
        boolean bl = vibeInSilent = Settings.System.getInt(this.mContentResolver, "vibrate_in_silent", 1) == 1;
        if (this.mRingerMode == 2) {
            if (direction == -1 && uiIndex <= 1) {
                if (vibeInSilent || this.mPrevVolDirection != -1) {
                    int n = newRingerMode = vibeInSilent ? 1 : 0;
                }
                if (uiIndex == 0 || !vibeInSilent && this.mPrevVolDirection == -1 && this.mVoiceCapable && streamType == 2) {
                    adjustVolumeIndex = false;
                }
            }
        } else if (this.mRingerMode == 1) {
            if (direction == -1) {
                if (this.mPrevVolDirection != -1) {
                    newRingerMode = 0;
                }
            } else if (direction == 1) {
                newRingerMode = 2;
            }
            adjustVolumeIndex = false;
        } else {
            if (direction == 1) {
                newRingerMode = vibeInSilent ? 1 : 2;
            }
            adjustVolumeIndex = false;
        }
        if (newRingerMode != this.mRingerMode) {
            this.setRingerMode(newRingerMode);
        }
        this.mPrevVolDirection = direction;
        return adjustVolumeIndex;
    }

    public boolean isStreamAffectedByRingerMode(int streamType) {
        return (this.mRingerModeAffectedStreams & 1 << streamType) != 0;
    }

    private boolean isStreamMutedByRingerMode(int streamType) {
        return (this.mRingerModeMutedStreams & 1 << streamType) != 0;
    }

    public boolean isStreamAffectedByMute(int streamType) {
        return (this.mMuteAffectedStreams & 1 << streamType) != 0;
    }

    private void ensureValidDirection(int direction) {
        if (direction < -1 || direction > 1) {
            throw new IllegalArgumentException("Bad direction " + direction);
        }
    }

    private void ensureValidStreamType(int streamType) {
        if (streamType < 0 || streamType >= this.mStreamStates.length) {
            throw new IllegalArgumentException("Bad stream type " + streamType);
        }
    }

    private int getActiveStreamType(int suggestedStreamType) {
        if (this.mVoiceCapable) {
            boolean isOffhook = false;
            try {
                ITelephony phone = ITelephony.Stub.asInterface(ServiceManager.checkService("phone"));
                if (phone != null) {
                    isOffhook = phone.isOffhook();
                }
            }
            catch (RemoteException e) {
                Log.w(TAG, "Couldn't connect to phone service", e);
            }
            if (isOffhook || this.getMode() == 3) {
                if (AudioSystem.getForceUse(0) == 3) {
                    return 6;
                }
                return 0;
            }
            if (AudioSystem.isStreamActive(3, 0)) {
                return 3;
            }
            if (suggestedStreamType == Integer.MIN_VALUE) {
                return 2;
            }
            return suggestedStreamType;
        }
        if (this.getMode() == 3) {
            if (AudioSystem.getForceUse(0) == 3) {
                return 6;
            }
            return 0;
        }
        if (AudioSystem.isStreamActive(5, 5000) || AudioSystem.isStreamActive(2, 5000)) {
            return 5;
        }
        if (AudioSystem.isStreamActive(3, 0) || suggestedStreamType == Integer.MIN_VALUE) {
            return 3;
        }
        return suggestedStreamType;
    }

    private void broadcastRingerMode() {
        Intent broadcast = new Intent("android.media.RINGER_MODE_CHANGED");
        broadcast.putExtra("android.media.EXTRA_RINGER_MODE", this.mRingerMode);
        broadcast.addFlags(0x30000000);
        long origCallerIdentityToken = Binder.clearCallingIdentity();
        this.mContext.sendStickyBroadcast(broadcast);
        Binder.restoreCallingIdentity(origCallerIdentityToken);
    }

    private void broadcastVibrateSetting(int vibrateType) {
        if (ActivityManagerNative.isSystemReady()) {
            Intent broadcast = new Intent("android.media.VIBRATE_SETTING_CHANGED");
            broadcast.putExtra("android.media.EXTRA_VIBRATE_TYPE", vibrateType);
            broadcast.putExtra("android.media.EXTRA_VIBRATE_SETTING", this.getVibrateSetting(vibrateType));
            this.mContext.sendBroadcast(broadcast);
        }
    }

    private static int getMsg(int baseMsg, int streamType) {
        return baseMsg & 0xFFFF | streamType << 16;
    }

    private static int getMsgBase(int msg) {
        return msg & 0xFFFF;
    }

    private static void sendMsg(Handler handler, int baseMsg, int streamType, int existingMsgPolicy, int arg1, int arg2, Object obj, int delay) {
        int msg;
        int n = msg = streamType == -1 ? baseMsg : AudioService.getMsg(baseMsg, streamType);
        if (existingMsgPolicy == 0) {
            handler.removeMessages(msg);
        } else if (existingMsgPolicy == 1 && handler.hasMessages(msg)) {
            return;
        }
        handler.sendMessageDelayed(handler.obtainMessage(msg, arg1, arg2, obj), delay);
    }

    boolean checkAudioSettingsPermission(String method) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_AUDIO_SETTINGS") == 0) {
            return true;
        }
        String msg = "Audio Settings Permission Denial: " + method + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid();
        Log.w(TAG, msg);
        return false;
    }

    private void makeA2dpDeviceAvailable(String address) {
        AudioSystem.setDeviceConnectionState(128, 1, address);
        AudioSystem.setParameters("A2dpSuspended=false");
        this.mConnectedDevices.put(new Integer(128), address);
    }

    private void makeA2dpDeviceUnavailableNow(String address) {
        Intent noisyIntent = new Intent("android.media.AUDIO_BECOMING_NOISY");
        this.mContext.sendBroadcast(noisyIntent);
        AudioSystem.setDeviceConnectionState(128, 0, address);
        this.mConnectedDevices.remove(128);
    }

    private void makeA2dpDeviceUnavailableLater(String address) {
        AudioSystem.setParameters("A2dpSuspended=true");
        this.mConnectedDevices.remove(128);
        Message msg = this.mAudioHandler.obtainMessage(8, address);
        this.mAudioHandler.sendMessageDelayed(msg, 8000L);
    }

    private void cancelA2dpDeviceTimeout() {
        this.mAudioHandler.removeMessages(8);
    }

    private boolean hasScheduledA2dpDockTimeout() {
        return this.mAudioHandler.hasMessages(8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleA2dpConnectionStateChange(BluetoothDevice btDevice, int state) {
        if (btDevice == null) {
            return;
        }
        String address = btDevice.getAddress();
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            address = "";
        }
        HashMap<Integer, String> hashMap = this.mConnectedDevices;
        synchronized (hashMap) {
            boolean isConnected;
            boolean bl = isConnected = this.mConnectedDevices.containsKey(128) && this.mConnectedDevices.get(128).equals(address);
            if (isConnected && state != 2) {
                if (btDevice.isBluetoothDock()) {
                    if (state == 0) {
                        this.makeA2dpDeviceUnavailableLater(address);
                    }
                } else {
                    this.makeA2dpDeviceUnavailableNow(address);
                }
            } else if (!isConnected && state == 2) {
                if (btDevice.isBluetoothDock()) {
                    this.cancelA2dpDeviceTimeout();
                    this.mDockAddress = address;
                } else if (this.hasScheduledA2dpDockTimeout()) {
                    this.cancelA2dpDeviceTimeout();
                    this.makeA2dpDeviceUnavailableNow(this.mDockAddress);
                }
                this.makeA2dpDeviceAvailable(address);
            }
        }
    }

    private void notifyTopOfAudioFocusStack() {
        if (!this.mFocusStack.empty() && this.mFocusStack.peek().mFocusDispatcher != null && this.canReassignAudioFocus()) {
            try {
                this.mFocusStack.peek().mFocusDispatcher.dispatchAudioFocusChange(1, this.mFocusStack.peek().mClientId);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failure to signal gain of audio control focus due to " + e);
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpFocusStack(PrintWriter pw) {
        pw.println("\nAudio Focus stack entries:");
        Object object = mAudioFocusLock;
        synchronized (object) {
            for (FocusStackEntry fse : this.mFocusStack) {
                pw.println("     source:" + fse.mSourceRef + " -- client: " + fse.mClientId + " -- duration: " + fse.mFocusChangeType + " -- uid: " + fse.mCallingUid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFocusStackEntry(String clientToRemove, boolean signal) {
        if (!this.mFocusStack.empty() && this.mFocusStack.peek().mClientId.equals(clientToRemove)) {
            FocusStackEntry fse = this.mFocusStack.pop();
            fse.unlinkToDeath();
            if (signal) {
                this.notifyTopOfAudioFocusStack();
                Stack<RemoteControlStackEntry> stack = this.mRCStack;
                synchronized (stack) {
                    this.checkUpdateRemoteControlDisplay_syncAfRcs(15);
                }
            }
        } else {
            Iterator stackIterator = this.mFocusStack.iterator();
            while (stackIterator.hasNext()) {
                FocusStackEntry fse = (FocusStackEntry)stackIterator.next();
                if (!fse.mClientId.equals(clientToRemove)) continue;
                Log.i(TAG, " AudioFocus  abandonAudioFocus(): removing entry for " + fse.mClientId);
                stackIterator.remove();
                fse.unlinkToDeath();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFocusStackEntryForClient(IBinder cb) {
        boolean isTopOfStackForClientToRemove = !this.mFocusStack.isEmpty() && this.mFocusStack.peek().mSourceRef.equals(cb);
        Iterator stackIterator = this.mFocusStack.iterator();
        while (stackIterator.hasNext()) {
            FocusStackEntry fse = (FocusStackEntry)stackIterator.next();
            if (!fse.mSourceRef.equals(cb)) continue;
            Log.i(TAG, " AudioFocus  abandonAudioFocus(): removing entry for " + fse.mClientId);
            stackIterator.remove();
        }
        if (isTopOfStackForClientToRemove) {
            this.notifyTopOfAudioFocusStack();
            Stack<RemoteControlStackEntry> stack = this.mRCStack;
            synchronized (stack) {
                this.checkUpdateRemoteControlDisplay_syncAfRcs(15);
            }
        }
    }

    private boolean canReassignAudioFocus() {
        return this.mFocusStack.isEmpty() || !IN_VOICE_COMM_FOCUS_ID.equals(this.mFocusStack.peek().mClientId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int requestAudioFocus(int mainStreamType, int focusChangeHint, IBinder cb, IAudioFocusDispatcher fd, String clientId, String callingPackageName) {
        Log.i(TAG, " AudioFocus  requestAudioFocus() from " + clientId);
        if (!cb.pingBinder()) {
            Log.e(TAG, " AudioFocus DOA client for requestAudioFocus(), aborting.");
            return 0;
        }
        Object object = mAudioFocusLock;
        synchronized (object) {
            if (!this.canReassignAudioFocus()) {
                return 0;
            }
            AudioFocusDeathHandler afdh = new AudioFocusDeathHandler(cb);
            try {
                cb.linkToDeath(afdh, 0);
            }
            catch (RemoteException e) {
                Log.w(TAG, "AudioFocus  requestAudioFocus() could not link to " + cb + " binder death");
                return 0;
            }
            if (!this.mFocusStack.empty() && this.mFocusStack.peek().mClientId.equals(clientId)) {
                if (this.mFocusStack.peek().mFocusChangeType == focusChangeHint) {
                    cb.unlinkToDeath(afdh, 0);
                    return 1;
                }
                FocusStackEntry fse = this.mFocusStack.pop();
                fse.unlinkToDeath();
            }
            if (!this.mFocusStack.empty() && this.mFocusStack.peek().mFocusDispatcher != null) {
                try {
                    this.mFocusStack.peek().mFocusDispatcher.dispatchAudioFocusChange(-1 * focusChangeHint, this.mFocusStack.peek().mClientId);
                }
                catch (RemoteException e) {
                    Log.e(TAG, " Failure to signal loss of focus due to " + e);
                    e.printStackTrace();
                }
            }
            this.removeFocusStackEntry(clientId, false);
            this.mFocusStack.push(new FocusStackEntry(mainStreamType, focusChangeHint, fd, cb, clientId, afdh, callingPackageName, Binder.getCallingUid()));
            Stack<RemoteControlStackEntry> stack = this.mRCStack;
            synchronized (stack) {
                this.checkUpdateRemoteControlDisplay_syncAfRcs(15);
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int abandonAudioFocus(IAudioFocusDispatcher fl, String clientId) {
        Log.i(TAG, " AudioFocus  abandonAudioFocus() from " + clientId);
        try {
            Object object = mAudioFocusLock;
            synchronized (object) {
                this.removeFocusStackEntry(clientId, true);
            }
        }
        catch (ConcurrentModificationException cme) {
            Log.e(TAG, "FATAL EXCEPTION AudioFocus  abandonAudioFocus() caused " + cme);
            cme.printStackTrace();
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAudioFocusClient(String clientId) {
        Object object = mAudioFocusLock;
        synchronized (object) {
            this.removeFocusStackEntry(clientId, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpRCStack(PrintWriter pw) {
        pw.println("\nRemote Control stack entries:");
        Stack<RemoteControlStackEntry> stack = this.mRCStack;
        synchronized (stack) {
            for (RemoteControlStackEntry rcse : this.mRCStack) {
                pw.println("  pi: " + rcse.mMediaIntent + "  -- ercvr: " + rcse.mReceiverComponent + "  -- client: " + rcse.mRcClient + "  -- uid: " + rcse.mCallingUid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMediaButtonReceiverForPackage(String packageName) {
        Stack<RemoteControlStackEntry> stack = this.mRCStack;
        synchronized (stack) {
            if (this.mRCStack.empty()) {
                return;
            }
            RemoteControlStackEntry oldTop = this.mRCStack.peek();
            Iterator stackIterator = this.mRCStack.iterator();
            while (stackIterator.hasNext()) {
                RemoteControlStackEntry rcse = (RemoteControlStackEntry)stackIterator.next();
                if (!packageName.equalsIgnoreCase(rcse.mReceiverComponent.getPackageName())) continue;
                stackIterator.remove();
                rcse.unlinkToRcClientDeath();
            }
            if (this.mRCStack.empty()) {
                this.mAudioHandler.sendMessage(this.mAudioHandler.obtainMessage(11, 0, 0, null));
            } else if (oldTop != this.mRCStack.peek()) {
                this.mAudioHandler.sendMessage(this.mAudioHandler.obtainMessage(11, 0, 0, this.mRCStack.peek().mReceiverComponent));
            }
        }
    }

    private void restoreMediaButtonReceiver() {
        String receiverName = Settings.System.getString(this.mContentResolver, "media_button_receiver");
        if (null != receiverName && !receiverName.isEmpty()) {
            ComponentName eventReceiver = ComponentName.unflattenFromString(receiverName);
            Intent mediaButtonIntent = new Intent("android.intent.action.MEDIA_BUTTON");
            mediaButtonIntent.setComponent(eventReceiver);
            PendingIntent pi = PendingIntent.getBroadcast(this.mContext, 0, mediaButtonIntent, 0);
            this.registerMediaButtonIntent(pi, eventReceiver);
        }
    }

    private void pushMediaButtonReceiver(PendingIntent mediaIntent, ComponentName target) {
        if (!this.mRCStack.empty() && this.mRCStack.peek().mMediaIntent.equals(mediaIntent)) {
            return;
        }
        Iterator stackIterator = this.mRCStack.iterator();
        RemoteControlStackEntry rcse = null;
        boolean wasInsideStack = false;
        while (stackIterator.hasNext()) {
            rcse = (RemoteControlStackEntry)stackIterator.next();
            if (!rcse.mMediaIntent.equals(mediaIntent)) continue;
            wasInsideStack = true;
            stackIterator.remove();
            break;
        }
        if (!wasInsideStack) {
            rcse = new RemoteControlStackEntry(mediaIntent, target);
        }
        this.mRCStack.push(rcse);
        this.mAudioHandler.sendMessage(this.mAudioHandler.obtainMessage(11, 0, 0, target));
    }

    private void removeMediaButtonReceiver(PendingIntent pi) {
        Iterator stackIterator = this.mRCStack.iterator();
        while (stackIterator.hasNext()) {
            RemoteControlStackEntry rcse = (RemoteControlStackEntry)stackIterator.next();
            if (!rcse.mMediaIntent.equals(pi)) continue;
            stackIterator.remove();
            rcse.unlinkToRcClientDeath();
            break;
        }
    }

    private boolean isCurrentRcController(PendingIntent pi) {
        return !this.mRCStack.empty() && this.mRCStack.peek().mMediaIntent.equals(pi);
    }

    private void setNewRcClientOnDisplays_syncRcsCurrc(int newClientGeneration, PendingIntent newMediaIntent, boolean clearing) {
        if (this.mRcDisplay != null) {
            try {
                this.mRcDisplay.setCurrentClientId(newClientGeneration, newMediaIntent, clearing);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Dead display in setNewRcClientOnDisplays_syncRcsCurrc() " + e);
                this.rcDisplay_stopDeathMonitor_syncRcStack();
                this.mRcDisplay = null;
            }
        }
    }

    private void setNewRcClientGenerationOnClients_syncRcsCurrc(int newClientGeneration) {
        Iterator stackIterator = this.mRCStack.iterator();
        while (stackIterator.hasNext()) {
            RemoteControlStackEntry se = (RemoteControlStackEntry)stackIterator.next();
            if (se == null || se.mRcClient == null) continue;
            try {
                se.mRcClient.setCurrentClientGenerationId(newClientGeneration);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Dead client in setNewRcClientGenerationOnClients_syncRcsCurrc()" + e);
                stackIterator.remove();
                se.unlinkToRcClientDeath();
            }
        }
    }

    private void setNewRcClient_syncRcsCurrc(int newClientGeneration, PendingIntent newMediaIntent, boolean clearing) {
        this.setNewRcClientOnDisplays_syncRcsCurrc(newClientGeneration, newMediaIntent, clearing);
        this.setNewRcClientGenerationOnClients_syncRcsCurrc(newClientGeneration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRcDisplayClear() {
        Stack<RemoteControlStackEntry> stack = this.mRCStack;
        synchronized (stack) {
            Object object = this.mCurrentRcLock;
            synchronized (object) {
                ++this.mCurrentRcClientGen;
                this.setNewRcClient_syncRcsCurrc(this.mCurrentRcClientGen, null, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRcDisplayUpdate(RemoteControlStackEntry rcse, int flags) {
        Stack<RemoteControlStackEntry> stack = this.mRCStack;
        synchronized (stack) {
            Object object = this.mCurrentRcLock;
            synchronized (object) {
                if (this.mCurrentRcClient != null && this.mCurrentRcClient.equals(rcse.mRcClient)) {
                    ++this.mCurrentRcClientGen;
                    this.setNewRcClient_syncRcsCurrc(this.mCurrentRcClientGen, rcse.mMediaIntent, false);
                    try {
                        this.mCurrentRcClient.onInformationRequested(this.mCurrentRcClientGen, flags, this.mArtworkExpectedWidth, this.mArtworkExpectedHeight);
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Current valid remote client is dead: " + e);
                        this.mCurrentRcClient = null;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearRemoteControlDisplay_syncAfRcs() {
        Object object = this.mCurrentRcLock;
        synchronized (object) {
            this.mCurrentRcClient = null;
        }
        this.mAudioHandler.sendMessage(this.mAudioHandler.obtainMessage(13));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRemoteControlDisplay_syncAfRcs(int infoChangedFlags) {
        RemoteControlStackEntry rcse = this.mRCStack.peek();
        int infoFlagsAboutToBeUsed = infoChangedFlags;
        if (rcse.mRcClient == null) {
            this.clearRemoteControlDisplay_syncAfRcs();
            return;
        }
        Object object = this.mCurrentRcLock;
        synchronized (object) {
            if (!rcse.mRcClient.equals(this.mCurrentRcClient)) {
                infoFlagsAboutToBeUsed = 15;
            }
            this.mCurrentRcClient = rcse.mRcClient;
        }
        this.mAudioHandler.sendMessage(this.mAudioHandler.obtainMessage(14, infoFlagsAboutToBeUsed, 0, rcse));
    }

    private void checkUpdateRemoteControlDisplay_syncAfRcs(int infoChangedFlags) {
        if (this.mRCStack.isEmpty() || this.mFocusStack.isEmpty()) {
            this.clearRemoteControlDisplay_syncAfRcs();
            return;
        }
        if (this.mRCStack.peek().mCallingPackageName != null && this.mFocusStack.peek().mPackageName != null && this.mRCStack.peek().mCallingPackageName.compareTo(this.mFocusStack.peek().mPackageName) != 0) {
            this.clearRemoteControlDisplay_syncAfRcs();
            return;
        }
        if (this.mRCStack.peek().mCallingUid != this.mFocusStack.peek().mCallingUid) {
            this.clearRemoteControlDisplay_syncAfRcs();
            return;
        }
        this.updateRemoteControlDisplay_syncAfRcs(infoChangedFlags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMediaButtonIntent(PendingIntent mediaIntent, ComponentName eventReceiver) {
        Log.i(TAG, "  Remote Control   registerMediaButtonIntent() for " + mediaIntent);
        Object object = mAudioFocusLock;
        synchronized (object) {
            Stack<RemoteControlStackEntry> stack = this.mRCStack;
            synchronized (stack) {
                this.pushMediaButtonReceiver(mediaIntent, eventReceiver);
                this.checkUpdateRemoteControlDisplay_syncAfRcs(15);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterMediaButtonIntent(PendingIntent mediaIntent, ComponentName eventReceiver) {
        Log.i(TAG, "  Remote Control   unregisterMediaButtonIntent() for " + mediaIntent);
        Object object = mAudioFocusLock;
        synchronized (object) {
            Stack<RemoteControlStackEntry> stack = this.mRCStack;
            synchronized (stack) {
                boolean topOfStackWillChange = this.isCurrentRcController(mediaIntent);
                this.removeMediaButtonReceiver(mediaIntent);
                if (topOfStackWillChange) {
                    this.checkUpdateRemoteControlDisplay_syncAfRcs(15);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerRemoteControlClient(PendingIntent mediaIntent, IRemoteControlClient rcClient, String callingPackageName) {
        Object object = mAudioFocusLock;
        synchronized (object) {
            Stack<RemoteControlStackEntry> stack = this.mRCStack;
            synchronized (stack) {
                for (RemoteControlStackEntry rcse : this.mRCStack) {
                    if (!rcse.mMediaIntent.equals(mediaIntent)) continue;
                    if (rcse.mRcClientDeathHandler != null) {
                        rcse.unlinkToRcClientDeath();
                    }
                    rcse.mRcClient = rcClient;
                    rcse.mCallingPackageName = callingPackageName;
                    rcse.mCallingUid = Binder.getCallingUid();
                    if (rcClient == null) break;
                    if (this.mRcDisplay != null) {
                        try {
                            rcse.mRcClient.plugRemoteControlDisplay(this.mRcDisplay);
                        }
                        catch (RemoteException e) {
                            Log.e(TAG, "Error connecting remote control display to client: " + e);
                            e.printStackTrace();
                        }
                    }
                    IBinder b = rcse.mRcClient.asBinder();
                    RcClientDeathHandler rcdh = new RcClientDeathHandler(b, rcse.mMediaIntent);
                    try {
                        b.linkToDeath(rcdh, 0);
                    }
                    catch (RemoteException e) {
                        Log.w(TAG, "registerRemoteControlClient() has a dead client " + b);
                        rcse.mRcClient = null;
                    }
                    rcse.mRcClientDeathHandler = rcdh;
                    break;
                }
                if (this.isCurrentRcController(mediaIntent)) {
                    this.checkUpdateRemoteControlDisplay_syncAfRcs(15);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterRemoteControlClient(PendingIntent mediaIntent, IRemoteControlClient rcClient) {
        Object object = mAudioFocusLock;
        synchronized (object) {
            Stack<RemoteControlStackEntry> stack = this.mRCStack;
            synchronized (stack) {
                for (RemoteControlStackEntry rcse : this.mRCStack) {
                    if (!rcse.mMediaIntent.equals(mediaIntent) || !rcClient.equals(rcse.mRcClient)) continue;
                    rcse.unlinkToRcClientDeath();
                    rcse.mRcClient = null;
                    rcse.mCallingPackageName = null;
                }
            }
        }
    }

    private void rcDisplay_stopDeathMonitor_syncRcStack() {
        if (this.mRcDisplay != null) {
            this.mRcDisplayDeathHandler.unlinkToRcDisplayDeath();
        }
    }

    private void rcDisplay_startDeathMonitor_syncRcStack() {
        if (this.mRcDisplay != null) {
            IBinder b = this.mRcDisplay.asBinder();
            this.mRcDisplayDeathHandler = new RcDisplayDeathHandler(b);
            try {
                b.linkToDeath(this.mRcDisplayDeathHandler, 0);
            }
            catch (RemoteException e) {
                Log.w(TAG, "registerRemoteControlDisplay() has a dead client " + b);
                this.mRcDisplay = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerRemoteControlDisplay(IRemoteControlDisplay rcd) {
        Object object = mAudioFocusLock;
        synchronized (object) {
            Stack<RemoteControlStackEntry> stack = this.mRCStack;
            synchronized (stack) {
                if (this.mRcDisplay == rcd || rcd == null) {
                    return;
                }
                this.rcDisplay_stopDeathMonitor_syncRcStack();
                this.mRcDisplay = rcd;
                this.rcDisplay_startDeathMonitor_syncRcStack();
                for (RemoteControlStackEntry rcse : this.mRCStack) {
                    if (rcse.mRcClient == null) continue;
                    try {
                        rcse.mRcClient.plugRemoteControlDisplay(this.mRcDisplay);
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Error connecting remote control display to client: " + e);
                        e.printStackTrace();
                    }
                }
                this.checkUpdateRemoteControlDisplay_syncAfRcs(15);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterRemoteControlDisplay(IRemoteControlDisplay rcd) {
        Stack<RemoteControlStackEntry> stack = this.mRCStack;
        synchronized (stack) {
            if (rcd == null || rcd != this.mRcDisplay) {
                return;
            }
            this.rcDisplay_stopDeathMonitor_syncRcStack();
            this.mRcDisplay = null;
            for (RemoteControlStackEntry rcse : this.mRCStack) {
                if (rcse.mRcClient == null) continue;
                try {
                    rcse.mRcClient.unplugRemoteControlDisplay(rcd);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Error disconnecting remote control display to client: " + e);
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remoteControlDisplayUsesBitmapSize(IRemoteControlDisplay rcd, int w, int h) {
        Stack<RemoteControlStackEntry> stack = this.mRCStack;
        synchronized (stack) {
            this.mArtworkExpectedWidth = w;
            this.mArtworkExpectedHeight = h;
        }
    }

    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.dumpFocusStack(pw);
        this.dumpRCStack(pw);
    }

    private class RcDisplayDeathHandler
    implements IBinder.DeathRecipient {
        private IBinder mCb;

        public RcDisplayDeathHandler(IBinder b) {
            this.mCb = b;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void binderDied() {
            Stack stack = AudioService.this.mRCStack;
            synchronized (stack) {
                Log.w(AudioService.TAG, "RemoteControl: display died");
                AudioService.this.mRcDisplay = null;
            }
        }

        public void unlinkToRcDisplayDeath() {
            try {
                this.mCb.unlinkToDeath(this, 0);
            }
            catch (NoSuchElementException e) {
                Log.e(AudioService.TAG, "Encountered " + e + " in unlinkToRcDisplayDeath()");
                e.printStackTrace();
            }
        }
    }

    private static class RemoteControlStackEntry {
        public PendingIntent mMediaIntent;
        public ComponentName mReceiverComponent;
        public String mCallingPackageName;
        public int mCallingUid;
        public IRemoteControlClient mRcClient;
        public RcClientDeathHandler mRcClientDeathHandler;

        public RemoteControlStackEntry(PendingIntent mediaIntent, ComponentName eventReceiver) {
            this.mMediaIntent = mediaIntent;
            this.mReceiverComponent = eventReceiver;
            this.mCallingUid = -1;
            this.mRcClient = null;
        }

        public void unlinkToRcClientDeath() {
            if (this.mRcClientDeathHandler != null && this.mRcClientDeathHandler.mCb != null) {
                try {
                    this.mRcClientDeathHandler.mCb.unlinkToDeath(this.mRcClientDeathHandler, 0);
                    this.mRcClientDeathHandler = null;
                }
                catch (NoSuchElementException e) {
                    Log.e(AudioService.TAG, "Encountered " + e + " in unlinkToRcClientDeath()");
                    e.printStackTrace();
                }
            }
        }

        protected void finalize() throws Throwable {
            this.unlinkToRcClientDeath();
            super.finalize();
        }
    }

    private class RcClientDeathHandler
    implements IBinder.DeathRecipient {
        private IBinder mCb;
        private PendingIntent mMediaIntent;

        RcClientDeathHandler(IBinder cb, PendingIntent pi) {
            this.mCb = cb;
            this.mMediaIntent = pi;
        }

        public void binderDied() {
            Log.w(AudioService.TAG, "  RemoteControlClient died");
            AudioService.this.registerRemoteControlClient(this.mMediaIntent, null, null);
        }

        public IBinder getBinder() {
            return this.mCb;
        }
    }

    private class MediaButtonBroadcastReceiver
    extends BroadcastReceiver {
        private MediaButtonBroadcastReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (!"android.intent.action.MEDIA_BUTTON".equals(action)) {
                return;
            }
            KeyEvent event = (KeyEvent)intent.getParcelableExtra("android.intent.extra.KEY_EVENT");
            if (event != null) {
                Object object = mRingingLock;
                synchronized (object) {
                    if (AudioService.this.mIsRinging || AudioService.this.getMode() == 2 || AudioService.this.getMode() == 3 || AudioService.this.getMode() == 1) {
                        return;
                    }
                }
                object = AudioService.this.mRCStack;
                synchronized (object) {
                    if (!AudioService.this.mRCStack.empty()) {
                        Intent targetedIntent = new Intent("android.intent.action.MEDIA_BUTTON");
                        Bundle extras = intent.getExtras();
                        if (extras != null) {
                            targetedIntent.putExtras(extras);
                            this.abortBroadcast();
                            try {
                                ((RemoteControlStackEntry)((AudioService)AudioService.this).mRCStack.peek()).mMediaIntent.send(context, 0, targetedIntent);
                            }
                            catch (PendingIntent.CanceledException e) {
                                Log.e(AudioService.TAG, "Error sending pending intent " + AudioService.this.mRCStack.peek());
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
        }
    }

    private class AudioFocusDeathHandler
    implements IBinder.DeathRecipient {
        private IBinder mCb;

        AudioFocusDeathHandler(IBinder cb) {
            this.mCb = cb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void binderDied() {
            Object object = mAudioFocusLock;
            synchronized (object) {
                Log.w(AudioService.TAG, "  AudioFocus   audio focus client died");
                AudioService.this.removeFocusStackEntryForClient(this.mCb);
            }
        }

        public IBinder getBinder() {
            return this.mCb;
        }
    }

    private static class FocusStackEntry {
        public int mStreamType = -1;
        public IAudioFocusDispatcher mFocusDispatcher = null;
        public IBinder mSourceRef = null;
        public String mClientId;
        public int mFocusChangeType;
        public AudioFocusDeathHandler mHandler;
        public String mPackageName;
        public int mCallingUid;

        public FocusStackEntry() {
        }

        public FocusStackEntry(int streamType, int duration, IAudioFocusDispatcher afl, IBinder source, String id2, AudioFocusDeathHandler hdlr, String pn, int uid) {
            this.mStreamType = streamType;
            this.mFocusDispatcher = afl;
            this.mSourceRef = source;
            this.mClientId = id2;
            this.mFocusChangeType = duration;
            this.mHandler = hdlr;
            this.mPackageName = pn;
            this.mCallingUid = uid;
        }

        public void unlinkToDeath() {
            try {
                if (this.mSourceRef != null && this.mHandler != null) {
                    this.mSourceRef.unlinkToDeath(this.mHandler, 0);
                    this.mHandler = null;
                }
            }
            catch (NoSuchElementException e) {
                Log.e(AudioService.TAG, "Encountered " + e + " in FocusStackEntry.unlinkToDeath()");
            }
        }

        protected void finalize() throws Throwable {
            this.unlinkToDeath();
            super.finalize();
        }
    }

    private class AudioServiceBroadcastReceiver
    extends BroadcastReceiver {
        private AudioServiceBroadcastReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.intent.action.DOCK_EVENT")) {
                int config;
                int dockState = intent.getIntExtra("android.intent.extra.DOCK_STATE", 0);
                switch (dockState) {
                    case 1: {
                        config = 7;
                        break;
                    }
                    case 2: {
                        config = 6;
                        break;
                    }
                    case 3: {
                        config = 8;
                        break;
                    }
                    case 4: {
                        config = 9;
                        break;
                    }
                    default: {
                        config = 0;
                    }
                }
                AudioSystem.setForceUse(3, config);
            } else if (action.equals("android.bluetooth.a2dp.profile.action.CONNECTION_STATE_CHANGED")) {
                int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 0);
                BluetoothDevice btDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                AudioService.this.handleA2dpConnectionStateChange(btDevice, state);
            } else {
                if (action.equals("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED")) {
                    int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 0);
                    int device = 16;
                    String address = null;
                    BluetoothDevice btDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    if (btDevice == null) {
                        return;
                    }
                    address = btDevice.getAddress();
                    BluetoothClass btClass = btDevice.getBluetoothClass();
                    if (btClass != null) {
                        switch (btClass.getDeviceClass()) {
                            case 1028: 
                            case 1032: {
                                device = 32;
                                break;
                            }
                            case 1056: {
                                device = 64;
                            }
                        }
                    }
                    if (!BluetoothAdapter.checkBluetoothAddress(address)) {
                        address = "";
                    }
                    HashMap hashMap = AudioService.this.mConnectedDevices;
                    synchronized (hashMap) {
                        boolean isConnected = AudioService.this.mConnectedDevices.containsKey(device) && ((String)AudioService.this.mConnectedDevices.get(device)).equals(address);
                        ArrayList arrayList = AudioService.this.mScoClients;
                        synchronized (arrayList) {
                            if (isConnected && state != 2) {
                                AudioSystem.setDeviceConnectionState(device, 0, address);
                                AudioService.this.mConnectedDevices.remove(device);
                                AudioService.this.mBluetoothHeadsetDevice = null;
                                AudioService.this.resetBluetoothSco();
                            } else if (!isConnected && state == 2) {
                                AudioSystem.setDeviceConnectionState(device, 1, address);
                                AudioService.this.mConnectedDevices.put(new Integer(device), address);
                                AudioService.this.mBluetoothHeadsetDevice = btDevice;
                            }
                        }
                    }
                }
                if (action.equals("android.intent.action.HEADSET_PLUG")) {
                    int state = intent.getIntExtra("state", 0);
                    int microphone = intent.getIntExtra("microphone", 0);
                    HashMap address = AudioService.this.mConnectedDevices;
                    synchronized (address) {
                        if (microphone != 0) {
                            boolean isConnected = AudioService.this.mConnectedDevices.containsKey(4);
                            if (state == 0 && isConnected) {
                                AudioSystem.setDeviceConnectionState(4, 0, "");
                                AudioService.this.mConnectedDevices.remove(4);
                            } else if (state == 1 && !isConnected) {
                                AudioSystem.setDeviceConnectionState(4, 1, "");
                                AudioService.this.mConnectedDevices.put(new Integer(4), "");
                            }
                        } else {
                            boolean isConnected = AudioService.this.mConnectedDevices.containsKey(8);
                            if (state == 0 && isConnected) {
                                AudioSystem.setDeviceConnectionState(8, 0, "");
                                AudioService.this.mConnectedDevices.remove(8);
                            } else if (state == 1 && !isConnected) {
                                AudioSystem.setDeviceConnectionState(8, 1, "");
                                AudioService.this.mConnectedDevices.put(new Integer(8), "");
                            }
                        }
                    }
                }
                if (action.equals("android.intent.action.USB_ANLG_HEADSET_PLUG")) {
                    int state = intent.getIntExtra("state", 0);
                    Log.v(AudioService.TAG, "Broadcast Receiver: Got ACTION_USB_ANLG_HEADSET_PLUG, state = " + state);
                    HashMap microphone = AudioService.this.mConnectedDevices;
                    synchronized (microphone) {
                        boolean isConnected = AudioService.this.mConnectedDevices.containsKey(2048);
                        if (state == 0 && isConnected) {
                            AudioSystem.setDeviceConnectionState(2048, 0, "");
                            AudioService.this.mConnectedDevices.remove(2048);
                        } else if (state == 1 && !isConnected) {
                            AudioSystem.setDeviceConnectionState(2048, 1, "");
                            AudioService.this.mConnectedDevices.put(new Integer(2048), "");
                        }
                    }
                }
                if (action.equals("android.intent.action.HDMI_AUDIO_PLUG")) {
                    int state = intent.getIntExtra("state", 0);
                    Log.v(AudioService.TAG, "Broadcast Receiver: Got ACTION_HDMI_AUDIO_PLUG, state = " + state);
                    HashMap microphone = AudioService.this.mConnectedDevices;
                    synchronized (microphone) {
                        boolean isConnected = AudioService.this.mConnectedDevices.containsKey(1024);
                        if (state == 0 && isConnected) {
                            AudioSystem.setDeviceConnectionState(1024, 0, "");
                            AudioService.this.mConnectedDevices.remove(1024);
                        } else if (state == 1 && !isConnected) {
                            AudioSystem.setDeviceConnectionState(1024, 1, "");
                            AudioService.this.mConnectedDevices.put(new Integer(1024), "");
                        }
                    }
                }
                if (action.equals("android.intent.action.USB_DGTL_HEADSET_PLUG")) {
                    int state = intent.getIntExtra("state", 0);
                    Log.v(AudioService.TAG, "Broadcast Receiver: Got ACTION_USB_DGTL_HEADSET_PLUG, state = " + state);
                    HashMap microphone = AudioService.this.mConnectedDevices;
                    synchronized (microphone) {
                        boolean isConnected = AudioService.this.mConnectedDevices.containsKey(4096);
                        if (state == 0 && isConnected) {
                            AudioSystem.setDeviceConnectionState(4096, 0, "");
                            AudioService.this.mConnectedDevices.remove(4096);
                        } else if (state == 1 && !isConnected) {
                            AudioSystem.setDeviceConnectionState(4096, 1, "");
                            AudioService.this.mConnectedDevices.put(new Integer(4096), "");
                        }
                    }
                }
                if (action.equals("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED")) {
                    boolean broadcast = false;
                    int state = -1;
                    ArrayList isConnected = AudioService.this.mScoClients;
                    synchronized (isConnected) {
                        int btState = intent.getIntExtra("android.bluetooth.profile.extra.STATE", -1);
                        if (!(AudioService.this.mScoClients.isEmpty() || AudioService.this.mScoAudioState != 3 && AudioService.this.mScoAudioState != 1 && AudioService.this.mScoAudioState != 5)) {
                            broadcast = true;
                        }
                        switch (btState) {
                            case 12: {
                                state = 1;
                                if (AudioService.this.mScoAudioState == 3 || AudioService.this.mScoAudioState == 5 || AudioService.this.mScoAudioState == 4) break;
                                AudioService.this.mScoAudioState = 2;
                                break;
                            }
                            case 10: {
                                state = 0;
                                AudioService.this.mScoAudioState = 0;
                                AudioService.this.clearAllScoClients(0, false);
                                break;
                            }
                            case 11: {
                                if (AudioService.this.mScoAudioState != 3 && AudioService.this.mScoAudioState != 5 && AudioService.this.mScoAudioState != 4) {
                                    AudioService.this.mScoAudioState = 2;
                                }
                            }
                            default: {
                                broadcast = false;
                            }
                        }
                    }
                    if (broadcast) {
                        AudioService.this.broadcastScoConnectionState(state);
                        Intent newIntent = new Intent("android.media.SCO_AUDIO_STATE_CHANGED");
                        newIntent.putExtra("android.media.extra.SCO_AUDIO_STATE", state);
                        AudioService.this.mContext.sendStickyBroadcast(newIntent);
                    }
                } else if (action.equals("android.intent.action.BOOT_COMPLETED")) {
                    AudioService.this.mBootCompleted = true;
                    AudioService.sendMsg(AudioService.this.mAudioHandler, 9, -1, 1, 0, 0, null, 0);
                    AudioService.this.mKeyguardManager = (KeyguardManager)AudioService.this.mContext.getSystemService("keyguard");
                    AudioService.this.mScoConnectionState = -1;
                    AudioService.this.resetBluetoothSco();
                    AudioService.this.getBluetoothHeadset();
                    Intent newIntent = new Intent("android.media.SCO_AUDIO_STATE_CHANGED");
                    newIntent.putExtra("android.media.extra.SCO_AUDIO_STATE", 0);
                    AudioService.this.mContext.sendStickyBroadcast(newIntent);
                    BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
                    if (adapter != null) {
                        adapter.getProfileProxy(AudioService.this.mContext, AudioService.this.mBluetoothProfileServiceListener, 2);
                    }
                } else if (action.equals("android.intent.action.PACKAGE_REMOVED")) {
                    String packageName;
                    if (!intent.getBooleanExtra("android.intent.extra.REPLACING", false) && (packageName = intent.getData().getSchemeSpecificPart()) != null) {
                        AudioService.this.removeMediaButtonReceiverForPackage(packageName);
                    }
                } else if (action.equals("android.intent.action.SCREEN_ON")) {
                    AudioSystem.setParameters("screen_state=on");
                } else if (action.equals("android.intent.action.SCREEN_OFF")) {
                    AudioSystem.setParameters("screen_state=off");
                }
            }
        }
    }

    private class SettingsObserver
    extends ContentObserver {
        SettingsObserver() {
            super(new Handler());
            AudioService.this.mContentResolver.registerContentObserver(Settings.System.getUriFor("mode_ringer_streams_affected"), false, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onChange(boolean selfChange) {
            super.onChange(selfChange);
            Object object = AudioService.this.mSettingsLock;
            synchronized (object) {
                int ringerModeAffectedStreams = Settings.System.getInt(AudioService.this.mContentResolver, "mode_ringer_streams_affected", 166);
                ringerModeAffectedStreams = AudioService.this.mVoiceCapable ? (ringerModeAffectedStreams &= 0xFFFFFFF7) : (ringerModeAffectedStreams |= 8);
                if (ringerModeAffectedStreams != AudioService.this.mRingerModeAffectedStreams) {
                    AudioService.this.mRingerModeAffectedStreams = ringerModeAffectedStreams;
                    AudioService.this.setRingerModeInt(AudioService.this.getRingerMode(), false);
                }
            }
        }
    }

    private class AudioHandler
    extends Handler {
        private AudioHandler() {
        }

        private void setSystemVolume(VolumeStreamState streamState) {
            AudioService.this.setStreamVolumeIndex(streamState.mStreamType, streamState.mIndex);
            int numStreamTypes = AudioSystem.getNumStreamTypes();
            for (int streamType = numStreamTypes - 1; streamType >= 0; --streamType) {
                if (streamType == streamState.mStreamType || AudioService.this.STREAM_VOLUME_ALIAS[streamType] != streamState.mStreamType) continue;
                AudioService.this.setStreamVolumeIndex(streamType, AudioService.this.mStreamStates[streamType].mIndex);
            }
            AudioService.sendMsg(AudioService.this.mAudioHandler, 1, streamState.mStreamType, 0, 1, 1, streamState, 3000);
        }

        private void persistVolume(VolumeStreamState streamState, boolean current, boolean lastAudible) {
            if (current) {
                Settings.System.putInt(AudioService.this.mContentResolver, streamState.mVolumeIndexSettingName, (streamState.mIndex + 5) / 10);
            }
            if (lastAudible) {
                Settings.System.putInt(AudioService.this.mContentResolver, streamState.mLastAudibleVolumeIndexSettingName, (streamState.mLastAudibleIndex + 5) / 10);
            }
        }

        private void persistRingerMode() {
            Settings.System.putInt(AudioService.this.mContentResolver, "mode_ringer", AudioService.this.mRingerMode);
        }

        private void persistVibrateSetting() {
            Settings.System.putInt(AudioService.this.mContentResolver, "vibrate_on", AudioService.this.mVibrateSetting);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void playSoundEffect(int effectType, int volume) {
            Object object = AudioService.this.mSoundEffectsLock;
            synchronized (object) {
                if (AudioService.this.mSoundPool == null) {
                    return;
                }
                float volFloat = volume < 0 ? (float)Math.pow(10.0, AudioService.this.SOUND_EFFECT_VOLUME_DB / 20) : (float)volume / 1000.0f;
                if (AudioService.this.SOUND_EFFECT_FILES_MAP[effectType][1] > 0) {
                    AudioService.this.mSoundPool.play(AudioService.this.SOUND_EFFECT_FILES_MAP[effectType][1], volFloat, volFloat, 0, 0, 1.0f);
                } else {
                    MediaPlayer mediaPlayer = new MediaPlayer();
                    if (mediaPlayer != null) {
                        try {
                            String filePath = Environment.getRootDirectory() + AudioService.SOUND_EFFECTS_PATH + SOUND_EFFECT_FILES[AudioService.this.SOUND_EFFECT_FILES_MAP[effectType][0]];
                            mediaPlayer.setDataSource(filePath);
                            mediaPlayer.setAudioStreamType(1);
                            mediaPlayer.prepare();
                            mediaPlayer.setVolume(volFloat, volFloat);
                            mediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                                public void onCompletion(MediaPlayer mp) {
                                    AudioHandler.this.cleanupPlayer(mp);
                                }
                            });
                            mediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                                public boolean onError(MediaPlayer mp, int what, int extra) {
                                    AudioHandler.this.cleanupPlayer(mp);
                                    return true;
                                }
                            });
                            mediaPlayer.start();
                        }
                        catch (IOException ex) {
                            Log.w(AudioService.TAG, "MediaPlayer IOException: " + ex);
                        }
                        catch (IllegalArgumentException ex) {
                            Log.w(AudioService.TAG, "MediaPlayer IllegalArgumentException: " + ex);
                        }
                        catch (IllegalStateException ex) {
                            Log.w(AudioService.TAG, "MediaPlayer IllegalStateException: " + ex);
                        }
                    }
                }
            }
        }

        private void onHandlePersistMediaButtonReceiver(ComponentName receiver) {
            Settings.System.putString(AudioService.this.mContentResolver, "media_button_receiver", receiver == null ? "" : receiver.flattenToString());
        }

        private void cleanupPlayer(MediaPlayer mp) {
            if (mp != null) {
                try {
                    mp.stop();
                    mp.release();
                }
                catch (IllegalStateException ex) {
                    Log.w(AudioService.TAG, "MediaPlayer IllegalStateException: " + ex);
                }
            }
        }

        private void setForceUse(int usage, int config) {
            AudioSystem.setForceUse(usage, config);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            int baseMsgWhat = AudioService.getMsgBase(msg.what);
            switch (baseMsgWhat) {
                case 0: {
                    this.setSystemVolume((VolumeStreamState)msg.obj);
                    break;
                }
                case 1: {
                    this.persistVolume((VolumeStreamState)msg.obj, msg.arg1 != 0, msg.arg2 != 0);
                    break;
                }
                case 3: {
                    this.persistRingerMode();
                    break;
                }
                case 4: {
                    this.persistVibrateSetting();
                    break;
                }
                case 5: {
                    if (AudioService.this.mMediaServerOk) break;
                    Log.e(AudioService.TAG, "Media server died.");
                    AudioSystem.setErrorCallback(AudioService.this.mAudioSystemCallback);
                    AudioService.sendMsg(AudioService.this.mAudioHandler, 5, -1, 1, 0, 0, null, 500);
                    break;
                }
                case 6: {
                    Log.e(AudioService.TAG, "Media server started.");
                    AudioSystem.setParameters("restarting=true");
                    HashMap hashMap = AudioService.this.mConnectedDevices;
                    synchronized (hashMap) {
                        Set set = AudioService.this.mConnectedDevices.entrySet();
                        for (Map.Entry device : set) {
                            AudioSystem.setDeviceConnectionState((Integer)device.getKey(), 1, (String)device.getValue());
                        }
                    }
                    AudioSystem.setPhoneState(AudioService.this.mMode);
                    AudioSystem.setForceUse(0, AudioService.this.mForcedUseForComm);
                    AudioSystem.setForceUse(2, AudioService.this.mForcedUseForComm);
                    int numStreamTypes = AudioSystem.getNumStreamTypes();
                    for (int streamType = numStreamTypes - 1; streamType >= 0; --streamType) {
                        VolumeStreamState streamState = AudioService.this.mStreamStates[streamType];
                        AudioSystem.initStreamVolume(streamType, 0, (streamState.mIndexMax + 5) / 10);
                        int index = streamState.muteCount() == 0 ? streamState.mIndex : 0;
                        AudioService.this.setStreamVolumeIndex(streamType, index);
                    }
                    AudioService.this.setRingerModeInt(AudioService.this.getRingerMode(), false);
                    AudioSystem.setParameters("restarting=false");
                    break;
                }
                case 9: {
                    AudioService.this.loadSoundEffects();
                    break;
                }
                case 7: {
                    this.playSoundEffect(msg.arg1, msg.arg2);
                    break;
                }
                case 8: {
                    HashMap hashMap = AudioService.this.mConnectedDevices;
                    synchronized (hashMap) {
                        AudioService.this.makeA2dpDeviceUnavailableNow((String)msg.obj);
                        break;
                    }
                }
                case 10: {
                    this.setForceUse(msg.arg1, msg.arg2);
                    break;
                }
                case 11: {
                    this.onHandlePersistMediaButtonReceiver((ComponentName)msg.obj);
                    break;
                }
                case 13: {
                    AudioService.this.onRcDisplayClear();
                    break;
                }
                case 14: {
                    AudioService.this.onRcDisplayUpdate((RemoteControlStackEntry)msg.obj, msg.arg1);
                    break;
                }
                case 12: {
                    AudioService.this.resetBluetoothSco();
                }
            }
        }
    }

    private class AudioSystemThread
    extends Thread {
        AudioSystemThread() {
            super(AudioService.TAG);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Looper.prepare();
            AudioService audioService = AudioService.this;
            synchronized (audioService) {
                AudioService.this.mAudioHandler = new AudioHandler();
                AudioService.this.notify();
            }
            Looper.loop();
        }
    }

    public class VolumeStreamState {
        private final int mStreamType;
        private String mVolumeIndexSettingName;
        private String mLastAudibleVolumeIndexSettingName;
        private int mIndexMax;
        private int mIndex;
        private int mLastAudibleIndex;
        private ArrayList<VolumeDeathHandler> mDeathHandlers;

        private VolumeStreamState(String settingName, int streamType) {
            this.setVolumeIndexSettingName(settingName);
            this.mStreamType = streamType;
            ContentResolver cr = AudioService.this.mContentResolver;
            this.mIndexMax = AudioService.this.MAX_STREAM_VOLUME[streamType];
            this.mIndex = Settings.System.getInt(cr, this.mVolumeIndexSettingName, AudioManager.DEFAULT_STREAM_VOLUME[streamType]);
            this.mLastAudibleIndex = Settings.System.getInt(cr, this.mLastAudibleVolumeIndexSettingName, this.mIndex > 0 ? this.mIndex : AudioManager.DEFAULT_STREAM_VOLUME[streamType]);
            AudioSystem.initStreamVolume(streamType, 0, this.mIndexMax);
            this.mIndexMax *= 10;
            this.mIndex = this.getValidIndex(10 * this.mIndex);
            this.mLastAudibleIndex = this.getValidIndex(10 * this.mLastAudibleIndex);
            AudioService.this.setStreamVolumeIndex(streamType, this.mIndex);
            this.mDeathHandlers = new ArrayList();
        }

        public void setVolumeIndexSettingName(String settingName) {
            this.mVolumeIndexSettingName = settingName;
            this.mLastAudibleVolumeIndexSettingName = settingName + "_last_audible";
        }

        public boolean adjustIndex(int deltaIndex) {
            return this.setIndex(this.mIndex + deltaIndex * 10, true);
        }

        public boolean setIndex(int index, boolean lastAudible) {
            int oldIndex = this.mIndex;
            this.mIndex = this.getValidIndex(index);
            if (oldIndex != this.mIndex) {
                if (lastAudible) {
                    this.mLastAudibleIndex = this.mIndex;
                }
                int numStreamTypes = AudioSystem.getNumStreamTypes();
                for (int streamType = numStreamTypes - 1; streamType >= 0; --streamType) {
                    if (streamType == this.mStreamType || AudioService.this.STREAM_VOLUME_ALIAS[streamType] != this.mStreamType) continue;
                    AudioService.this.mStreamStates[streamType].setIndex(AudioService.this.rescaleIndex(this.mIndex, this.mStreamType, streamType), lastAudible);
                }
                return true;
            }
            return false;
        }

        public void setLastAudibleIndex(int index) {
            this.mLastAudibleIndex = this.getValidIndex(index);
        }

        public void adjustLastAudibleIndex(int deltaIndex) {
            this.setLastAudibleIndex(this.mLastAudibleIndex + deltaIndex * 10);
        }

        public int getMaxIndex() {
            return this.mIndexMax;
        }

        public void mute(IBinder cb, boolean state) {
            VolumeDeathHandler handler = this.getDeathHandler(cb, state);
            if (handler == null) {
                Log.e(AudioService.TAG, "Could not get client death handler for stream: " + this.mStreamType);
                return;
            }
            handler.mute(state);
        }

        private int getValidIndex(int index) {
            if (index < 0) {
                return 0;
            }
            if (index > this.mIndexMax) {
                return this.mIndexMax;
            }
            return index;
        }

        private int muteCount() {
            int count = 0;
            int size = this.mDeathHandlers.size();
            for (int i = 0; i < size; ++i) {
                count += this.mDeathHandlers.get(i).mMuteCount;
            }
            return count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private VolumeDeathHandler getDeathHandler(IBinder cb, boolean state) {
            ArrayList<VolumeDeathHandler> arrayList = this.mDeathHandlers;
            synchronized (arrayList) {
                VolumeDeathHandler handler;
                int size = this.mDeathHandlers.size();
                for (int i = 0; i < size; ++i) {
                    handler = this.mDeathHandlers.get(i);
                    if (cb != handler.mICallback) continue;
                    return handler;
                }
                if (state) {
                    handler = new VolumeDeathHandler(cb);
                } else {
                    Log.w(AudioService.TAG, "stream was not muted by this client");
                    handler = null;
                }
                return handler;
            }
        }

        private class VolumeDeathHandler
        implements IBinder.DeathRecipient {
            private IBinder mICallback;
            private int mMuteCount;

            VolumeDeathHandler(IBinder cb) {
                this.mICallback = cb;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public void mute(boolean state) {
                var2_2 = VolumeStreamState.access$1700(VolumeStreamState.this);
                synchronized (var2_2) {
                    if (state) {
                        if (this.mMuteCount == 0) {
                            try {
                                if (this.mICallback != null) {
                                    this.mICallback.linkToDeath(this, 0);
                                }
                                VolumeStreamState.access$1700(VolumeStreamState.this).add(this);
                                if (VolumeStreamState.access$900(VolumeStreamState.this) != 0) ** GOTO lbl22
                                VolumeStreamState.this.setIndex(0, false);
                                AudioService.access$200(AudioService.access$100(AudioService.this), 0, VolumeStreamState.access$3500(VolumeStreamState.this), 1, 0, 0, VolumeStreamState.this, 0);
                            }
                            catch (RemoteException e) {
                                this.binderDied();
                                VolumeStreamState.access$1700(VolumeStreamState.this).notify();
                                return;
                            }
                        } else {
                            Log.w("AudioService", "stream: " + VolumeStreamState.access$3500(VolumeStreamState.this) + " was already muted by this client");
                        }
lbl22:
                        // 3 sources

                        ++this.mMuteCount;
                    } else if (this.mMuteCount == 0) {
                        Log.e("AudioService", "unexpected unmute for stream: " + VolumeStreamState.access$3500(VolumeStreamState.this));
                    } else {
                        --this.mMuteCount;
                        if (this.mMuteCount == 0) {
                            VolumeStreamState.access$1700(VolumeStreamState.this).remove(this);
                            if (this.mICallback != null) {
                                this.mICallback.unlinkToDeath(this, 0);
                            }
                            if (!(VolumeStreamState.access$900(VolumeStreamState.this) != 0 || AudioService.this.isStreamAffectedByRingerMode(VolumeStreamState.access$3500(VolumeStreamState.this)) && AudioService.access$3600(AudioService.this) != 2)) {
                                VolumeStreamState.this.setIndex(VolumeStreamState.access$800(VolumeStreamState.this), false);
                                AudioService.access$200(AudioService.access$100(AudioService.this), 0, VolumeStreamState.access$3500(VolumeStreamState.this), 1, 0, 0, VolumeStreamState.this, 0);
                            }
                        }
                    }
                    VolumeStreamState.access$1700(VolumeStreamState.this).notify();
                }
            }

            public void binderDied() {
                Log.w(AudioService.TAG, "Volume service client died for stream: " + VolumeStreamState.this.mStreamType);
                if (this.mMuteCount != 0) {
                    this.mMuteCount = 1;
                    this.mute(false);
                }
            }
        }
    }

    private class ScoClient
    implements IBinder.DeathRecipient {
        private IBinder mCb;
        private int mCreatorPid;
        private int mStartcount;

        ScoClient(IBinder cb) {
            this.mCb = cb;
            this.mCreatorPid = Binder.getCallingPid();
            this.mStartcount = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void binderDied() {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                Log.w(AudioService.TAG, "SCO client died");
                int index = AudioService.this.mScoClients.indexOf(this);
                if (index < 0) {
                    Log.w(AudioService.TAG, "unregistered SCO client died");
                } else {
                    this.clearCount(true);
                    AudioService.this.mScoClients.remove(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void incCount() {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                this.requestScoState(12);
                if (this.mStartcount == 0) {
                    try {
                        this.mCb.linkToDeath(this, 0);
                    }
                    catch (RemoteException e) {
                        Log.w(AudioService.TAG, "ScoClient  incCount() could not link to " + this.mCb + " binder death");
                    }
                }
                ++this.mStartcount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void decCount() {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                if (this.mStartcount == 0) {
                    Log.w(AudioService.TAG, "ScoClient.decCount() already 0");
                } else {
                    --this.mStartcount;
                    if (this.mStartcount == 0) {
                        try {
                            this.mCb.unlinkToDeath(this, 0);
                        }
                        catch (NoSuchElementException e) {
                            Log.w(AudioService.TAG, "decCount() going to 0 but not registered to binder");
                        }
                    }
                    this.requestScoState(10);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearCount(boolean stopSco) {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                if (this.mStartcount != 0) {
                    try {
                        this.mCb.unlinkToDeath(this, 0);
                    }
                    catch (NoSuchElementException e) {
                        Log.w(AudioService.TAG, "clearCount() mStartcount: " + this.mStartcount + " != 0 but not registered to binder");
                    }
                }
                this.mStartcount = 0;
                if (stopSco) {
                    this.requestScoState(10);
                }
            }
        }

        public int getCount() {
            return this.mStartcount;
        }

        public IBinder getBinder() {
            return this.mCb;
        }

        public int getPid() {
            return this.mCreatorPid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int totalCount() {
            ArrayList arrayList = AudioService.this.mScoClients;
            synchronized (arrayList) {
                int count = 0;
                int size = AudioService.this.mScoClients.size();
                for (int i = 0; i < size; ++i) {
                    count += ((ScoClient)AudioService.this.mScoClients.get(i)).getCount();
                }
                return count;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void requestScoState(int state) {
            AudioService.this.checkScoAudioState();
            if (this.totalCount() == 0) {
                if (state == 12) {
                    AudioService.this.broadcastScoConnectionState(2);
                    ArrayList arrayList = AudioService.this.mSetModeDeathHandlers;
                    synchronized (arrayList) {
                        if (!(!AudioService.this.mSetModeDeathHandlers.isEmpty() && ((SetModeDeathHandler)AudioService.this.mSetModeDeathHandlers.get(0)).getPid() != this.mCreatorPid || AudioService.this.mScoAudioState != 0 && AudioService.this.mScoAudioState != 5)) {
                            if (AudioService.this.mScoAudioState == 0) {
                                if (AudioService.this.mBluetoothHeadset != null && AudioService.this.mBluetoothHeadsetDevice != null) {
                                    if (AudioService.this.mBluetoothHeadset.startScoUsingVirtualVoiceCall(AudioService.this.mBluetoothHeadsetDevice)) {
                                        AudioService.this.mScoAudioState = 3;
                                    } else {
                                        AudioService.this.broadcastScoConnectionState(0);
                                    }
                                } else if (AudioService.this.getBluetoothHeadset()) {
                                    AudioService.this.mScoAudioState = 1;
                                }
                            } else {
                                AudioService.this.mScoAudioState = 3;
                                AudioService.this.broadcastScoConnectionState(1);
                            }
                        } else {
                            AudioService.this.broadcastScoConnectionState(0);
                        }
                    }
                } else if (state == 10 && (AudioService.this.mScoAudioState == 3 || AudioService.this.mScoAudioState == 1)) {
                    if (AudioService.this.mScoAudioState == 3) {
                        if (AudioService.this.mBluetoothHeadset != null && AudioService.this.mBluetoothHeadsetDevice != null) {
                            if (!AudioService.this.mBluetoothHeadset.stopScoUsingVirtualVoiceCall(AudioService.this.mBluetoothHeadsetDevice)) {
                                AudioService.this.mScoAudioState = 0;
                                AudioService.this.broadcastScoConnectionState(0);
                            }
                        } else if (AudioService.this.getBluetoothHeadset()) {
                            AudioService.this.mScoAudioState = 5;
                        }
                    } else {
                        AudioService.this.mScoAudioState = 0;
                        AudioService.this.broadcastScoConnectionState(0);
                    }
                }
            }
        }
    }

    private class SoundPoolCallback
    implements SoundPool.OnLoadCompleteListener {
        int mStatus;
        int mLastSample;

        private SoundPoolCallback() {
        }

        public int status() {
            return this.mStatus;
        }

        public void setLastSample(int sample) {
            this.mLastSample = sample;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onLoadComplete(SoundPool soundPool, int sampleId, int status) {
            Object object = AudioService.this.mSoundEffectsLock;
            synchronized (object) {
                if (status != 0) {
                    this.mStatus = status;
                }
                if (sampleId == this.mLastSample) {
                    AudioService.this.mSoundEffectsLock.notify();
                }
            }
        }
    }

    class SoundPoolListenerThread
    extends Thread {
        public SoundPoolListenerThread() {
            super("SoundPoolListenerThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Looper.prepare();
            AudioService.this.mSoundPoolLooper = Looper.myLooper();
            Object object = AudioService.this.mSoundEffectsLock;
            synchronized (object) {
                if (AudioService.this.mSoundPool != null) {
                    AudioService.this.mSoundPoolCallBack = new SoundPoolCallback();
                    AudioService.this.mSoundPool.setOnLoadCompleteListener(AudioService.this.mSoundPoolCallBack);
                }
                AudioService.this.mSoundEffectsLock.notify();
            }
            Looper.loop();
        }
    }

    private class SetModeDeathHandler
    implements IBinder.DeathRecipient {
        private IBinder mCb;
        private int mPid;
        private int mMode = 0;

        SetModeDeathHandler(IBinder cb, int pid) {
            this.mCb = cb;
            this.mPid = pid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void binderDied() {
            int newModeOwnerPid = 0;
            ArrayList arrayList = AudioService.this.mSetModeDeathHandlers;
            synchronized (arrayList) {
                Log.w(AudioService.TAG, "setMode() client died");
                int index = AudioService.this.mSetModeDeathHandlers.indexOf(this);
                if (index < 0) {
                    Log.w(AudioService.TAG, "unregistered setMode() client died");
                } else {
                    newModeOwnerPid = AudioService.this.setModeInt(0, this.mCb, this.mPid);
                }
            }
            if (newModeOwnerPid != 0) {
                AudioService.this.disconnectBluetoothSco(newModeOwnerPid);
            }
        }

        public int getPid() {
            return this.mPid;
        }

        public void setMode(int mode) {
            this.mMode = mode;
        }

        public int getMode() {
            return this.mMode;
        }

        public IBinder getBinder() {
            return this.mCb;
        }
    }
}

