/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.os.Parcel;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class TimedText {
    private static final int FIRST_PUBLIC_KEY = 1;
    public static final int KEY_DISPLAY_FLAGS = 1;
    public static final int KEY_STYLE_FLAGS = 2;
    public static final int KEY_BACKGROUND_COLOR_RGBA = 3;
    public static final int KEY_HIGHLIGHT_COLOR_RGBA = 4;
    public static final int KEY_SCROLL_DELAY = 5;
    public static final int KEY_WRAP_TEXT = 6;
    public static final int KEY_START_TIME = 7;
    public static final int KEY_STRUCT_BLINKING_TEXT_LIST = 8;
    public static final int KEY_STRUCT_FONT_LIST = 9;
    public static final int KEY_STRUCT_HIGHLIGHT_LIST = 10;
    public static final int KEY_STRUCT_HYPER_TEXT_LIST = 11;
    public static final int KEY_STRUCT_KARAOKE_LIST = 12;
    public static final int KEY_STRUCT_STYLE_LIST = 13;
    public static final int KEY_STRUCT_TEXT_POS = 14;
    public static final int KEY_STRUCT_JUSTIFICATION = 15;
    public static final int KEY_STRUCT_TEXT = 16;
    private static final int LAST_PUBLIC_KEY = 16;
    private static final int FIRST_PRIVATE_KEY = 101;
    private static final int KEY_GLOBAL_SETTING = 101;
    private static final int KEY_LOCAL_SETTING = 102;
    private static final int KEY_START_CHAR = 103;
    private static final int KEY_END_CHAR = 104;
    private static final int KEY_FONT_ID = 105;
    private static final int KEY_FONT_SIZE = 106;
    private static final int KEY_TEXT_COLOR_RGBA = 107;
    private static final int LAST_PRIVATE_KEY = 107;
    private static final String TAG = "TimedText";
    private Parcel mParcel = Parcel.obtain();
    private final HashMap<Integer, Object> mKeyObjectMap = new HashMap();
    private int mDisplayFlags = -1;
    private int mBackgroundColorRGBA = -1;
    private int mHighlightColorRGBA = -1;
    private int mScrollDelay = -1;
    private int mWrapText = -1;
    private List<CharPos> mBlinkingPosList = null;
    private List<CharPos> mHighlightPosList = null;
    private List<Karaoke> mKaraokeList = null;
    private List<Font> mFontList = null;
    private List<Style> mStyleList = null;
    private List<HyperText> mHyperTextList = null;
    private TextPos mTextPos;
    private Justification mJustification;
    private Text mTextStruct;

    public TimedText(byte[] obj) {
        this.mParcel.unmarshall(obj, 0, obj.length);
        if (!this.parseParcel()) {
            this.mKeyObjectMap.clear();
            throw new IllegalArgumentException("parseParcel() fails");
        }
    }

    private boolean parseParcel() {
        this.mParcel.setDataPosition(0);
        if (this.mParcel.dataAvail() == 0) {
            return false;
        }
        int type = this.mParcel.readInt();
        if (type == 102) {
            type = this.mParcel.readInt();
            if (type != 7) {
                return false;
            }
            int mStartTimeMs = this.mParcel.readInt();
            this.mKeyObjectMap.put(type, mStartTimeMs);
            type = this.mParcel.readInt();
            if (type != 16) {
                return false;
            }
            this.mTextStruct = new Text();
            this.mTextStruct.textLen = this.mParcel.readInt();
            this.mTextStruct.text = this.mParcel.createByteArray();
            this.mKeyObjectMap.put(type, this.mTextStruct);
        } else if (type != 101) {
            Log.w(TAG, "Invalid timed text key found: " + type);
            return false;
        }
        while (this.mParcel.dataAvail() > 0) {
            int key = this.mParcel.readInt();
            if (!this.isValidKey(key)) {
                Log.w(TAG, "Invalid timed text key found: " + key);
                return false;
            }
            Object object = null;
            switch (key) {
                case 13: {
                    this.readStyle();
                    object = this.mStyleList;
                    break;
                }
                case 9: {
                    this.readFont();
                    object = this.mFontList;
                    break;
                }
                case 10: {
                    this.readHighlight();
                    object = this.mHighlightPosList;
                    break;
                }
                case 12: {
                    this.readKaraoke();
                    object = this.mKaraokeList;
                    break;
                }
                case 11: {
                    this.readHyperText();
                    object = this.mHyperTextList;
                    break;
                }
                case 8: {
                    this.readBlinkingText();
                    object = this.mBlinkingPosList;
                    break;
                }
                case 6: {
                    this.mWrapText = this.mParcel.readInt();
                    object = this.mWrapText;
                    break;
                }
                case 4: {
                    this.mHighlightColorRGBA = this.mParcel.readInt();
                    object = this.mHighlightColorRGBA;
                    break;
                }
                case 1: {
                    this.mDisplayFlags = this.mParcel.readInt();
                    object = this.mDisplayFlags;
                    break;
                }
                case 15: {
                    this.mJustification = new Justification();
                    this.mJustification.horizontalJustification = this.mParcel.readInt();
                    this.mJustification.verticalJustification = this.mParcel.readInt();
                    object = this.mJustification;
                    break;
                }
                case 3: {
                    this.mBackgroundColorRGBA = this.mParcel.readInt();
                    object = this.mBackgroundColorRGBA;
                    break;
                }
                case 14: {
                    this.mTextPos = new TextPos();
                    this.mTextPos.top = this.mParcel.readInt();
                    this.mTextPos.left = this.mParcel.readInt();
                    this.mTextPos.bottom = this.mParcel.readInt();
                    this.mTextPos.right = this.mParcel.readInt();
                    object = this.mTextPos;
                    break;
                }
                case 5: {
                    this.mScrollDelay = this.mParcel.readInt();
                    object = this.mScrollDelay;
                    break;
                }
            }
            if (object == null) continue;
            if (this.mKeyObjectMap.containsKey(key)) {
                this.mKeyObjectMap.remove(key);
            }
            this.mKeyObjectMap.put(key, object);
        }
        this.mParcel.recycle();
        return true;
    }

    private void readStyle() {
        Style style2 = new Style();
        boolean endOfStyle = false;
        block8: while (!endOfStyle && this.mParcel.dataAvail() > 0) {
            int key = this.mParcel.readInt();
            switch (key) {
                case 103: {
                    style2.startChar = this.mParcel.readInt();
                    continue block8;
                }
                case 104: {
                    style2.endChar = this.mParcel.readInt();
                    continue block8;
                }
                case 105: {
                    style2.fontID = this.mParcel.readInt();
                    continue block8;
                }
                case 2: {
                    int flags = this.mParcel.readInt();
                    style2.isBold = flags % 2 == 1;
                    style2.isItalic = flags % 4 >= 2;
                    style2.isUnderlined = flags / 4 == 1;
                    continue block8;
                }
                case 106: {
                    style2.fontSize = this.mParcel.readInt();
                    continue block8;
                }
                case 107: {
                    style2.colorRGBA = this.mParcel.readInt();
                    continue block8;
                }
            }
            this.mParcel.setDataPosition(this.mParcel.dataPosition() - 4);
            endOfStyle = true;
        }
        if (this.mStyleList == null) {
            this.mStyleList = new ArrayList<Style>();
        }
        this.mStyleList.add(style2);
    }

    private void readFont() {
        int entryCount = this.mParcel.readInt();
        for (int i = 0; i < entryCount; ++i) {
            Font font = new Font();
            font.ID = this.mParcel.readInt();
            int nameLen = this.mParcel.readInt();
            byte[] text = this.mParcel.createByteArray();
            font.name = new String(text, 0, nameLen);
            if (this.mFontList == null) {
                this.mFontList = new ArrayList<Font>();
            }
            this.mFontList.add(font);
        }
    }

    private void readHighlight() {
        CharPos pos = new CharPos();
        pos.startChar = this.mParcel.readInt();
        pos.endChar = this.mParcel.readInt();
        if (this.mHighlightPosList == null) {
            this.mHighlightPosList = new ArrayList<CharPos>();
        }
        this.mHighlightPosList.add(pos);
    }

    private void readKaraoke() {
        int entryCount = this.mParcel.readInt();
        for (int i = 0; i < entryCount; ++i) {
            Karaoke kara = new Karaoke();
            kara.startTimeMs = this.mParcel.readInt();
            kara.endTimeMs = this.mParcel.readInt();
            kara.startChar = this.mParcel.readInt();
            kara.endChar = this.mParcel.readInt();
            if (this.mKaraokeList == null) {
                this.mKaraokeList = new ArrayList<Karaoke>();
            }
            this.mKaraokeList.add(kara);
        }
    }

    private void readHyperText() {
        HyperText hyperText = new HyperText();
        hyperText.startChar = this.mParcel.readInt();
        hyperText.endChar = this.mParcel.readInt();
        int len = this.mParcel.readInt();
        byte[] url = this.mParcel.createByteArray();
        hyperText.URL = new String(url, 0, len);
        len = this.mParcel.readInt();
        byte[] alt = this.mParcel.createByteArray();
        hyperText.altString = new String(alt, 0, len);
        if (this.mHyperTextList == null) {
            this.mHyperTextList = new ArrayList<HyperText>();
        }
        this.mHyperTextList.add(hyperText);
    }

    private void readBlinkingText() {
        CharPos blinkingPos = new CharPos();
        blinkingPos.startChar = this.mParcel.readInt();
        blinkingPos.endChar = this.mParcel.readInt();
        if (this.mBlinkingPosList == null) {
            this.mBlinkingPosList = new ArrayList<CharPos>();
        }
        this.mBlinkingPosList.add(blinkingPos);
    }

    public boolean isValidKey(int key) {
        return key >= 1 && key <= 16 || key >= 101 && key <= 107;
    }

    public boolean containsKey(int key) {
        return this.isValidKey(key) && this.mKeyObjectMap.containsKey(key);
    }

    public Set keySet() {
        return this.mKeyObjectMap.keySet();
    }

    public Object getObject(int key) {
        if (this.containsKey(key)) {
            return this.mKeyObjectMap.get(key);
        }
        throw new IllegalArgumentException("Invalid key: " + key);
    }

    public class HyperText {
        public int startChar = -1;
        public int endChar = -1;
        public String URL;
        public String altString;
    }

    public class Karaoke {
        public int startTimeMs = -1;
        public int endTimeMs = -1;
        public int startChar = -1;
        public int endChar = -1;
    }

    public class Font {
        public int ID = -1;
        public String name;
    }

    public class Style {
        public int startChar = -1;
        public int endChar = -1;
        public int fontID = -1;
        public boolean isBold = false;
        public boolean isItalic = false;
        public boolean isUnderlined = false;
        public int fontSize = -1;
        public int colorRGBA = -1;
    }

    public class Justification {
        public int horizontalJustification = -1;
        public int verticalJustification = -1;
    }

    public class TextPos {
        public int top = -1;
        public int left = -1;
        public int bottom = -1;
        public int right = -1;
    }

    public class CharPos {
        public int startChar = -1;
        public int endChar = -1;
    }

    public class Text {
        public int textLen;
        public byte[] text;
    }
}

