/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.Credentials;
import android.net.LocalSocketAddress;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class LocalSocketImpl {
    private SocketInputStream fis;
    private SocketOutputStream fos;
    private Object readMonitor = new Object();
    private Object writeMonitor = new Object();
    private FileDescriptor fd;
    FileDescriptor[] inboundFileDescriptors;
    FileDescriptor[] outboundFileDescriptors;

    private int available_native(FileDescriptor fileDescriptor) throws IOException {
        return OverrideMethod.invokeI("android.net.LocalSocketImpl#available_native(Ljava/io/FileDescriptor;)I", true, this);
    }

    private void close_native(FileDescriptor fileDescriptor) throws IOException {
        OverrideMethod.invokeV("android.net.LocalSocketImpl#close_native(Ljava/io/FileDescriptor;)V", true, this);
    }

    private int read_native(FileDescriptor fileDescriptor) throws IOException {
        return OverrideMethod.invokeI("android.net.LocalSocketImpl#read_native(Ljava/io/FileDescriptor;)I", true, this);
    }

    private int readba_native(byte[] byArray, int n, int n2, FileDescriptor fileDescriptor) throws IOException {
        return OverrideMethod.invokeI("android.net.LocalSocketImpl#readba_native([BIILjava/io/FileDescriptor;)I", true, this);
    }

    private void writeba_native(byte[] byArray, int n, int n2, FileDescriptor fileDescriptor) throws IOException {
        OverrideMethod.invokeV("android.net.LocalSocketImpl#writeba_native([BIILjava/io/FileDescriptor;)V", true, this);
    }

    private void write_native(int n, FileDescriptor fileDescriptor) throws IOException {
        OverrideMethod.invokeV("android.net.LocalSocketImpl#write_native(ILjava/io/FileDescriptor;)V", true, this);
    }

    private void connectLocal(FileDescriptor fileDescriptor, String string2, int n) throws IOException {
        OverrideMethod.invokeV("android.net.LocalSocketImpl#connectLocal(Ljava/io/FileDescriptor;Ljava/lang/String;I)V", true, this);
    }

    private void bindLocal(FileDescriptor fileDescriptor, String string2, int n) throws IOException {
        OverrideMethod.invokeV("android.net.LocalSocketImpl#bindLocal(Ljava/io/FileDescriptor;Ljava/lang/String;I)V", true, this);
    }

    private FileDescriptor create_native(boolean bl) throws IOException {
        return (FileDescriptor)OverrideMethod.invokeA("android.net.LocalSocketImpl#create_native(Z)Ljava/io/FileDescriptor;", true, this);
    }

    private void listen_native(FileDescriptor fileDescriptor, int n) throws IOException {
        OverrideMethod.invokeV("android.net.LocalSocketImpl#listen_native(Ljava/io/FileDescriptor;I)V", true, this);
    }

    private void shutdown(FileDescriptor fileDescriptor, boolean bl) {
        OverrideMethod.invokeV("android.net.LocalSocketImpl#shutdown(Ljava/io/FileDescriptor;Z)V", true, this);
    }

    private Credentials getPeerCredentials_native(FileDescriptor fileDescriptor) throws IOException {
        return (Credentials)OverrideMethod.invokeA("android.net.LocalSocketImpl#getPeerCredentials_native(Ljava/io/FileDescriptor;)Landroid/net/Credentials;", true, this);
    }

    private int getOption_native(FileDescriptor fileDescriptor, int n) throws IOException {
        return OverrideMethod.invokeI("android.net.LocalSocketImpl#getOption_native(Ljava/io/FileDescriptor;I)I", true, this);
    }

    private void setOption_native(FileDescriptor fileDescriptor, int n, int n2, int n3) throws IOException {
        OverrideMethod.invokeV("android.net.LocalSocketImpl#setOption_native(Ljava/io/FileDescriptor;III)V", true, this);
    }

    private FileDescriptor accept(FileDescriptor fileDescriptor, LocalSocketImpl localSocketImpl) throws IOException {
        return (FileDescriptor)OverrideMethod.invokeA("android.net.LocalSocketImpl#accept(Ljava/io/FileDescriptor;Landroid/net/LocalSocketImpl;)Ljava/io/FileDescriptor;", true, this);
    }

    LocalSocketImpl() {
    }

    LocalSocketImpl(FileDescriptor fd) throws IOException {
        this.fd = fd;
    }

    public String toString() {
        return super.toString() + " fd:" + this.fd;
    }

    public void create(boolean stream) throws IOException {
        if (this.fd == null) {
            this.fd = this.create_native(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        LocalSocketImpl localSocketImpl = this;
        synchronized (localSocketImpl) {
            if (this.fd == null) {
                return;
            }
            this.close_native(this.fd);
            this.fd = null;
        }
    }

    protected void connect(LocalSocketAddress address, int timeout) throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        this.connectLocal(this.fd, address.getName(), address.getNamespace().getId());
    }

    public void bind(LocalSocketAddress endpoint) throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        this.bindLocal(this.fd, endpoint.getName(), endpoint.getNamespace().getId());
    }

    protected void listen(int backlog) throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        this.listen_native(this.fd, backlog);
    }

    protected void accept(LocalSocketImpl s) throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        s.fd = this.accept(this.fd, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getInputStream() throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        LocalSocketImpl localSocketImpl = this;
        synchronized (localSocketImpl) {
            if (this.fis == null) {
                this.fis = new SocketInputStream();
            }
            return this.fis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OutputStream getOutputStream() throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        LocalSocketImpl localSocketImpl = this;
        synchronized (localSocketImpl) {
            if (this.fos == null) {
                this.fos = new SocketOutputStream();
            }
            return this.fos;
        }
    }

    protected int available() throws IOException {
        return this.getInputStream().available();
    }

    protected void shutdownInput() throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        this.shutdown(this.fd, true);
    }

    protected void shutdownOutput() throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        this.shutdown(this.fd, false);
    }

    protected FileDescriptor getFileDescriptor() {
        return this.fd;
    }

    protected boolean supportsUrgentData() {
        return false;
    }

    protected void sendUrgentData(int data) throws IOException {
        throw new RuntimeException("not impled");
    }

    public Object getOption(int optID) throws IOException {
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        if (optID == 4102) {
            return 0;
        }
        int value = this.getOption_native(this.fd, optID);
        switch (optID) {
            case 4097: 
            case 4098: {
                return value;
            }
        }
        return value;
    }

    public void setOption(int optID, Object value) throws IOException {
        int boolValue = -1;
        int intValue = 0;
        if (this.fd == null) {
            throw new IOException("socket not created");
        }
        if (value instanceof Integer) {
            intValue = (Integer)value;
        } else if (value instanceof Boolean) {
            boolValue = (Boolean)value != false ? 1 : 0;
        } else {
            throw new IOException("bad value: " + value);
        }
        this.setOption_native(this.fd, optID, boolValue, intValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFileDescriptorsForSend(FileDescriptor[] fds) {
        Object object = this.writeMonitor;
        synchronized (object) {
            this.outboundFileDescriptors = fds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileDescriptor[] getAncillaryFileDescriptors() throws IOException {
        Object object = this.readMonitor;
        synchronized (object) {
            FileDescriptor[] result = this.inboundFileDescriptors;
            this.inboundFileDescriptors = null;
            return result;
        }
    }

    public Credentials getPeerCredentials() throws IOException {
        return this.getPeerCredentials_native(this.fd);
    }

    public LocalSocketAddress getSockAddress() throws IOException {
        return null;
    }

    protected void finalize() throws IOException {
        this.close();
    }

    class SocketOutputStream
    extends OutputStream {
        SocketOutputStream() {
        }

        public void close() throws IOException {
            LocalSocketImpl.this.close();
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] b, int off, int len) throws IOException {
            Object object = LocalSocketImpl.this.writeMonitor;
            synchronized (object) {
                FileDescriptor myFd = LocalSocketImpl.this.fd;
                if (myFd == null) {
                    throw new IOException("socket closed");
                }
                if (off < 0 || len < 0 || off + len > b.length) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                LocalSocketImpl.this.writeba_native(b, off, len, myFd);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(int b) throws IOException {
            Object object = LocalSocketImpl.this.writeMonitor;
            synchronized (object) {
                FileDescriptor myFd = LocalSocketImpl.this.fd;
                if (myFd == null) {
                    throw new IOException("socket closed");
                }
                LocalSocketImpl.this.write_native(b, myFd);
            }
        }
    }

    class SocketInputStream
    extends InputStream {
        SocketInputStream() {
        }

        public int available() throws IOException {
            return LocalSocketImpl.this.available_native(LocalSocketImpl.this.fd);
        }

        public void close() throws IOException {
            LocalSocketImpl.this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            Object object = LocalSocketImpl.this.readMonitor;
            synchronized (object) {
                FileDescriptor myFd = LocalSocketImpl.this.fd;
                if (myFd == null) {
                    throw new IOException("socket closed");
                }
                int ret = LocalSocketImpl.this.read_native(myFd);
                return ret;
            }
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] b, int off, int len) throws IOException {
            Object object = LocalSocketImpl.this.readMonitor;
            synchronized (object) {
                FileDescriptor myFd = LocalSocketImpl.this.fd;
                if (myFd == null) {
                    throw new IOException("socket closed");
                }
                if (off < 0 || len < 0 || off + len > b.length) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                int ret = LocalSocketImpl.this.readba_native(b, off, len, myFd);
                return ret;
            }
        }
    }
}

