/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.res.Resources;
import android.net.NetworkIdentity;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.TelephonyManager;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.Objects;

public class NetworkTemplate
implements Parcelable {
    public static final int MATCH_MOBILE_ALL = 1;
    public static final int MATCH_MOBILE_3G_LOWER = 2;
    public static final int MATCH_MOBILE_4G = 3;
    public static final int MATCH_WIFI = 4;
    public static final int MATCH_ETHERNET = 5;
    private static final int[] DATA_USAGE_NETWORK_TYPES = Resources.getSystem().getIntArray(17235990);
    private final int mMatchRule;
    private final String mSubscriberId;
    public static final Parcelable.Creator<NetworkTemplate> CREATOR = new Parcelable.Creator<NetworkTemplate>(){

        @Override
        public NetworkTemplate createFromParcel(Parcel in) {
            return new NetworkTemplate(in);
        }

        public NetworkTemplate[] newArray(int size) {
            return new NetworkTemplate[size];
        }
    };

    public static NetworkTemplate buildTemplateMobileAll(String subscriberId) {
        return new NetworkTemplate(1, subscriberId);
    }

    public static NetworkTemplate buildTemplateMobile3gLower(String subscriberId) {
        return new NetworkTemplate(2, subscriberId);
    }

    public static NetworkTemplate buildTemplateMobile4g(String subscriberId) {
        return new NetworkTemplate(3, subscriberId);
    }

    public static NetworkTemplate buildTemplateWifi() {
        return new NetworkTemplate(4, null);
    }

    public static NetworkTemplate buildTemplateEthernet() {
        return new NetworkTemplate(5, null);
    }

    public NetworkTemplate(int matchRule, String subscriberId) {
        this.mMatchRule = matchRule;
        this.mSubscriberId = subscriberId;
    }

    private NetworkTemplate(Parcel in) {
        this.mMatchRule = in.readInt();
        this.mSubscriberId = in.readString();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mMatchRule);
        dest.writeString(this.mSubscriberId);
    }

    public int describeContents() {
        return 0;
    }

    public String toString() {
        String scrubSubscriberId = NetworkIdentity.scrubSubscriberId(this.mSubscriberId);
        return "NetworkTemplate: matchRule=" + NetworkTemplate.getMatchRuleName(this.mMatchRule) + ", subscriberId=" + scrubSubscriberId;
    }

    public int hashCode() {
        return Objects.hashCode(this.mMatchRule, this.mSubscriberId);
    }

    public boolean equals(Object obj) {
        if (obj instanceof NetworkTemplate) {
            NetworkTemplate other = (NetworkTemplate)obj;
            return this.mMatchRule == other.mMatchRule && Objects.equal(this.mSubscriberId, other.mSubscriberId);
        }
        return false;
    }

    public int getMatchRule() {
        return this.mMatchRule;
    }

    public String getSubscriberId() {
        return this.mSubscriberId;
    }

    public boolean matches(NetworkIdentity ident) {
        switch (this.mMatchRule) {
            case 1: {
                return this.matchesMobile(ident);
            }
            case 2: {
                return this.matchesMobile3gLower(ident);
            }
            case 3: {
                return this.matchesMobile4g(ident);
            }
            case 4: {
                return this.matchesWifi(ident);
            }
            case 5: {
                return this.matchesEthernet(ident);
            }
        }
        throw new IllegalArgumentException("unknown network template");
    }

    private boolean matchesMobile(NetworkIdentity ident) {
        if (ident.mType == 6) {
            return true;
        }
        return ArrayUtils.contains(DATA_USAGE_NETWORK_TYPES, ident.mType) && Objects.equal(this.mSubscriberId, ident.mSubscriberId);
    }

    private boolean matchesMobile3gLower(NetworkIdentity ident) {
        if (ident.mType == 6) {
            return false;
        }
        if (this.matchesMobile(ident)) {
            switch (TelephonyManager.getNetworkClass(ident.mSubType)) {
                case 0: 
                case 1: 
                case 2: {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean matchesMobile4g(NetworkIdentity ident) {
        if (ident.mType == 6) {
            return true;
        }
        if (this.matchesMobile(ident)) {
            switch (TelephonyManager.getNetworkClass(ident.mSubType)) {
                case 3: {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean matchesWifi(NetworkIdentity ident) {
        return ident.mType == 1;
    }

    private boolean matchesEthernet(NetworkIdentity ident) {
        return ident.mType == 9;
    }

    private static String getMatchRuleName(int matchRule) {
        switch (matchRule) {
            case 2: {
                return "MOBILE_3G_LOWER";
            }
            case 3: {
                return "MOBILE_4G";
            }
            case 1: {
                return "MOBILE_ALL";
            }
            case 4: {
                return "WIFI";
            }
            case 5: {
                return "ETHERNET";
            }
        }
        return "UNKNOWN";
    }
}

