/*
 * Decompiled with CFR 0.152.
 */
package android.net.sip;

import android.net.sip.ISipSessionListener;
import android.net.sip.SipProfile;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ISipSession
extends IInterface {
    public String getLocalIp() throws RemoteException;

    public SipProfile getLocalProfile() throws RemoteException;

    public SipProfile getPeerProfile() throws RemoteException;

    public int getState() throws RemoteException;

    public boolean isInCall() throws RemoteException;

    public String getCallId() throws RemoteException;

    public void setListener(ISipSessionListener var1) throws RemoteException;

    public void register(int var1) throws RemoteException;

    public void unregister() throws RemoteException;

    public void makeCall(SipProfile var1, String var2, int var3) throws RemoteException;

    public void answerCall(String var1, int var2) throws RemoteException;

    public void endCall() throws RemoteException;

    public void changeCall(String var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISipSession {
        private static final String DESCRIPTOR = "android.net.sip.ISipSession";
        static final int TRANSACTION_getLocalIp = 1;
        static final int TRANSACTION_getLocalProfile = 2;
        static final int TRANSACTION_getPeerProfile = 3;
        static final int TRANSACTION_getState = 4;
        static final int TRANSACTION_isInCall = 5;
        static final int TRANSACTION_getCallId = 6;
        static final int TRANSACTION_setListener = 7;
        static final int TRANSACTION_register = 8;
        static final int TRANSACTION_unregister = 9;
        static final int TRANSACTION_makeCall = 10;
        static final int TRANSACTION_answerCall = 11;
        static final int TRANSACTION_endCall = 12;
        static final int TRANSACTION_changeCall = 13;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ISipSession asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ISipSession) {
                return (ISipSession)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    data.enforceInterface(DESCRIPTOR);
                    String _result = this.getLocalIp();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 2: {
                    data.enforceInterface(DESCRIPTOR);
                    SipProfile _result = this.getLocalProfile();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 3: {
                    data.enforceInterface(DESCRIPTOR);
                    SipProfile _result = this.getPeerProfile();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 4: {
                    data.enforceInterface(DESCRIPTOR);
                    int _result = this.getState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 5: {
                    data.enforceInterface(DESCRIPTOR);
                    boolean _result = this.isInCall();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 6: {
                    data.enforceInterface(DESCRIPTOR);
                    String _result = this.getCallId();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 7: {
                    data.enforceInterface(DESCRIPTOR);
                    ISipSessionListener _arg0 = ISipSessionListener.Stub.asInterface(data.readStrongBinder());
                    this.setListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 8: {
                    data.enforceInterface(DESCRIPTOR);
                    int _arg0 = data.readInt();
                    this.register(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 9: {
                    data.enforceInterface(DESCRIPTOR);
                    this.unregister();
                    reply.writeNoException();
                    return true;
                }
                case 10: {
                    data.enforceInterface(DESCRIPTOR);
                    SipProfile _arg0 = 0 != data.readInt() ? SipProfile.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    this.makeCall(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 11: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    this.answerCall(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 12: {
                    data.enforceInterface(DESCRIPTOR);
                    this.endCall();
                    reply.writeNoException();
                    return true;
                }
                case 13: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    this.changeCall(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy
        implements ISipSession {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String getLocalIp() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public SipProfile getLocalProfile() throws RemoteException {
                SipProfile _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? SipProfile.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public SipProfile getPeerProfile() throws RemoteException {
                SipProfile _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? SipProfile.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int getState() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean isInCall() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String getCallId() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setListener(ISipSessionListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void register(int duration) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(duration);
                    this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void unregister() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void makeCall(SipProfile callee, String sessionDescription, int timeout) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (callee != null) {
                        _data.writeInt(1);
                        callee.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(sessionDescription);
                    _data.writeInt(timeout);
                    this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void answerCall(String sessionDescription, int timeout) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(sessionDescription);
                    _data.writeInt(timeout);
                    this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void endCall() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void changeCall(String sessionDescription, int timeout) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(sessionDescription);
                    _data.writeInt(timeout);
                    this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }
}

