/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p;

import android.net.wifi.p2p.WifiP2pDevice;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WifiP2pDeviceList
implements Parcelable {
    private Collection<WifiP2pDevice> mDevices;
    public static final Parcelable.Creator<WifiP2pDeviceList> CREATOR = new Parcelable.Creator<WifiP2pDeviceList>(){

        @Override
        public WifiP2pDeviceList createFromParcel(Parcel in) {
            WifiP2pDeviceList deviceList = new WifiP2pDeviceList();
            int deviceCount = in.readInt();
            for (int i = 0; i < deviceCount; ++i) {
                deviceList.update((WifiP2pDevice)in.readParcelable(null));
            }
            return deviceList;
        }

        public WifiP2pDeviceList[] newArray(int size) {
            return new WifiP2pDeviceList[size];
        }
    };

    public WifiP2pDeviceList() {
        this.mDevices = new ArrayList<WifiP2pDevice>();
    }

    public WifiP2pDeviceList(WifiP2pDeviceList source) {
        if (source != null) {
            this.mDevices = source.getDeviceList();
        }
    }

    public WifiP2pDeviceList(ArrayList<WifiP2pDevice> devices) {
        this.mDevices = new ArrayList<WifiP2pDevice>();
        for (WifiP2pDevice device : devices) {
            this.mDevices.add(device);
        }
    }

    public boolean clear() {
        if (this.mDevices.isEmpty()) {
            return false;
        }
        this.mDevices.clear();
        return true;
    }

    public void update(WifiP2pDevice device) {
        if (device == null) {
            return;
        }
        for (WifiP2pDevice d : this.mDevices) {
            if (!d.equals(device)) continue;
            d.deviceName = device.deviceName;
            d.primaryDeviceType = device.primaryDeviceType;
            d.secondaryDeviceType = device.secondaryDeviceType;
            d.wpsConfigMethodsSupported = device.wpsConfigMethodsSupported;
            d.deviceCapability = device.deviceCapability;
            d.groupCapability = device.groupCapability;
            return;
        }
        this.mDevices.add(device);
    }

    public boolean remove(WifiP2pDevice device) {
        if (device == null) {
            return false;
        }
        return this.mDevices.remove(device);
    }

    public Collection<WifiP2pDevice> getDeviceList() {
        return Collections.unmodifiableCollection(this.mDevices);
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        for (WifiP2pDevice device : this.mDevices) {
            sbuf.append("\n").append(device);
        }
        return sbuf.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mDevices.size());
        for (WifiP2pDevice device : this.mDevices) {
            dest.writeParcelable(device, flags);
        }
    }
}

