/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.graphics.Paint;
import android.text.AndroidBidi;
import android.text.Spanned;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.MetricAffectingSpan;
import android.text.style.ReplacementSpan;
import com.android.internal.util.ArrayUtils;

class MeasuredText {
    private static final boolean localLOGV = false;
    CharSequence mText;
    int mTextStart;
    float[] mWidths;
    char[] mChars;
    byte[] mLevels;
    int mDir;
    boolean mEasy;
    int mLen;
    private int mPos;
    private TextPaint mWorkPaint = new TextPaint();
    private static final Object[] sLock = new Object[0];
    private static MeasuredText[] sCached = new MeasuredText[3];

    private MeasuredText() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MeasuredText obtain() {
        Object[] objectArray = sLock;
        synchronized (sLock) {
            int i = sCached.length;
            while (--i >= 0) {
                if (sCached[i] == null) continue;
                MeasuredText mt = sCached[i];
                MeasuredText.sCached[i] = null;
                // ** MonitorExit[var1] (shouldn't be in output)
                return mt;
            }
            // ** MonitorExit[var1] (shouldn't be in output)
            MeasuredText mt = new MeasuredText();
            return mt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static MeasuredText recycle(MeasuredText mt) {
        mt.mText = null;
        if (mt.mLen >= 1000) return null;
        Object[] objectArray = sLock;
        synchronized (sLock) {
            for (int i = 0; i < sCached.length; ++i) {
                if (sCached[i] != null) continue;
                MeasuredText.sCached[i] = mt;
                mt.mText = null;
                break;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    void setPara(CharSequence text, int start, int end, TextDirectionHeuristic textDir) {
        int len;
        this.mText = text;
        this.mTextStart = start;
        this.mLen = len = end - start;
        this.mPos = 0;
        if (this.mWidths == null || this.mWidths.length < len) {
            this.mWidths = new float[ArrayUtils.idealFloatArraySize(len)];
        }
        if (this.mChars == null || this.mChars.length < len) {
            this.mChars = new char[ArrayUtils.idealCharArraySize(len)];
        }
        TextUtils.getChars(text, start, end, this.mChars, 0);
        if (text instanceof Spanned) {
            Spanned spanned = (Spanned)text;
            ReplacementSpan[] spans = spanned.getSpans(start, end, ReplacementSpan.class);
            for (int i = 0; i < spans.length; ++i) {
                int startInPara = spanned.getSpanStart(spans[i]) - start;
                int endInPara = spanned.getSpanEnd(spans[i]) - start;
                for (int j = startInPara; j < endInPara; ++j) {
                    this.mChars[j] = 65532;
                }
            }
        }
        if ((textDir == TextDirectionHeuristics.LTR || textDir == TextDirectionHeuristics.FIRSTSTRONG_LTR || textDir == TextDirectionHeuristics.ANYRTL_LTR) && TextUtils.doesNotNeedBidi(this.mChars, 0, len)) {
            this.mDir = 1;
            this.mEasy = true;
        } else {
            boolean isRtl;
            if (this.mLevels == null || this.mLevels.length < len) {
                this.mLevels = new byte[ArrayUtils.idealByteArraySize(len)];
            }
            int bidiRequest = textDir == TextDirectionHeuristics.LTR ? 1 : (textDir == TextDirectionHeuristics.RTL ? -1 : (textDir == TextDirectionHeuristics.FIRSTSTRONG_LTR ? 2 : (textDir == TextDirectionHeuristics.FIRSTSTRONG_RTL ? -2 : ((isRtl = textDir.isRtl(this.mChars, 0, len)) ? -1 : 1))));
            this.mDir = AndroidBidi.bidi(bidiRequest, this.mChars, this.mLevels, len, false);
            this.mEasy = false;
        }
    }

    float addStyleRun(TextPaint paint, int len, Paint.FontMetricsInt fm) {
        if (fm != null) {
            paint.getFontMetricsInt(fm);
        }
        int p = this.mPos;
        this.mPos = p + len;
        if (this.mEasy) {
            int flags = this.mDir == 1 ? 0 : 1;
            return paint.getTextRunAdvances(this.mChars, p, len, p, len, flags, this.mWidths, p);
        }
        float totalAdvance = 0.0f;
        byte level = this.mLevels[p];
        int q = p;
        int i = p + 1;
        int e = p + len;
        while (true) {
            if (i == e || this.mLevels[i] != level) {
                int flags = (level & 1) == 0 ? 0 : 1;
                totalAdvance += paint.getTextRunAdvances(this.mChars, q, i - q, q, i - q, flags, this.mWidths, q);
                if (i == e) break;
                q = i;
                level = this.mLevels[i];
            }
            ++i;
        }
        return totalAdvance;
    }

    float addStyleRun(TextPaint paint, MetricAffectingSpan[] spans, int len, Paint.FontMetricsInt fm) {
        float wid;
        TextPaint workPaint = this.mWorkPaint;
        workPaint.set(paint);
        workPaint.baselineShift = 0;
        ReplacementSpan replacement = null;
        for (int i = 0; i < spans.length; ++i) {
            MetricAffectingSpan span = spans[i];
            if (span instanceof ReplacementSpan) {
                replacement = (ReplacementSpan)span;
                continue;
            }
            span.updateMeasureState(workPaint);
        }
        if (replacement == null) {
            wid = this.addStyleRun(workPaint, len, fm);
        } else {
            wid = replacement.getSize(workPaint, this.mText, this.mTextStart + this.mPos, this.mTextStart + this.mPos + len, fm);
            float[] w = this.mWidths;
            w[this.mPos] = wid;
            int e = this.mPos + len;
            for (int i = this.mPos + 1; i < e; ++i) {
                w[i] = 0.0f;
            }
            this.mPos += len;
        }
        if (fm != null) {
            if (workPaint.baselineShift < 0) {
                fm.ascent += workPaint.baselineShift;
                fm.top += workPaint.baselineShift;
            } else {
                fm.descent += workPaint.baselineShift;
                fm.bottom += workPaint.baselineShift;
            }
        }
        return wid;
    }

    int breakText(int start, int limit, boolean forwards, float width) {
        float[] w = this.mWidths;
        if (forwards) {
            for (int i = start; i < limit; ++i) {
                float f;
                width -= w[i];
                if (!(f < 0.0f)) continue;
                return i - start;
            }
        } else {
            int i = limit;
            while (--i >= start) {
                float f;
                width -= w[i];
                if (!(f < 0.0f)) continue;
                return limit - i - 1;
            }
        }
        return limit - start;
    }

    float measure(int start, int limit) {
        float width = 0.0f;
        float[] w = this.mWidths;
        for (int i = start; i < limit; ++i) {
            width += w[i];
        }
        return width;
    }
}

