/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.os.SystemProperties;

public class DisplayMetrics {
    public static final int DENSITY_LOW = 120;
    public static final int DENSITY_MEDIUM = 160;
    public static final int DENSITY_TV = 213;
    public static final int DENSITY_HIGH = 240;
    public static final int DENSITY_XHIGH = 320;
    public static final int DENSITY_DEFAULT = 160;
    public static final int DENSITY_DEVICE = DisplayMetrics.getDeviceDensity();
    public int widthPixels;
    public int heightPixels;
    public float density;
    public int densityDpi;
    public float scaledDensity;
    public float xdpi;
    public float ydpi;
    public int noncompatWidthPixels;
    public int noncompatHeightPixels;
    public float noncompatDensity;
    public float noncompatScaledDensity;
    public float noncompatXdpi;
    public float noncompatYdpi;

    public void setTo(DisplayMetrics o) {
        this.widthPixels = o.widthPixels;
        this.heightPixels = o.heightPixels;
        this.density = o.density;
        this.densityDpi = o.densityDpi;
        this.scaledDensity = o.scaledDensity;
        this.xdpi = o.xdpi;
        this.ydpi = o.ydpi;
        this.noncompatWidthPixels = o.noncompatWidthPixels;
        this.noncompatHeightPixels = o.noncompatHeightPixels;
        this.noncompatDensity = o.noncompatDensity;
        this.noncompatScaledDensity = o.noncompatScaledDensity;
        this.noncompatXdpi = o.noncompatXdpi;
        this.noncompatYdpi = o.noncompatYdpi;
    }

    public void setToDefaults() {
        this.widthPixels = 0;
        this.heightPixels = 0;
        this.density = (float)DENSITY_DEVICE / 160.0f;
        this.densityDpi = DENSITY_DEVICE;
        this.scaledDensity = this.density;
        this.xdpi = DENSITY_DEVICE;
        this.ydpi = DENSITY_DEVICE;
        this.noncompatWidthPixels = 0;
        this.noncompatHeightPixels = 0;
    }

    public String toString() {
        return "DisplayMetrics{density=" + this.density + ", width=" + this.widthPixels + ", height=" + this.heightPixels + ", scaledDensity=" + this.scaledDensity + ", xdpi=" + this.xdpi + ", ydpi=" + this.ydpi + "}";
    }

    private static int getDeviceDensity() {
        return SystemProperties.getInt("qemu.sf.lcd_density", SystemProperties.getInt("ro.sf.lcd_density", 160));
    }
}

