/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import java.util.Locale;
import libcore.icu.ICU;

public class LocaleUtil {
    public static final int TEXT_LAYOUT_DIRECTION_LTR_DO_NOT_USE = 0;
    public static final int TEXT_LAYOUT_DIRECTION_RTL_DO_NOT_USE = 1;
    private static final char UNDERSCORE_CHAR = '_';
    private static String ARAB_SCRIPT_SUBTAG = "Arab";
    private static String HEBR_SCRIPT_SUBTAG = "Hebr";

    private LocaleUtil() {
    }

    public static int getLayoutDirectionFromLocale(Locale locale) {
        if (locale != null && !locale.equals(Locale.ROOT)) {
            String scriptSubtag = ICU.getScript(ICU.addLikelySubtags(locale.toString()));
            if (scriptSubtag == null) {
                return LocaleUtil.getLayoutDirectionFromFirstChar(locale);
            }
            if (scriptSubtag.equalsIgnoreCase(ARAB_SCRIPT_SUBTAG) || scriptSubtag.equalsIgnoreCase(HEBR_SCRIPT_SUBTAG)) {
                return 1;
            }
        }
        return 0;
    }

    private static int getLayoutDirectionFromFirstChar(Locale locale) {
        switch (Character.getDirectionality(locale.getDisplayName(locale).charAt(0))) {
            case 1: 
            case 2: {
                return 1;
            }
        }
        return 0;
    }
}

