/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.accessibilityservice.IAccessibilityServiceConnection;
import android.graphics.Rect;
import android.os.Message;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.SparseArray;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.IAccessibilityInteractionConnectionCallback;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessibilityInteractionClient
extends IAccessibilityInteractionConnectionCallback.Stub {
    public static final int NO_ID = -1;
    private static final String LOG_TAG = "AccessibilityInteractionClient";
    private static final boolean DEBUG = false;
    private static final long TIMEOUT_INTERACTION_MILLIS = 5000L;
    private static final Object sStaticLock = new Object();
    private static AccessibilityInteractionClient sInstance;
    private final AtomicInteger mInteractionIdCounter = new AtomicInteger();
    private final Object mInstanceLock = new Object();
    private int mInteractionId = -1;
    private AccessibilityNodeInfo mFindAccessibilityNodeInfoResult;
    private List<AccessibilityNodeInfo> mFindAccessibilityNodeInfosResult;
    private boolean mPerformAccessibilityActionResult;
    private Message mSameThreadMessage;
    private final Rect mTempBounds = new Rect();
    private static final SparseArray<IAccessibilityServiceConnection> sConnectionCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccessibilityInteractionClient getInstance() {
        Object object = sStaticLock;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = new AccessibilityInteractionClient();
            }
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSameThreadMessage(Message message) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            this.mSameThreadMessage = message;
            this.mInstanceLock.notifyAll();
        }
    }

    public AccessibilityNodeInfo findAccessibilityNodeInfoByAccessibilityId(int connectionId, int accessibilityWindowId, int accessibilityViewId) {
        try {
            int interactionId;
            float windowScale;
            IAccessibilityServiceConnection connection = this.getConnection(connectionId);
            if (connection != null && (windowScale = connection.findAccessibilityNodeInfoByAccessibilityId(accessibilityWindowId, accessibilityViewId, interactionId = this.mInteractionIdCounter.getAndIncrement(), this, Thread.currentThread().getId())) > 0.0f) {
                AccessibilityNodeInfo info = this.getFindAccessibilityNodeInfoResultAndClear(interactionId);
                this.finalizeAccessibilityNodeInfo(info, connectionId, windowScale);
                return info;
            }
        }
        catch (RemoteException re) {
            // empty catch block
        }
        return null;
    }

    public AccessibilityNodeInfo findAccessibilityNodeInfoByViewIdInActiveWindow(int connectionId, int viewId) {
        try {
            int interactionId;
            float windowScale;
            IAccessibilityServiceConnection connection = this.getConnection(connectionId);
            if (connection != null && (windowScale = connection.findAccessibilityNodeInfoByViewIdInActiveWindow(viewId, interactionId = this.mInteractionIdCounter.getAndIncrement(), this, Thread.currentThread().getId())) > 0.0f) {
                AccessibilityNodeInfo info = this.getFindAccessibilityNodeInfoResultAndClear(interactionId);
                this.finalizeAccessibilityNodeInfo(info, connectionId, windowScale);
                return info;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return null;
    }

    public List<AccessibilityNodeInfo> findAccessibilityNodeInfosByViewTextInActiveWindow(int connectionId, String text) {
        try {
            int interactionId;
            float windowScale;
            IAccessibilityServiceConnection connection = this.getConnection(connectionId);
            if (connection != null && (windowScale = connection.findAccessibilityNodeInfosByViewTextInActiveWindow(text, interactionId = this.mInteractionIdCounter.getAndIncrement(), this, Thread.currentThread().getId())) > 0.0f) {
                List<AccessibilityNodeInfo> infos = this.getFindAccessibilityNodeInfosResultAndClear(interactionId);
                this.finalizeAccessibilityNodeInfos(infos, connectionId, windowScale);
                return infos;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return null;
    }

    public List<AccessibilityNodeInfo> findAccessibilityNodeInfosByViewText(int connectionId, String text, int accessibilityWindowId, int accessibilityViewId) {
        try {
            int interactionId;
            float windowScale;
            IAccessibilityServiceConnection connection = this.getConnection(connectionId);
            if (connection != null && (windowScale = connection.findAccessibilityNodeInfosByViewText(text, accessibilityWindowId, accessibilityViewId, interactionId = this.mInteractionIdCounter.getAndIncrement(), this, Thread.currentThread().getId())) > 0.0f) {
                List<AccessibilityNodeInfo> infos = this.getFindAccessibilityNodeInfosResultAndClear(interactionId);
                this.finalizeAccessibilityNodeInfos(infos, connectionId, windowScale);
                return infos;
            }
        }
        catch (RemoteException re) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    public boolean performAccessibilityAction(int connectionId, int accessibilityWindowId, int accessibilityViewId, int action) {
        try {
            int interactionId;
            boolean success;
            IAccessibilityServiceConnection connection = this.getConnection(connectionId);
            if (connection != null && (success = connection.performAccessibilityAction(accessibilityWindowId, accessibilityViewId, action, interactionId = this.mInteractionIdCounter.getAndIncrement(), this, Thread.currentThread().getId()))) {
                return this.getPerformAccessibilityActionResult(interactionId);
            }
        }
        catch (RemoteException re) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AccessibilityNodeInfo getFindAccessibilityNodeInfoResultAndClear(int interactionId) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            boolean success = this.waitForResultTimedLocked(interactionId);
            AccessibilityNodeInfo result = success ? this.mFindAccessibilityNodeInfoResult : null;
            this.clearResultLocked();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFindAccessibilityNodeInfoResult(AccessibilityNodeInfo info, int interactionId) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (interactionId > this.mInteractionId) {
                this.mFindAccessibilityNodeInfoResult = info;
                this.mInteractionId = interactionId;
            }
            this.mInstanceLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AccessibilityNodeInfo> getFindAccessibilityNodeInfosResultAndClear(int interactionId) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            boolean success = this.waitForResultTimedLocked(interactionId);
            List<AccessibilityNodeInfo> result = success ? this.mFindAccessibilityNodeInfosResult : null;
            this.clearResultLocked();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFindAccessibilityNodeInfosResult(List<AccessibilityNodeInfo> infos, int interactionId) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (interactionId > this.mInteractionId) {
                this.mFindAccessibilityNodeInfosResult = infos;
                this.mInteractionId = interactionId;
            }
            this.mInstanceLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getPerformAccessibilityActionResult(int interactionId) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            boolean success = this.waitForResultTimedLocked(interactionId);
            boolean result = success ? this.mPerformAccessibilityActionResult : false;
            this.clearResultLocked();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPerformAccessibilityActionResult(boolean succeeded, int interactionId) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (interactionId > this.mInteractionId) {
                this.mPerformAccessibilityActionResult = succeeded;
                this.mInteractionId = interactionId;
            }
            this.mInstanceLock.notifyAll();
        }
    }

    private void clearResultLocked() {
        this.mInteractionId = -1;
        this.mFindAccessibilityNodeInfoResult = null;
        this.mFindAccessibilityNodeInfosResult = null;
        this.mPerformAccessibilityActionResult = false;
    }

    private boolean waitForResultTimedLocked(int interactionId) {
        long waitTimeMillis = 5000L;
        long startTimeMillis = SystemClock.uptimeMillis();
        while (true) {
            try {
                while (true) {
                    Message sameProcessMessage;
                    if ((sameProcessMessage = this.getSameProcessMessageAndClear()) != null) {
                        sameProcessMessage.getTarget().handleMessage(sameProcessMessage);
                    }
                    if (this.mInteractionId == interactionId) {
                        return true;
                    }
                    if (this.mInteractionId > interactionId) {
                        return false;
                    }
                    long elapsedTimeMillis = SystemClock.uptimeMillis() - startTimeMillis;
                    waitTimeMillis = 5000L - elapsedTimeMillis;
                    if (waitTimeMillis <= 0L) {
                        return false;
                    }
                    this.mInstanceLock.wait(waitTimeMillis);
                }
            }
            catch (InterruptedException ie) {
                continue;
            }
            break;
        }
    }

    private void applyCompatibilityScaleIfNeeded(AccessibilityNodeInfo info, float scale) {
        if (scale == 1.0f) {
            return;
        }
        Rect bounds = this.mTempBounds;
        info.getBoundsInParent(bounds);
        bounds.scale(scale);
        info.setBoundsInParent(bounds);
        info.getBoundsInScreen(bounds);
        bounds.scale(scale);
        info.setBoundsInScreen(bounds);
    }

    private void finalizeAccessibilityNodeInfo(AccessibilityNodeInfo info, int connectionId, float windowScale) {
        if (info != null) {
            this.applyCompatibilityScaleIfNeeded(info, windowScale);
            info.setConnectionId(connectionId);
            info.setSealed(true);
        }
    }

    private void finalizeAccessibilityNodeInfos(List<AccessibilityNodeInfo> infos, int connectionId, float windowScale) {
        if (infos != null) {
            int infosCount = infos.size();
            for (int i = 0; i < infosCount; ++i) {
                AccessibilityNodeInfo info = infos.get(i);
                this.finalizeAccessibilityNodeInfo(info, connectionId, windowScale);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message getSameProcessMessageAndClear() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            Message result = this.mSameThreadMessage;
            this.mSameThreadMessage = null;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAccessibilityServiceConnection getConnection(int connectionId) {
        SparseArray<IAccessibilityServiceConnection> sparseArray = sConnectionCache;
        synchronized (sparseArray) {
            return sConnectionCache.get(connectionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(int connectionId, IAccessibilityServiceConnection connection) {
        SparseArray<IAccessibilityServiceConnection> sparseArray = sConnectionCache;
        synchronized (sparseArray) {
            sConnectionCache.put(connectionId, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(int connectionId) {
        SparseArray<IAccessibilityServiceConnection> sparseArray = sConnectionCache;
        synchronized (sparseArray) {
            sConnectionCache.remove(connectionId);
        }
    }

    static {
        sConnectionCache = new SparseArray();
    }
}

