/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslCertificate;
import android.net.http.SslError;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.webkit.BrowserFrame;
import android.webkit.ClientCertRequestHandler;
import android.webkit.ConsoleMessage;
import android.webkit.DownloadListener;
import android.webkit.GeolocationPermissions;
import android.webkit.HttpAuthHandler;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.SearchBoxImpl;
import android.webkit.SslErrorHandler;
import android.webkit.URLUtil;
import android.webkit.ValueCallback;
import android.webkit.WebBackForwardList;
import android.webkit.WebBackForwardListClient;
import android.webkit.WebChromeClient;
import android.webkit.WebHistoryItem;
import android.webkit.WebResourceResponse;
import android.webkit.WebStorage;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.webkit.WebViewCore;
import android.widget.EditText;
import android.widget.TextView;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CallbackProxy
extends Handler {
    private static final String LOGTAG = "CallbackProxy";
    private volatile WebViewClient mWebViewClient;
    private volatile WebChromeClient mWebChromeClient;
    private final WebView mWebView;
    private volatile DownloadListener mDownloadListener;
    private boolean mProgressUpdatePending;
    private volatile int mLatestProgress = 100;
    private final WebBackForwardList mBackForwardList;
    private volatile WebBackForwardListClient mWebBackForwardListClient;
    private final Context mContext;
    private static final int PAGE_STARTED = 100;
    private static final int RECEIVED_ICON = 101;
    private static final int RECEIVED_TITLE = 102;
    private static final int OVERRIDE_URL = 103;
    private static final int AUTH_REQUEST = 104;
    private static final int SSL_ERROR = 105;
    private static final int PROGRESS = 106;
    private static final int UPDATE_VISITED = 107;
    private static final int LOAD_RESOURCE = 108;
    private static final int CREATE_WINDOW = 109;
    private static final int CLOSE_WINDOW = 110;
    private static final int SAVE_PASSWORD = 111;
    private static final int JS_ALERT = 112;
    private static final int JS_CONFIRM = 113;
    private static final int JS_PROMPT = 114;
    private static final int JS_UNLOAD = 115;
    private static final int ASYNC_KEYEVENTS = 116;
    private static final int DOWNLOAD_FILE = 118;
    private static final int REPORT_ERROR = 119;
    private static final int RESEND_POST_DATA = 120;
    private static final int PAGE_FINISHED = 121;
    private static final int REQUEST_FOCUS = 122;
    private static final int SCALE_CHANGED = 123;
    private static final int RECEIVED_CERTIFICATE = 124;
    private static final int SWITCH_OUT_HISTORY = 125;
    private static final int EXCEEDED_DATABASE_QUOTA = 126;
    private static final int REACHED_APPCACHE_MAXSIZE = 127;
    private static final int JS_TIMEOUT = 128;
    private static final int ADD_MESSAGE_TO_CONSOLE = 129;
    private static final int GEOLOCATION_PERMISSIONS_SHOW_PROMPT = 130;
    private static final int GEOLOCATION_PERMISSIONS_HIDE_PROMPT = 131;
    private static final int RECEIVED_TOUCH_ICON_URL = 132;
    private static final int GET_VISITED_HISTORY = 133;
    private static final int OPEN_FILE_CHOOSER = 134;
    private static final int ADD_HISTORY_ITEM = 135;
    private static final int HISTORY_INDEX_CHANGED = 136;
    private static final int AUTH_CREDENTIALS = 137;
    private static final int SET_INSTALLABLE_WEBAPP = 138;
    private static final int NOTIFY_SEARCHBOX_LISTENERS = 139;
    private static final int AUTO_LOGIN = 140;
    private static final int CLIENT_CERT_REQUEST = 141;
    private static final int SEARCHBOX_IS_SUPPORTED_CALLBACK = 142;
    private static final int SEARCHBOX_DISPATCH_COMPLETE_CALLBACK = 143;
    private static final int PROCEEDED_AFTER_SSL_ERROR = 144;
    private static final int NOTIFY = 200;
    private static final boolean PERF_PROBE = false;
    private long mWebCoreThreadTime;
    private long mWebCoreIdleTime;

    public CallbackProxy(Context context, WebView w) {
        this.mContext = context;
        this.mWebView = w;
        this.mBackForwardList = new WebBackForwardList(this);
    }

    public void setWebViewClient(WebViewClient client) {
        this.mWebViewClient = client;
    }

    public WebViewClient getWebViewClient() {
        return this.mWebViewClient;
    }

    public void setWebChromeClient(WebChromeClient client) {
        this.mWebChromeClient = client;
    }

    public WebChromeClient getWebChromeClient() {
        return this.mWebChromeClient;
    }

    public void setDownloadListener(DownloadListener client) {
        this.mDownloadListener = client;
    }

    public WebBackForwardList getBackForwardList() {
        return this.mBackForwardList;
    }

    void setWebBackForwardListClient(WebBackForwardListClient client) {
        this.mWebBackForwardListClient = client;
    }

    WebBackForwardListClient getWebBackForwardListClient() {
        return this.mWebBackForwardListClient;
    }

    public boolean uiOverrideUrlLoading(String overrideUrl) {
        if (overrideUrl == null || overrideUrl.length() == 0) {
            return false;
        }
        boolean override = false;
        if (this.mWebViewClient != null) {
            override = this.mWebViewClient.shouldOverrideUrlLoading(this.mWebView, overrideUrl);
        } else {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse(overrideUrl));
            intent.addCategory("android.intent.category.BROWSABLE");
            intent.putExtra("com.android.browser.application_id", this.mContext.getPackageName());
            try {
                this.mContext.startActivity(intent);
                override = true;
            }
            catch (ActivityNotFoundException ex) {
                // empty catch block
            }
        }
        return override;
    }

    public boolean uiOverrideKeyEvent(KeyEvent event) {
        if (this.mWebViewClient != null) {
            return this.mWebViewClient.shouldOverrideKeyEvent(this.mWebView, event);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 100: {
                String startedUrl = msg.getData().getString("url");
                this.mWebView.onPageStarted(startedUrl);
                if (this.mWebViewClient == null) break;
                this.mWebViewClient.onPageStarted(this.mWebView, startedUrl, (Bitmap)msg.obj);
                break;
            }
            case 121: {
                String finishedUrl = (String)msg.obj;
                this.mWebView.onPageFinished(finishedUrl);
                if (this.mWebViewClient == null) break;
                this.mWebViewClient.onPageFinished(this.mWebView, finishedUrl);
                break;
            }
            case 101: {
                if (this.mWebChromeClient == null) break;
                this.mWebChromeClient.onReceivedIcon(this.mWebView, (Bitmap)msg.obj);
                break;
            }
            case 132: {
                if (this.mWebChromeClient == null) break;
                this.mWebChromeClient.onReceivedTouchIconUrl(this.mWebView, (String)msg.obj, msg.arg1 == 1);
                break;
            }
            case 102: {
                if (this.mWebChromeClient == null) break;
                this.mWebChromeClient.onReceivedTitle(this.mWebView, (String)msg.obj);
                break;
            }
            case 119: {
                if (this.mWebViewClient == null) break;
                int reasonCode = msg.arg1;
                String description = msg.getData().getString("description");
                String failUrl = msg.getData().getString("failingUrl");
                this.mWebViewClient.onReceivedError(this.mWebView, reasonCode, description, failUrl);
                break;
            }
            case 120: {
                Message resend = (Message)msg.getData().getParcelable("resend");
                Message dontResend = (Message)msg.getData().getParcelable("dontResend");
                if (this.mWebViewClient != null) {
                    this.mWebViewClient.onFormResubmission(this.mWebView, dontResend, resend);
                    break;
                }
                dontResend.sendToTarget();
                break;
            }
            case 103: {
                String overrideUrl = msg.getData().getString("url");
                boolean override = this.uiOverrideUrlLoading(overrideUrl);
                ResultTransport result = (ResultTransport)msg.obj;
                CallbackProxy callbackProxy = this;
                synchronized (callbackProxy) {
                    result.setResult(override);
                    this.notify();
                    break;
                }
            }
            case 104: {
                if (this.mWebViewClient == null) break;
                HttpAuthHandler handler = (HttpAuthHandler)msg.obj;
                String host = msg.getData().getString("host");
                String realm = msg.getData().getString("realm");
                this.mWebViewClient.onReceivedHttpAuthRequest(this.mWebView, handler, host, realm);
                break;
            }
            case 105: {
                if (this.mWebViewClient == null) break;
                HashMap map = (HashMap)msg.obj;
                this.mWebViewClient.onReceivedSslError(this.mWebView, (SslErrorHandler)map.get("handler"), (SslError)map.get("error"));
                break;
            }
            case 144: {
                if (this.mWebViewClient == null) break;
                this.mWebViewClient.onProceededAfterSslError(this.mWebView, (SslError)msg.obj);
                break;
            }
            case 141: {
                if (this.mWebViewClient == null) break;
                HashMap map = (HashMap)msg.obj;
                this.mWebViewClient.onReceivedClientCertRequest(this.mWebView, (ClientCertRequestHandler)map.get("handler"), (String)map.get("host_and_port"));
                break;
            }
            case 106: {
                CallbackProxy map = this;
                synchronized (map) {
                    if (this.mWebChromeClient != null) {
                        this.mWebChromeClient.onProgressChanged(this.mWebView, this.mLatestProgress);
                    }
                    this.mProgressUpdatePending = false;
                    break;
                }
            }
            case 107: {
                if (this.mWebViewClient == null) break;
                this.mWebViewClient.doUpdateVisitedHistory(this.mWebView, (String)msg.obj, msg.arg1 != 0);
                break;
            }
            case 108: {
                if (this.mWebViewClient == null) break;
                this.mWebViewClient.onLoadResource(this.mWebView, (String)msg.obj);
                break;
            }
            case 118: {
                if (this.mDownloadListener == null) break;
                String url = msg.getData().getString("url");
                String userAgent = msg.getData().getString("userAgent");
                String contentDisposition = msg.getData().getString("contentDisposition");
                String mimetype = msg.getData().getString("mimetype");
                Long contentLength = msg.getData().getLong("contentLength");
                this.mDownloadListener.onDownloadStart(url, userAgent, contentDisposition, mimetype, contentLength);
                break;
            }
            case 109: {
                if (this.mWebChromeClient == null) break;
                if (!this.mWebChromeClient.onCreateWindow(this.mWebView, msg.arg1 == 1, msg.arg2 == 1, (Message)msg.obj)) {
                    CallbackProxy url = this;
                    synchronized (url) {
                        this.notify();
                    }
                }
                this.mWebView.dismissZoomControl();
                break;
            }
            case 122: {
                if (this.mWebChromeClient == null) break;
                this.mWebChromeClient.onRequestFocus(this.mWebView);
                break;
            }
            case 110: {
                if (this.mWebChromeClient == null) break;
                this.mWebChromeClient.onCloseWindow((WebView)msg.obj);
                break;
            }
            case 111: {
                Bundle bundle = msg.getData();
                String schemePlusHost = bundle.getString("host");
                String username = bundle.getString("username");
                String password = bundle.getString("password");
                if (this.mWebView.onSavePassword(schemePlusHost, username, password, (Message)msg.obj)) break;
                CallbackProxy contentLength = this;
                synchronized (contentLength) {
                    this.notify();
                    break;
                }
            }
            case 116: {
                if (this.mWebViewClient == null) break;
                this.mWebViewClient.onUnhandledKeyEvent(this.mWebView, (KeyEvent)msg.obj);
                break;
            }
            case 126: {
                if (this.mWebChromeClient == null) break;
                HashMap map = (HashMap)msg.obj;
                String databaseIdentifier = (String)map.get("databaseIdentifier");
                String url = (String)map.get("url");
                long currentQuota = (Long)map.get("currentQuota");
                long totalUsedQuota = (Long)map.get("totalUsedQuota");
                long estimatedSize = (Long)map.get("estimatedSize");
                WebStorage.QuotaUpdater quotaUpdater = (WebStorage.QuotaUpdater)map.get("quotaUpdater");
                this.mWebChromeClient.onExceededDatabaseQuota(url, databaseIdentifier, currentQuota, estimatedSize, totalUsedQuota, quotaUpdater);
                break;
            }
            case 127: {
                if (this.mWebChromeClient == null) break;
                HashMap map = (HashMap)msg.obj;
                long spaceNeeded = (Long)map.get("spaceNeeded");
                long totalUsedQuota = (Long)map.get("totalUsedQuota");
                WebStorage.QuotaUpdater quotaUpdater = (WebStorage.QuotaUpdater)map.get("quotaUpdater");
                this.mWebChromeClient.onReachedMaxAppCacheSize(spaceNeeded, totalUsedQuota, quotaUpdater);
                break;
            }
            case 130: {
                if (this.mWebChromeClient == null) break;
                HashMap map = (HashMap)msg.obj;
                String origin = (String)map.get("origin");
                GeolocationPermissions.Callback callback = (GeolocationPermissions.Callback)map.get("callback");
                this.mWebChromeClient.onGeolocationPermissionsShowPrompt(origin, callback);
                break;
            }
            case 131: {
                if (this.mWebChromeClient == null) break;
                this.mWebChromeClient.onGeolocationPermissionsHidePrompt();
                break;
            }
            case 112: {
                if (this.mWebChromeClient == null) break;
                final JsResult res = (JsResult)msg.obj;
                String message = msg.getData().getString("message");
                String url = msg.getData().getString("url");
                if (!this.mWebChromeClient.onJsAlert(this.mWebView, url, message, res)) {
                    if (!this.canShowAlertDialog()) {
                        res.cancel();
                        res.setReady();
                        break;
                    }
                    new AlertDialog.Builder(this.mContext).setTitle(this.getJsDialogTitle(url)).setMessage(message).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            res.confirm();
                        }
                    }).setOnCancelListener(new DialogInterface.OnCancelListener(){

                        public void onCancel(DialogInterface dialog) {
                            res.cancel();
                        }
                    }).show();
                }
                res.setReady();
                break;
            }
            case 113: {
                if (this.mWebChromeClient == null) break;
                final JsResult res = (JsResult)msg.obj;
                String message = msg.getData().getString("message");
                String url = msg.getData().getString("url");
                if (!this.mWebChromeClient.onJsConfirm(this.mWebView, url, message, res)) {
                    if (!this.canShowAlertDialog()) {
                        res.cancel();
                        res.setReady();
                        break;
                    }
                    new AlertDialog.Builder(this.mContext).setTitle(this.getJsDialogTitle(url)).setMessage(message).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            res.confirm();
                        }
                    }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            res.cancel();
                        }
                    }).setOnCancelListener(new DialogInterface.OnCancelListener(){

                        public void onCancel(DialogInterface dialog) {
                            res.cancel();
                        }
                    }).show();
                }
                res.setReady();
                break;
            }
            case 114: {
                if (this.mWebChromeClient == null) break;
                final JsPromptResult res = (JsPromptResult)msg.obj;
                String message = msg.getData().getString("message");
                String defaultVal = msg.getData().getString("default");
                String url = msg.getData().getString("url");
                if (!this.mWebChromeClient.onJsPrompt(this.mWebView, url, message, defaultVal, res)) {
                    if (!this.canShowAlertDialog()) {
                        res.cancel();
                        res.setReady();
                        break;
                    }
                    LayoutInflater factory = LayoutInflater.from(this.mContext);
                    View view = factory.inflate(17367112, null);
                    final EditText v = (EditText)view.findViewById(16908926);
                    v.setText(defaultVal);
                    ((TextView)view.findViewById(16908299)).setText(message);
                    new AlertDialog.Builder(this.mContext).setTitle(this.getJsDialogTitle(url)).setView(view).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int whichButton) {
                            res.confirm(v.getText().toString());
                        }
                    }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int whichButton) {
                            res.cancel();
                        }
                    }).setOnCancelListener(new DialogInterface.OnCancelListener(){

                        public void onCancel(DialogInterface dialog) {
                            res.cancel();
                        }
                    }).show();
                }
                res.setReady();
                break;
            }
            case 115: {
                if (this.mWebChromeClient == null) break;
                final JsResult res = (JsResult)msg.obj;
                String message = msg.getData().getString("message");
                String url = msg.getData().getString("url");
                if (!this.mWebChromeClient.onJsBeforeUnload(this.mWebView, url, message, res)) {
                    if (!this.canShowAlertDialog()) {
                        res.cancel();
                        res.setReady();
                        break;
                    }
                    String m = this.mContext.getString(17040157, message);
                    new AlertDialog.Builder(this.mContext).setMessage(m).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            res.confirm();
                        }
                    }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            res.cancel();
                        }
                    }).show();
                }
                res.setReady();
                break;
            }
            case 128: {
                if (this.mWebChromeClient == null) break;
                JsResult res = (JsResult)msg.obj;
                if (this.mWebChromeClient.onJsTimeout()) {
                    res.confirm();
                } else {
                    res.cancel();
                }
                res.setReady();
                break;
            }
            case 124: {
                this.mWebView.setCertificate((SslCertificate)msg.obj);
                break;
            }
            case 200: {
                CallbackProxy res = this;
                synchronized (res) {
                    this.notify();
                    break;
                }
            }
            case 123: {
                if (this.mWebViewClient == null) break;
                this.mWebViewClient.onScaleChanged(this.mWebView, msg.getData().getFloat("old"), msg.getData().getFloat("new"));
                break;
            }
            case 125: {
                this.mWebView.switchOutDrawHistory();
                break;
            }
            case 129: {
                ConsoleMessage.MessageLevel messageLevel;
                if (this.mWebChromeClient == null) break;
                String message = msg.getData().getString("message");
                String sourceID = msg.getData().getString("sourceID");
                int lineNumber = msg.getData().getInt("lineNumber");
                int msgLevel = msg.getData().getInt("msgLevel");
                int numberOfMessageLevels = ConsoleMessage.MessageLevel.values().length;
                if (msgLevel < 0 || msgLevel >= numberOfMessageLevels) {
                    msgLevel = 0;
                }
                if (this.mWebChromeClient.onConsoleMessage(new ConsoleMessage(message, sourceID, lineNumber, messageLevel = ConsoleMessage.MessageLevel.values()[msgLevel]))) break;
                String logTag = "Web Console";
                String logMessage = message + " at " + sourceID + ":" + lineNumber;
                switch (messageLevel) {
                    case TIP: {
                        Log.v(logTag, logMessage);
                        break;
                    }
                    case LOG: {
                        Log.i(logTag, logMessage);
                        break;
                    }
                    case WARNING: {
                        Log.w(logTag, logMessage);
                        break;
                    }
                    case ERROR: {
                        Log.e(logTag, logMessage);
                        break;
                    }
                    case DEBUG: {
                        Log.d(logTag, logMessage);
                    }
                }
                break;
            }
            case 133: {
                if (this.mWebChromeClient == null) break;
                this.mWebChromeClient.getVisitedHistory((ValueCallback)msg.obj);
                break;
            }
            case 134: {
                if (this.mWebChromeClient == null) break;
                UploadFileMessageData data = (UploadFileMessageData)msg.obj;
                this.mWebChromeClient.openFileChooser(data.getUploadFile(), data.getAcceptType());
                break;
            }
            case 135: {
                if (this.mWebBackForwardListClient == null) break;
                this.mWebBackForwardListClient.onNewHistoryItem((WebHistoryItem)msg.obj);
                break;
            }
            case 136: {
                if (this.mWebBackForwardListClient == null) break;
                this.mWebBackForwardListClient.onIndexChanged((WebHistoryItem)msg.obj, msg.arg1);
                break;
            }
            case 137: {
                String host = msg.getData().getString("host");
                String realm = msg.getData().getString("realm");
                String username = msg.getData().getString("username");
                String password = msg.getData().getString("password");
                this.mWebView.setHttpAuthUsernamePassword(host, realm, username, password);
                break;
            }
            case 138: {
                if (this.mWebChromeClient == null) break;
                this.mWebChromeClient.setInstallableWebApp();
                break;
            }
            case 139: {
                SearchBoxImpl searchBox = (SearchBoxImpl)this.mWebView.getSearchBox();
                List suggestions = (List)msg.obj;
                searchBox.handleSuggestions(msg.getData().getString("query"), suggestions);
                break;
            }
            case 140: {
                if (this.mWebViewClient == null) break;
                String realm = msg.getData().getString("realm");
                String account = msg.getData().getString("account");
                String args = msg.getData().getString("args");
                this.mWebViewClient.onReceivedLoginRequest(this.mWebView, realm, account, args);
                break;
            }
            case 142: {
                SearchBoxImpl searchBox = (SearchBoxImpl)this.mWebView.getSearchBox();
                Boolean supported = (Boolean)msg.obj;
                searchBox.handleIsSupportedCallback(supported);
                break;
            }
            case 143: {
                SearchBoxImpl searchBox = (SearchBoxImpl)this.mWebView.getSearchBox();
                Boolean success = (Boolean)msg.obj;
                searchBox.handleDispatchCompleteCallback(msg.getData().getString("function"), msg.getData().getInt("id"), success);
                break;
            }
        }
    }

    public int getProgress() {
        return this.mLatestProgress;
    }

    void switchOutDrawHistory() {
        this.sendMessage(this.obtainMessage(125));
    }

    private String getJsDialogTitle(String url) {
        String title = url;
        if (URLUtil.isDataUrl(url)) {
            title = this.mContext.getString(17040156);
        } else {
            try {
                URL aUrl = new URL(url);
                title = this.mContext.getString(17040155, aUrl.getProtocol() + "://" + aUrl.getHost());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return title;
    }

    public void onPageStarted(String url, Bitmap favicon) {
        Message msg = this.obtainMessage(100);
        msg.obj = favicon;
        msg.getData().putString("url", url);
        this.sendMessage(msg);
    }

    public void onPageFinished(String url) {
        Message msg = this.obtainMessage(121, url);
        this.sendMessage(msg);
    }

    public void onTooManyRedirects(Message cancelMsg, Message continueMsg) {
    }

    public void onReceivedError(int errorCode, String description, String failingUrl) {
        if (this.mWebViewClient == null) {
            return;
        }
        Message msg = this.obtainMessage(119);
        msg.arg1 = errorCode;
        msg.getData().putString("description", description);
        msg.getData().putString("failingUrl", failingUrl);
        this.sendMessage(msg);
    }

    public void onFormResubmission(Message dontResend, Message resend) {
        if (this.mWebViewClient == null) {
            dontResend.sendToTarget();
            return;
        }
        Message msg = this.obtainMessage(120);
        Bundle bundle = msg.getData();
        bundle.putParcelable("resend", resend);
        bundle.putParcelable("dontResend", dontResend);
        this.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldOverrideUrlLoading(String url) {
        ResultTransport<Boolean> res = new ResultTransport<Boolean>(false);
        Message msg = this.obtainMessage(103);
        msg.getData().putString("url", url);
        msg.obj = res;
        CallbackProxy callbackProxy = this;
        synchronized (callbackProxy) {
            this.sendMessage(msg);
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Log.e(LOGTAG, "Caught exception while waiting for overrideUrl");
                Log.e(LOGTAG, Log.getStackTraceString(e));
            }
        }
        return res.getResult();
    }

    public void onReceivedHttpAuthRequest(HttpAuthHandler handler, String hostName, String realmName) {
        if (this.mWebViewClient == null) {
            handler.cancel();
            return;
        }
        Message msg = this.obtainMessage(104, handler);
        msg.getData().putString("host", hostName);
        msg.getData().putString("realm", realmName);
        this.sendMessage(msg);
    }

    public void onReceivedSslError(SslErrorHandler handler, SslError error) {
        if (this.mWebViewClient == null) {
            handler.cancel();
            return;
        }
        Message msg = this.obtainMessage(105);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("handler", handler);
        map.put("error", error);
        msg.obj = map;
        this.sendMessage(msg);
    }

    public void onProceededAfterSslError(SslError error) {
        if (this.mWebViewClient == null) {
            return;
        }
        Message msg = this.obtainMessage(144);
        msg.obj = error;
        this.sendMessage(msg);
    }

    public void onReceivedClientCertRequest(ClientCertRequestHandler handler, String host_and_port) {
        if (this.mWebViewClient == null) {
            handler.cancel();
            return;
        }
        Message msg = this.obtainMessage(141);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("handler", handler);
        map.put("host_and_port", host_and_port);
        msg.obj = map;
        this.sendMessage(msg);
    }

    public void onReceivedCertificate(SslCertificate certificate) {
        this.sendMessage(this.obtainMessage(124, certificate));
    }

    public void doUpdateVisitedHistory(String url, boolean isReload) {
        if (this.mWebViewClient == null) {
            return;
        }
        this.sendMessage(this.obtainMessage(107, isReload ? 1 : 0, 0, url));
    }

    WebResourceResponse shouldInterceptRequest(String url) {
        if (this.mWebViewClient == null) {
            return null;
        }
        WebResourceResponse r = this.mWebViewClient.shouldInterceptRequest(this.mWebView, url);
        if (r == null) {
            this.sendMessage(this.obtainMessage(108, url));
        }
        return r;
    }

    public void onUnhandledKeyEvent(KeyEvent event) {
        if (this.mWebViewClient == null) {
            return;
        }
        this.sendMessage(this.obtainMessage(116, event));
    }

    public void onScaleChanged(float oldScale, float newScale) {
        if (this.mWebViewClient == null) {
            return;
        }
        Message msg = this.obtainMessage(123);
        Bundle bundle = msg.getData();
        bundle.putFloat("old", oldScale);
        bundle.putFloat("new", newScale);
        this.sendMessage(msg);
    }

    void onReceivedLoginRequest(String realm, String account, String args) {
        if (this.mWebViewClient == null) {
            return;
        }
        Message msg = this.obtainMessage(140);
        Bundle bundle = msg.getData();
        bundle.putString("realm", realm);
        bundle.putString("account", account);
        bundle.putString("args", args);
        this.sendMessage(msg);
    }

    public boolean onDownloadStart(String url, String userAgent, String contentDisposition, String mimetype, long contentLength) {
        if (this.mDownloadListener == null) {
            return false;
        }
        Message msg = this.obtainMessage(118);
        Bundle bundle = msg.getData();
        bundle.putString("url", url);
        bundle.putString("userAgent", userAgent);
        bundle.putString("mimetype", mimetype);
        bundle.putLong("contentLength", contentLength);
        bundle.putString("contentDisposition", contentDisposition);
        this.sendMessage(msg);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onSavePassword(String schemePlusHost, String username, String password, Message resumeMsg) {
        resumeMsg = this.obtainMessage(200);
        Message msg = this.obtainMessage(111, resumeMsg);
        Bundle bundle = msg.getData();
        bundle.putString("host", schemePlusHost);
        bundle.putString("username", username);
        bundle.putString("password", password);
        CallbackProxy callbackProxy = this;
        synchronized (callbackProxy) {
            this.sendMessage(msg);
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Log.e(LOGTAG, "Caught exception while waiting for onSavePassword");
                Log.e(LOGTAG, Log.getStackTraceString(e));
            }
        }
        return false;
    }

    public void onReceivedHttpAuthCredentials(String host, String realm, String username, String password) {
        Message msg = this.obtainMessage(137);
        msg.getData().putString("host", host);
        msg.getData().putString("realm", realm);
        msg.getData().putString("username", username);
        msg.getData().putString("password", password);
        this.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onProgressChanged(int newProgress) {
        CallbackProxy callbackProxy = this;
        synchronized (callbackProxy) {
            if (this.mLatestProgress == newProgress) {
                return;
            }
            this.mLatestProgress = newProgress;
            if (this.mWebChromeClient == null) {
                return;
            }
            if (!this.mProgressUpdatePending) {
                this.sendEmptyMessage(106);
                this.mProgressUpdatePending = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BrowserFrame createWindow(boolean dialog, boolean userGesture) {
        WebViewCore core;
        if (this.mWebChromeClient == null) {
            return null;
        }
        WebView.WebViewTransport transport = new WebView.WebViewTransport(this.mWebView);
        Message msg = this.obtainMessage(200);
        msg.obj = transport;
        CallbackProxy callbackProxy = this;
        synchronized (callbackProxy) {
            this.sendMessage(this.obtainMessage(109, dialog ? 1 : 0, userGesture ? 1 : 0, msg));
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Log.e(LOGTAG, "Caught exception while waiting for createWindow");
                Log.e(LOGTAG, Log.getStackTraceString(e));
            }
        }
        WebView w = transport.getWebView();
        if (w != null && (core = w.getWebViewCore()) != null) {
            core.initializeSubwindow();
            return core.getBrowserFrame();
        }
        return null;
    }

    public void onRequestFocus() {
        if (this.mWebChromeClient == null) {
            return;
        }
        this.sendEmptyMessage(122);
    }

    public void onCloseWindow(WebView window) {
        if (this.mWebChromeClient == null) {
            return;
        }
        this.sendMessage(this.obtainMessage(110, window));
    }

    public void onReceivedIcon(Bitmap icon) {
        WebHistoryItem i = this.mBackForwardList.getCurrentItem();
        if (i != null) {
            i.setFavicon(icon);
        }
        if (this.mWebChromeClient == null) {
            return;
        }
        this.sendMessage(this.obtainMessage(101, icon));
    }

    void onReceivedTouchIconUrl(String url, boolean precomposed) {
        WebHistoryItem i = this.mBackForwardList.getCurrentItem();
        if (i != null) {
            i.setTouchIconUrl(url, precomposed);
        }
        if (this.mWebChromeClient == null) {
            return;
        }
        this.sendMessage(this.obtainMessage(132, precomposed ? 1 : 0, 0, url));
    }

    public void onReceivedTitle(String title) {
        if (this.mWebChromeClient == null) {
            return;
        }
        this.sendMessage(this.obtainMessage(102, title));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onJsAlert(String url, String message) {
        if (this.mWebChromeClient == null) {
            return;
        }
        JsResult result = new JsResult(this, false);
        Message alert = this.obtainMessage(112, result);
        alert.getData().putString("message", message);
        alert.getData().putString("url", url);
        CallbackProxy callbackProxy = this;
        synchronized (callbackProxy) {
            this.sendMessage(alert);
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Log.e(LOGTAG, "Caught exception while waiting for jsAlert");
                Log.e(LOGTAG, Log.getStackTraceString(e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onJsConfirm(String url, String message) {
        if (this.mWebChromeClient == null) {
            return false;
        }
        JsResult result = new JsResult(this, false);
        Message confirm = this.obtainMessage(113, result);
        confirm.getData().putString("message", message);
        confirm.getData().putString("url", url);
        CallbackProxy callbackProxy = this;
        synchronized (callbackProxy) {
            this.sendMessage(confirm);
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Log.e(LOGTAG, "Caught exception while waiting for jsConfirm");
                Log.e(LOGTAG, Log.getStackTraceString(e));
            }
        }
        return result.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String onJsPrompt(String url, String message, String defaultValue) {
        if (this.mWebChromeClient == null) {
            return null;
        }
        JsPromptResult result = new JsPromptResult(this);
        Message prompt = this.obtainMessage(114, result);
        prompt.getData().putString("message", message);
        prompt.getData().putString("default", defaultValue);
        prompt.getData().putString("url", url);
        CallbackProxy callbackProxy = this;
        synchronized (callbackProxy) {
            this.sendMessage(prompt);
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Log.e(LOGTAG, "Caught exception while waiting for jsPrompt");
                Log.e(LOGTAG, Log.getStackTraceString(e));
            }
        }
        return result.getStringResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onJsBeforeUnload(String url, String message) {
        if (this.mWebChromeClient == null) {
            return true;
        }
        JsResult result = new JsResult(this, true);
        Message confirm = this.obtainMessage(115, result);
        confirm.getData().putString("message", message);
        confirm.getData().putString("url", url);
        CallbackProxy callbackProxy = this;
        synchronized (callbackProxy) {
            this.sendMessage(confirm);
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Log.e(LOGTAG, "Caught exception while waiting for jsUnload");
                Log.e(LOGTAG, Log.getStackTraceString(e));
            }
        }
        return result.getResult();
    }

    public void onExceededDatabaseQuota(String url, String databaseIdentifier, long currentQuota, long estimatedSize, long totalUsedQuota, WebStorage.QuotaUpdater quotaUpdater) {
        if (this.mWebChromeClient == null) {
            quotaUpdater.updateQuota(currentQuota);
            return;
        }
        Message exceededQuota = this.obtainMessage(126);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("databaseIdentifier", databaseIdentifier);
        map.put("url", url);
        map.put("currentQuota", currentQuota);
        map.put("estimatedSize", estimatedSize);
        map.put("totalUsedQuota", totalUsedQuota);
        map.put("quotaUpdater", quotaUpdater);
        exceededQuota.obj = map;
        this.sendMessage(exceededQuota);
    }

    public void onReachedMaxAppCacheSize(long spaceNeeded, long totalUsedQuota, WebStorage.QuotaUpdater quotaUpdater) {
        if (this.mWebChromeClient == null) {
            quotaUpdater.updateQuota(0L);
            return;
        }
        Message msg = this.obtainMessage(127);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("spaceNeeded", spaceNeeded);
        map.put("totalUsedQuota", totalUsedQuota);
        map.put("quotaUpdater", quotaUpdater);
        msg.obj = map;
        this.sendMessage(msg);
    }

    public void onGeolocationPermissionsShowPrompt(String origin, GeolocationPermissions.Callback callback) {
        if (this.mWebChromeClient == null) {
            return;
        }
        Message showMessage = this.obtainMessage(130);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("origin", origin);
        map.put("callback", callback);
        showMessage.obj = map;
        this.sendMessage(showMessage);
    }

    public void onGeolocationPermissionsHidePrompt() {
        if (this.mWebChromeClient == null) {
            return;
        }
        Message hideMessage = this.obtainMessage(131);
        this.sendMessage(hideMessage);
    }

    public void addMessageToConsole(String message, int lineNumber, String sourceID, int msgLevel) {
        if (this.mWebChromeClient == null) {
            return;
        }
        Message msg = this.obtainMessage(129);
        msg.getData().putString("message", message);
        msg.getData().putString("sourceID", sourceID);
        msg.getData().putInt("lineNumber", lineNumber);
        msg.getData().putInt("msgLevel", msgLevel);
        this.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onJsTimeout() {
        if (this.mWebChromeClient == null) {
            return true;
        }
        JsResult result = new JsResult(this, true);
        Message timeout = this.obtainMessage(128, result);
        CallbackProxy callbackProxy = this;
        synchronized (callbackProxy) {
            this.sendMessage(timeout);
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Log.e(LOGTAG, "Caught exception while waiting for jsUnload");
                Log.e(LOGTAG, Log.getStackTraceString(e));
            }
        }
        return result.getResult();
    }

    public void getVisitedHistory(ValueCallback<String[]> callback) {
        if (this.mWebChromeClient == null) {
            return;
        }
        Message msg = this.obtainMessage(133);
        msg.obj = callback;
        this.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Uri openFileChooser(String acceptType) {
        if (this.mWebChromeClient == null) {
            return null;
        }
        Message myMessage = this.obtainMessage(134);
        UploadFile uploadFile = new UploadFile();
        UploadFileMessageData data = new UploadFileMessageData(uploadFile, acceptType);
        myMessage.obj = data;
        CallbackProxy callbackProxy = this;
        synchronized (callbackProxy) {
            this.sendMessage(myMessage);
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Log.e(LOGTAG, "Caught exception while waiting for openFileChooser");
                Log.e(LOGTAG, Log.getStackTraceString(e));
            }
        }
        return uploadFile.getResult();
    }

    void onNewHistoryItem(WebHistoryItem item) {
        if (this.mWebBackForwardListClient == null) {
            return;
        }
        Message msg = this.obtainMessage(135, item);
        this.sendMessage(msg);
    }

    void onIndexChanged(WebHistoryItem item, int index) {
        if (this.mWebBackForwardListClient == null) {
            return;
        }
        Message msg = this.obtainMessage(136, index, 0, item);
        this.sendMessage(msg);
    }

    void setInstallableWebApp() {
        if (this.mWebChromeClient == null) {
            return;
        }
        this.sendMessage(this.obtainMessage(138));
    }

    boolean canShowAlertDialog() {
        return this.mContext instanceof Activity;
    }

    void onSearchboxSuggestionsReceived(String query, List<String> suggestions) {
        Message msg = this.obtainMessage(139);
        msg.obj = suggestions;
        msg.getData().putString("query", query);
        this.sendMessage(msg);
    }

    void onIsSupportedCallback(boolean isSupported) {
        Message msg = this.obtainMessage(142);
        msg.obj = new Boolean(isSupported);
        this.sendMessage(msg);
    }

    void onSearchboxDispatchCompleteCallback(String function, int id2, boolean success) {
        Message msg = this.obtainMessage(143);
        msg.obj = success;
        msg.getData().putString("function", function);
        msg.getData().putInt("id", id2);
        this.sendMessage(msg);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UploadFile
    implements ValueCallback<Uri> {
        private Uri mValue;

        private UploadFile() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceiveValue(Uri value) {
            this.mValue = value;
            CallbackProxy callbackProxy = CallbackProxy.this;
            synchronized (callbackProxy) {
                CallbackProxy.this.notify();
            }
        }

        public Uri getResult() {
            return this.mValue;
        }
    }

    private static class UploadFileMessageData {
        private UploadFile mCallback;
        private String mAcceptType;

        public UploadFileMessageData(UploadFile uploadFile, String acceptType) {
            this.mCallback = uploadFile;
            this.mAcceptType = acceptType;
        }

        public UploadFile getUploadFile() {
            return this.mCallback;
        }

        public String getAcceptType() {
            return this.mAcceptType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResultTransport<E> {
        private E mResult;

        public ResultTransport(E defaultResult) {
            this.mResult = defaultResult;
        }

        public synchronized void setResult(E result) {
            this.mResult = result;
        }

        public synchronized E getResult() {
            return this.mResult;
        }
    }
}

