/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.os.Handler;
import android.webkit.BrowserFrame;
import android.webkit.SslClientCertLookupTable;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.apache.harmony.xnet.provider.jsse.NativeCrypto;

public class ClientCertRequestHandler
extends Handler {
    private final BrowserFrame mBrowserFrame;
    private final int mHandle;
    private final String mHostAndPort;
    private final SslClientCertLookupTable mTable;

    ClientCertRequestHandler(BrowserFrame browserFrame, int handle, String host_and_port, SslClientCertLookupTable table) {
        this.mBrowserFrame = browserFrame;
        this.mHandle = handle;
        this.mHostAndPort = host_and_port;
        this.mTable = table;
    }

    public void proceed(PrivateKey privateKey, X509Certificate[] chain) {
        final byte[] privateKeyBytes = privateKey.getEncoded();
        try {
            final byte[][] chainBytes = NativeCrypto.encodeCertificates(chain);
            this.mTable.Allow(this.mHostAndPort, privateKeyBytes, chainBytes);
            this.post(new Runnable(){

                public void run() {
                    ClientCertRequestHandler.this.mBrowserFrame.nativeSslClientCert(ClientCertRequestHandler.this.mHandle, privateKeyBytes, chainBytes);
                }
            });
        }
        catch (CertificateEncodingException e) {
            this.post(new Runnable(){

                public void run() {
                    ClientCertRequestHandler.this.mBrowserFrame.nativeSslClientCert(ClientCertRequestHandler.this.mHandle, null, null);
                }
            });
        }
    }

    public void ignore() {
        this.post(new Runnable(){

            public void run() {
                ClientCertRequestHandler.this.mBrowserFrame.nativeSslClientCert(ClientCertRequestHandler.this.mHandle, null, null);
            }
        });
    }

    public void cancel() {
        this.mTable.Deny(this.mHostAndPort);
        this.post(new Runnable(){

            public void run() {
                ClientCertRequestHandler.this.mBrowserFrame.nativeSslClientCert(ClientCertRequestHandler.this.mHandle, null, null);
            }
        });
    }
}

