/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.webkit.CookieManager;
import android.webkit.JniUtil;
import android.webkit.WebSyncManager;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieSyncManager
extends WebSyncManager {
    private static CookieSyncManager sRef;
    private long mLastUpdate;

    private CookieSyncManager(Context context) {
        super(context, "CookieSyncManager");
    }

    public static synchronized CookieSyncManager getInstance() {
        CookieSyncManager.checkInstanceIsCreated();
        return sRef;
    }

    public static synchronized CookieSyncManager createInstance(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Invalid context argument");
        }
        JniUtil.setContext(context);
        Context appContext = context.getApplicationContext();
        if (sRef == null) {
            sRef = new CookieSyncManager(appContext);
        }
        return sRef;
    }

    ArrayList<CookieManager.Cookie> getCookiesForDomain(String domain) {
        if (this.mDataBase == null) {
            return new ArrayList<CookieManager.Cookie>();
        }
        return this.mDataBase.getCookiesForDomain(domain);
    }

    void clearAllCookies() {
        if (this.mDataBase == null) {
            return;
        }
        this.mDataBase.clearCookies();
    }

    boolean hasCookies() {
        if (this.mDataBase == null) {
            return false;
        }
        return this.mDataBase.hasCookies();
    }

    void clearSessionCookies() {
        if (this.mDataBase == null) {
            return;
        }
        this.mDataBase.clearSessionCookies();
    }

    void clearExpiredCookies(long now) {
        if (this.mDataBase == null) {
            return;
        }
        this.mDataBase.clearExpiredCookies(now);
    }

    @Override
    protected void syncFromRamToFlash() {
        CookieManager manager = CookieManager.getInstance();
        if (!manager.acceptCookie()) {
            return;
        }
        if (JniUtil.useChromiumHttpStack()) {
            manager.flushCookieStore();
        } else {
            ArrayList<CookieManager.Cookie> cookieList = manager.getUpdatedCookiesSince(this.mLastUpdate);
            this.mLastUpdate = System.currentTimeMillis();
            this.syncFromRamToFlash(cookieList);
            ArrayList<CookieManager.Cookie> lruList = manager.deleteLRUDomain();
            this.syncFromRamToFlash(lruList);
        }
    }

    private void syncFromRamToFlash(ArrayList<CookieManager.Cookie> list) {
        for (CookieManager.Cookie cookie : list) {
            if (cookie.mode == 1) continue;
            if (cookie.mode != 0) {
                this.mDataBase.deleteCookies(cookie.domain, cookie.path, cookie.name);
            }
            if (cookie.mode != 2) {
                this.mDataBase.addCookie(cookie);
                CookieManager.getInstance().syncedACookie(cookie);
                continue;
            }
            CookieManager.getInstance().deleteACookie(cookie);
        }
    }

    private static void checkInstanceIsCreated() {
        if (sRef == null) {
            throw new IllegalStateException("CookieSyncManager::createInstance() needs to be called before CookieSyncManager::getInstance()");
        }
    }
}

