/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.net.ProxyProperties;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.webkit.CertTool;
import android.webkit.CookieManager;
import android.webkit.PluginManager;
import android.webkit.WebView;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JWebCoreJavaBridge
extends Handler {
    private static final int TIMER_MESSAGE = 1;
    private static final int FUNCPTR_MESSAGE = 2;
    private static final String LOGTAG = "webkit-timers";
    private int mNativeBridge;
    private boolean mHasInstantTimer;
    private boolean mTimerPaused;
    private boolean mHasDeferredTimers;
    private static WeakReference<WebView> sCurrentMainWebView = new WeakReference<Object>(null);
    static final int REFRESH_PLUGINS = 100;
    private HashMap<String, String> mContentUriToFilePathMap;

    public JWebCoreJavaBridge() {
        this.nativeConstructor();
    }

    protected void finalize() {
        this.nativeFinalize();
    }

    static synchronized void setActiveWebView(WebView webview) {
        if (sCurrentMainWebView.get() != null) {
            return;
        }
        sCurrentMainWebView = new WeakReference<WebView>(webview);
    }

    static synchronized void removeActiveWebView(WebView webview) {
        if (sCurrentMainWebView.get() != webview) {
            return;
        }
        sCurrentMainWebView.clear();
    }

    private void fireSharedTimer() {
        this.mHasInstantTimer = false;
        this.sharedTimerFired();
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                if (this.mTimerPaused) {
                    this.mHasDeferredTimers = true;
                    break;
                }
                this.fireSharedTimer();
                break;
            }
            case 2: {
                this.nativeServiceFuncPtrQueue();
                break;
            }
            case 100: {
                this.nativeUpdatePluginDirectories(PluginManager.getInstance(null).getPluginDirectories(), (Boolean)msg.obj);
            }
        }
    }

    private void signalServiceFuncPtrQueue() {
        Message msg = this.obtainMessage(2);
        this.sendMessage(msg);
    }

    private void nativeServiceFuncPtrQueue() {
        OverrideMethod.invokeV("android.webkit.JWebCoreJavaBridge#nativeServiceFuncPtrQueue()V", true, this);
    }

    public void pause() {
        if (!this.mTimerPaused) {
            this.mTimerPaused = true;
            this.mHasDeferredTimers = false;
        }
    }

    public void resume() {
        if (this.mTimerPaused) {
            this.mTimerPaused = false;
            if (this.mHasDeferredTimers) {
                this.mHasDeferredTimers = false;
                this.fireSharedTimer();
            }
        }
    }

    public void setCacheSize(int n) {
        OverrideMethod.invokeV("android.webkit.JWebCoreJavaBridge#setCacheSize(I)V", true, this);
    }

    private void setCookies(String url, String value) {
        if (value.contains("\r") || value.contains("\n")) {
            int size = value.length();
            StringBuilder buffer = new StringBuilder(size);
            int i = 0;
            while (i != -1 && i < size) {
                int newi;
                int ir = value.indexOf(13, i);
                int in = value.indexOf(10, i);
                int n = ir == -1 ? in : (in == -1 ? ir : (newi = ir < in ? ir : in));
                if (newi > i) {
                    buffer.append(value.subSequence(i, newi));
                } else if (newi == -1) {
                    buffer.append(value.subSequence(i, size));
                    break;
                }
                i = newi + 1;
            }
            value = buffer.toString();
        }
        CookieManager.getInstance().setCookie(url, value);
    }

    private String cookies(String url) {
        return CookieManager.getInstance().getCookie(url);
    }

    private boolean cookiesEnabled() {
        return CookieManager.getInstance().acceptCookie();
    }

    private String[] getPluginDirectories() {
        return PluginManager.getInstance(null).getPluginDirectories();
    }

    private String getPluginSharedDataDirectory() {
        return PluginManager.getInstance(null).getPluginSharedDataDirectory();
    }

    private void setSharedTimer(long timemillis) {
        if (timemillis <= 0L) {
            if (this.mHasInstantTimer) {
                return;
            }
            this.mHasInstantTimer = true;
            Message msg = this.obtainMessage(1);
            this.sendMessageDelayed(msg, timemillis);
        } else {
            Message msg = this.obtainMessage(1);
            this.sendMessageDelayed(msg, timemillis);
        }
    }

    private void stopSharedTimer() {
        this.removeMessages(1);
        this.mHasInstantTimer = false;
        this.mHasDeferredTimers = false;
    }

    private String[] getKeyStrengthList() {
        return CertTool.getKeyStrengthList();
    }

    private synchronized String getSignedPublicKey(int index, String challenge, String url) {
        WebView current = (WebView)sCurrentMainWebView.get();
        if (current != null) {
            return CertTool.getSignedPublicKey(current.getContext(), index, challenge);
        }
        Log.e(LOGTAG, "There is no active WebView for getSignedPublicKey");
        return "";
    }

    private String resolveFilePathForContentUri(String uri) {
        String fileName;
        if (this.mContentUriToFilePathMap != null && (fileName = this.mContentUriToFilePathMap.get(uri)) != null) {
            return fileName;
        }
        Uri jUri = Uri.parse(uri);
        return jUri.getLastPathSegment();
    }

    public void storeFilePathForContentUri(String path, String contentUri) {
        if (this.mContentUriToFilePathMap == null) {
            this.mContentUriToFilePathMap = new HashMap();
        }
        this.mContentUriToFilePathMap.put(contentUri, path);
    }

    public void updateProxy(ProxyProperties proxyProperties) {
        if (proxyProperties == null) {
            this.nativeUpdateProxy("", "");
            return;
        }
        String host = proxyProperties.getHost();
        int port = proxyProperties.getPort();
        if (port != 0) {
            host = host + ":" + port;
        }
        this.nativeUpdateProxy(host, proxyProperties.getExclusionList());
    }

    private void nativeConstructor() {
        OverrideMethod.invokeV("android.webkit.JWebCoreJavaBridge#nativeConstructor()V", true, this);
    }

    private void nativeFinalize() {
        OverrideMethod.invokeV("android.webkit.JWebCoreJavaBridge#nativeFinalize()V", true, this);
    }

    private void sharedTimerFired() {
        OverrideMethod.invokeV("android.webkit.JWebCoreJavaBridge#sharedTimerFired()V", true, this);
    }

    private void nativeUpdatePluginDirectories(String[] stringArray, boolean bl) {
        OverrideMethod.invokeV("android.webkit.JWebCoreJavaBridge#nativeUpdatePluginDirectories([Ljava/lang/String;Z)V", true, this);
    }

    public void setNetworkOnLine(boolean bl) {
        OverrideMethod.invokeV("android.webkit.JWebCoreJavaBridge#setNetworkOnLine(Z)V", true, this);
    }

    public void setNetworkType(String string2, String string3) {
        OverrideMethod.invokeV("android.webkit.JWebCoreJavaBridge#setNetworkType(Ljava/lang/String;Ljava/lang/String;)V", true, this);
    }

    public void addPackageNames(Set<String> set) {
        OverrideMethod.invokeV("android.webkit.JWebCoreJavaBridge#addPackageNames(Ljava/util/Set;)V", true, this);
    }

    public void addPackageName(String string2) {
        OverrideMethod.invokeV("android.webkit.JWebCoreJavaBridge#addPackageName(Ljava/lang/String;)V", true, this);
    }

    public void removePackageName(String string2) {
        OverrideMethod.invokeV("android.webkit.JWebCoreJavaBridge#removePackageName(Ljava/lang/String;)V", true, this);
    }

    public void nativeUpdateProxy(String string2, String string3) {
        OverrideMethod.invokeV("android.webkit.JWebCoreJavaBridge#nativeUpdateProxy(Ljava/lang/String;Ljava/lang/String;)V", true, this);
    }
}

