/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.net.http.SslError;
import android.os.Bundle;
import android.os.Message;
import android.webkit.CallbackProxy;
import android.webkit.LoadListener;
import android.webkit.SslErrorHandler;
import java.util.LinkedList;

class SslErrorHandlerImpl
extends SslErrorHandler {
    private static final String LOGTAG = "network";
    private LinkedList<LoadListener> mLoaderQueue;
    private Bundle mSslPrefTable;
    private final SslErrorHandler mOriginHandler;
    private final LoadListener mLoadListener;
    private static final int HANDLE_RESPONSE = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 100: {
                LoadListener loader = (LoadListener)msg.obj;
                SslErrorHandlerImpl sslErrorHandlerImpl = this;
                synchronized (sslErrorHandlerImpl) {
                    this.handleSslErrorResponse(loader, loader.sslError(), msg.arg1 == 1);
                    this.mLoaderQueue.remove(loader);
                    this.fastProcessQueuedSslErrors();
                    break;
                }
            }
        }
    }

    SslErrorHandlerImpl() {
        this.mLoaderQueue = new LinkedList();
        this.mSslPrefTable = new Bundle();
        this.mOriginHandler = null;
        this.mLoadListener = null;
    }

    private SslErrorHandlerImpl(SslErrorHandler origin, LoadListener listener) {
        this.mOriginHandler = origin;
        this.mLoadListener = listener;
    }

    synchronized boolean saveState(Bundle outState) {
        boolean success;
        boolean bl = success = outState != null;
        if (success) {
            outState.putBundle("ssl-error-handler", this.mSslPrefTable);
        }
        return success;
    }

    synchronized boolean restoreState(Bundle inState) {
        boolean success;
        boolean bl = success = inState != null;
        if (success && (success = inState.containsKey("ssl-error-handler"))) {
            this.mSslPrefTable = inState.getBundle("ssl-error-handler");
        }
        return success;
    }

    synchronized void clear() {
        this.mSslPrefTable.clear();
    }

    synchronized void handleSslErrorRequest(LoadListener loader) {
        if (!loader.cancelled()) {
            this.mLoaderQueue.offer(loader);
            if (loader == this.mLoaderQueue.peek()) {
                this.fastProcessQueuedSslErrors();
            }
        }
    }

    synchronized boolean checkSslPrefTable(LoadListener loader, SslError error) {
        String host = loader.host();
        int primary = error.getPrimaryError();
        if (this.mSslPrefTable.containsKey(host) && primary <= this.mSslPrefTable.getInt(host)) {
            if (!loader.cancelled()) {
                loader.handleSslErrorResponse(true);
            }
            return true;
        }
        return false;
    }

    void fastProcessQueuedSslErrors() {
        while (this.processNextLoader()) {
        }
    }

    private synchronized boolean processNextLoader() {
        LoadListener loader = this.mLoaderQueue.peek();
        if (loader != null) {
            if (loader.cancelled()) {
                this.mLoaderQueue.remove(loader);
                return true;
            }
            SslError error = loader.sslError();
            if (this.checkSslPrefTable(loader, error)) {
                this.mLoaderQueue.remove(loader);
                return true;
            }
            CallbackProxy proxy = loader.getFrame().getCallbackProxy();
            proxy.onReceivedSslError(new SslErrorHandlerImpl(this, loader), error);
        }
        return false;
    }

    public void proceed() {
        this.mOriginHandler.sendMessage(this.mOriginHandler.obtainMessage(100, 1, 0, this.mLoadListener));
    }

    public void cancel() {
        this.mOriginHandler.sendMessage(this.mOriginHandler.obtainMessage(100, 0, 0, this.mLoadListener));
    }

    synchronized void handleSslErrorResponse(LoadListener loader, SslError error, boolean proceed) {
        if (!loader.cancelled()) {
            if (proceed) {
                int primary = error.getPrimaryError();
                String host = loader.host();
                boolean hasKey = this.mSslPrefTable.containsKey(host);
                if (!hasKey || primary > this.mSslPrefTable.getInt(host)) {
                    this.mSslPrefTable.putInt(host, primary);
                }
            }
            loader.handleSslErrorResponse(proceed);
        }
    }
}

