/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.text.Editable;
import android.text.Selection;
import android.text.SpannableStringBuilder;
import android.text.method.WordIterator;
import android.text.style.SpellCheckSpan;
import android.text.style.SuggestionSpan;
import android.view.textservice.SpellCheckerSession;
import android.view.textservice.SuggestionsInfo;
import android.view.textservice.TextInfo;
import android.view.textservice.TextServicesManager;
import android.widget.TextView;
import com.android.internal.util.ArrayUtils;
import java.util.Locale;

public class SpellChecker
implements SpellCheckerSession.SpellCheckerSessionListener {
    public static final int MAX_NUMBER_OF_WORDS = 50;
    public static final int AVERAGE_WORD_LENGTH = 7;
    public static final int WORD_ITERATOR_INTERVAL = 350;
    private static final int SPELL_PAUSE_DURATION = 400;
    private final TextView mTextView;
    SpellCheckerSession mSpellCheckerSession;
    final int mCookie;
    private int[] mIds;
    private SpellCheckSpan[] mSpellCheckSpans;
    private int mLength;
    private SpellParser[] mSpellParsers = new SpellParser[0];
    private int mSpanSequenceCounter = 0;
    private Locale mCurrentLocale;
    private WordIterator mWordIterator;
    private TextServicesManager mTextServicesManager;
    private Runnable mSpellRunnable;

    public SpellChecker(TextView textView) {
        this.mTextView = textView;
        int size = ArrayUtils.idealObjectArraySize(1);
        this.mIds = new int[size];
        this.mSpellCheckSpans = new SpellCheckSpan[size];
        this.setLocale(this.mTextView.getTextServicesLocale());
        this.mCookie = this.hashCode();
    }

    private void resetSession() {
        this.closeSession();
        this.mTextServicesManager = (TextServicesManager)this.mTextView.getContext().getSystemService("textservices");
        this.mSpellCheckerSession = !this.mTextServicesManager.isSpellCheckerEnabled() ? null : this.mTextServicesManager.newSpellCheckerSession(null, this.mCurrentLocale, this, false);
        for (int i = 0; i < this.mLength; ++i) {
            this.mSpellCheckSpans[i].setSpellCheckInProgress(false);
            this.mIds[i] = -1;
        }
        this.mLength = 0;
        this.mTextView.removeMisspelledSpans((Editable)this.mTextView.getText());
        this.mTextView.onLocaleChanged();
    }

    private void setLocale(Locale locale) {
        this.mCurrentLocale = locale;
        this.resetSession();
        this.mWordIterator = new WordIterator(locale);
        this.mTextView.onLocaleChanged();
    }

    private boolean isSessionActive() {
        return this.mSpellCheckerSession != null;
    }

    public void closeSession() {
        if (this.mSpellCheckerSession != null) {
            this.mSpellCheckerSession.close();
        }
        int length = this.mSpellParsers.length;
        for (int i = 0; i < length; ++i) {
            this.mSpellParsers[i].finish();
        }
        if (this.mSpellRunnable != null) {
            this.mTextView.removeCallbacks(this.mSpellRunnable);
        }
    }

    private int nextSpellCheckSpanIndex() {
        for (int i = 0; i < this.mLength; ++i) {
            if (this.mIds[i] >= 0) continue;
            return i;
        }
        if (this.mLength == this.mSpellCheckSpans.length) {
            int newSize = this.mLength * 2;
            int[] newIds = new int[newSize];
            SpellCheckSpan[] newSpellCheckSpans = new SpellCheckSpan[newSize];
            System.arraycopy(this.mIds, 0, newIds, 0, this.mLength);
            System.arraycopy(this.mSpellCheckSpans, 0, newSpellCheckSpans, 0, this.mLength);
            this.mIds = newIds;
            this.mSpellCheckSpans = newSpellCheckSpans;
        }
        this.mSpellCheckSpans[this.mLength] = new SpellCheckSpan();
        ++this.mLength;
        return this.mLength - 1;
    }

    private void addSpellCheckSpan(Editable editable, int start, int end) {
        int index = this.nextSpellCheckSpanIndex();
        editable.setSpan(this.mSpellCheckSpans[index], start, end, 33);
        ++this.mSpanSequenceCounter;
    }

    public void removeSpellCheckSpan(SpellCheckSpan spellCheckSpan) {
        for (int i = 0; i < this.mLength; ++i) {
            if (this.mSpellCheckSpans[i] != spellCheckSpan) continue;
            this.mSpellCheckSpans[i].setSpellCheckInProgress(false);
            this.mIds[i] = -1;
            return;
        }
    }

    public void onSelectionChanged() {
        this.spellCheck();
    }

    public void spellCheck(int start, int end) {
        SpellParser spellParser;
        Locale locale = this.mTextView.getTextServicesLocale();
        if (this.mCurrentLocale == null || !this.mCurrentLocale.equals(locale)) {
            this.setLocale(locale);
            start = 0;
            end = this.mTextView.getText().length();
        } else {
            boolean spellCheckerActivated = this.mTextServicesManager.isSpellCheckerEnabled();
            if (this.isSessionActive() != spellCheckerActivated) {
                this.resetSession();
            }
        }
        if (!this.isSessionActive()) {
            return;
        }
        int length = this.mSpellParsers.length;
        for (int i = 0; i < length; ++i) {
            spellParser = this.mSpellParsers[i];
            if (!spellParser.isFinished()) continue;
            spellParser.init(start, end);
            spellParser.parse();
            return;
        }
        SpellParser[] newSpellParsers = new SpellParser[length + 1];
        System.arraycopy(this.mSpellParsers, 0, newSpellParsers, 0, length);
        this.mSpellParsers = newSpellParsers;
        this.mSpellParsers[length] = spellParser = new SpellParser();
        spellParser.init(start, end);
        spellParser.parse();
    }

    private void spellCheck() {
        if (this.mSpellCheckerSession == null) {
            return;
        }
        Editable editable = (Editable)this.mTextView.getText();
        int selectionStart = Selection.getSelectionStart(editable);
        int selectionEnd = Selection.getSelectionEnd(editable);
        TextInfo[] textInfos = new TextInfo[this.mLength];
        int textInfosCount = 0;
        for (int i = 0; i < this.mLength; ++i) {
            SpellCheckSpan spellCheckSpan = this.mSpellCheckSpans[i];
            if (spellCheckSpan.isSpellCheckInProgress()) continue;
            int start = editable.getSpanStart(spellCheckSpan);
            int end = editable.getSpanEnd(spellCheckSpan);
            if (start < 0 || end <= start || selectionEnd >= start && selectionStart <= end) continue;
            String word = editable instanceof SpannableStringBuilder ? ((SpannableStringBuilder)editable).substring(start, end) : ((Object)editable.subSequence(start, end)).toString();
            spellCheckSpan.setSpellCheckInProgress(true);
            textInfos[textInfosCount++] = new TextInfo(word, this.mCookie, this.mIds[i]);
        }
        if (textInfosCount > 0) {
            if (textInfosCount < textInfos.length) {
                TextInfo[] textInfosCopy = new TextInfo[textInfosCount];
                System.arraycopy(textInfos, 0, textInfosCopy, 0, textInfosCount);
                textInfos = textInfosCopy;
            }
            this.mSpellCheckerSession.getSuggestions(textInfos, 5, false);
        }
    }

    public void onGetSuggestions(SuggestionsInfo[] results) {
        Editable editable = (Editable)this.mTextView.getText();
        block0: for (int i = 0; i < results.length; ++i) {
            SuggestionsInfo suggestionsInfo = results[i];
            if (suggestionsInfo.getCookie() != this.mCookie) continue;
            int sequenceNumber = suggestionsInfo.getSequence();
            for (int j = 0; j < this.mLength; ++j) {
                if (sequenceNumber != this.mIds[j]) continue;
                int attributes = suggestionsInfo.getSuggestionsAttributes();
                boolean isInDictionary = (attributes & 1) > 0;
                boolean looksLikeTypo = (attributes & 2) > 0;
                SpellCheckSpan spellCheckSpan = this.mSpellCheckSpans[j];
                if (!isInDictionary && looksLikeTypo) {
                    this.createMisspelledSuggestionSpan(editable, suggestionsInfo, spellCheckSpan);
                }
                editable.removeSpan(spellCheckSpan);
                continue block0;
            }
        }
        this.scheduleNewSpellCheck();
    }

    private void scheduleNewSpellCheck() {
        if (this.mSpellRunnable == null) {
            this.mSpellRunnable = new Runnable(){

                public void run() {
                    int length = SpellChecker.this.mSpellParsers.length;
                    for (int i = 0; i < length; ++i) {
                        SpellParser spellParser = SpellChecker.this.mSpellParsers[i];
                        if (spellParser.isFinished()) continue;
                        spellParser.parse();
                        break;
                    }
                }
            };
        } else {
            this.mTextView.removeCallbacks(this.mSpellRunnable);
        }
        this.mTextView.postDelayed(this.mSpellRunnable, 400L);
    }

    private void createMisspelledSuggestionSpan(Editable editable, SuggestionsInfo suggestionsInfo, SpellCheckSpan spellCheckSpan) {
        String[] suggestions;
        int start = editable.getSpanStart(spellCheckSpan);
        int end = editable.getSpanEnd(spellCheckSpan);
        if (start < 0 || end <= start) {
            return;
        }
        SuggestionSpan[] suggestionSpans = editable.getSpans(start, end, SuggestionSpan.class);
        int length = suggestionSpans.length;
        for (int i = 0; i < length; ++i) {
            int spanStart = editable.getSpanStart(suggestionSpans[i]);
            int spanEnd = editable.getSpanEnd(suggestionSpans[i]);
            if (spanStart == start && spanEnd == end) continue;
            suggestionSpans[i] = null;
        }
        int suggestionsCount = suggestionsInfo.getSuggestionsCount();
        if (suggestionsCount <= 0) {
            suggestions = ArrayUtils.emptyArray(String.class);
        } else {
            String spellSuggestion;
            int numberOfSuggestions = 0;
            suggestions = new String[suggestionsCount];
            for (int i = 0; i < suggestionsCount && (spellSuggestion = suggestionsInfo.getSuggestionAt(i)) != null; ++i) {
                boolean suggestionFound = false;
                block2: for (int j = 0; j < length && !suggestionFound && suggestionSpans[j] != null; ++j) {
                    String[] suggests = suggestionSpans[j].getSuggestions();
                    for (int k = 0; k < suggests.length; ++k) {
                        if (!spellSuggestion.equals(suggests[k])) continue;
                        suggestionFound = true;
                        continue block2;
                    }
                }
                if (suggestionFound) continue;
                suggestions[numberOfSuggestions++] = spellSuggestion;
            }
            if (numberOfSuggestions != suggestionsCount) {
                String[] newSuggestions = new String[numberOfSuggestions];
                System.arraycopy(suggestions, 0, newSuggestions, 0, numberOfSuggestions);
                suggestions = newSuggestions;
            }
        }
        SuggestionSpan suggestionSpan = new SuggestionSpan(this.mTextView.getContext(), suggestions, 3);
        editable.setSpan(suggestionSpan, start, end, 33);
        this.mTextView.invalidateRegion(start, end, false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SpellParser {
        private Object mRange = new Object();

        private SpellParser() {
        }

        public void init(int start, int end) {
            ((Editable)SpellChecker.this.mTextView.getText()).setSpan(this.mRange, start, end, 33);
        }

        public void finish() {
            ((Editable)SpellChecker.this.mTextView.getText()).removeSpan(this.mRange);
        }

        public boolean isFinished() {
            return ((Editable)SpellChecker.this.mTextView.getText()).getSpanStart(this.mRange) < 0;
        }

        public void parse() {
            int wordEnd;
            Editable editable = (Editable)SpellChecker.this.mTextView.getText();
            int start = editable.getSpanStart(this.mRange);
            int end = editable.getSpanEnd(this.mRange);
            int wordIteratorWindowEnd = Math.min(end, start + 350);
            SpellChecker.this.mWordIterator.setCharSequence(editable, start, wordIteratorWindowEnd);
            int wordStart = SpellChecker.this.mWordIterator.preceding(start);
            if (wordStart == -1) {
                wordEnd = SpellChecker.this.mWordIterator.following(start);
                if (wordEnd != -1) {
                    wordStart = SpellChecker.this.mWordIterator.getBeginning(wordEnd);
                }
            } else {
                wordEnd = SpellChecker.this.mWordIterator.getEnd(wordStart);
            }
            if (wordEnd == -1) {
                editable.removeSpan(this.mRange);
                return;
            }
            SpellCheckSpan[] spellCheckSpans = editable.getSpans(start - 1, end + 1, SpellCheckSpan.class);
            SuggestionSpan[] suggestionSpans = editable.getSpans(start - 1, end + 1, SuggestionSpan.class);
            int wordCount = 0;
            boolean scheduleOtherSpellCheck = false;
            while (wordStart <= end) {
                if (wordEnd >= start && wordEnd > wordStart) {
                    int i;
                    if (wordCount >= 50) {
                        scheduleOtherSpellCheck = true;
                        break;
                    }
                    if (wordStart < start && wordEnd > start) {
                        this.removeSpansAt(editable, start, spellCheckSpans);
                        this.removeSpansAt(editable, start, suggestionSpans);
                    }
                    if (wordStart < end && wordEnd > end) {
                        this.removeSpansAt(editable, end, spellCheckSpans);
                        this.removeSpansAt(editable, end, suggestionSpans);
                    }
                    boolean createSpellCheckSpan = true;
                    if (wordEnd == start) {
                        for (i = 0; i < spellCheckSpans.length; ++i) {
                            int spanEnd = editable.getSpanEnd(spellCheckSpans[i]);
                            if (spanEnd != start) continue;
                            createSpellCheckSpan = false;
                            break;
                        }
                    }
                    if (wordStart == end) {
                        for (i = 0; i < spellCheckSpans.length; ++i) {
                            int spanStart = editable.getSpanStart(spellCheckSpans[i]);
                            if (spanStart != end) continue;
                            createSpellCheckSpan = false;
                            break;
                        }
                    }
                    if (createSpellCheckSpan) {
                        SpellChecker.this.addSpellCheckSpan(editable, wordStart, wordEnd);
                    }
                    ++wordCount;
                }
                int originalWordEnd = wordEnd;
                wordEnd = SpellChecker.this.mWordIterator.following(wordEnd);
                if (wordIteratorWindowEnd < end && (wordEnd == -1 || wordEnd >= wordIteratorWindowEnd)) {
                    wordIteratorWindowEnd = Math.min(end, originalWordEnd + 350);
                    SpellChecker.this.mWordIterator.setCharSequence(editable, originalWordEnd, wordIteratorWindowEnd);
                    wordEnd = SpellChecker.this.mWordIterator.following(originalWordEnd);
                }
                if (wordEnd != -1 && (wordStart = SpellChecker.this.mWordIterator.getBeginning(wordEnd)) != -1) continue;
                break;
            }
            if (scheduleOtherSpellCheck) {
                editable.setSpan(this.mRange, wordStart, end, 33);
            } else {
                editable.removeSpan(this.mRange);
            }
            SpellChecker.this.spellCheck();
        }

        private <T> void removeSpansAt(Editable editable, int offset, T[] spans) {
            for (T span : spans) {
                int end;
                int start = editable.getSpanStart(span);
                if (start > offset || (end = editable.getSpanEnd(span)) < offset) continue;
                editable.removeSpan(span);
            }
        }
    }
}

