/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.location.CountryDetector;
import android.net.Uri;
import android.provider.ContactsContract;
import android.telephony.PhoneNumberUtils;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.android.i18n.phonenumbers.NumberParseException;
import com.android.i18n.phonenumbers.PhoneNumberUtil;
import com.android.i18n.phonenumbers.Phonenumber;
import com.android.i18n.phonenumbers.geocoding.PhoneNumberOfflineGeocoder;
import java.util.Locale;

public class CallerInfo {
    private static final String TAG = "CallerInfo";
    private static final boolean VDBG = Log.isLoggable("CallerInfo", 2);
    public static final String UNKNOWN_NUMBER = "-1";
    public static final String PRIVATE_NUMBER = "-2";
    public static final String PAYPHONE_NUMBER = "-3";
    public String name;
    public String phoneNumber;
    public String normalizedNumber;
    public String geoDescription;
    public String cnapName;
    public int numberPresentation;
    public int namePresentation;
    public boolean contactExists;
    public String phoneLabel;
    public int numberType;
    public String numberLabel;
    public int photoResource;
    public long person_id;
    public boolean needUpdate;
    public Uri contactRefUri;
    public Uri contactRingtoneUri;
    public boolean shouldSendToVoicemail;
    public Drawable cachedPhoto;
    public boolean isCachedPhotoCurrent;
    private boolean mIsEmergency = false;
    private boolean mIsVoiceMail = false;

    public static CallerInfo getCallerInfo(Context context, Uri contactRef, Cursor cursor) {
        CallerInfo info = new CallerInfo();
        info.photoResource = 0;
        info.phoneLabel = null;
        info.numberType = 0;
        info.numberLabel = null;
        info.cachedPhoto = null;
        info.isCachedPhotoCurrent = false;
        info.contactExists = false;
        if (VDBG) {
            Log.v(TAG, "getCallerInfo() based on cursor...");
        }
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                int typeColumnIndex;
                int columnIndex = cursor.getColumnIndex("display_name");
                if (columnIndex != -1) {
                    info.name = cursor.getString(columnIndex);
                }
                if ((columnIndex = cursor.getColumnIndex("number")) != -1) {
                    info.phoneNumber = cursor.getString(columnIndex);
                }
                if ((columnIndex = cursor.getColumnIndex("normalized_number")) != -1) {
                    info.normalizedNumber = cursor.getString(columnIndex);
                }
                if ((columnIndex = cursor.getColumnIndex("label")) != -1 && (typeColumnIndex = cursor.getColumnIndex("type")) != -1) {
                    info.numberType = cursor.getInt(typeColumnIndex);
                    info.numberLabel = cursor.getString(columnIndex);
                    info.phoneLabel = ((Object)ContactsContract.CommonDataKinds.Phone.getDisplayLabel(context, info.numberType, info.numberLabel)).toString();
                }
                if ((columnIndex = CallerInfo.getColumnIndexForPersonId(contactRef, cursor)) != -1) {
                    info.person_id = cursor.getLong(columnIndex);
                    if (VDBG) {
                        Log.v(TAG, "==> got info.person_id: " + info.person_id);
                    }
                } else {
                    Log.w(TAG, "Couldn't find person_id column for " + contactRef);
                }
                info.contactRingtoneUri = (columnIndex = cursor.getColumnIndex("custom_ringtone")) != -1 && cursor.getString(columnIndex) != null ? Uri.parse(cursor.getString(columnIndex)) : null;
                columnIndex = cursor.getColumnIndex("send_to_voicemail");
                info.shouldSendToVoicemail = columnIndex != -1 && cursor.getInt(columnIndex) == 1;
                info.contactExists = true;
            }
            cursor.close();
        }
        info.needUpdate = false;
        info.name = CallerInfo.normalize(info.name);
        info.contactRefUri = contactRef;
        return info;
    }

    public static CallerInfo getCallerInfo(Context context, Uri contactRef) {
        return CallerInfo.getCallerInfo(context, contactRef, context.getContentResolver().query(contactRef, null, null, null, null));
    }

    public static CallerInfo getCallerInfo(Context context, String number) {
        if (VDBG) {
            Log.v(TAG, "getCallerInfo() based on number...");
        }
        if (TextUtils.isEmpty(number)) {
            return null;
        }
        if (PhoneNumberUtils.isLocalEmergencyNumber(number, context)) {
            return new CallerInfo().markAsEmergency(context);
        }
        if (PhoneNumberUtils.isVoiceMailNumber(number)) {
            return new CallerInfo().markAsVoiceMail();
        }
        Uri contactUri = Uri.withAppendedPath(ContactsContract.PhoneLookup.CONTENT_FILTER_URI, Uri.encode(number));
        CallerInfo info = CallerInfo.getCallerInfo(context, contactUri);
        info = CallerInfo.doSecondaryLookupIfNecessary(context, number, info);
        if (TextUtils.isEmpty(info.phoneNumber)) {
            info.phoneNumber = number;
        }
        return info;
    }

    static CallerInfo doSecondaryLookupIfNecessary(Context context, String number, CallerInfo previousResult) {
        String username;
        if (!previousResult.contactExists && PhoneNumberUtils.isUriNumber(number) && PhoneNumberUtils.isGlobalPhoneNumber(username = PhoneNumberUtils.getUsernameFromUriNumber(number))) {
            previousResult = CallerInfo.getCallerInfo(context, Uri.withAppendedPath(ContactsContract.PhoneLookup.CONTENT_FILTER_URI, Uri.encode(username)));
        }
        return previousResult;
    }

    public static String getCallerId(Context context, String number) {
        CallerInfo info = CallerInfo.getCallerInfo(context, number);
        String callerID = null;
        if (info != null) {
            String name = info.name;
            callerID = !TextUtils.isEmpty(name) ? name : number;
        }
        return callerID;
    }

    public boolean isEmergencyNumber() {
        return this.mIsEmergency;
    }

    public boolean isVoiceMailNumber() {
        return this.mIsVoiceMail;
    }

    CallerInfo markAsEmergency(Context context) {
        this.phoneNumber = context.getString(17040089);
        this.photoResource = 17302575;
        this.mIsEmergency = true;
        return this;
    }

    CallerInfo markAsVoiceMail() {
        this.mIsVoiceMail = true;
        try {
            String voiceMailLabel;
            this.phoneNumber = voiceMailLabel = TelephonyManager.getDefault().getVoiceMailAlphaTag();
        }
        catch (SecurityException se) {
            Log.e(TAG, "Cannot access VoiceMail.", se);
        }
        return this;
    }

    private static String normalize(String s) {
        if (s == null || s.length() > 0) {
            return s;
        }
        return null;
    }

    private static int getColumnIndexForPersonId(Uri contactRef, Cursor cursor) {
        int columnIndex;
        if (VDBG) {
            Log.v(TAG, "- getColumnIndexForPersonId: contactRef URI = '" + contactRef + "'...");
        }
        String url = contactRef.toString();
        String columnName = null;
        if (url.startsWith("content://com.android.contacts/data/phones")) {
            if (VDBG) {
                Log.v(TAG, "'data/phones' URI; using RawContacts.CONTACT_ID");
            }
            columnName = "contact_id";
        } else if (url.startsWith("content://com.android.contacts/data")) {
            if (VDBG) {
                Log.v(TAG, "'data' URI; using Data.CONTACT_ID");
            }
            columnName = "contact_id";
        } else if (url.startsWith("content://com.android.contacts/phone_lookup")) {
            if (VDBG) {
                Log.v(TAG, "'phone_lookup' URI; using PhoneLookup._ID");
            }
            columnName = "_id";
        } else {
            Log.w(TAG, "Unexpected prefix for contactRef '" + url + "'");
        }
        int n = columnIndex = columnName != null ? cursor.getColumnIndex(columnName) : -1;
        if (VDBG) {
            Log.v(TAG, "==> Using column '" + columnName + "' (columnIndex = " + columnIndex + ") for person_id lookup...");
        }
        return columnIndex;
    }

    public void updateGeoDescription(Context context, String fallbackNumber) {
        String number = TextUtils.isEmpty(this.phoneNumber) ? fallbackNumber : this.phoneNumber;
        this.geoDescription = CallerInfo.getGeoDescription(context, number);
    }

    private static String getGeoDescription(Context context, String number) {
        if (VDBG) {
            Log.v(TAG, "getGeoDescription('" + number + "')...");
        }
        if (TextUtils.isEmpty(number)) {
            return null;
        }
        PhoneNumberUtil util = PhoneNumberUtil.getInstance();
        PhoneNumberOfflineGeocoder geocoder = PhoneNumberOfflineGeocoder.getInstance();
        Locale locale = context.getResources().getConfiguration().locale;
        String countryIso = CallerInfo.getCurrentCountryIso(context, locale);
        Phonenumber.PhoneNumber pn = null;
        try {
            if (VDBG) {
                Log.v(TAG, "parsing '" + number + "' for countryIso '" + countryIso + "'...");
            }
            pn = util.parse(number, countryIso);
            if (VDBG) {
                Log.v(TAG, "- parsed number: " + pn);
            }
        }
        catch (NumberParseException e) {
            Log.w(TAG, "getGeoDescription: NumberParseException for incoming number '" + number + "'");
        }
        if (pn != null) {
            String description = geocoder.getDescriptionForNumber(pn, locale);
            if (VDBG) {
                Log.v(TAG, "- got description: '" + description + "'");
            }
            return description;
        }
        return null;
    }

    private static String getCurrentCountryIso(Context context, Locale locale) {
        String countryIso;
        CountryDetector detector = (CountryDetector)context.getSystemService("country_detector");
        if (detector != null) {
            countryIso = detector.detectCountry().getCountryIso();
        } else {
            countryIso = locale.getCountry();
            Log.w(TAG, "No CountryDetector; falling back to countryIso based on locale: " + countryIso);
        }
        return countryIso;
    }

    public String toString() {
        boolean VERBOSE_DEBUG = false;
        return new StringBuilder(128).append(super.toString() + " { ").append("name " + (this.name == null ? "null" : "non-null")).append(", phoneNumber " + (this.phoneNumber == null ? "null" : "non-null")).append(" }").toString();
    }
}

